<?php

namespace SV\SignupAbuseBlocking\XF\Spam;

use XF\PrintableException;
use XF\Service\Report\Creator as ReportCreator;
use function strpos, implode;

/**
 * Extends \XF\Spam\ContentChecker
 */
class ContentChecker extends XFCP_ContentChecker
{
    public function logSpamTrigger($contentType, $contentId)
    {
        $doReport = false;
        // replace 'report' with 'allowed' before calling parent
        $decisions = $this->decisions;
        foreach($decisions as &$decision)
        {
            if ($decision === 'report')
            {
                $doReport = true;
                $decision = 'allowed';
            }
        }
        unset($decision);
        $this->decisions = $decisions;

        $ret = parent::logSpamTrigger($contentType, $contentId);
        if ($ret && $doReport)
        {
            $handler = $this->getReportHandlerForContentType($contentType, $xfContentType);
            if ($handler !== null)
            {
                try
                {
                    /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
                    $multipleAccountRepo = \XF::repository('SV\SignupAbuseBlocking:MultipleAccount');

                    $reportCreator = $multipleAccountRepo->getUserForReportCreation();
                    $currentUser = \XF::visitor();

                    if ($reportCreator !== null)
                    {
                        \XF::asVisitor($reportCreator, function () use ($currentUser, $contentType, $xfContentType, $contentId) {
                            $this->reportContent($currentUser, $contentType, $xfContentType, $contentId);
                        });
                    }
                }
                catch (\Throwable $e)
                {
                    // do not block posting if any sort of error occurs
                    \XF::logException($e, true);
                    if (\XF::$developmentMode)
                    {
                        throw $e;
                    }
                }
            }
        }
    }

    /**
     * @param string $contentType
     * @param string $xfContentType
     * @return \XF\Report\AbstractHandler|null
     */
    protected function getReportHandlerForContentType(string $contentType, string &$xfContentType)
    {
        $xfContentType = $contentType;
        $reportRepo = $this->app()->repository('XF:Report');
        assert($reportRepo instanceof \XF\Repository\Report);

        $handler = $reportRepo->getReportHandler($xfContentType, false);
        if ($handler === null && strpos($xfContentType, 'user_') === 0)
        {
            $xfContentType = 'user';
        }

        return $reportRepo->getReportHandler($xfContentType, false);
    }

    /** @noinspection PhpUnusedParameterInspection */
    protected function reportContent(\XF\Entity\User $contentUser, string $contentType, string $xfContentType, int $contentId)
    {
        if (!$contentUser->user_id)
        {
            // wat
            return;
        }
        try
        {
            $entity = \XF::finder($contentType)
                         ->whereId($contentId)
                         ->fetch();
        }
        catch (\Exception $e)
        {
            // badly setup finder
            \XF::logException($e, 'Unable to generate report for content which claims to support reports:');

            return;
        }

        $reasons = [];
        foreach ($this->details as $details)
        {
            $phraseName = $details['phrase'] ?? null;
            if ($phraseName === null)
            {
                continue;
            }
            $data = $details['data'] ?? [];
            $phrase = \XF::phrase($phraseName, $data);

            $reasons[] = $phrase->render('raw');
        }

        $message = \XF::phrase('sv_reg_log.reported_content_message', [
            'reasons' => $reasons ? implode("\n", $reasons) : \XF::phrase('n_a'),
        ]);

        /** @var ReportCreator $creator */
        $creator = $this->app()->service('XF:Report\Creator', $contentType, $entity);
        $creator->setMessage($message);
        if ($creator->validate($errors))
        {
            $creator->save();

            \XF::runLater(function() use ($creator) {
                $creator->sendNotifications();
            });
        }
        else
        {
            \XF::logException(new PrintableException($errors), false, 'Failed to report content:');
        }
    }
}