<?php

namespace SV\SignupAbuseBlocking\XF\Repository;

use XF\Mvc\Entity\ArrayCollection;

/**
 * Class ApprovalQueue
 *
 * @package SV\SignupAbuseBlocking\XF\Repository
 */
class ApprovalQueue extends XFCP_ApprovalQueue
{
    /**
     * @param \XF\Entity\ApprovalQueue[]|ArrayCollection $unapprovedItems
     */
    public function addContentToUnapprovedItems($unapprovedItems)
    {
        parent::addContentToUnapprovedItems($unapprovedItems);

        $userIds = [];

        /** @var \XF\Entity\ApprovalQueue $unapprovedItem */
        foreach ($unapprovedItems AS $unapprovedItem)
        {
            if ($unapprovedItem->content_type === 'user')
            {
                $userIds[$unapprovedItem->content_id] = $unapprovedItem;
            }
        }

        if ($userIds)
        {
            /** @var \SV\SignupAbuseBlocking\Finder\UserRegistrationLog $userRegistrationLogFinder */
            $userRegistrationLogFinder = $this->app()->finder('SV\SignupAbuseBlocking:UserRegistrationLog');
            $userRegistrationLogFinder->forUser(\array_keys($userIds));
            $userRegLogs = $userRegistrationLogFinder->fetch();
            $groupedUserRegLogs = $userRegLogs->groupBy('user_id');

            foreach ($userIds AS $userId => $unapprovedItem)
            {
                if (empty($groupedUserRegLogs[$userId]) || !$unapprovedItem->Content)
                {
                    continue;
                }

                $unapprovedItem->Content->hydrateRelation('UserRegistrationLogs', new ArrayCollection($groupedUserRegLogs[$userId]));
            }
        }
    }
}