<?php
/**
 * @noinspection PhpMissingReturnTypeInspection
 */

namespace SV\SignupAbuseBlocking\XF\Pub\Controller;

use SV\SignupAbuseBlocking\Entity\Token;
use SV\SignupAbuseBlocking\Globals;
use XF\ConnectedAccount\ProviderData\AbstractProviderData;
use XF\Entity\User;
use XF\Mvc\ParameterBag;
use XF\Mvc\Reply\Redirect as RedirectReply;
use XF\Service\User\RegisterForm as UserRegisterFormSvc;

class Register extends XFCP_Register
{
    protected function preDispatchController($action, ParameterBag $params)
    {
        Globals::$armLoginPlugin = true;
        parent::preDispatchController($action, $params);
    }

    protected function assertRegRedirect($link)
    {
        $redirectedRegistration = Globals::$redirectedRegistration ?? false;
        if ($redirectedRegistration)
        {
            return;
        }
        try
        {
            // note; this ensures we do not have infinite loops during update(s)...
            $this->assertCanonicalUrl($this->buildLink($link));
        }
        catch (\XF\Mvc\Reply\Exception $e)
        {
            // rewrite the reply redirect from permanent to temporary
            $response = $e->getReply();
            if ($response instanceof RedirectReply)
            {
                /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
                $multipleAccountRepo = $this->repository('SV\SignupAbuseBlocking:MultipleAccount');

                $receivedToken = $multipleAccountRepo->getCookieValue('register');
                if ($receivedToken)
                {
                    // capture any existing tracking cookie and push it to the next step
                    $session = $this->session();
                    $session->set('svRegCookie', $receivedToken);

                    $multipleAccountRepo->setCookieValue(null);
                }

                $response->setType('temporary');
            }

            throw $e;
        }
    }

    public function actionIndex()
    {
        $this->assertRegRedirect('register');

        return parent::actionIndex();
    }

    public function actionRegister()
    {
        $this->assertRegRedirect('register/register');

        return parent::actionRegister();
    }

    public function actionConnectedAccount(ParameterBag $params)
    {
        $this->assertRegRedirect('register/connected-accounts');

        return parent::actionConnectedAccount($params);
    }

    public function actionConnectedAccountAssociate(ParameterBag $params)
    {
        $this->assertRegRedirect('register/connected-accounts/associate');

        return parent::actionConnectedAccountAssociate($params);
    }

    public function actionConnectedAccountRegister(ParameterBag $params)
    {
        $this->assertRegRedirect('register/connected-accounts/register');

        return parent::actionConnectedAccountRegister($params);
    }

    protected function setupRegistration(array $input)
    {
        Globals::$duringRegistration = true;
        return parent::setupRegistration($input);
    }

    protected function setupConnectedRegistration(array $input, AbstractProviderData $providerData)
    {
        Globals::$duringRegistration = true;
        return parent::setupConnectedRegistration($input, $providerData);
    }

    /**
     * @param User|\SV\SignupAbuseBlocking\XF\Entity\User $user
     * @throws \Throwable
     * @throws \XF\PrintableException
     */
    protected function finalizeRegistration(User $user)
    {
        // call parent 1st to setup the session fully
        parent::finalizeRegistration($user);

        Globals::$duringRegistration = false;
        /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
        $multipleAccountRepo = $this->repository('SV\SignupAbuseBlocking:MultipleAccount');
        $receivedToken = $multipleAccountRepo->getCookieValue('register');
        if (!$receivedToken)
        {
            /** @var Token $token */
            $token = $user->AccountDetectionToken;
            $multipleAccountRepo->setCookieValue($token);
        }

        try
        {
            $dataCollection = Globals::$dataCollection ?? null;
            if ($dataCollection)
            {
                $this->reportMultipleAccountDetection($dataCollection);
            }
        }
        catch (\Throwable $e)
        {
            // do not block login if any sort of error occurs
            \XF::logException($e, true);
            if (\XF::$developmentMode)
            {
                throw $e;
            }
        }
    }

    /**
     * @param array $detectMethods
     * @throws \Throwable
     * @throws \XF\Db\Exception
     * @throws \XF\PrintableException
     */
    protected function reportMultipleAccountDetection(array $detectMethods)
    {
        /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
        $multipleAccountRepo = $this->repository('SV\SignupAbuseBlocking:MultipleAccount');
        $multipleAccountRepo->postRegistrationMultipleAccountDetection($detectMethods);
    }

    /**
     * @param UserRegisterFormSvc $regForm
     *
     * @return array
     */
    protected function getRegistrationInput(UserRegisterFormSvc $regForm)
    {
        $input = parent::getRegistrationInput($regForm);

        if ($this->options()->svSADAB_requestWebsiteOnSignup ?? false)
        {
            $input['website'] = $this->filter('website', 'str');
        }

        return $input;
    }
}