<?php

namespace SV\SignupAbuseBlocking\XF\Pub\Controller;

use XF\Mvc\ParameterBag;
use XF\Mvc\Reply\AbstractReply;

/**
 * Class Member
 *
 * @package SV\SignupAbuseBlocking\XF\Pub\Controller
 */
class Member extends XFCP_Member
{
    public function actionMultipleAccountList(ParameterBag $parameterBag): AbstractReply
    {
        /** @var \SV\SignupAbuseBlocking\XF\Entity\User $visitor */
        $visitor = \XF::visitor();
        if (!$visitor->canViewMultiAccountReport())
        {
            throw $this->exception($this->notFound());
        }

        $reportDataId = $this->filter('report_data_id', 'uint');

        /** @noinspection PhpUndefinedFieldInspection */
        $user = $this->assertViewableUser($parameterBag->user_id);

        /** @var \SV\SignupAbuseBlocking\ControllerPlugin\MultipleAccount $multipleAccountPlugin */
        $multipleAccountPlugin = $this->plugin('SV\SignupAbuseBlocking:MultipleAccount');

        return $multipleAccountPlugin->multipleAccountList(
            $user,
            'members/multiple-account-list',
            'SV\SignupAbuseBlocking\XF:Member\MultipleAccountList',
            ['report_data_id' => $reportDataId]
        );
    }

    public function actionMultiAccountToggleUserAlerting(ParameterBag $params): AbstractReply
    {
        /** @var \SV\SignupAbuseBlocking\XF\Entity\User $user */
        /** @noinspection PhpUndefinedFieldInspection */
        $user = $this->assertViewableUser($params->user_id);

        // return not found just in case someone tries being funny
        if (!$user->canChangeUserMultiAccountAlerting())
        {
            return $this->notFound();
        }

        $isAlertable = !$user->Profile->multiple_account_detection_alertable;

        if ($this->isPost())
        {
            $user->Profile->multiple_account_detection_alertable = $isAlertable;
            if ($isAlertable)
            {
                $text = \XF::phrase('sv_multiple_account_alerting.user_enable');
            }
            else
            {
                $text = \XF::phrase('sv_multiple_account_alerting.user_disable');
            }

            $user->Profile->saveIfChanged();

            $reply = $this->redirect($this->getDynamicRedirect());
            $reply->setJsonParam('switchKey', $isAlertable ? 'enable' : 'disable');
            $reply->setJsonParams([
                'text'        => $text,
                'isAlertable' => $isAlertable,
            ]);

            return $reply;
        }

        $viewParams = [
            'user' => $user,

            'is_alertable' => $isAlertable
        ];

        return $this->view('SV\SignupAbuseBlocking\XF:User\SuppressToggle', 'sv_multiple_account_user_confirm', $viewParams);
    }

    public function actionMultiAccountToggleLogAlerting(ParameterBag $params): AbstractReply
    {
        $user = $this->assertViewableUser($params->get('user_id'));
        $log = $this->assertViewableUserWithMultiAccountLog($this->filter('log_id', 'uint'));

        if (!$log->canChangeAlerting())
        {
            return $this->notFound();
        }

        if ($this->isPost())
        {
            $log->is_alertable = !$log->is_alertable;
            if ($log->is_alertable)
            {
                $text = \XF::phrase('sv_multiple_account_alerting.log_disable');
            }
            else
            {
                $text = \XF::phrase('sv_multiple_account_alerting.log_enable');
            }
            $log->save();

            $reply = $this->redirect($this->getDynamicRedirect());
            $reply->setJsonParam('switchKey', $log->is_alertable ? 'enable' : 'disable');
            $reply->setJsonParams([
                'text'        => $text,
                'isAlertable' => $log->is_alertable,
            ]);

            return $reply;
        }

        $skipAlert = $log->is_alertable;

        $viewParams = [
            'user' => $user,
            'log'  => $log,
            'is_alertable' => $skipAlert
        ];

        return $this->view('SV\SignupAbuseBlocking\XF:User\SuppressToggle', 'sv_multiple_account_log_confirm', $viewParams);
    }

    protected function assertViewableUserWithMultiAccountLog(int $logId, array $extraWith = []): \SV\SignupAbuseBlocking\Entity\Log
    {
        /** @var \SV\SignupAbuseBlocking\Entity\Log $log */
        $log = $this->em()->find('SV\SignupAbuseBlocking:Log', $logId, $extraWith);
        if (!$log)
        {
            throw $this->exception($this->notFound());
        }

        return $log;
    }
}