<?php

namespace SV\SignupAbuseBlocking\XF\Admin\Controller;

use XF\Mvc\ParameterBag;
use XF\Mvc\Reply\AbstractReply;
use XF\Mvc\Reply\View as ViewReply;

/**
 * Class User
 *
 * @package SV\SignupAbuseBlocking\XF\Admin\Controller
 */
class User extends XFCP_User
{
    public function actionRegistrationLog(ParameterBag $params): AbstractReply
    {
        /** @noinspection PhpUndefinedFieldInspection */
        $user = $this->assertUserExists($params->user_id);
        /** @var \SV\SignupAbuseBlocking\Finder\UserRegistrationLog $finder */
        $finder = $this->finder('SV\SignupAbuseBlocking:UserRegistrationLog');
        $finder->forUser($user);

        $total = $finder->total();
        $page = $this->filterPage();
        $perPage = 40;

        $logs = $finder->limit($perPage, ($page - 1) * $perPage)->fetch();
        /** @var \SV\SignupAbuseBlocking\Entity\UserRegistrationLog $log */
        foreach ($logs as $log)
        {
            $log->setOption('linkUsernameInDetails', false);
        }

        $viewParams = [
            'user' => $user,

            'hideFilters' => true,
            'entries'     => $logs,

            'pageLink' => 'users/registration-log',
            'page'     => $page,
            'perPage'  => $perPage,
            'total'    => $total,

            'linkParams' => [],
        ];

        return $this->view('SV\SignupAbuseBlocking\XF:User\RegistrationLog', 'svSignupAbuseBlocking_log_user_registration_list', $viewParams);
    }

    public function actionMultipleAccounts(ParameterBag $params): AbstractReply
    {
        /** @noinspection PhpUndefinedFieldInspection */
        $user = $this->assertUserExists($params->user_id);

        /** @var \SV\SignupAbuseBlocking\ControllerPlugin\MultipleAccount $multipleAccountPlugin */
        $multipleAccountPlugin = $this->plugin('SV\SignupAbuseBlocking:MultipleAccount');

        $response = $multipleAccountPlugin->multipleAccountList(
            $user,
            'users/multiple-accounts',
            'SV\SignupAbuseBlocking\XF:User\MultipleAccounts',
            [],
            true
        );
        if ($response instanceof ViewReply)
        {
            $response->setParam('paginationUrl', 'users/multiple-accounts');
            $response->setTemplateName('sv_multiple_account_list');
        }
        return $response;
    }
}