<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\User;

use SV\SignupAbuseBlocking\Repository\ScoreMatchableInterface;
use SV\SignupAbuseBlocking\Spam\IScoringChecker;
use XF\Spam\Checker\AbstractProvider;
use XF\Spam\Checker\UserCheckerInterface;

class GeoIp extends AbstractProvider implements UserCheckerInterface, ScoreMatchableInterface
{
    protected function getType(): string
    {
        return 'SignupAbuseGeoIp';
    }

    public function check(\XF\Entity\User $user, array $extraParams = [])
    {
        if (!($this->checker instanceof IScoringChecker))
        {
            return;
        }

        $repo = \XF::repository('SV\SignupAbuseBlocking:UserRegistrationLog');
        assert($repo instanceof \SV\SignupAbuseBlocking\Repository\UserRegistrationLog);
        $countryCode = $repo->resolveCountryCode();
        if ($countryCode === null)
        {
            return;
        }

        $scoreMatch = \XF::repository('SV\SignupAbuseBlocking:ScoreMatch');
        assert($scoreMatch instanceof \SV\SignupAbuseBlocking\Repository\ScoreMatch);
        $hasMatches = $scoreMatch->evaluateRules($countryCode, $this->app->options()->svSignupCountryBlockingRule ?? '', $this, false, true);
        if (!$hasMatches)
        {
            $this->onRuleMatch($countryCode, 0, '', $countryCode);
        }
    }

    public function onRuleMatch($input, $score, string $matchRule, string $matchInput): bool
    {
        /** @var IScoringChecker $checker */
        $checker = $this->checker;
        switch (\strval($score))
        {
            case 'reject':
                $checker->logScoreReject('sv_reg_log.country_fail', ['country' => $matchInput]);
                break;
            case 'moderate':
                $checker->logScoreModerate('sv_reg_log.country_fail', ['country' => $matchInput]);
                break;
            case '0':
                $checker->logScoreAccept('sv_reg_log.country_ok', ['country' => $matchInput]);
                break;
            default:
                $checker->logScore('sv_reg_log.country_fail', $score, ['country' => $matchInput]);
                break;
        }

        // keep going
        return true;
    }

    public function submit(\XF\Entity\User $user, array $extraParams = [])
    {
    }
}