<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\User;

use SV\SignupAbuseBlocking\Repository\ScoreMatchableInterface;
use SV\SignupAbuseBlocking\Spam\IScoringChecker;
use XF\Spam\Checker\AbstractProvider;
use XF\Spam\Checker\UserCheckerInterface;

class Asn extends AbstractProvider implements UserCheckerInterface, ScoreMatchableInterface
{
    protected function getType(): string
    {
        return 'SignupAbuseAsn';
    }

    public function check(\XF\Entity\User $user, array $extraParams = [])
    {
        if (!($this->checker instanceof IScoringChecker))
        {
            return;
        }

        $repo = \XF::repository('SV\SignupAbuseBlocking:UserRegistrationLog');
        assert($repo instanceof \SV\SignupAbuseBlocking\Repository\UserRegistrationLog);
        $asnData = $repo->resolveAsn();
        if (!$asnData)
        {
            return;
        }

        // note; we deliberately still run if there is no rules
        $asnBlockingRule = \XF::options()->svSignupAsnBlockingRule ?? '';
        $scoreMatch = \XF::repository('SV\SignupAbuseBlocking:ScoreMatch');
        assert($scoreMatch instanceof \SV\SignupAbuseBlocking\Repository\ScoreMatch);
        $hasMatches = $scoreMatch->evaluateRules($asnData, $asnBlockingRule, $this, true, true);
        if (!$hasMatches)
        {
            $this->onRuleMatch($asnData, 0, '', '');
        }
    }

    public function onRuleMatch($input, $score, string $matchRule, string $matchInput): bool
    {
        list($asNumber, $asName) = $input;
        /** @var IScoringChecker $checker */
        $checker = $this->checker;
        switch (\strval($score))
        {
            case 'reject':
                $checker->logScoreReject('sv_reg_log.as_fail', ['number' => $asNumber, 'name' => $asName]);
                break;
            case 'moderate':
                $checker->logScoreModerate('sv_reg_log.as_fail', ['number' => $asNumber, 'name' => $asName]);
                break;
            case '0':
                $checker->logScoreAccept('sv_reg_log.as_ok', ['number' => $asNumber, 'name' => $asName]);
                break;
            default:
                $checker->logScore('sv_reg_log.as_fail', $score, ['number' => $asNumber, 'name' => $asName]);
                break;
        }

        // stop on first match
        return false;
    }


    public function submit(\XF\Entity\User $user, array $extraParams = [])
    {
    }
}