<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\GeoIp;

use SV\SignupAbuseBlocking\Spam\GeoIpProvider;

class ipregistry extends GeoIpProvider
{
    public function isEnabled(): bool
    {
        return !empty($this->geoIpConfig['ipregistry']) && !empty($this->geoIpConfig['ipregistryKey']);
    }

    /**
     * @return null|string
     * @throws \Throwable
     */
    public function resolveGeoIp()
    {
        $ip = \XF::app()->request()->getIp();
        if (!$ip)
        {
            return null;
        }

        $headers = [];
        $fields = 'fields=connection,location.country.code&';
        $url = "https://api.ipregistry.co/{$ip}?{$fields}key=" . \urlencode($this->geoIpConfig['ipregistryKey']);
        $response = $this->httpApiQuery($url, $headers);

        if (empty($response['location']['country']['code']))
        {
            return null;
        }

        return $response['location']['country']['code'];
    }
}