<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\GeoIp;

use SV\SignupAbuseBlocking\Spam\GeoIpProvider;

class ipApi extends GeoIpProvider
{
    public function isEnabled(): bool
    {
        return !empty($this->geoIpConfig['ipApi']);
    }

    /**
     * @return null|string
     * @throws \Throwable
     * @noinspection HttpUrlsUsage
     */
    public function resolveGeoIp()
    {
        $ip = \XF::app()->request()->getIp();
        if (!$ip)
        {
            return null;
        }

        $headers = [];
        if (empty($this->geoIpConfig['ipApiKey']))
        {
            $url = "http://ip-api.com/json/{$ip}";
        }
        else
        {
            $url = "https://pro.ip-api.com/json/{$ip}?key=" . \urlencode($this->geoIpConfig['ipApiKey']);
        }

        $response = $this->httpApiQuery($url, $headers);
        if (empty($response['countryCode']))
        {
            return null;
        }

        return $response['countryCode'];
    }
}