<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\Content;

use SV\SignupAbuseBlocking\Entity\UserRegistrationLog as UserRegistrationLogEntity;
use function strcasecmp;

class GeoIpCheck extends AbstractUserRegistrationLogCheck
{
    protected function getType(): string
    {
        return 'svPostGeoip';
    }

    protected function getDefaultAction(): string
    {
        return (string)(\XF::options()->svGeoIpCheckActionOnNotMatch ?? 'allowed');
    }

    protected function resolveData(\XF\Entity\User $user)
    {
        $repo = \XF::repository('SV\SignupAbuseBlocking:UserRegistrationLog');
        assert($repo instanceof \SV\SignupAbuseBlocking\Repository\UserRegistrationLog);

        return $repo->resolveCountryCode();
    }

    protected function isEmpty(UserRegistrationLogEntity $logEntry): bool
    {
        return $logEntry->country === null;
    }

    protected function isMatching(UserRegistrationLogEntity $logEntry, $data): bool
    {
        return strcasecmp($data, $logEntry->country) === 0;
    }

    protected function onNonMatch(UserRegistrationLogEntity $logEntry, $data, string $defaultAction): string
    {
        $this->logDetail('sv_reg_log.content_geoip_not_match', [
            'contentGeoIP' => $data,
            'regGeoIP'     => $logEntry->country,
        ]);

        return $defaultAction;
    }
}