<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\Content;

use SV\SignupAbuseBlocking\Entity\UserRegistrationLog as UserRegistrationLogEntity;

class AsnCheck extends AbstractUserRegistrationLogCheck
{
    protected function getType(): string
    {
        return 'svPostAsn';
    }

    protected function getDefaultAction(): string
    {
        return (string)(\XF::options()->svAsnCheckActionOnNotMatch ?? 'allowed');
    }

    protected function resolveData(\XF\Entity\User $user)
    {
        $repo = \XF::repository('SV\SignupAbuseBlocking:UserRegistrationLog');
        assert($repo instanceof \SV\SignupAbuseBlocking\Repository\UserRegistrationLog);
        $asnData = $repo->resolveAsn();
        if (!$asnData)
        {
            return null;
        }
        $asn = (int)($asnData[1] ?? 0);
        if ($asn === 0)
        {
            return null;
        }

        return $asn;
    }

    protected function isEmpty(UserRegistrationLogEntity $logEntry): bool
    {
        return $logEntry->asn === null;
    }

    protected function isMatching(UserRegistrationLogEntity $logEntry, $data): bool
    {
        return $logEntry->asn === $data;
    }

    protected function onNonMatch(UserRegistrationLogEntity $logEntry, $data, string $defaultAction): string
    {
        $this->logDetail('sv_reg_log.content_geoip_not_match', [
            'contentAsn' => $data,
            'regAsn' => $logEntry->asn,
        ]);

        return $defaultAction;
    }
}