<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\Asn;

use SV\SignupAbuseBlocking\Spam\AsnProvider;

class ipApi extends AsnProvider
{
    public function isEnabled(): bool
    {
        return !empty($this->asnConfig['ipApi']) && !empty($this->asnConfig['ipApiKey']);
    }

    /**
     * @return null|array
     * @throws \Throwable
     */
    public function resolveIpToAsn()
    {
        $ip = \XF::app()->request()->getIp();
        if (!$ip)
        {
            return null;
        }

        $headers = [];
        $url = "https://pro.ip-api.com/json/{$ip}?key=" . \urlencode($this->asnConfig['ipApiKey']);

        $response = $this->httpApiQuery($url, $headers);
        if (empty($response['as']))
        {
            return null;
        }

        if (\preg_match("#^as(\d+)\s+(.*)$#", $response['as'], $matches))
        {
            $asn = (int)$matches[1];
            $isp = $matches[2];
            if ($asn > 0)
            {
                return [$asn, $isp, $response['countryCode'] ?? null];
            }
        }

        return null;
    }
}