<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\Asn;

use SV\SignupAbuseBlocking\Spam\AsnProvider;

class Ripe extends AsnProvider
{
    public function isEnabled(): bool
    {
        return !empty($this->asnConfig['ripe']);
    }

    /**
     * @return null|array
     * @throws \Throwable
     */
    public function resolveIpToAsn()
    {
        $ip = \XF::app()->request()->getIp();
        if (!$ip)
        {
            return null;
        }

        $networkInfo = $this->httpApiQuery('https://stat.ripe.net/data/network-info/data.json?resource=' . $ip);
        if (empty($networkInfo['data']['asns'][0]))
        {
            return null;
        }
        $asn = $networkInfo['data']['asns'][0];


        $asInfo = $this->httpApiQuery('https://stat.ripe.net/data/as-overview/data.json?resource=AS' . $asn);
        if (empty($asInfo['data']['holder']))
        {
            return null;
        }

        $asCountry = null;

        return [$asn, $asInfo['data']['holder'], $asCountry];
    }
}