<?php

namespace SV\SignupAbuseBlocking\Service;

use SV\SignupAbuseBlocking\Repository\AbstractAllowOrBanItem as ItemRepo;
use XF\App as BaseApp;
use XF\Mvc\Entity\Repository;
use XF\Mvc\Entity\Structure as EntityStructure;
use XF\Service\AbstractService;
use League\Csv\Reader as CsvReader;

/**
 * Class AbstractCsvImport
 *
 * @package SV\SignupAbuseBlocking\Service
 */
abstract class AbstractCsvImport extends AbstractService
{
    /**
     * @param CsvReader $reader
     */
    abstract public function import(CsvReader $reader);

    protected function app(): BaseApp
    {
        return $this->app;
    }

    /**
     * @return Repository|ItemRepo
     */
    protected function getItemRepo(): ItemRepo
    {
        return $this->app()->repository($this->getIdentifier());
    }

    protected function getStructure():EntityStructure
    {
        return $this->em()->getEntityStructure($this->getIdentifier());
    }

    /**
     * @return string|int
     */
    protected function getPrimaryKey()
    {
        return $this->getStructure()->primaryKey;
    }
}