<?php


namespace SV\SignupAbuseBlocking\Report;

use SV\SignupAbuseBlocking\Entity\LogEvent;
use XF\Entity\Report;
use XF\Mvc\Entity\Entity;
use XF\Report\AbstractHandler;

class MultipleAccount extends AbstractHandler
{
    /**
     * @param Report|\SV\SignupAbuseBlocking\XF\Entity\Report $report
     * @return bool
     */
    protected function canViewContent(Report $report): bool
    {
        /** @var \SV\SignupAbuseBlocking\XF\Entity\User $visitor */
        $visitor = \XF::visitor();

        return $visitor->canViewMultiAccountReport();
    }

    /**
     * @param Report|\SV\SignupAbuseBlocking\XF\Entity\Report $report
     * @param Entity                                          $content
     */
    public function setupReportEntityContent(Report $report, Entity $content)
    {
        /** @var \XF\Entity\User $content */
        $reportData  = $report->ReportData;
        if (!$reportData)
        {
            $logEvent = $content->getOption('svMultiAccountLogEvent') ?: null;
            if ($logEvent instanceof LogEvent)
            {
                $reportData = $logEvent->ReportData;
            }
        }

        $report->content_user_id = $content->user_id;
        $report->content_info = [
            'user_id'        => $content->user_id,
            'username'       => $content->username,
            'report_data_id' => $reportData ? $reportData->report_data_id : null
        ];
    }

    /**
     * @param $id
     * @return null|\XF\Mvc\Entity\ArrayCollection|Entity
     */
    public function getContent($id)
    {
        return \XF::app()->findByContentType('user', $id, $this->getEntityWith());
    }

    public function getEntityWith(): array
    {
        return ['Profile'];
    }

    /**
     * @param Report|\SV\SignupAbuseBlocking\XF\Entity\Report $report
     * @return \XF\Phrase
     */
    public function getContentTitle(Report $report): \XF\Phrase
    {
        $reportData = $report->ReportData;
        $count = $reportData ? $reportData->countUniqueAccounts() : 0;

        $content = $report->content_info;

        if ($report->content_user_id && $report->User)
        {
            $name = $report->User->username;
        }
        else
        {
            $name = $content['username'] ?? 'Guest';
        }

        return \XF::phraseDeferred('sv_multiple_accounts.report_subject', [
            'username' => $name,
            'count'    => $count,
        ]);
    }

    /**
     * @param Report|\SV\SignupAbuseBlocking\XF\Entity\Report $report
     * @return string|\XF\Phrase
     */
    public function getContentMessage(Report $report)
    {
        return '';
    }

    /**
     * @param Report $report
     * @return string
     */
    public function getContentLink(Report $report): string
    {
        return \XF::app()->router('public')->buildLink('canonical:members', $report->User);
    }
}