<?php

namespace SV\SignupAbuseBlocking\Option;

use XF\Entity\Option;
use XF\Option\AbstractOption;

class DefaultLinkAction extends AbstractOption
{
    public static function renderOption(Option $option, array $htmlParams): string
    {
        $choices = [];

        $app = \XF::app();
        $em = $app->em();

        foreach ($app->getContentTypeField('entity') AS $contentType => $entityName)
        {
            $class = \XF::stringToClass($entityName, '%s\Entity\%s');
            if (!\class_exists($class))
            {
                continue;
            }
            // detect invalid content type+entity configuration; Vault Wiki appears a major offender
            try
            {
                $structure = $em->getEntityStructure($entityName);
            }
            catch(\Throwable $e)
            {
                $structure = null;
            }
            if ($structure === null)
            {
                continue;
            }

            $value = $option->option_value[$contentType] ?? '';
            $choices[] = [
                'phraseName'  => \XF::phrase($app->getContentTypePhraseName($contentType)),
                'contentType' => $contentType,
                'value'       => $value,
                'selected'    => \strlen($value) !== 0,
            ];
        }

        return self::getTemplate(
            'admin:option_template_signup_blocking_default_link_block',
            $option,
            $htmlParams, [
                'choices' => $choices,
                'nextCounter' => \count($choices)
            ]
        );
    }

    public static function verifyOption(array &$values, Option $option): bool
    {
        if ($option->isInsert())
        {
            // insert - just trust the default value
            return true;
        }

        $contentTypes = \XF::app()->getContentTypeField('entity');
        $output = [];

        foreach ($values AS $contentType => $value)
        {
            if (isset($contentTypes[$contentType]) && ($value['checked'] ?? false))
            {
                $value = $value['value'] ?? '';
                if (\strlen($value) !== 0)
                {
                    $output[$contentType] = $value;
                }
            }
        }

        $values = $output;
        return true;
    }
}