<?php

namespace SV\SignupAbuseBlocking\Option;

use XF\Entity\Option;
use XF\Option\AbstractOption;

class ApprovalQueue extends AbstractOption
{
    public static function renderOption(Option $option, array $htmlParams): string
    {
        $contentTypes = \array_keys(\XF::app()->getContentTypeField('approval_queue_handler_class'));

        $value = [];
        $choices = [];
        $app = \XF::app();
        $em = $app->em();
        foreach ($contentTypes AS $type)
        {
            // detect invalid content type+entity configuration; Vault Wiki appears a major offender
            try
            {
                $entityName = $app->getContentTypeEntity($type, false);
                $structure = $entityName ? $em->getEntityStructure($entityName) : null;
            }
            catch(\Throwable $e)
            {
                $structure = null;
            }
            if ($structure === null)
            {
                continue;
            }

            if ($option->option_value[$type] ?? false)
            {
                $value[] = $type;
            }
            $choices[$type] = \XF::app()->getContentTypePhrase($type);
        }

        return self::getCheckboxRow($option, $htmlParams, $choices, $value);
    }

    public static function verifyOption(array &$choices, Option $option): bool
    {
        if ($option->isInsert())
        {
            // insert - just trust the default value
            return true;
        }

        $contentTypes = \XF::app()->getContentTypeField('approval_queue_handler_class');
        $values = [];
        foreach ($choices AS $contentType)
        {
            if ($contentTypes[$contentType] ?? false)
            {
                $values[$contentType] = true;
            }
        }

        $choices = $values;

        return true;
    }
}
