<?php

/*
 * This file is part of a XenForo add-on.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace SV\SignupAbuseBlocking\MultipleAccount;

use SV\SignupAbuseBlocking\Entity\Token;
use SV\SignupAbuseBlocking\XF\Entity\User;

class DetectionRecord
{
    /** @var User */
    public $user;
    /** @var DetectionMethod[] */
    public $methods;
    /** @var \SV\SignupAbuseBlocking\Entity\Log */
    public $log;
    /** @var Token */
    public $token;

    /**
     * DetectionRecord constructor.
     *
     * @param User              $user
     * @param DetectionMethod[] $methods
     * @param Token|null        $token
     */
    public function __construct(User $user, array $methods, Token $token = null)
    {
        $this->user = $user;
        $this->methods = $methods;
        $this->token = $token;
    }
}