<?php

/*
 * This file is part of a XenForo add-on.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace SV\SignupAbuseBlocking\MultipleAccount;


class DetectionMethodIp extends DetectionMethod
{
    /** @var string[] */
    public $ipAddress;

    /**
     * DetectionMethodCookie constructor.
     *
     * @param string|string[] $ipAddress
     */
    public function __construct($ipAddress)
    {
        parent::__construct('ip');
        if (!\is_array($ipAddress))
        {
            $ipAddress = [$ipAddress];
        }
        $this->ipAddress = $ipAddress;
    }

    /**
     * @param string|string[] $ipAddress
     */
    public function addIps($ipAddress)
    {
        if (!\is_array($ipAddress))
        {
            $ipAddress = [$ipAddress];
        }

        $this->ipAddress = \array_unique(\array_merge($this->ipAddress, $ipAddress), \SORT_STRING);
    }

    public function forPhraseData(): array
    {
        return ['ip' => \join(', ', $this->ipAddress)];
    }
}