<?php

namespace SV\SignupAbuseBlocking\ControllerPlugin;

use XF\ControllerPlugin\AbstractPlugin;
use XF\Mvc\Entity\ArrayCollection;
use XF\Mvc\Reply\AbstractReply;

/**
 * Class MultipleAccount
 *
 * @package SV\SignupAbuseBlocking\ControllerPlugin
 */
class MultipleAccount extends AbstractPlugin
{
    public function multipleAccountList(\XF\Entity\User $user, string $pagePath, string $viewName, array $additionalLinkParams = [], $noFilterContainer = null): AbstractReply
    {
        /** @var \SV\SignupAbuseBlocking\Finder\Log $finder */
        $finder = $this->finder('SV\SignupAbuseBlocking:Log');
        $finder->asActive()
            ->byUser($user);


        $linkParams = [];
        $reportDataParams = [];
        if (!empty($additionalLinkParams['report_data_id']))
        {
            $reportDataId = $additionalLinkParams['report_data_id'];

            $reportDataParams['report_data_id'] = $reportDataId;
            $linkParams['report_data_id'] = $reportDataId;
            unset($additionalLinkParams['report_data_id']);

            $finder->inReportData($reportDataId);
        }
        else
        {
            $finder->order('detection_date', 'desc');
        }

        $total = $finder->total();
        $page = $this->filterPage();
        $perPage = 40;


        $originalUsersStr = $this->filter('users', 'str');
        $linkParams['users'] = $originalUsersStr;
        $usersArr = \XF\Util\Arr::stringToArray($originalUsersStr, '/\s*,\s*/');
        if (\count($usersArr))
        {
            foreach($usersArr as &$username)
            {
                $username = '%'.$username.'%';
            }
            $finder->whereOr(['User.username', 'like', $usersArr], ['LogEvent.username', 'like', $usersArr]);
        }

        $originalEmailsStr = $this->filter('emails', 'str');
        $linkParams['emails'] = $originalEmailsStr;
        $emailsArr = \XF\Util\Arr::stringToArray($originalEmailsStr, '/\s*,\s*/');
        if (\count($emailsArr))
        {
            foreach($emailsArr as &$email)
            {
                $email = '%'.$email.'%';
            }
            $finder->where('User.email', 'like', $emailsArr);
        }

        $logs = $finder->limitByPage($page, $perPage)->fetch();
        $finder->loadUserRecords($logs);

        // collect logs by event
        /** @var \SV\SignupAbuseBlocking\Entity\LogEvent [] $events */
        $events = [];
        $logsByEvents = [];
        /** @var \SV\SignupAbuseBlocking\Entity\Log $log */
        foreach($logs as $log)
        {
            if (empty($events[$log->event_id]))
            {
                $events[$log->event_id] = clone $log->LogEvent;
            }
            $logsByEvents[$log->event_id][] = $log;
        }
        foreach($logsByEvents as $eventId => $logs)
        {
            $events[$eventId]->hydrateRelation('Logs', new ArrayCollection($logs));
        }

        $viewParams = [
            'filterUrl' => $this->buildLink($pagePath, $user, $reportDataParams),
            'paginationUrl' => $this->buildLink($pagePath, $user, $linkParams),

            'user' => $user,
            'events' => $events,

            'users' => $originalUsersStr,
            'emails' => $originalEmailsStr,

            'page' => $page,
            'perPage' => $perPage,
            'total' => $total,
            'linkParams' => array_merge($linkParams, $additionalLinkParams),

            'noFilterContainer' => $noFilterContainer,
        ];

        return $this->view($viewName, 'public:sv_multiple_account_list', $viewParams);
    }
}