<?php

namespace SV\SignupAbuseBlocking\XF\Service\User;

/**
 * Extends \XF\Service\User\PasswordReset
 */
class PasswordReset extends XFCP_PasswordReset
{
    /** @noinspection PhpMissingReturnTypeInspection */
    public function resetLostPassword($newPassword)
    {
        $user = parent::resetLostPassword($newPassword);

        $visitor = \XF::visitor();
        if (!$this->isAdminReset && $visitor->user_id && $this->user->user_id && $visitor->user_id !== $this->user->user_id)
        {
            // This can happen as it means another user has used this user's email confirmation link(s). Log as an explicit multi-account trigger
            /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
            $multipleAccountRepo = $this->repository('SV\SignupAbuseBlocking:MultipleAccount');
            $multipleAccountRepo->handleSharedEmailLink($visitor, $this->user);
        }

        return $user;
    }
}