<?php

namespace SV\SignupAbuseBlocking\XF\Service\User;

use XF\Entity\User;

class Login extends XFCP_Login
{
    /**
     * @param string $password
     * @param null   $error
     * @return null|User
     * @throws \Throwable
     * @throws \XF\PrintableException
     */
    public function validate($password, &$error = null)
    {
        $user = parent::validate($password, $error);

        $svLoginFloodLimit = (int)(\XF::options()->svLoginFloodLimit ?? 0);
        if ($user instanceof User && $svLoginFloodLimit > 0)
        {
            if (!$user->hasPermission('general', 'bypassFloodCheck'))
            {
                /** @var \XF\Service\FloodCheck $floodChecker */
                $floodChecker = $this->service('XF:FloodCheck');
                $timeRemaining = $floodChecker->checkFlooding('sv_login', $user->user_id, $svLoginFloodLimit);
                if ($timeRemaining)
                {
                    $error = \XF::phrase('sv_must_wait_x_seconds_before_attempting_to_login', ['count' => $timeRemaining]);

                    // trigger multi-account detection, even tho we block the login
                    if (!$user->user_id)
                    {
                        return null;
                    }

                    try
                    {
                        /** @var \SV\SignupAbuseBlocking\XF\Entity\User $user */
                        /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
                        $multipleAccountRepo = $this->repository('SV\SignupAbuseBlocking:MultipleAccount');
                        $dataCollection = \XF::asVisitor($user, function () use ($user, $multipleAccountRepo) {
                            $receivedToken =  $multipleAccountRepo->getCookieValue('login');

                            return $multipleAccountRepo->detectMultipleAccounts($user, $receivedToken);
                        });

                        if ($dataCollection)
                        {
                            $multipleAccountRepo->processMultipleAccountDetection($user, $dataCollection, 'login');
                        }
                    }
                    catch (\Throwable $e)
                    {
                        // do not block login if any sort of error occurs
                        \XF::logException($e, true);
                        if (\XF::$developmentMode)
                        {
                            throw $e;
                        }
                    }

                    return null;
                }
            }
        }

        return $user;
    }
}