<?php

namespace SV\SignupAbuseBlocking\XF\Service\User;

use SV\SignupAbuseBlocking\XF\Entity\User as UserEntity;

/**
 * Extends \XF\Service\User\EmailConfirmation
 */
class EmailConfirmation extends XFCP_EmailConfirmation
{
    protected function advanceUserState()
    {
        /** @var UserEntity $user */
        $user = $this->user;
        $wasInEmailConfirm = $user->user_state === 'email_confirm';

        parent::advanceUserState();

        if ($wasInEmailConfirm && $user->user_state === 'moderated' &&
            $user->isRequireEmailConfirmationFromApprovalQueue(false))
        {
            // XenForo pushes from email_confirm => moderated when manual approval is true
            // but "Require email confirmation (always notifies)" pushes from moderated => email_confirm
            // avoid the loop
            $this->user->user_state = 'valid';
        }

        $visitor = \XF::visitor();
        if ($visitor->user_id && $this->user->user_id && $visitor->user_id !== $this->user->user_id)
        {
            // This can happen as it means another user has used this user's email confirmation link(s). Log as an explicit multi-account trigger
            /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
            $multipleAccountRepo = $this->repository('SV\SignupAbuseBlocking:MultipleAccount');
            $multipleAccountRepo->handleSharedEmailLink($visitor, $this->user);
        }
    }
}