<?php
/**
 * @noinspection PhpMissingReturnTypeInspection
 */

namespace SV\SignupAbuseBlocking\XF\Repository;

/**
 * Extends \XF\Repository\Report
 */
class Report extends XFCP_Report
{
    /**
     * @param array $state
     * @param int|null  $timeFrame
     * @return \XF\Finder\Report
     */
    public function findReports($state = ['open', 'assigned'], $timeFrame = null)
    {
        $finder = parent::findReports($state, $timeFrame);

        $finder->with('ReportData');

        return $finder;
    }

    public function filterViewableReports($reports)
    {
        /** @noinspection PhpDeprecationInspection */
        $reports = parent::filterViewableReports($reports);

        /** @var \SV\SignupAbuseBlocking\XF\Entity\User $visitor */
        $visitor = \XF::visitor();
        if ($reports && $reports->count() > 0 && $visitor->canViewMultiAccountReport())
        {
            $multiAccountReports = [];
            /** @var \XF\Entity\Report $report */
            foreach($reports as $reportId => $report)
            {
                if ($report->content_type === 'multiple_account')
                {
                    $multiAccountReports[$reportId] = $report;
                }
            }

            if ($multiAccountReports)
            {
                $reportData = \XF::finder('SV\SignupAbuseBlocking:ReportData')
                                 ->where('report_id', '=', \array_keys($multiAccountReports))
                                 ->where('active', '=', 1)
                                 ->keyedBy('report_id')
                                 ->fetch();

                foreach ($multiAccountReports as $reportId => $report)
                {
                    $report->hydrateRelation('ReportData', isset($reportData[$reportId]) ? $reportData[$reportId] : null);
                }
            }
        }

        return $reports;
    }
}