<?php

namespace SV\SignupAbuseBlocking\XF\Pub\Controller;

/**
 * Extends \XF\Pub\Controller\Misc
 */
class Misc extends XFCP_Misc
{
    public function actionAsnInfo()
    {
        if (!\XF::visitor()->canViewIps())
        {
            return $this->notFound();
        }

        $asn = $this->filter('asn', 'str');
        $url = $this->options()->svAsnInfoUrl ?? '';
        if (\strlen($url) === 0)
        {
            return $this->notFound();
        }

        if (\strpos($url, '{asn}') === false)
        {
            $url = 'https://www.peeringdb.com/advanced_search?reftag=org&asn={asn}';
        }

        return $this->redirectPermanently(\str_replace('{asn}', \urlencode($asn), $url));
    }
}