<?php
/**
 * @noinspection PhpMissingReturnTypeInspection
 */

namespace SV\SignupAbuseBlocking\XF\Pub\Controller;

use SV\SignupAbuseBlocking\Globals;
use XF\Mvc\ParameterBag;

/**
 * Extends \XF\Pub\Controller\Login
 */
class Login extends XFCP_Login
{
    /** @var null|string */
    protected $actionL = null;

    public function preDispatch($action, ParameterBag $params)
    {
        $this->actionL = \strtolower($action);
        parent::preDispatch($action, $params);
    }

    protected function preDispatchController($action, ParameterBag $params)
    {
        Globals::$armLoginPlugin = true;
        parent::preDispatchController($action, $params);
    }

    public function assertNotBanned()
    {
        if ((\XF::options()->svAllowBannedLogout ?? false) && $this->actionL === 'logout')
        {
            return;
        }

        parent::assertNotBanned();
    }

    public function assertNotRejected($action)
    {
        if ((\XF::options()->svAllowRejectedLogout ?? false) && $this->actionL === 'logout')
        {
            return;
        }

        parent::assertNotRejected($action);
    }

    protected function svRegCookieJuggle()
    {
        $session = \XF::session();
        $cookie = $session->get('svRegCookie');
        if ($cookie)
        {
            /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
            $multipleAccountRepo = $this->repository('SV\SignupAbuseBlocking:MultipleAccount');
            $multipleAccountRepo->setCookieValue($cookie);

            $session->remove('svRegCookie');
        }
    }

    public function actionLogout(ParameterBag $params)
    {
        return $this->rerouteController('XF:Logout', 'index', $params);
    }

    public function actionRegister(ParameterBag $params)
    {
        $this->svRegCookieJuggle();
        Globals::$redirectedRegistration = true;
        return $this->rerouteController('XF:Register', 'index', $params);
    }

    public function actionRegisterRegister(ParameterBag $params)
    {
        $this->svRegCookieJuggle();
        Globals::$redirectedRegistration = true;
        return $this->rerouteController('XF:Register', 'register', $params);
    }

    public function actionRegisterConnectedAccounts(ParameterBag $params)
    {
        $this->svRegCookieJuggle();
        Globals::$redirectedRegistration = true;
        return $this->rerouteController('XF:Register', 'connectedAccount', $params);
    }

    public function actionRegisterConnectedAccountsAssociate(ParameterBag $params)
    {
        $this->svRegCookieJuggle();
        Globals::$redirectedRegistration = true;
        return $this->rerouteController('XF:Register', 'connectedAccountAssociate', $params);
    }

    public function actionRegisterConnectedAccountsRegister(ParameterBag $params)
    {
        $this->svRegCookieJuggle();
        Globals::$redirectedRegistration = true;
        return $this->rerouteController('XF:Register', 'connectedAccountRegister', $params);
    }
}