<?php

namespace SV\SignupAbuseBlocking\XF\Pub\Controller;

use XF\Mvc\ParameterBag;

/**
 * Extends \XF\Pub\Controller\Account
 */
class Account extends XFCP_Account
{
    protected $actionL = null;

    public function preDispatch($action, ParameterBag $params)
    {
        $this->actionL = \strtolower($action);
        parent::preDispatch($action, $params);
    }

    public function assertNotBanned()
    {
        if ((\XF::options()->svAllowBannedLogout ?? false) && $this->actionL === 'visitormenu')
        {
            return;
        }
        parent::assertNotBanned();
    }

    public function assertNotRejected($action)
    {
        if ((\XF::options()->svAllowRejectedLogout ?? false) && $this->actionL === 'visitormenu')
        {
            return;
        }

        parent::assertNotRejected($action);
    }
}