<?php

namespace SV\SignupAbuseBlocking\Util;

use function array_unique;
use function strtoupper, strtolower;

abstract class LanguageList
{
    // ISO 639-2 Language codes
    // https://www.loc.gov/standards/iso639-2/
    // https://www.loc.gov/standards/iso639-2/ISO-639-2_8859-1.txt
    // This list has been generated by a small c# program which iterates supported cultures and generates a list of languages by country
    public static $languageList = [
        'AD' => [
            'ca',
        ],
        'AE' => [
            'ar',
            'en',
        ],
        'AF' => [
            'prs',
            'ps',
            'uz',
        ],
        'AG' => [
            'en',
        ],
        'AI' => [
            'en',
        ],
        'AL' => [
            'sq',
        ],
        'AM' => [
            'hy',
        ],
        'AO' => [
            'ln',
            'pt',
        ],
        'AR' => [
            'es',
        ],
        'AS' => [
            'en',
        ],
        'AT' => [
            'de',
            'en',
        ],
        'AU' => [
            'en',
        ],
        'AW' => [
            'nl',
        ],
        'AX' => [
            'sv',
        ],
        'AZ' => [
            'az',
            'az',
        ],
        'BA' => [
            'bs',
            'bs',
            'hr',
            'sr',
            'sr',
        ],
        'BB' => [
            'en',
        ],
        'BD' => [
            'bn',
            'ccp',
        ],
        'BE' => [
            'de',
            'en',
            'fr',
            'nl',
        ],
        'BF' => [
            'ff',
            'fr',
        ],
        'BG' => [
            'bg',
        ],
        'BH' => [
            'ar',
        ],
        'BI' => [
            'en',
            'fr',
            'rn',
        ],
        'BJ' => [
            'fr',
            'yo',
        ],
        'BL' => [
            'fr',
        ],
        'BM' => [
            'en',
        ],
        'BN' => [
            'ms',
        ],
        'BO' => [
            'es',
            'quz',
        ],
        'BQ' => [
            'nl',
        ],
        'BR' => [
            'es',
            'pt',
        ],
        'BS' => [
            'en',
        ],
        'BT' => [
            'dz',
        ],
        'BW' => [
            'en',
            'tn',
        ],
        'BY' => [
            'be',
            'ru',
        ],
        'BZ' => [
            'en',
            'es',
        ],
        'CA' => [
            'en',
            'fr',
            'iu',
            'iu',
            'moh',
        ],
        'CC' => [
            'en',
        ],
        'CD' => [
            'fr',
            'ln',
            'lu',
            'sw',
        ],
        'CF' => [
            'fr',
            'ln',
            'sg',
        ],
        'CG' => [
            'fr',
            'ln',
        ],
        'CH' => [
            'de',
            'en',
            'fr',
            'gsw',
            'it',
            'pt',
            'rm',
            'wae',
        ],
        'CI' => [
            'fr',
        ],
        'CK' => [
            'en',
        ],
        'CL' => [
            'arn',
            'es',
        ],
        'CM' => [
            'agq',
            'bas',
            'dua',
            'en',
            'ewo',
            'ff',
            'fr',
            'jgo',
            'kkj',
            'ksf',
            'mgo',
            'mua',
            'nmg',
            'nnh',
            'yav',
        ],
        'CN' => [
            'bo',
            'ii',
            'mn',
            'ug',
            'zh',
        ],
        'CO' => [
            'es',
        ],
        'CR' => [
            'es',
        ],
        'CU' => [
            'es',
        ],
        'CV' => [
            'kea',
            'pt',
        ],
        'CW' => [
            'nl',
        ],
        'CX' => [
            'en',
        ],
        'CY' => [
            'el',
            'en',
            'tr',
        ],
        'CZ' => [
            'cs',
        ],
        'DE' => [
            'de',
            'dsb',
            'en',
            'hsb',
            'ksh',
            'nds',
        ],
        'DJ' => [
            'aa',
            'ar',
            'fr',
            'so',
        ],
        'DK' => [
            'da',
            'en',
            'fo',
        ],
        'DM' => [
            'en',
        ],
        'DO' => [
            'es',
        ],
        'DZ' => [
            'ar',
            'fr',
            'kab',
            'tzm',
        ],
        'EC' => [
            'es',
            'quz',
        ],
        'EE' => [
            'et',
        ],
        'EG' => [
            'ar',
        ],
        'ER' => [
            'aa',
            'ar',
            'byn',
            'en',
            'ssy',
            'ti',
            'tig',
        ],
        'ES' => [
            'ast',
            'ca',
            'ca',
            'es',
            'eu',
            'gl',
        ],
        'ET' => [
            'aa',
            'am',
            'om',
            'so',
            'ti',
            'wal',
        ],
        'FI' => [
            'en',
            'fi',
            'se',
            'smn',
            'sms',
            'sv',
        ],
        'FJ' => [
            'en',
        ],
        'FK' => [
            'en',
        ],
        'FM' => [
            'en',
        ],
        'FO' => [
            'fo',
        ],
        'FR' => [
            'br',
            'ca',
            'co',
            'fr',
            'gsw',
            'oc',
        ],
        'GA' => [
            'fr',
        ],
        'GB' => [
            'cy',
            'en',
            'gd',
            'kw',
        ],
        'GD' => [
            'en',
        ],
        'GE' => [
            'ka',
            'os',
        ],
        'GF' => [
            'fr',
        ],
        'GG' => [
            'en',
        ],
        'GH' => [
            'ak',
            'ee',
            'en',
            'ff',
            'ha',
        ],
        'GI' => [
            'en',
        ],
        'GL' => [
            'da',
            'kl',
        ],
        'GM' => [
            'en',
            'ff',
        ],
        'GN' => [
            'ff',
            'fr',
            'nqo',
        ],
        'GP' => [
            'fr',
        ],
        'GQ' => [
            'es',
            'fr',
            'pt',
        ],
        'GR' => [
            'el',
        ],
        'GT' => [
            'es',
            'quc',
        ],
        'GU' => [
            'en',
        ],
        'GW' => [
            'ff',
            'pt',
        ],
        'GY' => [
            'en',
        ],
        'HK' => [
            'en',
            'zh',
            'zh-tw',
        ],
        'HN' => [
            'es',
        ],
        'HR' => [
            'hr',
        ],
        'HT' => [
            'fr',
        ],
        'HU' => [
            'hu',
        ],
        'ID' => [
            'en',
            'id',
            'jv',
            'jv',
        ],
        'IE' => [
            'en',
            'ga',
        ],
        'IL' => [
            'ar',
            'en',
            'he',
        ],
        'IM' => [
            'en',
            'gv',
        ],
        'IN' => [
            'as',
            'bn',
            'bo',
            'brx',
            'ccp',
            'en',
            'gu',
            'hi',
            'kn',
            'kok',
            'ks',
            'ks',
            'ml',
            'mni',
            'mr',
            'ne',
            'or',
            'pa',
            'sa',
            'sd',
            'ta',
            'te',
            'ur',
        ],
        'IO' => [
            'en',
        ],
        'IQ' => [
            'ar',
            'ku',
            'lrc',
        ],
        'IR' => [
            'fa',
            'ku',
            'lrc',
            'mzn',
        ],
        'IS' => [
            'is',
        ],
        'IT' => [
            'ca',
            'de',
            'fur',
            'it',
        ],
        'JE' => [
            'en',
        ],
        'JM' => [
            'en',
        ],
        'JO' => [
            'ar',
        ],
        'JP' => [
            'ja',
        ],
        'KE' => [
            'dav',
            'ebu',
            'en',
            'guz',
            'kam',
            'ki',
            'kln',
            'luo',
            'luy',
            'mas',
            'mer',
            'om',
            'saq',
            'so',
            'sw',
            'teo',
        ],
        'KG' => [
            'ky',
            'ru',
        ],
        'KH' => [
            'km',
        ],
        'KI' => [
            'en',
        ],
        'KM' => [
            'ar',
            'fr',
        ],
        'KN' => [
            'en',
        ],
        'KP' => [
            'ko',
        ],
        'KR' => [
            'ko',
        ],
        'KW' => [
            'ar',
        ],
        'KY' => [
            'en',
        ],
        'KZ' => [
            'kk',
            'ru',
        ],
        'LA' => [
            'lo',
        ],
        'LB' => [
            'ar',
        ],
        'LC' => [
            'en',
        ],
        'LI' => [
            'de',
            'gsw',
        ],
        'LK' => [
            'si',
            'ta',
        ],
        'LR' => [
            'en',
            'ff',
            'vai',
            'vai',
        ],
        'LS' => [
            'en',
            'st',
        ],
        'LT' => [
            'lt',
        ],
        'LU' => [
            'de',
            'fr',
            'lb',
            'pt',
        ],
        'LV' => [
            'lv',
        ],
        'LY' => [
            'ar',
        ],
        'MA' => [
            'ar',
            'fr',
            'shi',
            'shi',
            'tzm',
            'tzm',
            'tzm',
            'zgh',
        ],
        'MC' => [
            'fr',
        ],
        'MD' => [
            'ro',
            'ru',
        ],
        'ME' => [
            'sr',
            'sr',
        ],
        'MF' => [
            'fr',
        ],
        'MG' => [
            'en',
            'fr',
            'mg',
        ],
        'MH' => [
            'en',
        ],
        'MK' => [
            'mk',
            'sq',
        ],
        'ML' => [
            'bm',
            'fr',
            'khq',
            'ses',
        ],
        'MM' => [
            'my',
        ],
        'MN' => [
            'mn',
            'mn',
        ],
        'MO' => [
            'en',
            'pt',
            'zh',
            'zh',
        ],
        'MP' => [
            'en',
        ],
        'MQ' => [
            'fr',
        ],
        'MR' => [
            'ar',
            'ff',
            'fr',
        ],
        'MS' => [
            'en',
        ],
        'MT' => [
            'en',
            'mt',
        ],
        'MU' => [
            'en',
            'fr',
            'mfe',
        ],
        'MV' => [
            'dv',
        ],
        'MW' => [
            'en',
        ],
        'MX' => [
            'es',
        ],
        'MY' => [
            'en',
            'ms',
            'ta',
        ],
        'MZ' => [
            'mgh',
            'pt',
            'seh',
        ],
        'NA' => [
            'af',
            'en',
            'naq',
        ],
        'NC' => [
            'fr',
        ],
        'NE' => [
            'dje',
            'ff',
            'fr',
            'ha',
            'twq',
        ],
        'NF' => [
            'en',
        ],
        'NG' => [
            'bin',
            'en',
            'ff',
            'ha',
            'ibb',
            'ig',
            'kr',
            'yo',
        ],
        'NI' => [
            'es',
        ],
        'NL' => [
            'en',
            'fy',
            'nds',
            'nl',
        ],
        'NO' => [
            'nb',
            'nn',
            'se',
            'sma',
            'smj',
        ],
        'NP' => [
            'ne',
        ],
        'NR' => [
            'en',
        ],
        'NU' => [
            'en',
        ],
        'NZ' => [
            'en',
            'mi',
        ],
        'OM' => [
            'ar',
        ],
        'PA' => [
            'es',
        ],
        'PE' => [
            'es',
            'quz',
        ],
        'PF' => [
            'fr',
        ],
        'PG' => [
            'en',
        ],
        'PH' => [
            'ceb',
            'en',
            'es',
            'fil',
        ],
        'PK' => [
            'en',
            'pa',
            'ps',
            'sd',
            'ur',
        ],
        'PL' => [
            'pl',
        ],
        'PM' => [
            'fr',
        ],
        'PN' => [
            'en',
        ],
        'PR' => [
            'en',
            'es',
        ],
        'PS' => [
            'ar',
        ],
        'PT' => [
            'pt',
        ],
        'PW' => [
            'en',
        ],
        'PY' => [
            'es',
            'gn',
        ],
        'QA' => [
            'ar',
        ],
        'RE' => [
            'fr',
        ],
        'RO' => [
            'ro',
        ],
        'RS' => [
            'sr',
            'sr',
        ],
        'RU' => [
            'ba',
            'ce',
            'cu',
            'os',
            'ru',
            'sah',
            'tt',
        ],
        'RW' => [
            'en',
            'fr',
            'rw',
        ],
        'SA' => [
            'ar',
        ],
        'SB' => [
            'en',
        ],
        'SC' => [
            'en',
            'fr',
        ],
        'SD' => [
            'ar',
            'en',
        ],
        'SE' => [
            'en',
            'se',
            'sma',
            'smj',
            'sv',
        ],
        'SG' => [
            'en',
            'ms',
            'ta',
            'zh',
        ],
        'SH' => [
            'en',
        ],
        'SI' => [
            'en',
            'sl',
        ],
        'SJ' => [
            'nb',
        ],
        'SK' => [
            'sk',
        ],
        'SL' => [
            'en',
            'ff',
        ],
        'SM' => [
            'it',
        ],
        'SN' => [
            'dyo',
            'ff',
            'fr',
            'wo',
        ],
        'SO' => [
            'ar',
            'so',
        ],
        'SR' => [
            'nl',
        ],
        'SS' => [
            'ar',
            'en',
            'nus',
        ],
        'ST' => [
            'pt',
        ],
        'SV' => [
            'es',
        ],
        'SX' => [
            'en',
            'nl',
        ],
        'SY' => [
            'ar',
            'fr',
            'syr',
        ],
        'SZ' => [
            'en',
            'ss',
        ],
        'TC' => [
            'en',
        ],
        'TD' => [
            'ar',
            'fr',
        ],
        'TG' => [
            'ee',
            'fr',
        ],
        'TH' => [
            'th',
        ],
        'TJ' => [
            'tg',
        ],
        'TK' => [
            'en',
        ],
        'TL' => [
            'pt',
        ],
        'TM' => [
            'tk',
        ],
        'TN' => [
            'ar',
            'fr',
        ],
        'TO' => [
            'en',
            'to',
        ],
        'TR' => [
            'tr',
        ],
        'TT' => [
            'en',
        ],
        'TV' => [
            'en',
        ],
        'TW' => [
            'zh',
        ],
        'TZ' => [
            'asa',
            'bez',
            'en',
            'jmc',
            'kde',
            'ksb',
            'lag',
            'mas',
            'rof',
            'rwk',
            'sbp',
            'sw',
            'vun',
        ],
        'UA' => [
            'ru',
            'uk',
        ],
        'UG' => [
            'cgg',
            'en',
            'lg',
            'nyn',
            'sw',
            'teo',
            'xog',
        ],
        'UM' => [
            'en',
        ],
        'US' => [
            'chr',
            'en',
            'es',
            'haw',
            'lkt',
        ],
        'UY' => [
            'es',
        ],
        'UZ' => [
            'uz',
            'uz',
        ],
        'VA' => [
            'it',
        ],
        'VC' => [
            'en',
        ],
        'VE' => [
            'es',
        ],
        'VG' => [
            'en',
        ],
        'VI' => [
            'en',
        ],
        'VN' => [
            'vi',
        ],
        'VU' => [
            'en',
            'fr',
        ],
        'WF' => [
            'fr',
        ],
        'WS' => [
            'en',
        ],
        'XK' => [
            'sq',
            'sr',
            'sr',
        ],
        'YE' => [
            'ar',
        ],
        'YT' => [
            'fr',
        ],
        'ZA' => [
            'af',
            'en',
            'nr',
            'nso',
            'ss',
            'st',
            'tn',
            'ts',
            've',
            'xh',
            'zu',
        ],
        'ZM' => [
            'bem',
            'en',
        ],
        'ZW' => [
            'en',
            'nd',
            'sn',
        ],
    ];

    public static function buildList(): string
    {
        $list = [];
        foreach (LanguageList::$languageList as $code => $languageCodes)
        {
            $countryCode = strtoupper($code);
            if ($languageCodes)
            {
                foreach ($languageCodes as $language)
                {
                    $language = strtolower($language);
                    $list[] = '0|' . $countryCode . '-' . $language;
                    // special case english, as browsers tend to ask for en-US when requesting english
                    if ($language === 'en')
                    {
                        $list[] = '0|' . $countryCode . '-' . $language.'-US';
                    }
                }
            }
        }
        $list = array_unique($list);
        sort($list);

        return implode("\n", $list);
    }
}