<?php

namespace SV\SignupAbuseBlocking\Util;

use function strlen, is_string, explode, intval, strcmp;

class Ip
{
    public static function ipMatchesRanges(string $ip, array $ranges): bool
    {
        // copied from \XF\Http\Request::ipMatchesRanges since it is protected
        $ip = \XF\Util\Ip::convertIpStringToBinary($ip);
        if ($ip === false)
        {
            return false;
        }

        $type = strlen($ip) === 4 ? 'v4' : 'v6';

        if (empty($ranges[$type]))
        {
            return false;
        }

        foreach ($ranges[$type] AS $range)
        {
            if (is_string($range))
            {
                $range = explode('/', $range);
            }

            $rangeIp = \XF\Util\Ip::convertIpStringToBinary($range[0]);
            $cidr = intval($range[1]);

            if (self::ipMatchesCidrRange($ip, $rangeIp, $cidr))
            {
                return true;
            }
        }

        return false;
    }

    public static function ipMatchesCidrRange(string $testIp, string $rangeIp, string$cidr): bool
    {
        $range = \XF\Util\Ip::getIpCidrMatchRange($rangeIp, $cidr);
        if (is_string($range))
        {
            return ($testIp == $range);
        }
        else
        {
            return self::ipMatchesRange($testIp, $range[0], $range[1]);
        }
    }

    /**
     * Simplifies checking if an IP is within a range.
     * All IPs and ranges must be binary encoded.
     *
     * @param string $testIp
     * @param string $lowerBound
     * @param string $upperBound
     *
     * @return bool
     */
    public static function ipMatchesRange(string $testIp, string $lowerBound, string $upperBound): bool
    {
        // stock XF2.2.10 does integer comparisons and not string comparisons, which is not safe
        if (strlen($testIp) !== strlen($lowerBound))
        {
            return false;
        }

        return strcmp($testIp, $lowerBound) >= 0 && strcmp($testIp, $upperBound) <= 0;
    }
}