<?php

namespace SV\SignupAbuseBlocking\Util;

use League\Csv\Reader as CsvReader;

/**
 * Class Csv
 *
 * @package SV\SignupAbuseBlocking\Util
 */
class Csv
{
    /**
     * @param string $file
     * @return CsvReader
     */
    public static function openFile(string $file): CsvReader
    {
        if (!\file_exists($file))
        {
            throw new \InvalidArgumentException("$file does not exist");
        }

        return static::open(\file_get_contents($file));
    }

    /**
     * @param string $csv
     * @return CsvReader
     */
    public static function open(string $csv): CsvReader
    {
        return CsvReader::createFromString($csv);
    }
}