<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\GeoIp;

use SV\SignupAbuseBlocking\Spam\GeoIpProvider;

class ipStack extends GeoIpProvider
{
    public function isEnabled(): bool
    {
        return !empty($this->geoIpConfig['ipStack']) && !empty($this->geoIpConfig['ipStackKey']);
    }

    /**
     * @return null|string
     * @throws \Throwable
     */
    public function resolveGeoIp()
    {
        $ip = \XF::app()->request()->getIp();
        if (!$ip)
        {
            return null;
        }

        $url = "https://api.ipstack.com/{$ip}?output=json&fields=country_code";
        if (!empty($this->geoIpConfig['ipStackPaid']))
        {
            $url .= ',connection.asn,connection.isp';
        }
        $url .= '&access_key='.\urlencode($this->geoIpConfig['ipStackKey']);

        $response = $this->httpApiQuery($url);
        if (empty($response['country_code']))
        {
            return null;
        }

        return $response['country_code'];
    }
}