<?php

namespace SV\SignupAbuseBlocking\Spam\Checker\GeoIp;

use SV\SignupAbuseBlocking\Spam\GeoIpProvider;

class CloudFlare extends GeoIpProvider
{
    public function isEnabled(): bool
    {
        /** @var \SV\SignupAbuseBlocking\Repository\CloudFlare $cloudFlare */
        $cloudFlare = $this->app->repository('SV\SignupAbuseBlocking:CloudFlare');
        return !empty($this->geoIpConfig['cloudflare']) && $cloudFlare->canTrustCloudFlareHeaders();
    }

    /**
     * @return null|string
     */
    public function resolveGeoIp()
    {
        /** @var \SV\SignupAbuseBlocking\Repository\CloudFlare $cloudFlare */
        $cloudFlare = $this->app->repository('SV\SignupAbuseBlocking:CloudFlare');
        return $cloudFlare->getCountry();
    }
}