<?php

namespace SV\SignupAbuseBlocking\Service;

use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Finder;
use XF\Service\AbstractService;
use League\Csv\Writer as CsvWriter;

abstract class AbstractCsvExport extends AbstractService
{
    /**
     * @param Finder $finder
     *
     * @return string
     *
     * @throws \XF\PrintableException
     */
    public function export(Finder $finder): string
    {
        $writer = CsvWriter::createFromString('');

        $entities = $finder->fetch();
        if ($entities->count())
        {
            foreach ($entities AS $entity)
            {
                $this->exportEntry($entity, $writer);
            }
        }
        else
        {
            throw new \XF\PrintableException(\XF::phrase('please_select_at_least_one_x_to_export', ['tag_name' => \XF::phrase('entry')]));
        }

        return (string) $writer;
    }

    abstract protected function exportEntry(Entity $entity, CsvWriter $writer);

    protected function getColumns(): array
    {
        return [];
    }
}