<?php

namespace SV\SignupAbuseBlocking\Service;

use League\Csv\Reader as CsvReader;

abstract class AbstractAllowOrBanItemCsvImporter extends AbstractCsvImport
{
    abstract protected function getIdentifier(): string;

    /**
     * @param CsvReader $reader
     *
     * @throws \XF\PrintableException
     */
    public function import(CsvReader $reader)
    {
        $primaryKey = $this->getPrimaryKey();

        $itemRepo = $this->getItemRepo();
        foreach ($itemRepo->findItems()->fetchColumns([$primaryKey]) as $row)
        {
            $itemCache[\strtolower($row[$primaryKey])] = true;
        }

        foreach ($reader->getIterator() AS $entry)
        {
            list($primaryValue, $reason) = $entry;
            if (isset($itemCache[strtolower((string) $primaryValue)]))
            {
                // already exists
                continue;
            }

            $itemRepo->addItem($primaryValue, $reason);
        }
    }
}