<?php

namespace SV\SignupAbuseBlocking\Repository;

use SV\SignupAbuseBlocking\Globals;
use SV\SignupAbuseBlocking\Spam\AsnProvider;
use SV\SignupAbuseBlocking\Spam\GeoIpProvider;
use XF\Mvc\Entity\Repository;

/**
 * Class UserRegistrationLog
 *
 * @package SV\SignupAbuseBlocking\Repository
 */
class UserRegistrationLog extends Repository
{

    public function findUserRegistrationLogsForList(): \SV\SignupAbuseBlocking\Finder\UserRegistrationLog
    {
        $finder = $this->finder('SV\SignupAbuseBlocking:UserRegistrationLog')
            ->with('User')
            ->setDefaultOrder('log_date', 'DESC');
        assert($finder instanceof \SV\SignupAbuseBlocking\Finder\UserRegistrationLog);

        return $finder;
    }

    /**
     * @return string|null
     */
    public function resolveCountryCode()
    {
        $spamContainer = $this->app()->spam();
        if (!$spamContainer->offsetExists('geoIpProviders'))
        {
            return null;
        }
        /** @var GeoIpProvider[] $providers */
        $providers = $spamContainer->get('geoIpProviders');
        if (!$providers)
        {
            return null;
        }

        $countryCode = null;
        $unknownCountry = false;
        foreach ($providers as $provider)
        {
            $country = $provider->resolveGeoIp();
            if ($country !== null)
            {
                if ($country === 'XX')
                {
                    $unknownCountry = true;
                    continue;
                }
                $countryCode = $country;
                break;
            }
        }

        if ($unknownCountry && $countryCode === null)
        {
            $countryCode = 'XX';
        }

        return $countryCode;
    }

    /**
     * @return array|null
     */
    public function resolveAsn()
    {
        $spamContainer = $this->app()->spam();
        if (!$spamContainer->offsetExists('asnProviders'))
        {
            return null;
        }
        /** @var AsnProvider[] $providers */
        $providers = $spamContainer->get('asnProviders');
        if (!$providers)
        {
            return null;
        }

        $asn = $asName = $fallbackCountry = null;
        foreach ($providers as $provider)
        {
            $entry = $provider->resolveIpToAsn();
            if ($entry !== null)
            {
                $asn = $entry[0] ?? null;
                $asName = $entry[1] ?? null;
                $fallbackCountry = $entry[2] ?? $fallbackCountry;
                if ($asn !== null)
                {
                    break;
                }
            }
        }

        $asName = $asName ?? '';
        if ($asn === null)
        {
            // no providers configured, skip
            return null;
        }

        Globals::$asnCountryLookupFallback = $fallbackCountry;

        return [$asn, $asName];
    }
}