<?php
/**
 * @noinspection PhpMissingParamTypeInspection
 */

namespace SV\SignupAbuseBlocking\Repository;

use XF\Mvc\Entity\Repository;

/**
 * Callbacks for conversation routes.
 */
class LinkBuilder extends Repository
{
    /** @var bool */
    protected $init = false;
    /** @var callable[] */
    protected $previousCallbacks = [];

    public function hookRouteBuilder()
    {
        if ($this->init)
        {
            return;
        }
        $this->init = true;
        // patch routing on the fly, this way upgrades to XF don't break this
        $router = \XF::app()->router('public');
        $routes = $router->getRoutes();
        $hasFromClosure = is_callable('\Closure::fromCallable');
        foreach ([
                     'register' => [
                         ''                   => [$this, 'rewriteRegisterLink'],
                         'connected-accounts' => [$this, 'rewriteExternalAssociateRegisterLink']
                     ],
                     'logout' => [
                         ''                   => [$this, 'rewriteLogoutLink'],
                     ],
                 ] as $routeLabel => $subSectionToHook)
        {
            if (empty($routes[$routeLabel]))
            {
                continue;
            }

            foreach ($routes[$routeLabel] as $subSection => $route)
            {
                $callable = $subSectionToHook[$subSection] ?? null;
                if (!$callable)
                {
                    continue;
                }

                // chainable callbacks. what a hack
                if (!empty($route['build_callback']))
                {
                    $previousCallback = $route['build_callback'];
                    if ($hasFromClosure && \is_array($previousCallback))
                    {
                        /** @noinspection PhpElementIsNotAvailableInCurrentPhpVersionInspection */
                        $previousCallback = \Closure::fromCallable($previousCallback);
                    }
                    $this->previousCallbacks[$subSection] = $previousCallback;
                    $route['subSection'] = $subSection;
                }
                $route['build_callback'] = $callable;
                $router->addRoute($routeLabel, $subSection, $route);
            }
        }
    }

    /**
     * @param string         $prefix
     * @param array          $route
     * @param string         $action
     * @param mixed          $data
     * @param array          $params
     * @param \XF\Mvc\Router $router
     * @return \XF\Mvc\RouteBuiltLink|null
     */
    public function rewriteLogoutLink(&$prefix, array &$route, &$action, &$data, array &$params, \XF\Mvc\Router $router)
    {
        if ($prefix === 'logout')
        {
            if ($action === '')
            {
                $prefix = 'login';
                $action = 'logout';
            }
        }

        // chain callbacks
        if (isset($route['subSection']) && isset($this->previousCallbacks[$route['subSection']]))
        {
            $callable = $this->previousCallbacks[$route['subSection']];

            return \call_user_func_array(
                $callable,
                [&$prefix, &$route, &$action, &$data, &$params, $router]
            );
        }

        return null;
    }

    /**
     * @param string         $prefix
     * @param array          $route
     * @param string         $action
     * @param mixed          $data
     * @param array          $params
     * @param \XF\Mvc\Router $router
     * @return \XF\Mvc\RouteBuiltLink|null
     */
    public function rewriteRegisterLink(&$prefix, array &$route, &$action, &$data, array &$params, \XF\Mvc\Router $router)
    {
        if ($prefix === 'register')
        {
            if ($action === '')
            {
                $prefix = 'login';
                $action = 'register';
            }
            else if ($action === 'register')
            {
                $prefix = 'login';
                $action = 'register-register';
            }
        }

        // chain callbacks
        if (isset($route['subSection']) && isset($this->previousCallbacks[$route['subSection']]))
        {
            $callable = $this->previousCallbacks[$route['subSection']];

            return \call_user_func_array(
                $callable,
                [&$prefix, &$route, &$action, &$data, &$params, $router]
            );
        }

        return null;
    }

    /**
     * @param string         $prefix
     * @param array          $route
     * @param string         $action
     * @param mixed          $data
     * @param array          $params
     * @param \XF\Mvc\Router $router
     * @return \XF\Mvc\RouteBuiltLink|null
     */
    public function rewriteExternalAssociateRegisterLink(&$prefix, array &$route, &$action, &$data, array &$params, \XF\Mvc\Router $router)
    {
        if ($prefix === 'register')
        {
            switch($action)
            {
                case '':
                    $prefix = 'login/register';
                    $action = '';
                    break;
                case 'associate':
                    $prefix = 'login/register';
                    $action = 'associate';
                    break;
                case 'register':
                    $prefix = 'login/register';
                    $action = 'register';
                    break;
            }
        }

        // chain callbacks
        if (isset($route['subSection']) && isset($this->previousCallbacks[$route['subSection']]))
        {
            $callable = $this->previousCallbacks[$route['subSection']];

            return \call_user_func_array(
                $callable,
                [&$prefix, &$route, &$action, &$data, &$params, $router]
            );
        }

        return null;
    }
}
