<?php

namespace SV\SignupAbuseBlocking\Repository;

use SV\SignupAbuseBlocking\Listener;

/**
 * Class AllowedEmailDomain
 *
 * @package SV\SignupAbuseBlocking\Repository
 */
class AllowEmailDomain extends AbstractAllowOrBanItem
{
    public function valuesMatches(string $value, array $items)
    {
        $valueParts = \explode('@', $value, 2);
        if (\count($valueParts) !== 2)
        {
            return false; // wtf
        }
        $value = $valueParts[1];

        foreach ($items AS $item)
        {
            $itemTest = \str_replace('\\*', '(.*)', \preg_quote($item, '/'));
            if (\preg_match('/^' . $itemTest . '$/i', $value))
            {
                return $item;
            }
        }

        return false;
    }

    protected function getCacheSuffixKey(): string
    {
        return Listener::ALLOWED_EMAIL_DOMAINS_CACHE_KEY_SUFFIX;
    }
}