<?php

namespace SV\SignupAbuseBlocking\Job;

use XF\Job\AbstractRebuildJob;

class MigrateAlterEgoDetectorReports extends AbstractRebuildJob
{
    protected function getNextIds($start, $batch): array
    {
        $db = $this->app->db();

        return $db->fetchAllColumn($db->limit(
            "
				SELECT report_id
				FROM xf_report
				WHERE report_id > ? and (content_type = ? or content_type = ?)
				ORDER BY report_id
			", $batch
        ), [$start, 'alterego', 'multiple_account']);
    }

    public function decodeJsonOrSerialized($string)
    {
        // fastest possible check for serialized data
        if (!empty($string[1]) && $string[1] == ':' && preg_match('/^([abCdioOsS]:|N;$)/', $string))
        {
            return @\unserialize($string) ?: [];
        }
        else
        {
            return @\json_decode($string, true) ?: [];
        }
    }

    protected function rebuildById($id)
    {
        $db = $this->app->db();

        $db->beginTransaction();

        /** @var \XF\Entity\Report $report */
        $report = \XF::app()->find('XF:Report', $id, ['User']);
        if (!$report)
        {
            $db->commit();

            return;
        }

        $contentInfoRaw = $report->getValueSourceEncoded('content_info');
        $contentInfoOld = $this->decodeJsonOrSerialized($contentInfoRaw);
        $contentUserId = $report->content_user_id;

        if (isset($contentInfoOld['user_id']))
        {
            $contentInfo = [
                'user_id' => $contentInfoOld['user_id'],
                'username' => $contentInfoOld['username']
            ];
            if (!$contentInfo['username'] && $report->User)
            {
                $contentInfo['username'] = $report->User->username;
            }
            if (isset($contentInfoOld['report_data_id']))
            {
                $contentInfo['report_data_id'] = $contentInfoOld['report_data_id'];
            }

            $report->content_info = $contentInfo;
            $report->save(true, false);

            $db->commit();

            return;
        }
        else if (!isset($contentInfoOld[0]))
        {
            $db->commit();

            return;
        }
        $username = null;
        $userIds = [];
        foreach ($contentInfoOld[0] as $user)
        {
            if (!isset($user['user_id']))
            {
                continue;
            }
            $userId = \intval($user['user_id']);
            if (!$userId)
            {
                continue;
            }

            $userIds[$userId] = $user['username'];
            if (!$contentUserId)
            {
                $contentUserId = $userId;
            }
            if (!$username && $userId === $contentUserId)
            {
                $username = $user['username'];
            }
        }
        $contentInfo = [
            'user_id' => $contentUserId,
            'username' => $username,
            'oldUsers' => $userIds,
        ];
        if (!$contentInfo['username'] && $report->User)
        {
            $contentInfo['username'] = $report->User->username;
        }

        /** @var \XF\Repository\User $userRepo */
        $userRepo = \XF::repository('XF:User');

        $user = $report->User;
        if (!$user)
        {
            /** @var \SV\SignupAbuseBlocking\XF\Entity\User $user */
            $user = $userRepo->getGuestUser($contentInfo['username']);
            $user->svInitGuestUser($contentInfo['user_id']);
        }

        $reportDataId = $db->fetchOne('select report_id from xf_sv_multiple_account_report_data where report_id = ? and active = 1', $id);
        $reportDataId = $reportDataId ?: null;
        $isLinked = (bool)$reportDataId;
        // rewrite time to kick everything into the past
        $oldTime = \XF::$time;
        \XF::$time = $report->first_report_date;
        try
        {
            /** @var \SV\SignupAbuseBlocking\Repository\MultipleAccount $multipleAccountRepo */
            $multipleAccountRepo = \XF::repository('SV\SignupAbuseBlocking:MultipleAccount');
            $multipleAccountRepo->handleLegacyCookieValue($user, $userIds, 'legacy', true, $reportDataId);
        }
        finally
        {
            \XF::$time = $oldTime;
        }

        if ($reportDataId)
        {
            if (!$isLinked && ($reportData = \XF::app()->find('SV\SignupAbuseBlocking:ReportData', $reportDataId)))
            {
                /** @var \SV\SignupAbuseBlocking\Entity\ReportData $reportData */
                $reportData->report_id = $id;
                $reportData->save(true, false);
            }

            $contentInfo['report_data_id'] = $reportDataId;
        }

        $report->content_type = 'multiple_account';
        $report->content_info = $contentInfo;
        $report->save(true, false);

        $db->commit();
    }

    protected function getStatusType(): \XF\Phrase
    {
        return \XF::phrase('reports');
    }
}