<?php

namespace XF\Data;

class Emoji
{
	public function getEmojiListForDisplay($lazyLoad = false)
	{
		if (!\XF::config('fullUnicode'))
		{
			return [];
		}


		$list = $this->getDetailedEmojiList();
		$formatter = \XF::app()->stringFormatter()->getEmojiFormatter();

		$output = [];

		foreach ($list AS $key => $emoji)
		{
			if ($emoji['diversity'])
			{
				// TODO: Support skin-tone modifiers
				unset($list[$key]);
				continue;
			}

			if (!$emoji['gender'] && $emoji['gender_children'])
			{
				// this removes items that are essentially duplicates
				// e.g. person_raising_hand is the same as woman_raising_hand
				unset($list[$key]);
				continue;
			}

			$emoji['html'] = $formatter->getImageFromShortname($emoji['shortname'], $lazyLoad);

			$output[$emoji['shortname']] = $emoji;
		}

		return $output;
	}

	//###### GENERATED CODE START ######
	public function getDetailedEmojiList()
	{
		return [
			'1f600' => [
				'name' => \XF::phrase('emoji.grinning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grinning:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'grin', 'uc6'],
			],
			'1f603' => [
				'name' => \XF::phrase('emoji.smiley'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiley:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'mouth', 'open', 'smile', 'uc6'],
			],
			'1f604' => [
				'name' => \XF::phrase('emoji.smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smile:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eye', 'face', 'mouth', 'open', 'smile', 'uc6'],
			],
			'1f601' => [
				'name' => \XF::phrase('emoji.grin'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grin:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eye', 'face', 'grin', 'smile', 'uc6'],
			],
			'1f606' => [
				'name' => \XF::phrase('emoji.laughing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':laughing:',
				'shortname_alternates' => [':satisfied:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'laugh', 'mouth', 'open', 'satisfied', 'smile', 'uc6'],
			],
			'1f605' => [
				'name' => \XF::phrase('emoji.sweat_smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sweat_smile:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cold', 'face', 'open', 'smile', 'sweat', 'uc6'],
			],
			'1f602' => [
				'name' => \XF::phrase('emoji.joy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':joy:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'joy', 'laugh', 'tear', 'uc6'],
			],
			'1f923' => [
				'name' => \XF::phrase('emoji.rofl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rofl:',
				'shortname_alternates' => [':rolling_on_the_floor_laughing:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'floor', 'laugh', 'rolling', 'uc9'],
			],
			'263a' => [
				'name' => \XF::phrase('emoji.relaxed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':relaxed:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'outlined', 'relaxed', 'smile', 'uc1'],
			],
			'1f60a' => [
				'name' => \XF::phrase('emoji.blush'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blush:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['blush', 'eye', 'face', 'smile', 'uc6'],
			],
			'1f607' => [
				'name' => \XF::phrase('emoji.innocent'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':innocent:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angel', 'face', 'fairy tale', 'fantasy', 'halo', 'innocent', 'smile', 'uc6'],
			],
			'1f642' => [
				'name' => \XF::phrase('emoji.slight_smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':slight_smile:',
				'shortname_alternates' => [':slightly_smiling_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'smile', 'uc7'],
			],
			'1f643' => [
				'name' => \XF::phrase('emoji.upside_down'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':upside_down:',
				'shortname_alternates' => [':upside_down_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'upside-down', 'uc8'],
			],
			'1f609' => [
				'name' => \XF::phrase('emoji.wink'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wink:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'wink', 'uc6'],
			],
			'1f60c' => [
				'name' => \XF::phrase('emoji.relieved'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':relieved:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'relieved', 'uc6'],
			],
			'1f972' => [
				'name' => \XF::phrase('emoji.smiling_face_with_tear'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiling_face_with_tear:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f60d' => [
				'name' => \XF::phrase('emoji.heart_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eye', 'face', 'love', 'smile', 'uc6'],
			],
			'1f970' => [
				'name' => \XF::phrase('emoji.smiling_face_with_3_hearts'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiling_face_with_3_hearts:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f618' => [
				'name' => \XF::phrase('emoji.kissing_heart'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_heart:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'kiss', 'uc6'],
			],
			'1f617' => [
				'name' => \XF::phrase('emoji.kissing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'kiss', 'uc6'],
			],
			'1f619' => [
				'name' => \XF::phrase('emoji.kissing_smiling_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_smiling_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eye', 'face', 'kiss', 'smile', 'uc6'],
			],
			'1f61a' => [
				'name' => \XF::phrase('emoji.kissing_closed_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_closed_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['closed', 'eye', 'face', 'kiss', 'uc6'],
			],
			'1f60b' => [
				'name' => \XF::phrase('emoji.yum'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':yum:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['delicious', 'face', 'savouring', 'smile', 'um', 'yum', 'uc6'],
			],
			'1f61b' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'tongue', 'uc6'],
			],
			'1f61d' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue_closed_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue_closed_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eye', 'face', 'horrible', 'taste', 'tongue', 'uc6'],
			],
			'1f61c' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue_winking_eye'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue_winking_eye:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eye', 'face', 'joke', 'tongue', 'wink', 'uc6'],
			],
			'1f92a' => [
				'name' => \XF::phrase('emoji.zany_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zany_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eye', 'large', 'small', 'uc10'],
			],
			'1f928' => [
				'name' => \XF::phrase('emoji.face_with_raised_eyebrow'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_raised_eyebrow:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f9d0' => [
				'name' => \XF::phrase('emoji.face_with_monocle'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_monocle:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f913' => [
				'name' => \XF::phrase('emoji.nerd'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nerd:',
				'shortname_alternates' => [':nerd_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'geek', 'nerd', 'uc8'],
			],
			'1f60e' => [
				'name' => \XF::phrase('emoji.sunglasses'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sunglasses:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bright', 'cool', 'eye', 'eyewear', 'face', 'glasses', 'smile', 'sun', 'sunglasses', 'uc6'],
			],
			'1f929' => [
				'name' => \XF::phrase('emoji.star_struck'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':star_struck:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f973' => [
				'name' => \XF::phrase('emoji.partying_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':partying_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f60f' => [
				'name' => \XF::phrase('emoji.smirk'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smirk:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'smirk', 'uc6'],
			],
			'1f612' => [
				'name' => \XF::phrase('emoji.unamused'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':unamused:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'unamused', 'unhappy', 'uc6'],
			],
			'1f61e' => [
				'name' => \XF::phrase('emoji.disappointed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':disappointed:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['disappointed', 'face', 'uc6'],
			],
			'1f614' => [
				'name' => \XF::phrase('emoji.pensive'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pensive:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dejected', 'face', 'pensive', 'uc6'],
			],
			'1f61f' => [
				'name' => \XF::phrase('emoji.worried'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':worried:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'worried', 'uc6'],
			],
			'1f615' => [
				'name' => \XF::phrase('emoji.confused'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':confused:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['confused', 'face', 'uc6'],
			],
			'1f641' => [
				'name' => \XF::phrase('emoji.slight_frown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':slight_frown:',
				'shortname_alternates' => [':slightly_frowning_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'frown', 'uc7'],
			],
			'2639' => [
				'name' => \XF::phrase('emoji.frowning2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':frowning2:',
				'shortname_alternates' => [':white_frowning_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'frown', 'uc1'],
			],
			'1f623' => [
				'name' => \XF::phrase('emoji.persevere'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':persevere:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'persevere', 'uc6'],
			],
			'1f616' => [
				'name' => \XF::phrase('emoji.confounded'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':confounded:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['confounded', 'face', 'uc6'],
			],
			'1f62b' => [
				'name' => \XF::phrase('emoji.tired_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tired_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'tired', 'uc6'],
			],
			'1f629' => [
				'name' => \XF::phrase('emoji.weary'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':weary:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'tired', 'weary', 'uc6'],
			],
			'1f97a' => [
				'name' => \XF::phrase('emoji.pleading_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pleading_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f622' => [
				'name' => \XF::phrase('emoji.cry'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cry:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cry', 'face', 'sad', 'tear', 'uc6'],
			],
			'1f62d' => [
				'name' => \XF::phrase('emoji.sob'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sob:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cry', 'face', 'sad', 'sob', 'tear', 'uc6'],
			],
			'1f624' => [
				'name' => \XF::phrase('emoji.triumph'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':triumph:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'triumph', 'won', 'uc6'],
			],
			'1f620' => [
				'name' => \XF::phrase('emoji.angry'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angry:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angry', 'face', 'mad', 'uc6'],
			],
			'1f621' => [
				'name' => \XF::phrase('emoji.rage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rage:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angry', 'face', 'mad', 'pouting', 'rage', 'red', 'uc6'],
			],
			'1f92c' => [
				'name' => \XF::phrase('emoji.face_with_symbols_over_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_symbols_over_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f92f' => [
				'name' => \XF::phrase('emoji.exploding_head'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':exploding_head:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['shocked', 'uc10'],
			],
			'1f633' => [
				'name' => \XF::phrase('emoji.flushed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':flushed:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dazed', 'face', 'flushed', 'uc6'],
			],
			'1f975' => [
				'name' => \XF::phrase('emoji.hot_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hot_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f976' => [
				'name' => \XF::phrase('emoji.cold_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cold_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f631' => [
				'name' => \XF::phrase('emoji.scream'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scream:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'fear', 'fearful', 'munch', 'scared', 'scream', 'uc6'],
			],
			'1f628' => [
				'name' => \XF::phrase('emoji.fearful'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fearful:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'fear', 'fearful', 'scared', 'uc6'],
			],
			'1f630' => [
				'name' => \XF::phrase('emoji.cold_sweat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cold_sweat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['blue', 'cold', 'face', 'mouth', 'open', 'rushed', 'sweat', 'uc6'],
			],
			'1f625' => [
				'name' => \XF::phrase('emoji.disappointed_relieved'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':disappointed_relieved:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['disappointed', 'face', 'relieved', 'whew', 'uc6'],
			],
			'1f613' => [
				'name' => \XF::phrase('emoji.sweat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sweat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cold', 'face', 'sweat', 'uc6'],
			],
			'1f917' => [
				'name' => \XF::phrase('emoji.hugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hugging:',
				'shortname_alternates' => [':hugging_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'hug', 'hugging', 'uc8'],
			],
			'1f914' => [
				'name' => \XF::phrase('emoji.thinking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thinking:',
				'shortname_alternates' => [':thinking_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'thinking', 'uc8'],
			],
			'1f92d' => [
				'name' => \XF::phrase('emoji.face_with_hand_over_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_hand_over_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f971' => [
				'name' => \XF::phrase('emoji.yawning_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':yawning_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f92b' => [
				'name' => \XF::phrase('emoji.shushing_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':shushing_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['quiet', 'shush', 'uc10'],
			],
			'1f925' => [
				'name' => \XF::phrase('emoji.lying_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lying_face:',
				'shortname_alternates' => [':liar:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'lie', 'pinocchio', 'uc9'],
			],
			'1f636' => [
				'name' => \XF::phrase('emoji.no_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':no_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'mouth', 'quiet', 'silent', 'uc6'],
			],
			'1f610' => [
				'name' => \XF::phrase('emoji.neutral_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':neutral_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['deadpan', 'face', 'neutral', 'uc6'],
			],
			'1f611' => [
				'name' => \XF::phrase('emoji.expressionless'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':expressionless:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['expressionless', 'face', 'inexpressive', 'unexpressive', 'uc6'],
			],
			'1f62c' => [
				'name' => \XF::phrase('emoji.grimacing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grimacing:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'grimace', 'uc6'],
			],
			'1f644' => [
				'name' => \XF::phrase('emoji.rolling_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rolling_eyes:',
				'shortname_alternates' => [':face_with_rolling_eyes:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eyes', 'face', 'rolling', 'uc8'],
			],
			'1f62f' => [
				'name' => \XF::phrase('emoji.hushed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hushed:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'hushed', 'stunned', 'surprised', 'uc6'],
			],
			'1f626' => [
				'name' => \XF::phrase('emoji.frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':frowning:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'frown', 'mouth', 'open', 'uc6'],
			],
			'1f627' => [
				'name' => \XF::phrase('emoji.anguished'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':anguished:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['anguished', 'face', 'uc6'],
			],
			'1f62e' => [
				'name' => \XF::phrase('emoji.open_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'mouth', 'open', 'sympathy', 'uc6'],
			],
			'1f632' => [
				'name' => \XF::phrase('emoji.astonished'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astonished:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['astonished', 'face', 'shocked', 'totally', 'uc6'],
			],
			'1f634' => [
				'name' => \XF::phrase('emoji.sleeping'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sleeping:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'sleep', 'zzz', 'uc6'],
			],
			'1f924' => [
				'name' => \XF::phrase('emoji.drooling_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':drooling_face:',
				'shortname_alternates' => [':drool:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['drooling', 'face', 'uc9'],
			],
			'1f62a' => [
				'name' => \XF::phrase('emoji.sleepy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sleepy:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'sleep', 'uc6'],
			],
			'1f635' => [
				'name' => \XF::phrase('emoji.dizzy_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dizzy_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dizzy', 'face', 'uc6'],
			],
			'1f910' => [
				'name' => \XF::phrase('emoji.zipper_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zipper_mouth:',
				'shortname_alternates' => [':zipper_mouth_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'mouth', 'zipper', 'uc8'],
			],
			'1f974' => [
				'name' => \XF::phrase('emoji.woozy_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woozy_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f922' => [
				'name' => \XF::phrase('emoji.nauseated_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nauseated_face:',
				'shortname_alternates' => [':sick:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'nauseated', 'vomit', 'uc9'],
			],
			'1f92e' => [
				'name' => \XF::phrase('emoji.face_vomiting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_vomiting:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['sick', 'vomit', 'uc10'],
			],
			'1f927' => [
				'name' => \XF::phrase('emoji.sneezing_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sneezing_face:',
				'shortname_alternates' => [':sneeze:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'gesundheit', 'sneeze', 'uc9'],
			],
			'1f637' => [
				'name' => \XF::phrase('emoji.mask'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mask:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cold', 'doctor', 'face', 'mask', 'medicine', 'sick', 'uc6'],
			],
			'1f912' => [
				'name' => \XF::phrase('emoji.thermometer_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thermometer_face:',
				'shortname_alternates' => [':face_with_thermometer:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'ill', 'sick', 'thermometer', 'uc8'],
			],
			'1f915' => [
				'name' => \XF::phrase('emoji.head_bandage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':head_bandage:',
				'shortname_alternates' => [':face_with_head_bandage:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bandage', 'face', 'hurt', 'injury', 'uc8'],
			],
			'1f911' => [
				'name' => \XF::phrase('emoji.money_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':money_mouth:',
				'shortname_alternates' => [':money_mouth_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'money', 'mouth', 'uc8'],
			],
			'1f920' => [
				'name' => \XF::phrase('emoji.cowboy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cowboy:',
				'shortname_alternates' => [':face_with_cowboy_hat:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cowboy', 'cowgirl', 'face', 'hat', 'uc9'],
			],
			'1f978' => [
				'name' => \XF::phrase('emoji.disguised_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':disguised_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f608' => [
				'name' => \XF::phrase('emoji.smiling_imp'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiling_imp:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'fairy tale', 'fantasy', 'horns', 'smile', 'uc6'],
			],
			'1f47f' => [
				'name' => \XF::phrase('emoji.imp'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':imp:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['demon', 'devil', 'face', 'fairy tale', 'fantasy', 'imp', 'uc6'],
			],
			'1f479' => [
				'name' => \XF::phrase('emoji.japanese_ogre'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':japanese_ogre:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc6'],
			],
			'1f47a' => [
				'name' => \XF::phrase('emoji.japanese_goblin'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':japanese_goblin:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['creature', 'face', 'fairy tale', 'fantasy', 'monster', 'uc6'],
			],
			'1f921' => [
				'name' => \XF::phrase('emoji.clown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clown:',
				'shortname_alternates' => [':clown_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clown', 'face', 'uc9'],
			],
			'1f4a9' => [
				'name' => \XF::phrase('emoji.poop'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':poop:',
				'shortname_alternates' => [':shit:', ':hankey:', ':poo:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['comic', 'dung', 'face', 'monster', 'poo', 'poop', 'uc6'],
			],
			'1f47b' => [
				'name' => \XF::phrase('emoji.ghost'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ghost:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['creature', 'face', 'fairy tale', 'fantasy', 'monster', 'uc6'],
			],
			'1f480' => [
				'name' => \XF::phrase('emoji.skull'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':skull:',
				'shortname_alternates' => [':skeleton:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['death', 'face', 'fairy tale', 'monster', 'uc6'],
			],
			'2620' => [
				'name' => \XF::phrase('emoji.skull_crossbones'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':skull_crossbones:',
				'shortname_alternates' => [':skull_and_crossbones:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['crossbones', 'death', 'face', 'monster', 'skull', 'uc1'],
			],
			'1f47d' => [
				'name' => \XF::phrase('emoji.alien'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':alien:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['creature', 'extraterrestrial', 'face', 'fairy tale', 'fantasy', 'monster', 'ufo', 'uc6'],
			],
			'1f47e' => [
				'name' => \XF::phrase('emoji.space_invader'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':space_invader:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['alien', 'creature', 'extraterrestrial', 'face', 'fairy tale', 'fantasy', 'monster', 'ufo', 'uc6'],
			],
			'1f916' => [
				'name' => \XF::phrase('emoji.robot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':robot:',
				'shortname_alternates' => [':robot_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'monster', 'robot', 'uc8'],
			],
			'1f383' => [
				'name' => \XF::phrase('emoji.jack_o_lantern'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':jack_o_lantern:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['celebration', 'halloween', 'jack', 'lantern', 'uc6'],
			],
			'1f63a' => [
				'name' => \XF::phrase('emoji.smiley_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiley_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'face', 'mouth', 'open', 'smile', 'uc6'],
			],
			'1f638' => [
				'name' => \XF::phrase('emoji.smile_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smile_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'eye', 'face', 'grin', 'smile', 'uc6'],
			],
			'1f639' => [
				'name' => \XF::phrase('emoji.joy_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':joy_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'face', 'joy', 'tear', 'uc6'],
			],
			'1f63b' => [
				'name' => \XF::phrase('emoji.heart_eyes_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_eyes_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'eye', 'face', 'love', 'smile', 'uc6'],
			],
			'1f63c' => [
				'name' => \XF::phrase('emoji.smirk_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smirk_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'face', 'ironic', 'smile', 'wry', 'uc6'],
			],
			'1f63d' => [
				'name' => \XF::phrase('emoji.kissing_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'eye', 'face', 'kiss', 'uc6'],
			],
			'1f640' => [
				'name' => \XF::phrase('emoji.scream_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scream_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'face', 'oh', 'surprised', 'weary', 'uc6'],
			],
			'1f63f' => [
				'name' => \XF::phrase('emoji.crying_cat_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':crying_cat_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'cry', 'face', 'sad', 'tear', 'uc6'],
			],
			'1f63e' => [
				'name' => \XF::phrase('emoji.pouting_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pouting_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'face', 'pouting', 'uc6'],
			],
			'1f932' => [
				'name' => \XF::phrase('emoji.palms_up_together'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f932-1f3fb', '1f932-1f3fc', '1f932-1f3fd', '1f932-1f3fe', '1f932-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f932-1f3fb' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone1:',
				'shortname_alternates' => [':palms_up_together_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'prayer', 'uc10'],
			],
			'1f932-1f3fc' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone2:',
				'shortname_alternates' => [':palms_up_together_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'prayer', 'uc10'],
			],
			'1f932-1f3fd' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone3:',
				'shortname_alternates' => [':palms_up_together_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'prayer', 'uc10'],
			],
			'1f932-1f3fe' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone4:',
				'shortname_alternates' => [':palms_up_together_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'prayer', 'uc10'],
			],
			'1f932-1f3ff' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone5:',
				'shortname_alternates' => [':palms_up_together_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'prayer', 'uc10'],
			],
			'1f450' => [
				'name' => \XF::phrase('emoji.open_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f450-1f3fb', '1f450-1f3fc', '1f450-1f3fd', '1f450-1f3fe', '1f450-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'open', 'uc6'],
			],
			'1f450-1f3fb' => [
				'name' => \XF::phrase('emoji.open_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'light skin tone', 'open', 'uc8'],
			],
			'1f450-1f3fc' => [
				'name' => \XF::phrase('emoji.open_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'open', 'uc8'],
			],
			'1f450-1f3fd' => [
				'name' => \XF::phrase('emoji.open_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium skin tone', 'open', 'uc8'],
			],
			'1f450-1f3fe' => [
				'name' => \XF::phrase('emoji.open_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'open', 'uc8'],
			],
			'1f450-1f3ff' => [
				'name' => \XF::phrase('emoji.open_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'hand', 'open', 'uc8'],
			],
			'1f64c' => [
				'name' => \XF::phrase('emoji.raised_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64c-1f3fb', '1f64c-1f3fc', '1f64c-1f3fd', '1f64c-1f3fe', '1f64c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'raised', 'uc6'],
			],
			'1f64c-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'light skin tone', 'raised', 'uc8'],
			],
			'1f64c-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium-light skin tone', 'raised', 'uc8'],
			],
			'1f64c-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium skin tone', 'raised', 'uc8'],
			],
			'1f64c-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium-dark skin tone', 'raised', 'uc8'],
			],
			'1f64c-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['celebration', 'dark skin tone', 'gesture', 'hand', 'hooray', 'raised', 'uc8'],
			],
			'1f44f' => [
				'name' => \XF::phrase('emoji.clap'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44f-1f3fb', '1f44f-1f3fc', '1f44f-1f3fd', '1f44f-1f3fe', '1f44f-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clap', 'hand', 'uc6'],
			],
			'1f44f-1f3fb' => [
				'name' => \XF::phrase('emoji.clap_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clap', 'hand', 'light skin tone', 'uc8'],
			],
			'1f44f-1f3fc' => [
				'name' => \XF::phrase('emoji.clap_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clap', 'hand', 'medium-light skin tone', 'uc8'],
			],
			'1f44f-1f3fd' => [
				'name' => \XF::phrase('emoji.clap_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clap', 'hand', 'medium skin tone', 'uc8'],
			],
			'1f44f-1f3fe' => [
				'name' => \XF::phrase('emoji.clap_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clap', 'hand', 'medium-dark skin tone', 'uc8'],
			],
			'1f44f-1f3ff' => [
				'name' => \XF::phrase('emoji.clap_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clap', 'dark skin tone', 'hand', 'uc8'],
			],
			'1f91d' => [
				'name' => \XF::phrase('emoji.handshake'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake:',
				'shortname_alternates' => [':shaking_hands:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['agreement', 'hand', 'handshake', 'meeting', 'shake', 'uc9'],
			],
			'1f44d' => [
				'name' => \XF::phrase('emoji.thumbsup'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup:',
				'shortname_alternates' => [':+1:', ':thumbup:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44d-1f3fb', '1f44d-1f3fc', '1f44d-1f3fd', '1f44d-1f3fe', '1f44d-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['+1', 'hand', 'thumb', 'up', 'uc6'],
			],
			'1f44d-1f3fb' => [
				'name' => \XF::phrase('emoji.thumbsup_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone1:',
				'shortname_alternates' => [':+1_tone1:', ':thumbup_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['+1', 'hand', 'light skin tone', 'thumb', 'up', 'uc8'],
			],
			'1f44d-1f3fc' => [
				'name' => \XF::phrase('emoji.thumbsup_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone2:',
				'shortname_alternates' => [':+1_tone2:', ':thumbup_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['+1', 'hand', 'medium-light skin tone', 'thumb', 'up', 'uc8'],
			],
			'1f44d-1f3fd' => [
				'name' => \XF::phrase('emoji.thumbsup_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone3:',
				'shortname_alternates' => [':+1_tone3:', ':thumbup_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['+1', 'hand', 'medium skin tone', 'thumb', 'up', 'uc8'],
			],
			'1f44d-1f3fe' => [
				'name' => \XF::phrase('emoji.thumbsup_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone4:',
				'shortname_alternates' => [':+1_tone4:', ':thumbup_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['+1', 'hand', 'medium-dark skin tone', 'thumb', 'up', 'uc8'],
			],
			'1f44d-1f3ff' => [
				'name' => \XF::phrase('emoji.thumbsup_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone5:',
				'shortname_alternates' => [':+1_tone5:', ':thumbup_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['+1', 'dark skin tone', 'hand', 'thumb', 'up', 'uc8'],
			],
			'1f44e' => [
				'name' => \XF::phrase('emoji.thumbsdown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown:',
				'shortname_alternates' => [':-1:', ':thumbdown:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44e-1f3fb', '1f44e-1f3fc', '1f44e-1f3fd', '1f44e-1f3fe', '1f44e-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['-1', 'down', 'hand', 'thumb', 'uc6'],
			],
			'1f44e-1f3fb' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone1:',
				'shortname_alternates' => [':-1_tone1:', ':thumbdown_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['-1', 'down', 'hand', 'light skin tone', 'thumb', 'uc8'],
			],
			'1f44e-1f3fc' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone2:',
				'shortname_alternates' => [':-1_tone2:', ':thumbdown_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['-1', 'down', 'hand', 'medium-light skin tone', 'thumb', 'uc8'],
			],
			'1f44e-1f3fd' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone3:',
				'shortname_alternates' => [':-1_tone3:', ':thumbdown_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['-1', 'down', 'hand', 'medium skin tone', 'thumb', 'uc8'],
			],
			'1f44e-1f3fe' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone4:',
				'shortname_alternates' => [':-1_tone4:', ':thumbdown_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['-1', 'down', 'hand', 'medium-dark skin tone', 'thumb', 'uc8'],
			],
			'1f44e-1f3ff' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone5:',
				'shortname_alternates' => [':-1_tone5:', ':thumbdown_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['-1', 'dark skin tone', 'down', 'hand', 'thumb', 'uc8'],
			],
			'1f44a' => [
				'name' => \XF::phrase('emoji.punch'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44a-1f3fb', '1f44a-1f3fc', '1f44a-1f3fd', '1f44a-1f3fe', '1f44a-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'punch', 'uc6'],
			],
			'1f44a-1f3fb' => [
				'name' => \XF::phrase('emoji.punch_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'light skin tone', 'punch', 'uc8'],
			],
			'1f44a-1f3fc' => [
				'name' => \XF::phrase('emoji.punch_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium-light skin tone', 'punch', 'uc8'],
			],
			'1f44a-1f3fd' => [
				'name' => \XF::phrase('emoji.punch_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium skin tone', 'punch', 'uc8'],
			],
			'1f44a-1f3fe' => [
				'name' => \XF::phrase('emoji.punch_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium-dark skin tone', 'punch', 'uc8'],
			],
			'1f44a-1f3ff' => [
				'name' => \XF::phrase('emoji.punch_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'dark skin tone', 'fist', 'hand', 'punch', 'uc8'],
			],
			'270a' => [
				'name' => \XF::phrase('emoji.fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['270a-1f3fb', '270a-1f3fc', '270a-1f3fd', '270a-1f3fe', '270a-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'punch', 'uc6'],
			],
			'270a-1f3fb' => [
				'name' => \XF::phrase('emoji.fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'light skin tone', 'punch', 'uc8'],
			],
			'270a-1f3fc' => [
				'name' => \XF::phrase('emoji.fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium-light skin tone', 'punch', 'uc8'],
			],
			'270a-1f3fd' => [
				'name' => \XF::phrase('emoji.fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium skin tone', 'punch', 'uc8'],
			],
			'270a-1f3fe' => [
				'name' => \XF::phrase('emoji.fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'fist', 'hand', 'medium-dark skin tone', 'punch', 'uc8'],
			],
			'270a-1f3ff' => [
				'name' => \XF::phrase('emoji.fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clenched', 'dark skin tone', 'fist', 'hand', 'punch', 'uc8'],
			],
			'1f91b' => [
				'name' => \XF::phrase('emoji.left_facing_fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist:',
				'shortname_alternates' => [':left_fist:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91b-1f3fb', '1f91b-1f3fc', '1f91b-1f3fd', '1f91b-1f3fe', '1f91b-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'leftwards', 'uc9'],
			],
			'1f91b-1f3fb' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone1:',
				'shortname_alternates' => [':left_fist_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'leftwards', 'light skin tone', 'uc9'],
			],
			'1f91b-1f3fc' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone2:',
				'shortname_alternates' => [':left_fist_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'leftwards', 'medium-light skin tone', 'uc9'],
			],
			'1f91b-1f3fd' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone3:',
				'shortname_alternates' => [':left_fist_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'leftwards', 'medium skin tone', 'uc9'],
			],
			'1f91b-1f3fe' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone4:',
				'shortname_alternates' => [':left_fist_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'leftwards', 'medium-dark skin tone', 'uc9'],
			],
			'1f91b-1f3ff' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone5:',
				'shortname_alternates' => [':left_fist_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'fist', 'leftwards', 'uc9'],
			],
			'1f91c' => [
				'name' => \XF::phrase('emoji.right_facing_fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist:',
				'shortname_alternates' => [':right_fist:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91c-1f3fb', '1f91c-1f3fc', '1f91c-1f3fd', '1f91c-1f3fe', '1f91c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'rightwards', 'uc9'],
			],
			'1f91c-1f3fb' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone1:',
				'shortname_alternates' => [':right_fist_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'light skin tone', 'rightwards', 'uc9'],
			],
			'1f91c-1f3fc' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone2:',
				'shortname_alternates' => [':right_fist_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'medium-light skin tone', 'rightwards', 'uc9'],
			],
			'1f91c-1f3fd' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone3:',
				'shortname_alternates' => [':right_fist_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'medium skin tone', 'rightwards', 'uc9'],
			],
			'1f91c-1f3fe' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone4:',
				'shortname_alternates' => [':right_fist_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fist', 'medium-dark skin tone', 'rightwards', 'uc9'],
			],
			'1f91c-1f3ff' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone5:',
				'shortname_alternates' => [':right_fist_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'fist', 'rightwards', 'uc9'],
			],
			'1f91e' => [
				'name' => \XF::phrase('emoji.fingers_crossed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed:',
				'shortname_alternates' => [':hand_with_index_and_middle_finger_crossed:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91e-1f3fb', '1f91e-1f3fc', '1f91e-1f3fd', '1f91e-1f3fe', '1f91e-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'uc9'],
			],
			'1f91e-1f3fb' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone1:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cross', 'finger', 'hand', 'light skin tone', 'luck', 'uc9'],
			],
			'1f91e-1f3fc' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone2:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium-light skin tone', 'uc9'],
			],
			'1f91e-1f3fd' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone3:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium skin tone', 'uc9'],
			],
			'1f91e-1f3fe' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone4:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium-dark skin tone', 'uc9'],
			],
			'1f91e-1f3ff' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone5:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cross', 'dark skin tone', 'finger', 'hand', 'luck', 'uc9'],
			],
			'270c' => [
				'name' => \XF::phrase('emoji.v'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['270c-1f3fb', '270c-1f3fc', '270c-1f3fd', '270c-1f3fe', '270c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'v', 'victory', 'uc1'],
			],
			'270c-1f3fb' => [
				'name' => \XF::phrase('emoji.v_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'light skin tone', 'v', 'victory', 'uc8'],
			],
			'270c-1f3fc' => [
				'name' => \XF::phrase('emoji.v_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'v', 'victory', 'uc8'],
			],
			'270c-1f3fd' => [
				'name' => \XF::phrase('emoji.v_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium skin tone', 'v', 'victory', 'uc8'],
			],
			'270c-1f3fe' => [
				'name' => \XF::phrase('emoji.v_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'v', 'victory', 'uc8'],
			],
			'270c-1f3ff' => [
				'name' => \XF::phrase('emoji.v_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'hand', 'v', 'victory', 'uc8'],
			],
			'1f91f' => [
				'name' => \XF::phrase('emoji.love_you_gesture'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91f-1f3fb', '1f91f-1f3fc', '1f91f-1f3fd', '1f91f-1f3fe', '1f91f-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ILY', 'hand', 'uc10'],
			],
			'1f91f-1f3fb' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone1:',
				'shortname_alternates' => [':love_you_gesture_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ILY', 'hand', 'light skin tone', 'uc10'],
			],
			'1f91f-1f3fc' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone2:',
				'shortname_alternates' => [':love_you_gesture_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ILY', 'hand', 'medium-light skin tone', 'uc10'],
			],
			'1f91f-1f3fd' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone3:',
				'shortname_alternates' => [':love_you_gesture_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ILY', 'hand', 'medium skin tone', 'uc10'],
			],
			'1f91f-1f3fe' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone4:',
				'shortname_alternates' => [':love_you_gesture_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ILY', 'hand', 'medium-dark skin tone', 'uc10'],
			],
			'1f91f-1f3ff' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone5:',
				'shortname_alternates' => [':love_you_gesture_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ILY', 'dark skin tone', 'hand', 'uc10'],
			],
			'1f918' => [
				'name' => \XF::phrase('emoji.metal'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal:',
				'shortname_alternates' => [':sign_of_the_horns:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f918-1f3fb', '1f918-1f3fc', '1f918-1f3fd', '1f918-1f3fe', '1f918-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'horns', 'rock-on', 'uc8'],
			],
			'1f918-1f3fb' => [
				'name' => \XF::phrase('emoji.metal_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone1:',
				'shortname_alternates' => [':sign_of_the_horns_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'horns', 'light skin tone', 'rock-on', 'uc8'],
			],
			'1f918-1f3fc' => [
				'name' => \XF::phrase('emoji.metal_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone2:',
				'shortname_alternates' => [':sign_of_the_horns_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'horns', 'medium-light skin tone', 'rock-on', 'uc8'],
			],
			'1f918-1f3fd' => [
				'name' => \XF::phrase('emoji.metal_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone3:',
				'shortname_alternates' => [':sign_of_the_horns_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'horns', 'medium skin tone', 'rock-on', 'uc8'],
			],
			'1f918-1f3fe' => [
				'name' => \XF::phrase('emoji.metal_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone4:',
				'shortname_alternates' => [':sign_of_the_horns_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'horns', 'medium-dark skin tone', 'rock-on', 'uc8'],
			],
			'1f918-1f3ff' => [
				'name' => \XF::phrase('emoji.metal_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone5:',
				'shortname_alternates' => [':sign_of_the_horns_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'horns', 'rock-on', 'uc8'],
			],
			'1f44c' => [
				'name' => \XF::phrase('emoji.ok_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44c-1f3fb', '1f44c-1f3fc', '1f44c-1f3fd', '1f44c-1f3fe', '1f44c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['OK', 'hand', 'uc6'],
			],
			'1f44c-1f3fb' => [
				'name' => \XF::phrase('emoji.ok_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['OK', 'hand', 'light skin tone', 'uc8'],
			],
			'1f44c-1f3fc' => [
				'name' => \XF::phrase('emoji.ok_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['OK', 'hand', 'medium-light skin tone', 'uc8'],
			],
			'1f44c-1f3fd' => [
				'name' => \XF::phrase('emoji.ok_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['OK', 'hand', 'medium skin tone', 'uc8'],
			],
			'1f44c-1f3fe' => [
				'name' => \XF::phrase('emoji.ok_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['OK', 'hand', 'medium-dark skin tone', 'uc8'],
			],
			'1f44c-1f3ff' => [
				'name' => \XF::phrase('emoji.ok_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['OK', 'dark skin tone', 'hand', 'uc8'],
			],
			'1f90f' => [
				'name' => \XF::phrase('emoji.pinching_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f90f-1f3fb', '1f90f-1f3fc', '1f90f-1f3fd', '1f90f-1f3fe', '1f90f-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f90f-1f3fb' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone1:',
				'shortname_alternates' => [':pinching_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f90f-1f3fc' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone2:',
				'shortname_alternates' => [':pinching_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f90f-1f3fd' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone3:',
				'shortname_alternates' => [':pinching_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f90f-1f3fe' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone4:',
				'shortname_alternates' => [':pinching_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f90f-1f3ff' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone5:',
				'shortname_alternates' => [':pinching_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f90c' => [
				'name' => \XF::phrase('emoji.pinched_fingers'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f90c-1f3fb', '1f90c-1f3fc', '1f90c-1f3fd', '1f90c-1f3fe', '1f90c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f90c-1f3fc' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone2:',
				'shortname_alternates' => [':pinched_fingers_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f90c-1f3fb' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone1:',
				'shortname_alternates' => [':pinched_fingers_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f90c-1f3fd' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone3:',
				'shortname_alternates' => [':pinched_fingers_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f90c-1f3fe' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone4:',
				'shortname_alternates' => [':pinched_fingers_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f90c-1f3ff' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone5:',
				'shortname_alternates' => [':pinched_fingers_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f448' => [
				'name' => \XF::phrase('emoji.point_left'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f448-1f3fb', '1f448-1f3fc', '1f448-1f3fd', '1f448-1f3fe', '1f448-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point', 'uc6'],
			],
			'1f448-1f3fb' => [
				'name' => \XF::phrase('emoji.point_left_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8'],
			],
			'1f448-1f3fc' => [
				'name' => \XF::phrase('emoji.point_left_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8'],
			],
			'1f448-1f3fd' => [
				'name' => \XF::phrase('emoji.point_left_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8'],
			],
			'1f448-1f3fe' => [
				'name' => \XF::phrase('emoji.point_left_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8'],
			],
			'1f448-1f3ff' => [
				'name' => \XF::phrase('emoji.point_left_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'uc8'],
			],
			'1f449' => [
				'name' => \XF::phrase('emoji.point_right'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f449-1f3fb', '1f449-1f3fc', '1f449-1f3fd', '1f449-1f3fe', '1f449-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point', 'uc6'],
			],
			'1f449-1f3fb' => [
				'name' => \XF::phrase('emoji.point_right_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8'],
			],
			'1f449-1f3fc' => [
				'name' => \XF::phrase('emoji.point_right_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8'],
			],
			'1f449-1f3fd' => [
				'name' => \XF::phrase('emoji.point_right_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8'],
			],
			'1f449-1f3fe' => [
				'name' => \XF::phrase('emoji.point_right_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8'],
			],
			'1f449-1f3ff' => [
				'name' => \XF::phrase('emoji.point_right_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'uc8'],
			],
			'1f446' => [
				'name' => \XF::phrase('emoji.point_up_2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f446-1f3fb', '1f446-1f3fc', '1f446-1f3fd', '1f446-1f3fe', '1f446-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point', 'up', 'uc6'],
			],
			'1f446-1f3fb' => [
				'name' => \XF::phrase('emoji.point_up_2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'up', 'uc8'],
			],
			'1f446-1f3fc' => [
				'name' => \XF::phrase('emoji.point_up_2_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'up', 'uc8'],
			],
			'1f446-1f3fd' => [
				'name' => \XF::phrase('emoji.point_up_2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'up', 'uc8'],
			],
			'1f446-1f3fe' => [
				'name' => \XF::phrase('emoji.point_up_2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'up', 'uc8'],
			],
			'1f446-1f3ff' => [
				'name' => \XF::phrase('emoji.point_up_2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'up', 'uc8'],
			],
			'1f447' => [
				'name' => \XF::phrase('emoji.point_down'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f447-1f3fb', '1f447-1f3fc', '1f447-1f3fd', '1f447-1f3fe', '1f447-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'point', 'uc6'],
			],
			'1f447-1f3fb' => [
				'name' => \XF::phrase('emoji.point_down_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8'],
			],
			'1f447-1f3fc' => [
				'name' => \XF::phrase('emoji.point_down_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8'],
			],
			'1f447-1f3fd' => [
				'name' => \XF::phrase('emoji.point_down_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8'],
			],
			'1f447-1f3fe' => [
				'name' => \XF::phrase('emoji.point_down_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8'],
			],
			'1f447-1f3ff' => [
				'name' => \XF::phrase('emoji.point_down_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'dark skin tone', 'down', 'finger', 'hand', 'index', 'point', 'uc8'],
			],
			'261d' => [
				'name' => \XF::phrase('emoji.point_up'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['261d-1f3fb', '261d-1f3fc', '261d-1f3fd', '261d-1f3fe', '261d-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'index', 'point', 'up', 'uc1'],
			],
			'261d-1f3fb' => [
				'name' => \XF::phrase('emoji.point_up_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'index', 'light skin tone', 'point', 'up', 'uc8'],
			],
			'261d-1f3fc' => [
				'name' => \XF::phrase('emoji.point_up_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'index', 'medium-light skin tone', 'point', 'up', 'uc8'],
			],
			'261d-1f3fd' => [
				'name' => \XF::phrase('emoji.point_up_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'index', 'medium skin tone', 'point', 'up', 'uc8'],
			],
			'261d-1f3fe' => [
				'name' => \XF::phrase('emoji.point_up_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'up', 'uc8'],
			],
			'261d-1f3ff' => [
				'name' => \XF::phrase('emoji.point_up_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'index', 'point', 'up', 'uc8'],
			],
			'270b' => [
				'name' => \XF::phrase('emoji.raised_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['270b-1f3fb', '270b-1f3fc', '270b-1f3fd', '270b-1f3fe', '270b-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'uc6'],
			],
			'270b-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'light skin tone', 'uc8'],
			],
			'270b-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'uc8'],
			],
			'270b-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium skin tone', 'uc8'],
			],
			'270b-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'uc8'],
			],
			'270b-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'hand', 'uc8'],
			],
			'1f91a' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand:',
				'shortname_alternates' => [':back_of_hand:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91a-1f3fb', '1f91a-1f3fc', '1f91a-1f3fd', '1f91a-1f3fe', '1f91a-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'raised', 'uc9'],
			],
			'1f91a-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone1:',
				'shortname_alternates' => [':back_of_hand_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'light skin tone', 'raised', 'uc9'],
			],
			'1f91a-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone2:',
				'shortname_alternates' => [':back_of_hand_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'medium-light skin tone', 'raised', 'uc9'],
			],
			'1f91a-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone3:',
				'shortname_alternates' => [':back_of_hand_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'medium skin tone', 'raised', 'uc9'],
			],
			'1f91a-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone4:',
				'shortname_alternates' => [':back_of_hand_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'medium-dark skin tone', 'raised', 'uc9'],
			],
			'1f91a-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone5:',
				'shortname_alternates' => [':back_of_hand_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['backhand', 'dark skin tone', 'raised', 'uc9'],
			],
			'1f590' => [
				'name' => \XF::phrase('emoji.hand_splayed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f590-1f3fb', '1f590-1f3fc', '1f590-1f3fd', '1f590-1f3fe', '1f590-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'splayed', 'uc7'],
			],
			'1f590-1f3fb' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone1:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'light skin tone', 'splayed', 'uc8'],
			],
			'1f590-1f3fc' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone2:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium-light skin tone', 'splayed', 'uc8'],
			],
			'1f590-1f3fd' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone3:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium skin tone', 'splayed', 'uc8'],
			],
			'1f590-1f3fe' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone4:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium-dark skin tone', 'splayed', 'uc8'],
			],
			'1f590-1f3ff' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone5:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'splayed', 'uc8'],
			],
			'1f596' => [
				'name' => \XF::phrase('emoji.vulcan'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f596-1f3fb', '1f596-1f3fc', '1f596-1f3fd', '1f596-1f3fe', '1f596-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'spock', 'vulcan', 'uc7'],
			],
			'1f596-1f3fb' => [
				'name' => \XF::phrase('emoji.vulcan_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone1:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'light skin tone', 'spock', 'vulcan', 'uc8'],
			],
			'1f596-1f3fc' => [
				'name' => \XF::phrase('emoji.vulcan_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone2:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium-light skin tone', 'spock', 'vulcan', 'uc8'],
			],
			'1f596-1f3fd' => [
				'name' => \XF::phrase('emoji.vulcan_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone3:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium skin tone', 'spock', 'vulcan', 'uc8'],
			],
			'1f596-1f3fe' => [
				'name' => \XF::phrase('emoji.vulcan_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone4:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium-dark skin tone', 'spock', 'vulcan', 'uc8'],
			],
			'1f596-1f3ff' => [
				'name' => \XF::phrase('emoji.vulcan_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone5:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'spock', 'vulcan', 'uc8'],
			],
			'1f44b' => [
				'name' => \XF::phrase('emoji.wave'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44b-1f3fb', '1f44b-1f3fc', '1f44b-1f3fd', '1f44b-1f3fe', '1f44b-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'wave', 'waving', 'uc6'],
			],
			'1f44b-1f3fb' => [
				'name' => \XF::phrase('emoji.wave_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'light skin tone', 'wave', 'waving', 'uc8'],
			],
			'1f44b-1f3fc' => [
				'name' => \XF::phrase('emoji.wave_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'wave', 'waving', 'uc8'],
			],
			'1f44b-1f3fd' => [
				'name' => \XF::phrase('emoji.wave_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium skin tone', 'wave', 'waving', 'uc8'],
			],
			'1f44b-1f3fe' => [
				'name' => \XF::phrase('emoji.wave_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'wave', 'waving', 'uc8'],
			],
			'1f44b-1f3ff' => [
				'name' => \XF::phrase('emoji.wave_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'hand', 'wave', 'waving', 'uc8'],
			],
			'1f919' => [
				'name' => \XF::phrase('emoji.call_me'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me:',
				'shortname_alternates' => [':call_me_hand:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f919-1f3fb', '1f919-1f3fc', '1f919-1f3fd', '1f919-1f3fe', '1f919-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['call', 'hand', 'uc9'],
			],
			'1f919-1f3fb' => [
				'name' => \XF::phrase('emoji.call_me_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone1:',
				'shortname_alternates' => [':call_me_hand_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['call', 'hand', 'light skin tone', 'uc9'],
			],
			'1f919-1f3fc' => [
				'name' => \XF::phrase('emoji.call_me_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone2:',
				'shortname_alternates' => [':call_me_hand_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['call', 'hand', 'medium-light skin tone', 'uc9'],
			],
			'1f919-1f3fd' => [
				'name' => \XF::phrase('emoji.call_me_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone3:',
				'shortname_alternates' => [':call_me_hand_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['call', 'hand', 'medium skin tone', 'uc9'],
			],
			'1f919-1f3fe' => [
				'name' => \XF::phrase('emoji.call_me_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone4:',
				'shortname_alternates' => [':call_me_hand_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['call', 'hand', 'medium-dark skin tone', 'uc9'],
			],
			'1f919-1f3ff' => [
				'name' => \XF::phrase('emoji.call_me_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone5:',
				'shortname_alternates' => [':call_me_hand_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['call', 'dark skin tone', 'hand', 'uc9'],
			],
			'1f4aa' => [
				'name' => \XF::phrase('emoji.muscle'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f4aa-1f3fb', '1f4aa-1f3fc', '1f4aa-1f3fd', '1f4aa-1f3fe', '1f4aa-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'muscle', 'uc6'],
			],
			'1f4aa-1f3fb' => [
				'name' => \XF::phrase('emoji.muscle_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'light skin tone', 'muscle', 'uc8'],
			],
			'1f4aa-1f3fc' => [
				'name' => \XF::phrase('emoji.muscle_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'medium-light skin tone', 'muscle', 'uc8'],
			],
			'1f4aa-1f3fd' => [
				'name' => \XF::phrase('emoji.muscle_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'medium skin tone', 'muscle', 'uc8'],
			],
			'1f4aa-1f3fe' => [
				'name' => \XF::phrase('emoji.muscle_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['biceps', 'comic', 'flex', 'medium-dark skin tone', 'muscle', 'uc8'],
			],
			'1f4aa-1f3ff' => [
				'name' => \XF::phrase('emoji.muscle_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['biceps', 'comic', 'dark skin tone', 'flex', 'muscle', 'uc8'],
			],
			'1f9be' => [
				'name' => \XF::phrase('emoji.mechanical_arm'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanical_arm:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f595' => [
				'name' => \XF::phrase('emoji.middle_finger'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f595-1f3fb', '1f595-1f3fc', '1f595-1f3fd', '1f595-1f3fe', '1f595-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'uc7'],
			],
			'1f595-1f3fb' => [
				'name' => \XF::phrase('emoji.middle_finger_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone1:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'light skin tone', 'uc8'],
			],
			'1f595-1f3fc' => [
				'name' => \XF::phrase('emoji.middle_finger_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone2:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium-light skin tone', 'uc8'],
			],
			'1f595-1f3fd' => [
				'name' => \XF::phrase('emoji.middle_finger_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone3:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium skin tone', 'uc8'],
			],
			'1f595-1f3fe' => [
				'name' => \XF::phrase('emoji.middle_finger_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone4:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['finger', 'hand', 'medium-dark skin tone', 'uc8'],
			],
			'1f595-1f3ff' => [
				'name' => \XF::phrase('emoji.middle_finger_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone5:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'finger', 'hand', 'uc8'],
			],
			'270d' => [
				'name' => \XF::phrase('emoji.writing_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['270d-1f3fb', '270d-1f3fc', '270d-1f3fd', '270d-1f3fe', '270d-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'write', 'uc1'],
			],
			'270d-1f3fb' => [
				'name' => \XF::phrase('emoji.writing_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'light skin tone', 'write', 'uc8'],
			],
			'270d-1f3fc' => [
				'name' => \XF::phrase('emoji.writing_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-light skin tone', 'write', 'uc8'],
			],
			'270d-1f3fd' => [
				'name' => \XF::phrase('emoji.writing_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium skin tone', 'write', 'uc8'],
			],
			'270d-1f3fe' => [
				'name' => \XF::phrase('emoji.writing_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'medium-dark skin tone', 'write', 'uc8'],
			],
			'270d-1f3ff' => [
				'name' => \XF::phrase('emoji.writing_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'hand', 'write', 'uc8'],
			],
			'1f64f' => [
				'name' => \XF::phrase('emoji.pray'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64f-1f3fb', '1f64f-1f3fc', '1f64f-1f3fd', '1f64f-1f3fe', '1f64f-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'please', 'pray', 'thanks', 'uc6'],
			],
			'1f64f-1f3fb' => [
				'name' => \XF::phrase('emoji.pray_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'light skin tone', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f64f-1f3fc' => [
				'name' => \XF::phrase('emoji.pray_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium-light skin tone', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f64f-1f3fd' => [
				'name' => \XF::phrase('emoji.pray_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium skin tone', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f64f-1f3fe' => [
				'name' => \XF::phrase('emoji.pray_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium-dark skin tone', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f64f-1f3ff' => [
				'name' => \XF::phrase('emoji.pray_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ask', 'bow', 'dark skin tone', 'folded', 'gesture', 'hand', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f9b6' => [
				'name' => \XF::phrase('emoji.foot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b6-1f3fb', '1f9b6-1f3fc', '1f9b6-1f3fd', '1f9b6-1f3fe', '1f9b6-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3fb' => [
				'name' => \XF::phrase('emoji.foot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone1:',
				'shortname_alternates' => [':foot_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3fc' => [
				'name' => \XF::phrase('emoji.foot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone2:',
				'shortname_alternates' => [':foot_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3fd' => [
				'name' => \XF::phrase('emoji.foot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone3:',
				'shortname_alternates' => [':foot_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3fe' => [
				'name' => \XF::phrase('emoji.foot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone4:',
				'shortname_alternates' => [':foot_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3ff' => [
				'name' => \XF::phrase('emoji.foot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone5:',
				'shortname_alternates' => [':foot_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b5' => [
				'name' => \XF::phrase('emoji.leg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b5-1f3fb', '1f9b5-1f3fc', '1f9b5-1f3fd', '1f9b5-1f3fe', '1f9b5-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3fb' => [
				'name' => \XF::phrase('emoji.leg_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone1:',
				'shortname_alternates' => [':leg_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3fc' => [
				'name' => \XF::phrase('emoji.leg_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone2:',
				'shortname_alternates' => [':leg_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3fd' => [
				'name' => \XF::phrase('emoji.leg_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone3:',
				'shortname_alternates' => [':leg_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3fe' => [
				'name' => \XF::phrase('emoji.leg_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone4:',
				'shortname_alternates' => [':leg_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3ff' => [
				'name' => \XF::phrase('emoji.leg_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone5:',
				'shortname_alternates' => [':leg_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9bf' => [
				'name' => \XF::phrase('emoji.mechanical_leg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanical_leg:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f484' => [
				'name' => \XF::phrase('emoji.lipstick'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lipstick:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cosmetics', 'makeup', 'uc6'],
			],
			'1f48b' => [
				'name' => \XF::phrase('emoji.kiss'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['kiss', 'lips', 'uc6'],
			],
			'1f444' => [
				'name' => \XF::phrase('emoji.lips'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lips:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['lips', 'uc6'],
			],
			'1f9b7' => [
				'name' => \XF::phrase('emoji.tooth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tooth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b4' => [
				'name' => \XF::phrase('emoji.bone'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bone:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f445' => [
				'name' => \XF::phrase('emoji.tongue'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tongue:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'uc6'],
			],
			'1f442' => [
				'name' => \XF::phrase('emoji.ear'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f442-1f3fb', '1f442-1f3fc', '1f442-1f3fd', '1f442-1f3fe', '1f442-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'uc6'],
			],
			'1f442-1f3fb' => [
				'name' => \XF::phrase('emoji.ear_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'light skin tone', 'uc8'],
			],
			'1f442-1f3fc' => [
				'name' => \XF::phrase('emoji.ear_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'medium-light skin tone', 'uc8'],
			],
			'1f442-1f3fd' => [
				'name' => \XF::phrase('emoji.ear_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'medium skin tone', 'uc8'],
			],
			'1f442-1f3fe' => [
				'name' => \XF::phrase('emoji.ear_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'medium-dark skin tone', 'uc8'],
			],
			'1f442-1f3ff' => [
				'name' => \XF::phrase('emoji.ear_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'dark skin tone', 'uc8'],
			],
			'1f9bb' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9bb-1f3fb', '1f9bb-1f3fc', '1f9bb-1f3fd', '1f9bb-1f3fe', '1f9bb-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3fb' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone1:',
				'shortname_alternates' => [':ear_with_hearing_aid_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3fc' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone2:',
				'shortname_alternates' => [':ear_with_hearing_aid_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3fd' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone3:',
				'shortname_alternates' => [':ear_with_hearing_aid_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3fe' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone4:',
				'shortname_alternates' => [':ear_with_hearing_aid_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3ff' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone5:',
				'shortname_alternates' => [':ear_with_hearing_aid_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f443' => [
				'name' => \XF::phrase('emoji.nose'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f443-1f3fb', '1f443-1f3fc', '1f443-1f3fd', '1f443-1f3fe', '1f443-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'uc6'],
			],
			'1f443-1f3fb' => [
				'name' => \XF::phrase('emoji.nose_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'light skin tone', 'uc8'],
			],
			'1f443-1f3fc' => [
				'name' => \XF::phrase('emoji.nose_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'medium-light skin tone', 'uc8'],
			],
			'1f443-1f3fd' => [
				'name' => \XF::phrase('emoji.nose_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'medium skin tone', 'uc8'],
			],
			'1f443-1f3fe' => [
				'name' => \XF::phrase('emoji.nose_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'medium-dark skin tone', 'uc8'],
			],
			'1f443-1f3ff' => [
				'name' => \XF::phrase('emoji.nose_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'dark skin tone', 'uc8'],
			],
			'1f463' => [
				'name' => \XF::phrase('emoji.footprints'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':footprints:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'footprint', 'print', 'uc6'],
			],
			'1f441' => [
				'name' => \XF::phrase('emoji.eye'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':eye:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['body', 'uc7'],
			],
			'1f440' => [
				'name' => \XF::phrase('emoji.eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['eye', 'face', 'uc6'],
			],
			'1f9e0' => [
				'name' => \XF::phrase('emoji.brain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':brain:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['intelligent', 'uc10'],
			],
			'1fac0' => [
				'name' => \XF::phrase('emoji.anatomical_heart'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':anatomical_heart:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1fac1' => [
				'name' => \XF::phrase('emoji.lungs'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lungs:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f5e3' => [
				'name' => \XF::phrase('emoji.speaking_head'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':speaking_head:',
				'shortname_alternates' => [':speaking_head_in_silhouette:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'head', 'silhouette', 'speak', 'speaking', 'uc7'],
			],
			'1f464' => [
				'name' => \XF::phrase('emoji.bust_in_silhouette'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bust_in_silhouette:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bust', 'silhouette', 'uc6'],
			],
			'1f465' => [
				'name' => \XF::phrase('emoji.busts_in_silhouette'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':busts_in_silhouette:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bust', 'silhouette', 'uc6'],
			],
			'1fac2' => [
				'name' => \XF::phrase('emoji.people_hugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_hugging:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f476' => [
				'name' => \XF::phrase('emoji.baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f476-1f3fb', '1f476-1f3fc', '1f476-1f3fd', '1f476-1f3fe', '1f476-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'young', 'uc6'],
			],
			'1f476-1f3fb' => [
				'name' => \XF::phrase('emoji.baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'light skin tone', 'young', 'uc8'],
			],
			'1f476-1f3fc' => [
				'name' => \XF::phrase('emoji.baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'medium-light skin tone', 'young', 'uc8'],
			],
			'1f476-1f3fd' => [
				'name' => \XF::phrase('emoji.baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'medium skin tone', 'young', 'uc8'],
			],
			'1f476-1f3fe' => [
				'name' => \XF::phrase('emoji.baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'medium-dark skin tone', 'young', 'uc8'],
			],
			'1f476-1f3ff' => [
				'name' => \XF::phrase('emoji.baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'dark skin tone', 'young', 'uc8'],
			],
			'1f467' => [
				'name' => \XF::phrase('emoji.girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f467-1f3fb', '1f467-1f3fc', '1f467-1f3fd', '1f467-1f3fe', '1f467-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Virgo', 'young', 'zodiac', 'uc6'],
			],
			'1f467-1f3fb' => [
				'name' => \XF::phrase('emoji.girl_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Virgo', 'light skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f467-1f3fc' => [
				'name' => \XF::phrase('emoji.girl_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Virgo', 'medium-light skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f467-1f3fd' => [
				'name' => \XF::phrase('emoji.girl_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Virgo', 'medium skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f467-1f3fe' => [
				'name' => \XF::phrase('emoji.girl_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Virgo', 'medium-dark skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f467-1f3ff' => [
				'name' => \XF::phrase('emoji.girl_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Virgo', 'dark skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f9d2' => [
				'name' => \XF::phrase('emoji.child'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d2-1f3fb', '1f9d2-1f3fc', '1f9d2-1f3fd', '1f9d2-1f3fe', '1f9d2-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f9d2-1f3fb' => [
				'name' => \XF::phrase('emoji.child_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone1:',
				'shortname_alternates' => [':child_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'light skin tone', 'young', 'uc10'],
			],
			'1f9d2-1f3fc' => [
				'name' => \XF::phrase('emoji.child_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone2:',
				'shortname_alternates' => [':child_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium-light skin tone', 'young', 'uc10'],
			],
			'1f9d2-1f3fd' => [
				'name' => \XF::phrase('emoji.child_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone3:',
				'shortname_alternates' => [':child_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium skin tone', 'young', 'uc10'],
			],
			'1f9d2-1f3fe' => [
				'name' => \XF::phrase('emoji.child_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone4:',
				'shortname_alternates' => [':child_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium-dark skin tone', 'young', 'uc10'],
			],
			'1f9d2-1f3ff' => [
				'name' => \XF::phrase('emoji.child_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone5:',
				'shortname_alternates' => [':child_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'gender-neutral', 'young', 'uc10'],
			],
			'1f466' => [
				'name' => \XF::phrase('emoji.boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f466-1f3fb', '1f466-1f3fc', '1f466-1f3fd', '1f466-1f3fe', '1f466-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['boy', 'young', 'uc6'],
			],
			'1f466-1f3fb' => [
				'name' => \XF::phrase('emoji.boy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['boy', 'light skin tone', 'young', 'uc8'],
			],
			'1f466-1f3fc' => [
				'name' => \XF::phrase('emoji.boy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['boy', 'medium-light skin tone', 'young', 'uc8'],
			],
			'1f466-1f3fd' => [
				'name' => \XF::phrase('emoji.boy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['boy', 'medium skin tone', 'young', 'uc8'],
			],
			'1f466-1f3fe' => [
				'name' => \XF::phrase('emoji.boy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['boy', 'medium-dark skin tone', 'young', 'uc8'],
			],
			'1f466-1f3ff' => [
				'name' => \XF::phrase('emoji.boy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['boy', 'dark skin tone', 'young', 'uc8'],
			],
			'1f469' => [
				'name' => \XF::phrase('emoji.woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb', '1f469-1f3fc', '1f469-1f3fd', '1f469-1f3fe', '1f469-1f3ff'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['woman', 'uc6'],
			],
			'1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'woman', 'uc8'],
			],
			'1f9d1' => [
				'name' => \XF::phrase('emoji.adult'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb', '1f9d1-1f3fc', '1f9d1-1f3fd', '1f9d1-1f3fe', '1f9d1-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.adult_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone1:',
				'shortname_alternates' => [':adult_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'light skin tone', 'uc10'],
			],
			'1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.adult_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone2:',
				'shortname_alternates' => [':adult_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium-light skin tone', 'uc10'],
			],
			'1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.adult_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone3:',
				'shortname_alternates' => [':adult_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium skin tone', 'uc10'],
			],
			'1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.adult_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone4:',
				'shortname_alternates' => [':adult_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium-dark skin tone', 'uc10'],
			],
			'1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.adult_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone5:',
				'shortname_alternates' => [':adult_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'gender-neutral', 'uc10'],
			],
			'1f468' => [
				'name' => \XF::phrase('emoji.man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb', '1f468-1f3fc', '1f468-1f3fd', '1f468-1f3fe', '1f468-1f3ff'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'uc6'],
			],
			'1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'man', 'uc8'],
			],
			'1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium-light skin tone', 'uc8'],
			],
			'1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium skin tone', 'uc8'],
			],
			'1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'uc8'],
			],
			'1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'man', 'uc8'],
			],
			'1f9d1-1f9b1' => [
				'name' => \XF::phrase('emoji.person_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_curly_hair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9b1', '1f9d1-1f3fc-1f9b1', '1f9d1-1f3fd-1f9b1', '1f9d1-1f3fe-1f9b1', '1f9d1-1f3ff-1f9b1'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone1_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone1_curly_hair:',
				'shortname_alternates' => [':person_light_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone2_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone2_curly_hair:',
				'shortname_alternates' => [':person_medium_light_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone3_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone3_curly_hair:',
				'shortname_alternates' => [':person_medium_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone4_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone4_curly_hair:',
				'shortname_alternates' => [':person_medium_dark_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone5_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone5_curly_hair:',
				'shortname_alternates' => [':person_dark_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9b1', '1f469-1f3fc-1f9b1', '1f469-1f3fd-1f9b1', '1f469-1f3fe-1f9b1', '1f469-1f3ff-1f9b1'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fb-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone1:',
				'shortname_alternates' => [':woman_curly_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fc-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone2:',
				'shortname_alternates' => [':woman_curly_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fd-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone3:',
				'shortname_alternates' => [':woman_curly_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fe-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone4:',
				'shortname_alternates' => [':woman_curly_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3ff-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone5:',
				'shortname_alternates' => [':woman_curly_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9b1', '1f468-1f3fc-1f9b1', '1f468-1f3fd-1f9b1', '1f468-1f3fe-1f9b1', '1f468-1f3ff-1f9b1'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fb-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone1:',
				'shortname_alternates' => [':man_curly_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fc-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone2:',
				'shortname_alternates' => [':man_curly_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fd-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone3:',
				'shortname_alternates' => [':man_curly_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fe-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone4:',
				'shortname_alternates' => [':man_curly_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3ff-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone5:',
				'shortname_alternates' => [':man_curly_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9d1-1f9b0' => [
				'name' => \XF::phrase('emoji.person_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_red_hair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9b0', '1f9d1-1f3fc-1f9b0', '1f9d1-1f3fd-1f9b0', '1f9d1-1f3fe-1f9b0', '1f9d1-1f3ff-1f9b0'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone1_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone1_red_hair:',
				'shortname_alternates' => [':person_light_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone2_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone2_red_hair:',
				'shortname_alternates' => [':person_medium_light_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone3_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone3_red_hair:',
				'shortname_alternates' => [':person_medium_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone4_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone4_red_hair:',
				'shortname_alternates' => [':person_medium_dark_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone5_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone5_red_hair:',
				'shortname_alternates' => [':person_dark_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9b0', '1f469-1f3fc-1f9b0', '1f469-1f3fd-1f9b0', '1f469-1f3fe-1f9b0', '1f469-1f3ff-1f9b0'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fb-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone1:',
				'shortname_alternates' => [':woman_red_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fc-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone2:',
				'shortname_alternates' => [':woman_red_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fd-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone3:',
				'shortname_alternates' => [':woman_red_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fe-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone4:',
				'shortname_alternates' => [':woman_red_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3ff-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone5:',
				'shortname_alternates' => [':woman_red_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9b0', '1f468-1f3fc-1f9b0', '1f468-1f3fd-1f9b0', '1f468-1f3fe-1f9b0', '1f468-1f3ff-1f9b0'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fb-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone1:',
				'shortname_alternates' => [':man_red_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fc-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone2:',
				'shortname_alternates' => [':man_red_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fd-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone3:',
				'shortname_alternates' => [':man_red_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fe-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone4:',
				'shortname_alternates' => [':man_red_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3ff-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone5:',
				'shortname_alternates' => [':man_red_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f471-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f471-1f3ff-2640', '1f471-1f3fe-2640', '1f471-1f3fd-2640', '1f471-1f3fc-2640', '1f471-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['blonde', 'woman', 'uc6'],
			],
			'1f471-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone1:',
				'shortname_alternates' => [':blond-haired_woman_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['blonde', 'light skin tone', 'woman', 'uc8'],
			],
			'1f471-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone2:',
				'shortname_alternates' => [':blond-haired_woman_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['blonde', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f471-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone3:',
				'shortname_alternates' => [':blond-haired_woman_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['blonde', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f471-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone4:',
				'shortname_alternates' => [':blond-haired_woman_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['blonde', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f471-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone5:',
				'shortname_alternates' => [':blond-haired_woman_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['blonde', 'dark skin tone', 'woman', 'uc8'],
			],
			'1f471' => [
				'name' => \XF::phrase('emoji.blond_haired_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person:',
				'shortname_alternates' => [':person_with_blond_hair:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f471-1f3fb', '1f471-1f3fc', '1f471-1f3fd', '1f471-1f3fe', '1f471-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f471-2642', '1f471-2640'],
				'keywords' => ['blond', 'uc6'],
			],
			'1f471-1f3fb' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone1:',
				'shortname_alternates' => [':person_with_blond_hair_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3fb-2642', '1f471-1f3fb-2640'],
				'keywords' => ['blond', 'light skin tone', 'uc8'],
			],
			'1f471-1f3fc' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone2:',
				'shortname_alternates' => [':person_with_blond_hair_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3fc-2642', '1f471-1f3fc-2640'],
				'keywords' => ['blond', 'medium-light skin tone', 'uc8'],
			],
			'1f471-1f3fd' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone3:',
				'shortname_alternates' => [':person_with_blond_hair_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3fd-2642', '1f471-1f3fd-2640'],
				'keywords' => ['blond', 'medium skin tone', 'uc8'],
			],
			'1f471-1f3fe' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone4:',
				'shortname_alternates' => [':person_with_blond_hair_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3fe-2642', '1f471-1f3fe-2640'],
				'keywords' => ['blond', 'medium-dark skin tone', 'uc8'],
			],
			'1f471-1f3ff' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone5:',
				'shortname_alternates' => [':person_with_blond_hair_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3ff-2642', '1f471-1f3ff-2640'],
				'keywords' => ['blond', 'dark skin tone', 'uc8'],
			],
			'1f471-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f471-1f3ff-2642', '1f471-1f3fe-2642', '1f471-1f3fd-2642', '1f471-1f3fc-2642', '1f471-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['blond', 'man', 'uc6'],
			],
			'1f471-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone1:',
				'shortname_alternates' => [':blond-haired_man_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['blond', 'light skin tone', 'man', 'uc8'],
			],
			'1f471-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone2:',
				'shortname_alternates' => [':blond-haired_man_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['blond', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f471-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone3:',
				'shortname_alternates' => [':blond-haired_man_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['blond', 'man', 'medium skin tone', 'uc8'],
			],
			'1f471-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone4:',
				'shortname_alternates' => [':blond-haired_man_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['blond', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f471-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone5:',
				'shortname_alternates' => [':blond-haired_man_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['blond', 'dark skin tone', 'man', 'uc8'],
			],
			'1f9d1-1f9b3' => [
				'name' => \XF::phrase('emoji.person_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_white_hair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9b3', '1f9d1-1f3fc-1f9b3', '1f9d1-1f3fd-1f9b3', '1f9d1-1f3fe-1f9b3', '1f9d1-1f3ff-1f9b3'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone1_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone1_white_hair:',
				'shortname_alternates' => [':person_light_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone2_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone2_white_hair:',
				'shortname_alternates' => [':person_medium_light_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone3_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone3_white_hair:',
				'shortname_alternates' => [':person_medium_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone4_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone4_white_hair:',
				'shortname_alternates' => [':person_medium_dark_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone5_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone5_white_hair:',
				'shortname_alternates' => [':person_dark_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9b3', '1f469-1f3fc-1f9b3', '1f469-1f3fd-1f9b3', '1f469-1f3fe-1f9b3', '1f469-1f3ff-1f9b3'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fb-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone1:',
				'shortname_alternates' => [':woman_white_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fc-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone2:',
				'shortname_alternates' => [':woman_white_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fd-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone3:',
				'shortname_alternates' => [':woman_white_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fe-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone4:',
				'shortname_alternates' => [':woman_white_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3ff-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone5:',
				'shortname_alternates' => [':woman_white_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9b3', '1f468-1f3fc-1f9b3', '1f468-1f3fd-1f9b3', '1f468-1f3fe-1f9b3', '1f468-1f3ff-1f9b3'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fb-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone1:',
				'shortname_alternates' => [':man_white_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fc-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone2:',
				'shortname_alternates' => [':man_white_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fd-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone3:',
				'shortname_alternates' => [':man_white_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fe-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone4:',
				'shortname_alternates' => [':man_white_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3ff-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone5:',
				'shortname_alternates' => [':man_white_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9d1-1f9b2' => [
				'name' => \XF::phrase('emoji.person_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bald:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9b2', '1f9d1-1f3fc-1f9b2', '1f9d1-1f3fd-1f9b2', '1f9d1-1f3fe-1f9b2', '1f9d1-1f3ff-1f9b2'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone1_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone1_bald:',
				'shortname_alternates' => [':person_light_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone2_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone2_bald:',
				'shortname_alternates' => [':person_medium_light_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone3_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone3_bald:',
				'shortname_alternates' => [':person_medium_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone4_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone4_bald:',
				'shortname_alternates' => [':person_medium_dark_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone5_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone5_bald:',
				'shortname_alternates' => [':person_dark_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9b2', '1f469-1f3fc-1f9b2', '1f469-1f3fd-1f9b2', '1f469-1f3fe-1f9b2', '1f469-1f3ff-1f9b2'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fb-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone1:',
				'shortname_alternates' => [':woman_bald_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fc-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone2:',
				'shortname_alternates' => [':woman_bald_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fd-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone3:',
				'shortname_alternates' => [':woman_bald_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3fe-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone4:',
				'shortname_alternates' => [':woman_bald_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f469-1f3ff-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone5:',
				'shortname_alternates' => [':woman_bald_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9b2', '1f468-1f3fc-1f9b2', '1f468-1f3fd-1f9b2', '1f468-1f3fe-1f9b2', '1f468-1f3ff-1f9b2'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fb-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone1:',
				'shortname_alternates' => [':man_bald_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fc-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone2:',
				'shortname_alternates' => [':man_bald_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fd-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone3:',
				'shortname_alternates' => [':man_bald_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3fe-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone4:',
				'shortname_alternates' => [':man_bald_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f468-1f3ff-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone5:',
				'shortname_alternates' => [':man_bald_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9d4' => [
				'name' => \XF::phrase('emoji.bearded_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d4-1f3fb', '1f9d4-1f3fc', '1f9d4-1f3fd', '1f9d4-1f3fe', '1f9d4-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f9d4-1f3fb' => [
				'name' => \XF::phrase('emoji.bearded_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone1:',
				'shortname_alternates' => [':bearded_person_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['beard', 'light skin tone', 'uc10'],
			],
			'1f9d4-1f3fc' => [
				'name' => \XF::phrase('emoji.bearded_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone2:',
				'shortname_alternates' => [':bearded_person_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['beard', 'medium-light skin tone', 'uc10'],
			],
			'1f9d4-1f3fd' => [
				'name' => \XF::phrase('emoji.bearded_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone3:',
				'shortname_alternates' => [':bearded_person_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['beard', 'medium skin tone', 'uc10'],
			],
			'1f9d4-1f3fe' => [
				'name' => \XF::phrase('emoji.bearded_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone4:',
				'shortname_alternates' => [':bearded_person_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['beard', 'medium-dark skin tone', 'uc10'],
			],
			'1f9d4-1f3ff' => [
				'name' => \XF::phrase('emoji.bearded_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone5:',
				'shortname_alternates' => [':bearded_person_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['beard', 'dark skin tone', 'uc10'],
			],
			'1f475' => [
				'name' => \XF::phrase('emoji.older_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman:',
				'shortname_alternates' => [':grandma:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f475-1f3fb', '1f475-1f3fc', '1f475-1f3fd', '1f475-1f3fe', '1f475-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['old', 'woman', 'uc6'],
			],
			'1f475-1f3fb' => [
				'name' => \XF::phrase('emoji.older_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone1:',
				'shortname_alternates' => [':grandma_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'old', 'woman', 'uc8'],
			],
			'1f475-1f3fc' => [
				'name' => \XF::phrase('emoji.older_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone2:',
				'shortname_alternates' => [':grandma_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'old', 'woman', 'uc8'],
			],
			'1f475-1f3fd' => [
				'name' => \XF::phrase('emoji.older_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone3:',
				'shortname_alternates' => [':grandma_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'old', 'woman', 'uc8'],
			],
			'1f475-1f3fe' => [
				'name' => \XF::phrase('emoji.older_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone4:',
				'shortname_alternates' => [':grandma_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'old', 'woman', 'uc8'],
			],
			'1f475-1f3ff' => [
				'name' => \XF::phrase('emoji.older_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone5:',
				'shortname_alternates' => [':grandma_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'old', 'woman', 'uc8'],
			],
			'1f9d3' => [
				'name' => \XF::phrase('emoji.older_adult'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d3-1f3fb', '1f9d3-1f3fc', '1f9d3-1f3fd', '1f9d3-1f3fe', '1f9d3-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f9d3-1f3fb' => [
				'name' => \XF::phrase('emoji.older_adult_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone1:',
				'shortname_alternates' => [':older_adult_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'light skin tone', 'old', 'uc10'],
			],
			'1f9d3-1f3fc' => [
				'name' => \XF::phrase('emoji.older_adult_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone2:',
				'shortname_alternates' => [':older_adult_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium-light skin tone', 'old', 'uc10'],
			],
			'1f9d3-1f3fd' => [
				'name' => \XF::phrase('emoji.older_adult_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone3:',
				'shortname_alternates' => [':older_adult_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium skin tone', 'old', 'uc10'],
			],
			'1f9d3-1f3fe' => [
				'name' => \XF::phrase('emoji.older_adult_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone4:',
				'shortname_alternates' => [':older_adult_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gender-neutral', 'medium-dark skin tone', 'old', 'uc10'],
			],
			'1f9d3-1f3ff' => [
				'name' => \XF::phrase('emoji.older_adult_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone5:',
				'shortname_alternates' => [':older_adult_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'gender-neutral', 'old', 'uc10'],
			],
			'1f474' => [
				'name' => \XF::phrase('emoji.older_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f474-1f3fb', '1f474-1f3fc', '1f474-1f3fd', '1f474-1f3fe', '1f474-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['man', 'old', 'uc6'],
			],
			'1f474-1f3fb' => [
				'name' => \XF::phrase('emoji.older_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'man', 'old', 'uc8'],
			],
			'1f474-1f3fc' => [
				'name' => \XF::phrase('emoji.older_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['man', 'medium-light skin tone', 'old', 'uc8'],
			],
			'1f474-1f3fd' => [
				'name' => \XF::phrase('emoji.older_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['man', 'medium skin tone', 'old', 'uc8'],
			],
			'1f474-1f3fe' => [
				'name' => \XF::phrase('emoji.older_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'old', 'uc8'],
			],
			'1f474-1f3ff' => [
				'name' => \XF::phrase('emoji.older_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'man', 'old', 'uc8'],
			],
			'1f472' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap:',
				'shortname_alternates' => [':man_with_gua_pi_mao:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f472-1f3fb', '1f472-1f3fc', '1f472-1f3fd', '1f472-1f3fe', '1f472-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gua pi mao', 'hat', 'man', 'uc6'],
			],
			'1f472-1f3fb' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone1:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gua pi mao', 'hat', 'light skin tone', 'man', 'uc8'],
			],
			'1f472-1f3fc' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone2:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f472-1f3fd' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone3:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium skin tone', 'uc8'],
			],
			'1f472-1f3fe' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone4:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f472-1f3ff' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone5:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'gua pi mao', 'hat', 'man', 'uc8'],
			],
			'1f473' => [
				'name' => \XF::phrase('emoji.person_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban:',
				'shortname_alternates' => [':man_with_turban:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f473-1f3fb', '1f473-1f3fc', '1f473-1f3fd', '1f473-1f3fe', '1f473-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f473-2642', '1f473-2640'],
				'keywords' => ['turban', 'uc6'],
			],
			'1f473-1f3fb' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone1:',
				'shortname_alternates' => [':man_with_turban_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3fb-2642', '1f473-1f3fb-2640'],
				'keywords' => ['light skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fc' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone2:',
				'shortname_alternates' => [':man_with_turban_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3fc-2642', '1f473-1f3fc-2640'],
				'keywords' => ['medium-light skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fd' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone3:',
				'shortname_alternates' => [':man_with_turban_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3fd-2642', '1f473-1f3fd-2640'],
				'keywords' => ['medium skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fe' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone4:',
				'shortname_alternates' => [':man_with_turban_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3fe-2642', '1f473-1f3fe-2640'],
				'keywords' => ['medium-dark skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3ff' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone5:',
				'shortname_alternates' => [':man_with_turban_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3ff-2642', '1f473-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'turban', 'uc8'],
			],
			'1f473-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f473-1f3ff-2640', '1f473-1f3fe-2640', '1f473-1f3fd-2640', '1f473-1f3fc-2640', '1f473-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['turban', 'woman', 'uc6'],
			],
			'1f473-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone1:',
				'shortname_alternates' => [':woman_wearing_turban_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone2:',
				'shortname_alternates' => [':woman_wearing_turban_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone3:',
				'shortname_alternates' => [':woman_wearing_turban_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone4:',
				'shortname_alternates' => [':woman_wearing_turban_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone5:',
				'shortname_alternates' => [':woman_wearing_turban_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f473-1f3ff-2642', '1f473-1f3fe-2642', '1f473-1f3fd-2642', '1f473-1f3fc-2642', '1f473-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'turban', 'uc6'],
			],
			'1f473-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone1:',
				'shortname_alternates' => [':man_wearing_turban_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'man', 'turban', 'uc8'],
			],
			'1f473-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone2:',
				'shortname_alternates' => [':man_wearing_turban_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium-light skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone3:',
				'shortname_alternates' => [':man_wearing_turban_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone4:',
				'shortname_alternates' => [':man_wearing_turban_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone5:',
				'shortname_alternates' => [':man_wearing_turban_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'man', 'turban', 'uc8'],
			],
			'1f9d5' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d5-1f3fb', '1f9d5-1f3fc', '1f9d5-1f3fd', '1f9d5-1f3fe', '1f9d5-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f9d5-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone1:',
				'shortname_alternates' => [':woman_with_headscarf_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['headscarf', 'hijab', 'light skin tone', 'mantilla', 'tichel', 'uc10'],
			],
			'1f9d5-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone2:',
				'shortname_alternates' => [':woman_with_headscarf_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium-light skin tone', 'tichel', 'uc10'],
			],
			'1f9d5-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone3:',
				'shortname_alternates' => [':woman_with_headscarf_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium skin tone', 'tichel', 'uc10'],
			],
			'1f9d5-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone4:',
				'shortname_alternates' => [':woman_with_headscarf_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium-dark skin tone', 'tichel', 'uc10'],
			],
			'1f9d5-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone5:',
				'shortname_alternates' => [':woman_with_headscarf_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'headscarf', 'hijab', 'mantilla', 'tichel', 'uc10'],
			],
			'1f46e' => [
				'name' => \XF::phrase('emoji.police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer:',
				'shortname_alternates' => [':cop:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46e-1f3fb', '1f46e-1f3fc', '1f46e-1f3fd', '1f46e-1f3fe', '1f46e-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f46e-2642', '1f46e-2640'],
				'keywords' => ['cop', 'officer', 'police', 'uc6'],
			],
			'1f46e-1f3fb' => [
				'name' => \XF::phrase('emoji.police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone1:',
				'shortname_alternates' => [':cop_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3fb-2642', '1f46e-1f3fb-2640'],
				'keywords' => ['cop', 'light skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fc' => [
				'name' => \XF::phrase('emoji.police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone2:',
				'shortname_alternates' => [':cop_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3fc-2642', '1f46e-1f3fc-2640'],
				'keywords' => ['cop', 'medium-light skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fd' => [
				'name' => \XF::phrase('emoji.police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone3:',
				'shortname_alternates' => [':cop_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3fd-2642', '1f46e-1f3fd-2640'],
				'keywords' => ['cop', 'medium skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fe' => [
				'name' => \XF::phrase('emoji.police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone4:',
				'shortname_alternates' => [':cop_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3fe-2642', '1f46e-1f3fe-2640'],
				'keywords' => ['cop', 'medium-dark skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3ff' => [
				'name' => \XF::phrase('emoji.police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone5:',
				'shortname_alternates' => [':cop_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3ff-2642', '1f46e-1f3ff-2640'],
				'keywords' => ['cop', 'dark skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46e-1f3ff-2640', '1f46e-1f3fe-2640', '1f46e-1f3fd-2640', '1f46e-1f3fc-2640', '1f46e-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['cop', 'officer', 'police', 'woman', 'uc6'],
			],
			'1f46e-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone1:',
				'shortname_alternates' => [':woman_police_officer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['cop', 'light skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone2:',
				'shortname_alternates' => [':woman_police_officer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['cop', 'medium-light skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone3:',
				'shortname_alternates' => [':woman_police_officer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['cop', 'medium skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone4:',
				'shortname_alternates' => [':woman_police_officer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['cop', 'medium-dark skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone5:',
				'shortname_alternates' => [':woman_police_officer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['cop', 'dark skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46e-1f3ff-2642', '1f46e-1f3fe-2642', '1f46e-1f3fd-2642', '1f46e-1f3fc-2642', '1f46e-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['cop', 'man', 'officer', 'police', 'uc6'],
			],
			'1f46e-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone1:',
				'shortname_alternates' => [':man_police_officer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['cop', 'light skin tone', 'man', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone2:',
				'shortname_alternates' => [':man_police_officer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['cop', 'man', 'medium-light skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone3:',
				'shortname_alternates' => [':man_police_officer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['cop', 'man', 'medium skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone4:',
				'shortname_alternates' => [':man_police_officer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['cop', 'man', 'medium-dark skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone5:',
				'shortname_alternates' => [':man_police_officer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['cop', 'dark skin tone', 'man', 'officer', 'police', 'uc8'],
			],
			'1f477' => [
				'name' => \XF::phrase('emoji.construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f477-1f3fb', '1f477-1f3fc', '1f477-1f3fd', '1f477-1f3fe', '1f477-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f477-2642', '1f477-2640'],
				'keywords' => ['construction', 'hat', 'worker', 'uc6'],
			],
			'1f477-1f3fb' => [
				'name' => \XF::phrase('emoji.construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3fb-2642', '1f477-1f3fb-2640'],
				'keywords' => ['construction', 'hat', 'light skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fc' => [
				'name' => \XF::phrase('emoji.construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3fc-2642', '1f477-1f3fc-2640'],
				'keywords' => ['construction', 'hat', 'medium-light skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fd' => [
				'name' => \XF::phrase('emoji.construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3fd-2642', '1f477-1f3fd-2640'],
				'keywords' => ['construction', 'hat', 'medium skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fe' => [
				'name' => \XF::phrase('emoji.construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3fe-2642', '1f477-1f3fe-2640'],
				'keywords' => ['construction', 'hat', 'medium-dark skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3ff' => [
				'name' => \XF::phrase('emoji.construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3ff-2642', '1f477-1f3ff-2640'],
				'keywords' => ['construction', 'dark skin tone', 'hat', 'worker', 'uc8'],
			],
			'1f477-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f477-1f3ff-2640', '1f477-1f3fe-2640', '1f477-1f3fd-2640', '1f477-1f3fc-2640', '1f477-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['construction', 'woman', 'worker', 'uc6'],
			],
			'1f477-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone1:',
				'shortname_alternates' => [':woman_construction_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['construction', 'light skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone2:',
				'shortname_alternates' => [':woman_construction_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['construction', 'medium-light skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone3:',
				'shortname_alternates' => [':woman_construction_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['construction', 'medium skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone4:',
				'shortname_alternates' => [':woman_construction_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['construction', 'medium-dark skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone5:',
				'shortname_alternates' => [':woman_construction_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['construction', 'dark skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f477-1f3ff-2642', '1f477-1f3fe-2642', '1f477-1f3fd-2642', '1f477-1f3fc-2642', '1f477-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['construction', 'man', 'worker', 'uc6'],
			],
			'1f477-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone1:',
				'shortname_alternates' => [':man_construction_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['construction', 'light skin tone', 'man', 'worker', 'uc8'],
			],
			'1f477-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone2:',
				'shortname_alternates' => [':man_construction_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['construction', 'man', 'medium-light skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone3:',
				'shortname_alternates' => [':man_construction_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['construction', 'man', 'medium skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone4:',
				'shortname_alternates' => [':man_construction_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['construction', 'man', 'medium-dark skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone5:',
				'shortname_alternates' => [':man_construction_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['construction', 'dark skin tone', 'man', 'worker', 'uc8'],
			],
			'1f482' => [
				'name' => \XF::phrase('emoji.guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard:',
				'shortname_alternates' => [':guardsman:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f482-1f3fb', '1f482-1f3fc', '1f482-1f3fd', '1f482-1f3fe', '1f482-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f482-2642', '1f482-2640'],
				'keywords' => ['guard', 'uc6'],
			],
			'1f482-1f3fb' => [
				'name' => \XF::phrase('emoji.guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone1:',
				'shortname_alternates' => [':guardsman_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3fb-2642', '1f482-1f3fb-2640'],
				'keywords' => ['guard', 'light skin tone', 'uc8'],
			],
			'1f482-1f3fc' => [
				'name' => \XF::phrase('emoji.guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone2:',
				'shortname_alternates' => [':guardsman_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3fc-2642', '1f482-1f3fc-2640'],
				'keywords' => ['guard', 'medium-light skin tone', 'uc8'],
			],
			'1f482-1f3fd' => [
				'name' => \XF::phrase('emoji.guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone3:',
				'shortname_alternates' => [':guardsman_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3fd-2642', '1f482-1f3fd-2640'],
				'keywords' => ['guard', 'medium skin tone', 'uc8'],
			],
			'1f482-1f3fe' => [
				'name' => \XF::phrase('emoji.guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone4:',
				'shortname_alternates' => [':guardsman_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3fe-2642', '1f482-1f3fe-2640'],
				'keywords' => ['guard', 'medium-dark skin tone', 'uc8'],
			],
			'1f482-1f3ff' => [
				'name' => \XF::phrase('emoji.guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone5:',
				'shortname_alternates' => [':guardsman_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3ff-2642', '1f482-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'guard', 'uc8'],
			],
			'1f482-2640' => [
				'name' => \XF::phrase('emoji.woman_guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f482-1f3ff-2640', '1f482-1f3fe-2640', '1f482-1f3fd-2640', '1f482-1f3fc-2640', '1f482-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['guard', 'woman', 'uc6'],
			],
			'1f482-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone1:',
				'shortname_alternates' => [':woman_guard_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['guard', 'light skin tone', 'woman', 'uc8'],
			],
			'1f482-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone2:',
				'shortname_alternates' => [':woman_guard_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['guard', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f482-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone3:',
				'shortname_alternates' => [':woman_guard_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['guard', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f482-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone4:',
				'shortname_alternates' => [':woman_guard_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['guard', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f482-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone5:',
				'shortname_alternates' => [':woman_guard_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'guard', 'woman', 'uc8'],
			],
			'1f482-2642' => [
				'name' => \XF::phrase('emoji.man_guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f482-1f3ff-2642', '1f482-1f3fe-2642', '1f482-1f3fd-2642', '1f482-1f3fc-2642', '1f482-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['guard', 'man', 'uc6'],
			],
			'1f482-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone1:',
				'shortname_alternates' => [':man_guard_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['guard', 'light skin tone', 'man', 'uc8'],
			],
			'1f482-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone2:',
				'shortname_alternates' => [':man_guard_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['guard', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f482-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone3:',
				'shortname_alternates' => [':man_guard_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['guard', 'man', 'medium skin tone', 'uc8'],
			],
			'1f482-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone4:',
				'shortname_alternates' => [':man_guard_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['guard', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f482-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone5:',
				'shortname_alternates' => [':man_guard_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'guard', 'man', 'uc8'],
			],
			'1f575' => [
				'name' => \XF::phrase('emoji.detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective:',
				'shortname_alternates' => [':spy:', ':sleuth_or_spy:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f575-1f3fb', '1f575-1f3fc', '1f575-1f3fd', '1f575-1f3fe', '1f575-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f575-2642', '1f575-2640'],
				'keywords' => ['detective', 'sleuth', 'spy', 'uc7'],
			],
			'1f575-1f3fb' => [
				'name' => \XF::phrase('emoji.detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone1:',
				'shortname_alternates' => [':spy_tone1:', ':sleuth_or_spy_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3fb-2642', '1f575-1f3fb-2640'],
				'keywords' => ['detective', 'light skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fc' => [
				'name' => \XF::phrase('emoji.detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone2:',
				'shortname_alternates' => [':spy_tone2:', ':sleuth_or_spy_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3fc-2642', '1f575-1f3fc-2640'],
				'keywords' => ['detective', 'medium-light skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fd' => [
				'name' => \XF::phrase('emoji.detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone3:',
				'shortname_alternates' => [':spy_tone3:', ':sleuth_or_spy_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3fd-2642', '1f575-1f3fd-2640'],
				'keywords' => ['detective', 'medium skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fe' => [
				'name' => \XF::phrase('emoji.detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone4:',
				'shortname_alternates' => [':spy_tone4:', ':sleuth_or_spy_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3fe-2642', '1f575-1f3fe-2640'],
				'keywords' => ['detective', 'medium-dark skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3ff' => [
				'name' => \XF::phrase('emoji.detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone5:',
				'shortname_alternates' => [':spy_tone5:', ':sleuth_or_spy_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3ff-2642', '1f575-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'detective', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-2640' => [
				'name' => \XF::phrase('emoji.woman_detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f575-1f3ff-2640', '1f575-1f3fe-2640', '1f575-1f3fd-2640', '1f575-1f3fc-2640', '1f575-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['detective', 'sleuth', 'spy', 'woman', 'uc7'],
			],
			'1f575-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone1:',
				'shortname_alternates' => [':woman_detective_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['detective', 'light skin tone', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone2:',
				'shortname_alternates' => [':woman_detective_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['detective', 'medium-light skin tone', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone3:',
				'shortname_alternates' => [':woman_detective_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['detective', 'medium skin tone', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone4:',
				'shortname_alternates' => [':woman_detective_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['detective', 'medium-dark skin tone', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone5:',
				'shortname_alternates' => [':woman_detective_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'detective', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-2642' => [
				'name' => \XF::phrase('emoji.man_detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f575-1f3ff-2642', '1f575-1f3fe-2642', '1f575-1f3fd-2642', '1f575-1f3fc-2642', '1f575-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['detective', 'man', 'sleuth', 'spy', 'uc7'],
			],
			'1f575-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone1:',
				'shortname_alternates' => [':man_detective_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['detective', 'light skin tone', 'man', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone2:',
				'shortname_alternates' => [':man_detective_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['detective', 'man', 'medium-light skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone3:',
				'shortname_alternates' => [':man_detective_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['detective', 'man', 'medium skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone4:',
				'shortname_alternates' => [':man_detective_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['detective', 'man', 'medium-dark skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone5:',
				'shortname_alternates' => [':man_detective_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'detective', 'man', 'sleuth', 'spy', 'uc8'],
			],
			'1f9d1-2695' => [
				'name' => \XF::phrase('emoji.health_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-2695', '1f9d1-1f3fc-2695', '1f9d1-1f3fd-2695', '1f9d1-1f3fe-2695', '1f9d1-1f3ff-2695'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone1:',
				'shortname_alternates' => [':health_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone2:',
				'shortname_alternates' => [':health_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone3:',
				'shortname_alternates' => [':health_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone4:',
				'shortname_alternates' => [':health_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone5:',
				'shortname_alternates' => [':health_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-2695', '1f469-1f3fe-2695', '1f469-1f3fd-2695', '1f469-1f3fc-2695', '1f469-1f3fb-2695'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'nurse', 'therapist', 'woman', 'uc6'],
			],
			'1f469-1f3fb-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone1:',
				'shortname_alternates' => [':woman_health_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'light skin tone', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f469-1f3fc-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone2:',
				'shortname_alternates' => [':woman_health_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'medium-light skin tone', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f469-1f3fd-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone3:',
				'shortname_alternates' => [':woman_health_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'medium skin tone', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f469-1f3fe-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone4:',
				'shortname_alternates' => [':woman_health_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'medium-dark skin tone', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f469-1f3ff-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone5:',
				'shortname_alternates' => [':woman_health_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'doctor', 'healthcare', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f468-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-2695', '1f468-1f3fe-2695', '1f468-1f3fd-2695', '1f468-1f3fc-2695', '1f468-1f3fb-2695'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'man', 'nurse', 'therapist', 'uc6'],
			],
			'1f468-1f3fb-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone1:',
				'shortname_alternates' => [':man_health_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'light skin tone', 'man', 'nurse', 'therapist', 'uc8'],
			],
			'1f468-1f3fc-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone2:',
				'shortname_alternates' => [':man_health_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'man', 'medium-light skin tone', 'nurse', 'therapist', 'uc8'],
			],
			'1f468-1f3fd-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone3:',
				'shortname_alternates' => [':man_health_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'man', 'medium skin tone', 'nurse', 'therapist', 'uc8'],
			],
			'1f468-1f3fe-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone4:',
				'shortname_alternates' => [':man_health_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doctor', 'healthcare', 'man', 'medium-dark skin tone', 'nurse', 'therapist', 'uc8'],
			],
			'1f468-1f3ff-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone5:',
				'shortname_alternates' => [':man_health_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'doctor', 'healthcare', 'man', 'nurse', 'therapist', 'uc8'],
			],
			'1f9d1-1f33e' => [
				'name' => \XF::phrase('emoji.farmer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f33e', '1f9d1-1f3fc-1f33e', '1f9d1-1f3fd-1f33e', '1f9d1-1f3fe-1f33e', '1f9d1-1f3ff-1f33e'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone1:',
				'shortname_alternates' => [':farmer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone2:',
				'shortname_alternates' => [':farmer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone3:',
				'shortname_alternates' => [':farmer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone4:',
				'shortname_alternates' => [':farmer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone5:',
				'shortname_alternates' => [':farmer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f33e', '1f469-1f3fe-1f33e', '1f469-1f3fd-1f33e', '1f469-1f3fc-1f33e', '1f469-1f3fb-1f33e'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'rancher', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone1:',
				'shortname_alternates' => [':woman_farmer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'light skin tone', 'rancher', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone2:',
				'shortname_alternates' => [':woman_farmer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'medium-light skin tone', 'rancher', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone3:',
				'shortname_alternates' => [':woman_farmer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'medium skin tone', 'rancher', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone4:',
				'shortname_alternates' => [':woman_farmer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'medium-dark skin tone', 'rancher', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone5:',
				'shortname_alternates' => [':woman_farmer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'farmer', 'gardener', 'rancher', 'woman', 'uc8'],
			],
			'1f468-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f33e', '1f468-1f3fe-1f33e', '1f468-1f3fd-1f33e', '1f468-1f3fc-1f33e', '1f468-1f3fb-1f33e'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'man', 'rancher', 'uc6'],
			],
			'1f468-1f3fb-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone1:',
				'shortname_alternates' => [':man_farmer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'light skin tone', 'man', 'rancher', 'uc8'],
			],
			'1f468-1f3fc-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone2:',
				'shortname_alternates' => [':man_farmer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'man', 'medium-light skin tone', 'rancher', 'uc8'],
			],
			'1f468-1f3fd-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone3:',
				'shortname_alternates' => [':man_farmer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'man', 'medium skin tone', 'rancher', 'uc8'],
			],
			'1f468-1f3fe-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone4:',
				'shortname_alternates' => [':man_farmer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['farmer', 'gardener', 'man', 'medium-dark skin tone', 'rancher', 'uc8'],
			],
			'1f468-1f3ff-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone5:',
				'shortname_alternates' => [':man_farmer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'farmer', 'gardener', 'man', 'rancher', 'uc8'],
			],
			'1f9d1-1f373' => [
				'name' => \XF::phrase('emoji.cook'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f373', '1f9d1-1f3fc-1f373', '1f9d1-1f3fd-1f373', '1f9d1-1f3fe-1f373', '1f9d1-1f3ff-1f373'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone1:',
				'shortname_alternates' => [':cook_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone2:',
				'shortname_alternates' => [':cook_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone3:',
				'shortname_alternates' => [':cook_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone4:',
				'shortname_alternates' => [':cook_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone5:',
				'shortname_alternates' => [':cook_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f373', '1f469-1f3fe-1f373', '1f469-1f3fd-1f373', '1f469-1f3fc-1f373', '1f469-1f3fb-1f373'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone1:',
				'shortname_alternates' => [':woman_cook_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone2:',
				'shortname_alternates' => [':woman_cook_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone3:',
				'shortname_alternates' => [':woman_cook_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone4:',
				'shortname_alternates' => [':woman_cook_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone5:',
				'shortname_alternates' => [':woman_cook_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'dark skin tone', 'woman', 'uc8'],
			],
			'1f468-1f373' => [
				'name' => \XF::phrase('emoji.man_cook'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f373', '1f468-1f3fe-1f373', '1f468-1f3fd-1f373', '1f468-1f3fc-1f373', '1f468-1f3fb-1f373'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'man', 'uc6'],
			],
			'1f468-1f3fb-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone1:',
				'shortname_alternates' => [':man_cook_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'light skin tone', 'man', 'uc8'],
			],
			'1f468-1f3fc-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone2:',
				'shortname_alternates' => [':man_cook_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f468-1f3fd-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone3:',
				'shortname_alternates' => [':man_cook_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'man', 'medium skin tone', 'uc8'],
			],
			'1f468-1f3fe-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone4:',
				'shortname_alternates' => [':man_cook_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f468-1f3ff-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone5:',
				'shortname_alternates' => [':man_cook_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['chef', 'cook', 'dark skin tone', 'man', 'uc8'],
			],
			'1f9d1-1f393' => [
				'name' => \XF::phrase('emoji.student'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f393', '1f9d1-1f3fc-1f393', '1f9d1-1f3fd-1f393', '1f9d1-1f3fe-1f393', '1f9d1-1f3ff-1f393'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f393' => [
				'name' => \XF::phrase('emoji.student_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone1:',
				'shortname_alternates' => [':student_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f393' => [
				'name' => \XF::phrase('emoji.student_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone2:',
				'shortname_alternates' => [':student_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f393' => [
				'name' => \XF::phrase('emoji.student_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone3:',
				'shortname_alternates' => [':student_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f393' => [
				'name' => \XF::phrase('emoji.student_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone4:',
				'shortname_alternates' => [':student_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f393' => [
				'name' => \XF::phrase('emoji.student_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone5:',
				'shortname_alternates' => [':student_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f393' => [
				'name' => \XF::phrase('emoji.woman_student'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f393', '1f469-1f3fe-1f393', '1f469-1f3fd-1f393', '1f469-1f3fc-1f393', '1f469-1f3fb-1f393'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['graduate', 'student', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone1:',
				'shortname_alternates' => [':woman_student_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['graduate', 'light skin tone', 'student', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone2:',
				'shortname_alternates' => [':woman_student_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['graduate', 'medium-light skin tone', 'student', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone3:',
				'shortname_alternates' => [':woman_student_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['graduate', 'medium skin tone', 'student', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone4:',
				'shortname_alternates' => [':woman_student_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['graduate', 'medium-dark skin tone', 'student', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone5:',
				'shortname_alternates' => [':woman_student_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'graduate', 'student', 'woman', 'uc8'],
			],
			'1f468-1f393' => [
				'name' => \XF::phrase('emoji.man_student'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f393', '1f468-1f3fe-1f393', '1f468-1f3fd-1f393', '1f468-1f3fc-1f393', '1f468-1f3fb-1f393'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['graduate', 'man', 'student', 'uc6'],
			],
			'1f468-1f3fb-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone1:',
				'shortname_alternates' => [':man_student_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['graduate', 'light skin tone', 'man', 'student', 'uc8'],
			],
			'1f468-1f3fc-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone2:',
				'shortname_alternates' => [':man_student_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['graduate', 'man', 'medium-light skin tone', 'student', 'uc8'],
			],
			'1f468-1f3fd-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone3:',
				'shortname_alternates' => [':man_student_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['graduate', 'man', 'medium skin tone', 'student', 'uc8'],
			],
			'1f468-1f3fe-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone4:',
				'shortname_alternates' => [':man_student_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['graduate', 'man', 'medium-dark skin tone', 'student', 'uc8'],
			],
			'1f468-1f3ff-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone5:',
				'shortname_alternates' => [':man_student_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'graduate', 'man', 'student', 'uc8'],
			],
			'1f9d1-1f3a4' => [
				'name' => \XF::phrase('emoji.singer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f3a4', '1f9d1-1f3fc-1f3a4', '1f9d1-1f3fd-1f3a4', '1f9d1-1f3fe-1f3a4', '1f9d1-1f3ff-1f3a4'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone1:',
				'shortname_alternates' => [':singer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone2:',
				'shortname_alternates' => [':singer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone3:',
				'shortname_alternates' => [':singer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone4:',
				'shortname_alternates' => [':singer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone5:',
				'shortname_alternates' => [':singer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f3a4', '1f469-1f3fe-1f3a4', '1f469-1f3fd-1f3a4', '1f469-1f3fc-1f3a4', '1f469-1f3fb-1f3a4'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'rock', 'singer', 'star', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone1:',
				'shortname_alternates' => [':woman_singer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'light skin tone', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone2:',
				'shortname_alternates' => [':woman_singer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'medium-light skin tone', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone3:',
				'shortname_alternates' => [':woman_singer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'medium skin tone', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone4:',
				'shortname_alternates' => [':woman_singer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'medium-dark skin tone', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone5:',
				'shortname_alternates' => [':woman_singer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['actor', 'dark skin tone', 'entertainer', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f468-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f3a4', '1f468-1f3fe-1f3a4', '1f468-1f3fd-1f3a4', '1f468-1f3fc-1f3a4', '1f468-1f3fb-1f3a4'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'man', 'rock', 'singer', 'star', 'uc6'],
			],
			'1f468-1f3fb-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone1:',
				'shortname_alternates' => [':man_singer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'light skin tone', 'man', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f468-1f3fc-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone2:',
				'shortname_alternates' => [':man_singer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'man', 'medium-light skin tone', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f468-1f3fd-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone3:',
				'shortname_alternates' => [':man_singer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'man', 'medium skin tone', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f468-1f3fe-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone4:',
				'shortname_alternates' => [':man_singer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['actor', 'entertainer', 'man', 'medium-dark skin tone', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f468-1f3ff-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone5:',
				'shortname_alternates' => [':man_singer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['actor', 'dark skin tone', 'entertainer', 'man', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f9d1-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f3eb', '1f9d1-1f3fc-1f3eb', '1f9d1-1f3fd-1f3eb', '1f9d1-1f3fe-1f3eb', '1f9d1-1f3ff-1f3eb'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone1:',
				'shortname_alternates' => [':teacher_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone2:',
				'shortname_alternates' => [':teacher_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone3:',
				'shortname_alternates' => [':teacher_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone4:',
				'shortname_alternates' => [':teacher_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone5:',
				'shortname_alternates' => [':teacher_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f3eb', '1f469-1f3fe-1f3eb', '1f469-1f3fd-1f3eb', '1f469-1f3fc-1f3eb', '1f469-1f3fb-1f3eb'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['instructor', 'professor', 'teacher', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone1:',
				'shortname_alternates' => [':woman_teacher_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['instructor', 'light skin tone', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone2:',
				'shortname_alternates' => [':woman_teacher_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['instructor', 'medium-light skin tone', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone3:',
				'shortname_alternates' => [':woman_teacher_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['instructor', 'medium skin tone', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone4:',
				'shortname_alternates' => [':woman_teacher_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['instructor', 'medium-dark skin tone', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone5:',
				'shortname_alternates' => [':woman_teacher_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'instructor', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f468-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f3eb', '1f468-1f3fe-1f3eb', '1f468-1f3fd-1f3eb', '1f468-1f3fc-1f3eb', '1f468-1f3fb-1f3eb'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['instructor', 'man', 'professor', 'teacher', 'uc6'],
			],
			'1f468-1f3fb-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone1:',
				'shortname_alternates' => [':man_teacher_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['instructor', 'light skin tone', 'man', 'professor', 'teacher', 'uc8'],
			],
			'1f468-1f3fc-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone2:',
				'shortname_alternates' => [':man_teacher_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['instructor', 'man', 'medium-light skin tone', 'professor', 'teacher', 'uc8'],
			],
			'1f468-1f3fd-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone3:',
				'shortname_alternates' => [':man_teacher_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['instructor', 'man', 'medium skin tone', 'professor', 'teacher', 'uc8'],
			],
			'1f468-1f3fe-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone4:',
				'shortname_alternates' => [':man_teacher_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['instructor', 'man', 'medium-dark skin tone', 'professor', 'teacher', 'uc8'],
			],
			'1f468-1f3ff-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone5:',
				'shortname_alternates' => [':man_teacher_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'instructor', 'man', 'professor', 'teacher', 'uc8'],
			],
			'1f9d1-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f3ed', '1f9d1-1f3fc-1f3ed', '1f9d1-1f3fd-1f3ed', '1f9d1-1f3fe-1f3ed', '1f9d1-1f3ff-1f3ed'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone1:',
				'shortname_alternates' => [':factory_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone2:',
				'shortname_alternates' => [':factory_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone3:',
				'shortname_alternates' => [':factory_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone4:',
				'shortname_alternates' => [':factory_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone5:',
				'shortname_alternates' => [':factory_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f3ed', '1f469-1f3fe-1f3ed', '1f469-1f3fd-1f3ed', '1f469-1f3fc-1f3ed', '1f469-1f3fb-1f3ed'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'woman', 'worker', 'uc6'],
			],
			'1f469-1f3fb-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone1:',
				'shortname_alternates' => [':woman_factory_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'light skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f469-1f3fc-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone2:',
				'shortname_alternates' => [':woman_factory_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'medium-light skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f469-1f3fd-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone3:',
				'shortname_alternates' => [':woman_factory_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'medium skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f469-1f3fe-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone4:',
				'shortname_alternates' => [':woman_factory_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'medium-dark skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f469-1f3ff-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone5:',
				'shortname_alternates' => [':woman_factory_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['assembly', 'dark skin tone', 'factory', 'industrial', 'woman', 'worker', 'uc8'],
			],
			'1f468-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f3ed', '1f468-1f3fe-1f3ed', '1f468-1f3fd-1f3ed', '1f468-1f3fc-1f3ed', '1f468-1f3fb-1f3ed'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'worker', 'uc6'],
			],
			'1f468-1f3fb-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone1:',
				'shortname_alternates' => [':man_factory_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'light skin tone', 'man', 'worker', 'uc8'],
			],
			'1f468-1f3fc-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone2:',
				'shortname_alternates' => [':man_factory_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium-light skin tone', 'worker', 'uc8'],
			],
			'1f468-1f3fd-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone3:',
				'shortname_alternates' => [':man_factory_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium skin tone', 'worker', 'uc8'],
			],
			'1f468-1f3fe-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone4:',
				'shortname_alternates' => [':man_factory_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium-dark skin tone', 'worker', 'uc8'],
			],
			'1f468-1f3ff-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone5:',
				'shortname_alternates' => [':man_factory_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['assembly', 'dark skin tone', 'factory', 'industrial', 'man', 'worker', 'uc8'],
			],
			'1f9d1-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f4bb', '1f9d1-1f3fc-1f4bb', '1f9d1-1f3fd-1f4bb', '1f9d1-1f3fe-1f4bb', '1f9d1-1f3ff-1f4bb'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone1:',
				'shortname_alternates' => [':technologist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone2:',
				'shortname_alternates' => [':technologist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone3:',
				'shortname_alternates' => [':technologist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone4:',
				'shortname_alternates' => [':technologist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone5:',
				'shortname_alternates' => [':technologist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f4bb', '1f469-1f3fe-1f4bb', '1f469-1f3fd-1f4bb', '1f469-1f3fc-1f4bb', '1f469-1f3fb-1f4bb'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'software', 'technologist', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone1:',
				'shortname_alternates' => [':woman_technologist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'light skin tone', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone2:',
				'shortname_alternates' => [':woman_technologist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'medium-light skin tone', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone3:',
				'shortname_alternates' => [':woman_technologist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'medium skin tone', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone4:',
				'shortname_alternates' => [':woman_technologist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'medium-dark skin tone', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone5:',
				'shortname_alternates' => [':woman_technologist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['coder', 'dark skin tone', 'developer', 'inventor', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f468-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f4bb', '1f468-1f3fe-1f4bb', '1f468-1f3fd-1f4bb', '1f468-1f3fc-1f4bb', '1f468-1f3fb-1f4bb'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'software', 'technologist', 'uc6'],
			],
			'1f468-1f3fb-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone1:',
				'shortname_alternates' => [':man_technologist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'light skin tone', 'man', 'software', 'technologist', 'uc8'],
			],
			'1f468-1f3fc-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone2:',
				'shortname_alternates' => [':man_technologist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium-light skin tone', 'software', 'technologist', 'uc8'],
			],
			'1f468-1f3fd-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone3:',
				'shortname_alternates' => [':man_technologist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium skin tone', 'software', 'technologist', 'uc8'],
			],
			'1f468-1f3fe-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone4:',
				'shortname_alternates' => [':man_technologist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium-dark skin tone', 'software', 'technologist', 'uc8'],
			],
			'1f468-1f3ff-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone5:',
				'shortname_alternates' => [':man_technologist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['coder', 'dark skin tone', 'developer', 'inventor', 'man', 'software', 'technologist', 'uc8'],
			],
			'1f9d1-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f4bc', '1f9d1-1f3fc-1f4bc', '1f9d1-1f3fd-1f4bc', '1f9d1-1f3fe-1f4bc', '1f9d1-1f3ff-1f4bc'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone1:',
				'shortname_alternates' => [':office_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone2:',
				'shortname_alternates' => [':office_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone3:',
				'shortname_alternates' => [':office_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone4:',
				'shortname_alternates' => [':office_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone5:',
				'shortname_alternates' => [':office_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f4bc', '1f469-1f3fe-1f4bc', '1f469-1f3fd-1f4bc', '1f469-1f3fc-1f4bc', '1f469-1f3fb-1f4bc'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'manager', 'office', 'white-collar', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone1:',
				'shortname_alternates' => [':woman_office_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'light skin tone', 'manager', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone2:',
				'shortname_alternates' => [':woman_office_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'manager', 'medium-light skin tone', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone3:',
				'shortname_alternates' => [':woman_office_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'manager', 'medium skin tone', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone4:',
				'shortname_alternates' => [':woman_office_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'manager', 'medium-dark skin tone', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone5:',
				'shortname_alternates' => [':woman_office_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'dark skin tone', 'manager', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f468-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f4bc', '1f468-1f3fe-1f4bc', '1f468-1f3fd-1f4bc', '1f468-1f3fc-1f4bc', '1f468-1f3fb-1f4bc'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'man', 'manager', 'office', 'white-collar', 'uc6'],
			],
			'1f468-1f3fb-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone1:',
				'shortname_alternates' => [':man_office_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'light skin tone', 'man', 'manager', 'office', 'white-collar', 'uc8'],
			],
			'1f468-1f3fc-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone2:',
				'shortname_alternates' => [':man_office_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium-light skin tone', 'office', 'white-collar', 'uc8'],
			],
			'1f468-1f3fd-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone3:',
				'shortname_alternates' => [':man_office_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium skin tone', 'office', 'white-collar', 'uc8'],
			],
			'1f468-1f3fe-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone4:',
				'shortname_alternates' => [':man_office_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium-dark skin tone', 'office', 'white-collar', 'uc8'],
			],
			'1f468-1f3ff-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone5:',
				'shortname_alternates' => [':man_office_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['architect', 'business', 'dark skin tone', 'man', 'manager', 'office', 'white-collar', 'uc8'],
			],
			'1f9d1-1f527' => [
				'name' => \XF::phrase('emoji.mechanic'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f527', '1f9d1-1f3fc-1f527', '1f9d1-1f3fd-1f527', '1f9d1-1f3fe-1f527', '1f9d1-1f3ff-1f527'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone1:',
				'shortname_alternates' => [':mechanic_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone2:',
				'shortname_alternates' => [':mechanic_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone3:',
				'shortname_alternates' => [':mechanic_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone4:',
				'shortname_alternates' => [':mechanic_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone5:',
				'shortname_alternates' => [':mechanic_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f527', '1f469-1f3fe-1f527', '1f469-1f3fd-1f527', '1f469-1f3fc-1f527', '1f469-1f3fb-1f527'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['electrician', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone1:',
				'shortname_alternates' => [':woman_mechanic_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['electrician', 'light skin tone', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone2:',
				'shortname_alternates' => [':woman_mechanic_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['electrician', 'mechanic', 'medium-light skin tone', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone3:',
				'shortname_alternates' => [':woman_mechanic_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['electrician', 'mechanic', 'medium skin tone', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone4:',
				'shortname_alternates' => [':woman_mechanic_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['electrician', 'mechanic', 'medium-dark skin tone', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone5:',
				'shortname_alternates' => [':woman_mechanic_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'electrician', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f468-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f527', '1f468-1f3fe-1f527', '1f468-1f3fd-1f527', '1f468-1f3fc-1f527', '1f468-1f3fb-1f527'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['electrician', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc6'],
			],
			'1f468-1f3fb-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone1:',
				'shortname_alternates' => [':man_mechanic_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['electrician', 'light skin tone', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f468-1f3fc-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone2:',
				'shortname_alternates' => [':man_mechanic_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['electrician', 'man', 'mechanic', 'medium-light skin tone', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f468-1f3fd-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone3:',
				'shortname_alternates' => [':man_mechanic_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['electrician', 'man', 'mechanic', 'medium skin tone', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f468-1f3fe-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone4:',
				'shortname_alternates' => [':man_mechanic_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['electrician', 'man', 'mechanic', 'medium-dark skin tone', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f468-1f3ff-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone5:',
				'shortname_alternates' => [':man_mechanic_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'electrician', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f9d1-1f52c' => [
				'name' => \XF::phrase('emoji.scientist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f52c', '1f9d1-1f3fc-1f52c', '1f9d1-1f3fd-1f52c', '1f9d1-1f3fe-1f52c', '1f9d1-1f3ff-1f52c'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone1:',
				'shortname_alternates' => [':scientist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone2:',
				'shortname_alternates' => [':scientist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone3:',
				'shortname_alternates' => [':scientist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone4:',
				'shortname_alternates' => [':scientist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone5:',
				'shortname_alternates' => [':scientist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f52c', '1f469-1f3fe-1f52c', '1f469-1f3fd-1f52c', '1f469-1f3fc-1f52c', '1f469-1f3fb-1f52c'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'physicist', 'scientist', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone1:',
				'shortname_alternates' => [':woman_scientist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'light skin tone', 'mathematician', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone2:',
				'shortname_alternates' => [':woman_scientist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium-light skin tone', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone3:',
				'shortname_alternates' => [':woman_scientist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium skin tone', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone4:',
				'shortname_alternates' => [':woman_scientist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium-dark skin tone', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone5:',
				'shortname_alternates' => [':woman_scientist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'dark skin tone', 'engineer', 'mathematician', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f468-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f52c', '1f468-1f3fe-1f52c', '1f468-1f3fd-1f52c', '1f468-1f3fc-1f52c', '1f468-1f3fb-1f52c'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'physicist', 'scientist', 'uc6'],
			],
			'1f468-1f3fb-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone1:',
				'shortname_alternates' => [':man_scientist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'light skin tone', 'man', 'mathematician', 'physicist', 'scientist', 'uc8'],
			],
			'1f468-1f3fc-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone2:',
				'shortname_alternates' => [':man_scientist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium-light skin tone', 'physicist', 'scientist', 'uc8'],
			],
			'1f468-1f3fd-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone3:',
				'shortname_alternates' => [':man_scientist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium skin tone', 'physicist', 'scientist', 'uc8'],
			],
			'1f468-1f3fe-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone4:',
				'shortname_alternates' => [':man_scientist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium-dark skin tone', 'physicist', 'scientist', 'uc8'],
			],
			'1f468-1f3ff-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone5:',
				'shortname_alternates' => [':man_scientist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['biologist', 'chemist', 'dark skin tone', 'engineer', 'man', 'mathematician', 'physicist', 'scientist', 'uc8'],
			],
			'1f9d1-1f3a8' => [
				'name' => \XF::phrase('emoji.artist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f3a8', '1f9d1-1f3fc-1f3a8', '1f9d1-1f3fd-1f3a8', '1f9d1-1f3fe-1f3a8', '1f9d1-1f3ff-1f3a8'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone1:',
				'shortname_alternates' => [':artist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone2:',
				'shortname_alternates' => [':artist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone3:',
				'shortname_alternates' => [':artist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone4:',
				'shortname_alternates' => [':artist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone5:',
				'shortname_alternates' => [':artist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f3a8', '1f469-1f3fc-1f3a8', '1f469-1f3fd-1f3a8', '1f469-1f3fe-1f3a8', '1f469-1f3ff-1f3a8'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['artist', 'palette', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone1:',
				'shortname_alternates' => [':woman_artist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['artist', 'light skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone2:',
				'shortname_alternates' => [':woman_artist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['artist', 'medium-light skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone3:',
				'shortname_alternates' => [':woman_artist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['artist', 'medium skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone4:',
				'shortname_alternates' => [':woman_artist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['artist', 'medium-dark skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone5:',
				'shortname_alternates' => [':woman_artist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['artist', 'dark skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f468-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f3a8', '1f468-1f3fc-1f3a8', '1f468-1f3fd-1f3a8', '1f468-1f3fe-1f3a8', '1f468-1f3ff-1f3a8'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['artist', 'man', 'palette', 'uc6'],
			],
			'1f468-1f3fb-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone1:',
				'shortname_alternates' => [':man_artist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['artist', 'light skin tone', 'man', 'palette', 'uc8'],
			],
			'1f468-1f3fc-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone2:',
				'shortname_alternates' => [':man_artist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['artist', 'man', 'medium-light skin tone', 'palette', 'uc8'],
			],
			'1f468-1f3fd-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone3:',
				'shortname_alternates' => [':man_artist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['artist', 'man', 'medium skin tone', 'palette', 'uc8'],
			],
			'1f468-1f3fe-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone4:',
				'shortname_alternates' => [':man_artist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['artist', 'man', 'medium-dark skin tone', 'palette', 'uc8'],
			],
			'1f468-1f3ff-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone5:',
				'shortname_alternates' => [':man_artist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['artist', 'dark skin tone', 'man', 'palette', 'uc8'],
			],
			'1f9d1-1f692' => [
				'name' => \XF::phrase('emoji.firefighter'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f692', '1f9d1-1f3fc-1f692', '1f9d1-1f3fd-1f692', '1f9d1-1f3fe-1f692', '1f9d1-1f3ff-1f692'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone1:',
				'shortname_alternates' => [':firefighter_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone2:',
				'shortname_alternates' => [':firefighter_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone3:',
				'shortname_alternates' => [':firefighter_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone4:',
				'shortname_alternates' => [':firefighter_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone5:',
				'shortname_alternates' => [':firefighter_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f692', '1f469-1f3fc-1f692', '1f469-1f3fd-1f692', '1f469-1f3fe-1f692', '1f469-1f3ff-1f692'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone1:',
				'shortname_alternates' => [':woman_firefighter_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone2:',
				'shortname_alternates' => [':woman_firefighter_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone3:',
				'shortname_alternates' => [':woman_firefighter_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone4:',
				'shortname_alternates' => [':woman_firefighter_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone5:',
				'shortname_alternates' => [':woman_firefighter_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'firefighter', 'firetruck', 'woman', 'uc8'],
			],
			'1f468-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f692', '1f468-1f3fc-1f692', '1f468-1f3fd-1f692', '1f468-1f3fe-1f692', '1f468-1f3ff-1f692'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'man', 'uc6'],
			],
			'1f468-1f3fb-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone1:',
				'shortname_alternates' => [':man_firefighter_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'light skin tone', 'man', 'uc8'],
			],
			'1f468-1f3fc-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone2:',
				'shortname_alternates' => [':man_firefighter_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f468-1f3fd-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone3:',
				'shortname_alternates' => [':man_firefighter_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium skin tone', 'uc8'],
			],
			'1f468-1f3fe-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone4:',
				'shortname_alternates' => [':man_firefighter_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f468-1f3ff-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone5:',
				'shortname_alternates' => [':man_firefighter_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'firefighter', 'firetruck', 'man', 'uc8'],
			],
			'1f9d1-2708' => [
				'name' => \XF::phrase('emoji.pilot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-2708', '1f9d1-1f3fc-2708', '1f9d1-1f3fd-2708', '1f9d1-1f3fe-2708', '1f9d1-1f3ff-2708'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone1:',
				'shortname_alternates' => [':pilot_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone2:',
				'shortname_alternates' => [':pilot_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone3:',
				'shortname_alternates' => [':pilot_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone4:',
				'shortname_alternates' => [':pilot_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone5:',
				'shortname_alternates' => [':pilot_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-2708', '1f469-1f3fc-2708', '1f469-1f3fd-2708', '1f469-1f3fe-2708', '1f469-1f3ff-2708'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['pilot', 'plane', 'woman', 'uc6'],
			],
			'1f469-1f3fb-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone1:',
				'shortname_alternates' => [':woman_pilot_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f469-1f3fc-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone2:',
				'shortname_alternates' => [':woman_pilot_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f469-1f3fd-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone3:',
				'shortname_alternates' => [':woman_pilot_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f469-1f3fe-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone4:',
				'shortname_alternates' => [':woman_pilot_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f469-1f3ff-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone5:',
				'shortname_alternates' => [':woman_pilot_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f468-2708' => [
				'name' => \XF::phrase('emoji.man_pilot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-2708', '1f468-1f3fc-2708', '1f468-1f3fd-2708', '1f468-1f3fe-2708', '1f468-1f3ff-2708'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'pilot', 'plane', 'uc6'],
			],
			'1f468-1f3fb-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone1:',
				'shortname_alternates' => [':man_pilot_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'man', 'pilot', 'plane', 'uc8'],
			],
			'1f468-1f3fc-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone2:',
				'shortname_alternates' => [':man_pilot_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium-light skin tone', 'pilot', 'plane', 'uc8'],
			],
			'1f468-1f3fd-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone3:',
				'shortname_alternates' => [':man_pilot_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium skin tone', 'pilot', 'plane', 'uc8'],
			],
			'1f468-1f3fe-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone4:',
				'shortname_alternates' => [':man_pilot_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'pilot', 'plane', 'uc8'],
			],
			'1f468-1f3ff-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone5:',
				'shortname_alternates' => [':man_pilot_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'man', 'pilot', 'plane', 'uc8'],
			],
			'1f9d1-1f680' => [
				'name' => \XF::phrase('emoji.astronaut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f680', '1f9d1-1f3fc-1f680', '1f9d1-1f3fd-1f680', '1f9d1-1f3fe-1f680', '1f9d1-1f3ff-1f680'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone1:',
				'shortname_alternates' => [':astronaut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone2:',
				'shortname_alternates' => [':astronaut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone3:',
				'shortname_alternates' => [':astronaut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone4:',
				'shortname_alternates' => [':astronaut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone5:',
				'shortname_alternates' => [':astronaut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f680', '1f469-1f3fc-1f680', '1f469-1f3fd-1f680', '1f469-1f3fe-1f680', '1f469-1f3ff-1f680'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'rocket', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone1:',
				'shortname_alternates' => [':woman_astronaut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'light skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone2:',
				'shortname_alternates' => [':woman_astronaut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'medium-light skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone3:',
				'shortname_alternates' => [':woman_astronaut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'medium skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone4:',
				'shortname_alternates' => [':woman_astronaut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'medium-dark skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone5:',
				'shortname_alternates' => [':woman_astronaut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'dark skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f468-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f680', '1f468-1f3fc-1f680', '1f468-1f3fd-1f680', '1f468-1f3fe-1f680', '1f468-1f3ff-1f680'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'man', 'rocket', 'uc6'],
			],
			'1f468-1f3fb-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone1:',
				'shortname_alternates' => [':man_astronaut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'light skin tone', 'man', 'rocket', 'uc8'],
			],
			'1f468-1f3fc-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone2:',
				'shortname_alternates' => [':man_astronaut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'man', 'medium-light skin tone', 'rocket', 'uc8'],
			],
			'1f468-1f3fd-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone3:',
				'shortname_alternates' => [':man_astronaut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'man', 'medium skin tone', 'rocket', 'uc8'],
			],
			'1f468-1f3fe-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone4:',
				'shortname_alternates' => [':man_astronaut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'man', 'medium-dark skin tone', 'rocket', 'uc8'],
			],
			'1f468-1f3ff-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone5:',
				'shortname_alternates' => [':man_astronaut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['astronaut', 'dark skin tone', 'man', 'rocket', 'uc8'],
			],
			'1f9d1-2696' => [
				'name' => \XF::phrase('emoji.judge'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-2696', '1f9d1-1f3fc-2696', '1f9d1-1f3fd-2696', '1f9d1-1f3fe-2696', '1f9d1-1f3ff-2696'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-2696' => [
				'name' => \XF::phrase('emoji.judge_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone1:',
				'shortname_alternates' => [':judge_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-2696' => [
				'name' => \XF::phrase('emoji.judge_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone2:',
				'shortname_alternates' => [':judge_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-2696' => [
				'name' => \XF::phrase('emoji.judge_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone3:',
				'shortname_alternates' => [':judge_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-2696' => [
				'name' => \XF::phrase('emoji.judge_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone4:',
				'shortname_alternates' => [':judge_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-2696' => [
				'name' => \XF::phrase('emoji.judge_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone5:',
				'shortname_alternates' => [':judge_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-2696' => [
				'name' => \XF::phrase('emoji.woman_judge'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-2696', '1f469-1f3fc-2696', '1f469-1f3fd-2696', '1f469-1f3fe-2696', '1f469-1f3ff-2696'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['judge', 'scales', 'woman', 'uc6'],
			],
			'1f469-1f3fb-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone1:',
				'shortname_alternates' => [':woman_judge_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['judge', 'light skin tone', 'scales', 'woman', 'uc8'],
			],
			'1f469-1f3fc-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone2:',
				'shortname_alternates' => [':woman_judge_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['judge', 'medium-light skin tone', 'scales', 'woman', 'uc8'],
			],
			'1f469-1f3fd-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone3:',
				'shortname_alternates' => [':woman_judge_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['judge', 'medium skin tone', 'scales', 'woman', 'uc8'],
			],
			'1f469-1f3fe-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone4:',
				'shortname_alternates' => [':woman_judge_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['judge', 'medium-dark skin tone', 'scales', 'woman', 'uc8'],
			],
			'1f469-1f3ff-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone5:',
				'shortname_alternates' => [':woman_judge_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'judge', 'scales', 'woman', 'uc8'],
			],
			'1f468-2696' => [
				'name' => \XF::phrase('emoji.man_judge'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-2696', '1f468-1f3fc-2696', '1f468-1f3fd-2696', '1f468-1f3fe-2696', '1f468-1f3ff-2696'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['justice', 'man', 'scales', 'uc6'],
			],
			'1f468-1f3fb-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone1:',
				'shortname_alternates' => [':man_judge_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['justice', 'light skin tone', 'man', 'scales', 'uc8'],
			],
			'1f468-1f3fc-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone2:',
				'shortname_alternates' => [':man_judge_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['justice', 'man', 'medium-light skin tone', 'scales', 'uc8'],
			],
			'1f468-1f3fd-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone3:',
				'shortname_alternates' => [':man_judge_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['justice', 'man', 'medium skin tone', 'scales', 'uc8'],
			],
			'1f468-1f3fe-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone4:',
				'shortname_alternates' => [':man_judge_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['justice', 'man', 'medium-dark skin tone', 'scales', 'uc8'],
			],
			'1f468-1f3ff-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone5:',
				'shortname_alternates' => [':man_judge_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'justice', 'man', 'scales', 'uc8'],
			],
			'1f470' => [
				'name' => \XF::phrase('emoji.person_with_veil'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f470-1f3fb', '1f470-1f3fc', '1f470-1f3fd', '1f470-1f3fe', '1f470-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'veil', 'wedding', 'uc6'],
			],
			'1f470-1f3fb' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'light skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-1f3fc' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'medium-light skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-1f3fd' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'medium skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-1f3fe' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'medium-dark skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-1f3ff' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'dark skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f470-1f3fb-2640', '1f470-1f3fc-2640', '1f470-1f3fd-2640', '1f470-1f3fe-2640', '1f470-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone1:',
				'shortname_alternates' => [':woman_with_veil_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone2:',
				'shortname_alternates' => [':woman_with_veil_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone3:',
				'shortname_alternates' => [':woman_with_veil_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone4:',
				'shortname_alternates' => [':woman_with_veil_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone5:',
				'shortname_alternates' => [':woman_with_veil_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f470-1f3fb-2642', '1f470-1f3fc-2642', '1f470-1f3fd-2642', '1f470-1f3fe-2642', '1f470-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone1:',
				'shortname_alternates' => [':man_with_veil_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone2:',
				'shortname_alternates' => [':man_with_veil_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone3:',
				'shortname_alternates' => [':man_with_veil_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone4:',
				'shortname_alternates' => [':man_with_veil_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f470-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone5:',
				'shortname_alternates' => [':man_with_veil_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f935-1f3fb', '1f935-1f3fc', '1f935-1f3fd', '1f935-1f3fe', '1f935-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'tuxedo', 'uc9'],
			],
			'1f935-1f3fb' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone1:',
				'shortname_alternates' => [':tuxedo_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'person', 'tuxedo', 'uc9'],
			],
			'1f935-1f3fc' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone2:',
				'shortname_alternates' => [':tuxedo_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'medium-light skin tone', 'tuxedo', 'uc9'],
			],
			'1f935-1f3fd' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone3:',
				'shortname_alternates' => [':tuxedo_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'medium skin tone', 'tuxedo', 'uc9'],
			],
			'1f935-1f3fe' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone4:',
				'shortname_alternates' => [':tuxedo_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['person', 'medium-dark skin tone', 'tuxedo', 'uc9'],
			],
			'1f935-1f3ff' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone5:',
				'shortname_alternates' => [':tuxedo_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'person', 'tuxedo', 'uc9'],
			],
			'1f935-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f935-1f3fb-2640', '1f935-1f3fc-2640', '1f935-1f3fd-2640', '1f935-1f3fe-2640', '1f935-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone1:',
				'shortname_alternates' => [':woman_in_tuxedo_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone2:',
				'shortname_alternates' => [':woman_in_tuxedo_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone3:',
				'shortname_alternates' => [':woman_in_tuxedo_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone4:',
				'shortname_alternates' => [':woman_in_tuxedo_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone5:',
				'shortname_alternates' => [':woman_in_tuxedo_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f935-1f3fb-2642', '1f935-1f3fc-2642', '1f935-1f3fd-2642', '1f935-1f3fe-2642', '1f935-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone1:',
				'shortname_alternates' => [':man_in_tuxedo_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone2:',
				'shortname_alternates' => [':man_in_tuxedo_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone3:',
				'shortname_alternates' => [':man_in_tuxedo_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone4:',
				'shortname_alternates' => [':man_in_tuxedo_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f935-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone5:',
				'shortname_alternates' => [':man_in_tuxedo_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f478' => [
				'name' => \XF::phrase('emoji.princess'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f478-1f3fb', '1f478-1f3fc', '1f478-1f3fd', '1f478-1f3fe', '1f478-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fairy tale', 'fantasy', 'uc6'],
			],
			'1f478-1f3fb' => [
				'name' => \XF::phrase('emoji.princess_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fairy tale', 'fantasy', 'light skin tone', 'uc8'],
			],
			'1f478-1f3fc' => [
				'name' => \XF::phrase('emoji.princess_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fairy tale', 'fantasy', 'medium-light skin tone', 'uc8'],
			],
			'1f478-1f3fd' => [
				'name' => \XF::phrase('emoji.princess_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fairy tale', 'fantasy', 'medium skin tone', 'uc8'],
			],
			'1f478-1f3fe' => [
				'name' => \XF::phrase('emoji.princess_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fairy tale', 'fantasy', 'medium-dark skin tone', 'uc8'],
			],
			'1f478-1f3ff' => [
				'name' => \XF::phrase('emoji.princess_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'fairy tale', 'fantasy', 'uc8'],
			],
			'1f934' => [
				'name' => \XF::phrase('emoji.prince'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f934-1f3fb', '1f934-1f3fc', '1f934-1f3fd', '1f934-1f3fe', '1f934-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['prince', 'uc9'],
			],
			'1f934-1f3fb' => [
				'name' => \XF::phrase('emoji.prince_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'prince', 'uc9'],
			],
			'1f934-1f3fc' => [
				'name' => \XF::phrase('emoji.prince_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'prince', 'uc9'],
			],
			'1f934-1f3fd' => [
				'name' => \XF::phrase('emoji.prince_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'prince', 'uc9'],
			],
			'1f934-1f3fe' => [
				'name' => \XF::phrase('emoji.prince_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'prince', 'uc9'],
			],
			'1f934-1f3ff' => [
				'name' => \XF::phrase('emoji.prince_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'prince', 'uc9'],
			],
			'1f9b8' => [
				'name' => \XF::phrase('emoji.superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b8-1f3fb', '1f9b8-1f3fc', '1f9b8-1f3fd', '1f9b8-1f3fe', '1f9b8-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9b8-2640', '1f9b8-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fb' => [
				'name' => \XF::phrase('emoji.superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone1:',
				'shortname_alternates' => [':superhero_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3fb-2640', '1f9b8-1f3fb-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fc' => [
				'name' => \XF::phrase('emoji.superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone2:',
				'shortname_alternates' => [':superhero_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3fc-2640', '1f9b8-1f3fc-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fd' => [
				'name' => \XF::phrase('emoji.superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone3:',
				'shortname_alternates' => [':superhero_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3fd-2640', '1f9b8-1f3fd-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fe' => [
				'name' => \XF::phrase('emoji.superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone4:',
				'shortname_alternates' => [':superhero_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3fe-2640', '1f9b8-1f3fe-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3ff' => [
				'name' => \XF::phrase('emoji.superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone5:',
				'shortname_alternates' => [':superhero_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3ff-2640', '1f9b8-1f3ff-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b8-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b8-1f3fb-2640', '1f9b8-1f3fc-2640', '1f9b8-1f3fd-2640', '1f9b8-1f3fe-2640', '1f9b8-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone1:',
				'shortname_alternates' => [':woman_superhero_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone2:',
				'shortname_alternates' => [':woman_superhero_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone3:',
				'shortname_alternates' => [':woman_superhero_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone4:',
				'shortname_alternates' => [':woman_superhero_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone5:',
				'shortname_alternates' => [':woman_superhero_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-2642' => [
				'name' => \XF::phrase('emoji.man_superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b8-1f3fb-2642', '1f9b8-1f3fc-2642', '1f9b8-1f3fd-2642', '1f9b8-1f3fe-2642', '1f9b8-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone1:',
				'shortname_alternates' => [':man_superhero_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone2:',
				'shortname_alternates' => [':man_superhero_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone3:',
				'shortname_alternates' => [':man_superhero_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone4:',
				'shortname_alternates' => [':man_superhero_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone5:',
				'shortname_alternates' => [':man_superhero_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9' => [
				'name' => \XF::phrase('emoji.supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b9-1f3fb', '1f9b9-1f3fc', '1f9b9-1f3fd', '1f9b9-1f3fe', '1f9b9-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9b9-2640', '1f9b9-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fb' => [
				'name' => \XF::phrase('emoji.supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone1:',
				'shortname_alternates' => [':supervillain_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3fb-2640', '1f9b9-1f3fb-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fc' => [
				'name' => \XF::phrase('emoji.supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone2:',
				'shortname_alternates' => [':supervillain_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3fc-2640', '1f9b9-1f3fc-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fd' => [
				'name' => \XF::phrase('emoji.supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone3:',
				'shortname_alternates' => [':supervillain_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3fd-2640', '1f9b9-1f3fd-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fe' => [
				'name' => \XF::phrase('emoji.supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone4:',
				'shortname_alternates' => [':supervillain_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3fe-2640', '1f9b9-1f3fe-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3ff' => [
				'name' => \XF::phrase('emoji.supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone5:',
				'shortname_alternates' => [':supervillain_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3ff-2640', '1f9b9-1f3ff-2642'],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone1:',
				'shortname_alternates' => [':woman_supervillain_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b9-1f3fb-2640', '1f9b9-1f3fc-2640', '1f9b9-1f3fd-2640', '1f9b9-1f3fe-2640', '1f9b9-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone2:',
				'shortname_alternates' => [':woman_supervillain_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone3:',
				'shortname_alternates' => [':woman_supervillain_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone4:',
				'shortname_alternates' => [':woman_supervillain_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone5:',
				'shortname_alternates' => [':woman_supervillain_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b9-1f3fb-2642', '1f9b9-1f3fc-2642', '1f9b9-1f3fd-2642', '1f9b9-1f3fe-2642', '1f9b9-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone1:',
				'shortname_alternates' => [':man_supervillain_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone2:',
				'shortname_alternates' => [':man_supervillain_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone3:',
				'shortname_alternates' => [':man_supervillain_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone4:',
				'shortname_alternates' => [':man_supervillain_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone5:',
				'shortname_alternates' => [':man_supervillain_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f977' => [
				'name' => \XF::phrase('emoji.ninja'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f977-1f3fb', '1f977-1f3fc', '1f977-1f3fd', '1f977-1f3fe', '1f977-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f977-1f3fb' => [
				'name' => \XF::phrase('emoji.ninja_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone1:',
				'shortname_alternates' => [':ninja_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f977-1f3fc' => [
				'name' => \XF::phrase('emoji.ninja_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone2:',
				'shortname_alternates' => [':ninja_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f977-1f3fd' => [
				'name' => \XF::phrase('emoji.ninja_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone3:',
				'shortname_alternates' => [':ninja_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f977-1f3fe' => [
				'name' => \XF::phrase('emoji.ninja_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone4:',
				'shortname_alternates' => [':ninja_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f977-1f3ff' => [
				'name' => \XF::phrase('emoji.ninja_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone5:',
				'shortname_alternates' => [':ninja_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f384', '1f9d1-1f3fc-1f384', '1f9d1-1f3fd-1f384', '1f9d1-1f3fe-1f384', '1f9d1-1f3ff-1f384'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fb-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone1:',
				'shortname_alternates' => [':mx_claus_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fc-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone2:',
				'shortname_alternates' => [':mx_claus_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fd-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone3:',
				'shortname_alternates' => [':mx_claus_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fe-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone4:',
				'shortname_alternates' => [':mx_claus_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3ff-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone5:',
				'shortname_alternates' => [':mx_claus_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f936' => [
				'name' => \XF::phrase('emoji.mrs_claus'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus:',
				'shortname_alternates' => [':mother_christmas:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f936-1f3fb', '1f936-1f3fc', '1f936-1f3fd', '1f936-1f3fe', '1f936-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'mother', 'uc9'],
			],
			'1f936-1f3fb' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone1:',
				'shortname_alternates' => [':mother_christmas_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'light skin tone', 'mother', 'uc9'],
			],
			'1f936-1f3fc' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone2:',
				'shortname_alternates' => [':mother_christmas_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium-light skin tone', 'mother', 'uc9'],
			],
			'1f936-1f3fd' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone3:',
				'shortname_alternates' => [':mother_christmas_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium skin tone', 'mother', 'uc9'],
			],
			'1f936-1f3fe' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone4:',
				'shortname_alternates' => [':mother_christmas_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium-dark skin tone', 'mother', 'uc9'],
			],
			'1f936-1f3ff' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone5:',
				'shortname_alternates' => [':mother_christmas_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'dark skin tone', 'mother', 'uc9'],
			],
			'1f385' => [
				'name' => \XF::phrase('emoji.santa'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f385-1f3fb', '1f385-1f3fc', '1f385-1f3fd', '1f385-1f3fe', '1f385-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'santa', 'uc6'],
			],
			'1f385-1f3fb' => [
				'name' => \XF::phrase('emoji.santa_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'light skin tone', 'santa', 'uc8'],
			],
			'1f385-1f3fc' => [
				'name' => \XF::phrase('emoji.santa_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium-light skin tone', 'santa', 'uc8'],
			],
			'1f385-1f3fd' => [
				'name' => \XF::phrase('emoji.santa_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium skin tone', 'santa', 'uc8'],
			],
			'1f385-1f3fe' => [
				'name' => \XF::phrase('emoji.santa_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium-dark skin tone', 'santa', 'uc8'],
			],
			'1f385-1f3ff' => [
				'name' => \XF::phrase('emoji.santa_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'celebration', 'claus', 'dark skin tone', 'father', 'santa', 'uc8'],
			],
			'1f9d9' => [
				'name' => \XF::phrase('emoji.mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d9-1f3fb', '1f9d9-1f3fc', '1f9d9-1f3fd', '1f9d9-1f3fe', '1f9d9-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9d9-2640', '1f9d9-2642'],
				'keywords' => ['sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fb' => [
				'name' => \XF::phrase('emoji.mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone1:',
				'shortname_alternates' => [':mage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3fb-2640', '1f9d9-1f3fb-2642'],
				'keywords' => ['light skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fc' => [
				'name' => \XF::phrase('emoji.mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone2:',
				'shortname_alternates' => [':mage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3fc-2640', '1f9d9-1f3fc-2642'],
				'keywords' => ['medium-light skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fd' => [
				'name' => \XF::phrase('emoji.mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone3:',
				'shortname_alternates' => [':mage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3fd-2640', '1f9d9-1f3fd-2642'],
				'keywords' => ['medium skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fe' => [
				'name' => \XF::phrase('emoji.mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone4:',
				'shortname_alternates' => [':mage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3fe-2640', '1f9d9-1f3fe-2642'],
				'keywords' => ['medium-dark skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3ff' => [
				'name' => \XF::phrase('emoji.mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone5:',
				'shortname_alternates' => [':mage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3ff-2640', '1f9d9-1f3ff-2642'],
				'keywords' => ['dark skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-2640' => [
				'name' => \XF::phrase('emoji.woman_mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d9-1f3fb-2640', '1f9d9-1f3fc-2640', '1f9d9-1f3fd-2640', '1f9d9-1f3fe-2640', '1f9d9-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone1:',
				'shortname_alternates' => [':woman_mage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone2:',
				'shortname_alternates' => [':woman_mage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone3:',
				'shortname_alternates' => [':woman_mage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone4:',
				'shortname_alternates' => [':woman_mage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone5:',
				'shortname_alternates' => [':woman_mage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-2642' => [
				'name' => \XF::phrase('emoji.man_mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d9-1f3fb-2642', '1f9d9-1f3fc-2642', '1f9d9-1f3fd-2642', '1f9d9-1f3fe-2642', '1f9d9-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone1:',
				'shortname_alternates' => [':man_mage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone2:',
				'shortname_alternates' => [':man_mage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone3:',
				'shortname_alternates' => [':man_mage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone4:',
				'shortname_alternates' => [':man_mage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone5:',
				'shortname_alternates' => [':man_mage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9dd' => [
				'name' => \XF::phrase('emoji.elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dd-1f3fb', '1f9dd-1f3fc', '1f9dd-1f3fd', '1f9dd-1f3fe', '1f9dd-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9dd-2640', '1f9dd-2642'],
				'keywords' => ['uc10'],
			],
			'1f9dd-1f3fb' => [
				'name' => \XF::phrase('emoji.elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone1:',
				'shortname_alternates' => [':elf_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3fb-2640', '1f9dd-1f3fb-2642'],
				'keywords' => ['light skin tone', 'magical', 'uc10'],
			],
			'1f9dd-1f3fc' => [
				'name' => \XF::phrase('emoji.elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone2:',
				'shortname_alternates' => [':elf_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3fc-2640', '1f9dd-1f3fc-2642'],
				'keywords' => ['magical', 'medium-light skin tone', 'uc10'],
			],
			'1f9dd-1f3fd' => [
				'name' => \XF::phrase('emoji.elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone3:',
				'shortname_alternates' => [':elf_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3fd-2640', '1f9dd-1f3fd-2642'],
				'keywords' => ['magical', 'medium skin tone', 'uc10'],
			],
			'1f9dd-1f3fe' => [
				'name' => \XF::phrase('emoji.elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone4:',
				'shortname_alternates' => [':elf_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3fe-2640', '1f9dd-1f3fe-2642'],
				'keywords' => ['magical', 'medium-dark skin tone', 'uc10'],
			],
			'1f9dd-1f3ff' => [
				'name' => \XF::phrase('emoji.elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone5:',
				'shortname_alternates' => [':elf_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3ff-2640', '1f9dd-1f3ff-2642'],
				'keywords' => ['dark skin tone', 'magical', 'uc10'],
			],
			'1f9dd-2640' => [
				'name' => \XF::phrase('emoji.woman_elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dd-1f3fb-2640', '1f9dd-1f3fc-2640', '1f9dd-1f3fd-2640', '1f9dd-1f3fe-2640', '1f9dd-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['magical', 'uc10'],
			],
			'1f9dd-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone1:',
				'shortname_alternates' => [':woman_elf_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'magical', 'uc10'],
			],
			'1f9dd-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone2:',
				'shortname_alternates' => [':woman_elf_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['magical', 'medium-light skin tone', 'uc10'],
			],
			'1f9dd-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone3:',
				'shortname_alternates' => [':woman_elf_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['magical', 'medium skin tone', 'uc10'],
			],
			'1f9dd-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone4:',
				'shortname_alternates' => [':woman_elf_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['magical', 'medium-dark skin tone', 'uc10'],
			],
			'1f9dd-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone5:',
				'shortname_alternates' => [':woman_elf_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'magical', 'uc10'],
			],
			'1f9dd-2642' => [
				'name' => \XF::phrase('emoji.man_elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dd-1f3fb-2642', '1f9dd-1f3fc-2642', '1f9dd-1f3fd-2642', '1f9dd-1f3fe-2642', '1f9dd-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['magical', 'uc10'],
			],
			'1f9dd-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone1:',
				'shortname_alternates' => [':man_elf_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'magical', 'uc10'],
			],
			'1f9dd-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone2:',
				'shortname_alternates' => [':man_elf_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['magical', 'medium-light skin tone', 'uc10'],
			],
			'1f9dd-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone3:',
				'shortname_alternates' => [':man_elf_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['magical', 'medium skin tone', 'uc10'],
			],
			'1f9dd-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone4:',
				'shortname_alternates' => [':man_elf_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['magical', 'medium-dark skin tone', 'uc10'],
			],
			'1f9dd-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone5:',
				'shortname_alternates' => [':man_elf_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'magical', 'uc10'],
			],
			'1f9db' => [
				'name' => \XF::phrase('emoji.vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9db-1f3fb', '1f9db-1f3fc', '1f9db-1f3fd', '1f9db-1f3fe', '1f9db-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9db-2640', '1f9db-2642'],
				'keywords' => ['Dracula', 'undead', 'uc10'],
			],
			'1f9db-1f3fb' => [
				'name' => \XF::phrase('emoji.vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone1:',
				'shortname_alternates' => [':vampire_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3fb-2640', '1f9db-1f3fb-2642'],
				'keywords' => ['Dracula', 'light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fc' => [
				'name' => \XF::phrase('emoji.vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone2:',
				'shortname_alternates' => [':vampire_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3fc-2640', '1f9db-1f3fc-2642'],
				'keywords' => ['Dracula', 'medium-light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fd' => [
				'name' => \XF::phrase('emoji.vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone3:',
				'shortname_alternates' => [':vampire_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3fd-2640', '1f9db-1f3fd-2642'],
				'keywords' => ['Dracula', 'medium skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fe' => [
				'name' => \XF::phrase('emoji.vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone4:',
				'shortname_alternates' => [':vampire_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3fe-2640', '1f9db-1f3fe-2642'],
				'keywords' => ['Dracula', 'medium-dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3ff' => [
				'name' => \XF::phrase('emoji.vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone5:',
				'shortname_alternates' => [':vampire_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3ff-2640', '1f9db-1f3ff-2642'],
				'keywords' => ['Dracula', 'dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9db-1f3fb-2640', '1f9db-1f3fc-2640', '1f9db-1f3fd-2640', '1f9db-1f3fe-2640', '1f9db-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['undead', 'uc10'],
			],
			'1f9db-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone1:',
				'shortname_alternates' => [':woman_vampire_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone2:',
				'shortname_alternates' => [':woman_vampire_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone3:',
				'shortname_alternates' => [':woman_vampire_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone4:',
				'shortname_alternates' => [':woman_vampire_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone5:',
				'shortname_alternates' => [':woman_vampire_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-2642' => [
				'name' => \XF::phrase('emoji.man_vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9db-1f3fb-2642', '1f9db-1f3fc-2642', '1f9db-1f3fd-2642', '1f9db-1f3fe-2642', '1f9db-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Dracula', 'undead', 'uc10'],
			],
			'1f9db-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone1:',
				'shortname_alternates' => [':man_vampire_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Dracula', 'light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone2:',
				'shortname_alternates' => [':man_vampire_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Dracula', 'medium-light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone3:',
				'shortname_alternates' => [':man_vampire_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Dracula', 'medium skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone4:',
				'shortname_alternates' => [':man_vampire_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Dracula', 'medium-dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone5:',
				'shortname_alternates' => [':man_vampire_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Dracula', 'dark skin tone', 'undead', 'uc10'],
			],
			'1f9df' => [
				'name' => \XF::phrase('emoji.zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zombie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9df-2640', '1f9df-2642'],
				'keywords' => ['uc10'],
			],
			'1f9df-2640' => [
				'name' => \XF::phrase('emoji.woman_zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_zombie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['undead', 'walking dead', 'uc10'],
			],
			'1f9df-2642' => [
				'name' => \XF::phrase('emoji.man_zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_zombie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['undead', 'walking dead', 'uc10'],
			],
			'1f9de' => [
				'name' => \XF::phrase('emoji.genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':genie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9de-2640', '1f9de-2642'],
				'keywords' => ['uc10'],
			],
			'1f9de-2640' => [
				'name' => \XF::phrase('emoji.woman_genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_genie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['djinn', 'uc10'],
			],
			'1f9de-2642' => [
				'name' => \XF::phrase('emoji.man_genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_genie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['djinn', 'uc10'],
			],
			'1f9dc' => [
				'name' => \XF::phrase('emoji.merperson'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dc-1f3fb', '1f9dc-1f3fc', '1f9dc-1f3fd', '1f9dc-1f3fe', '1f9dc-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9dc-2640', '1f9dc-2642'],
				'keywords' => ['mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fb' => [
				'name' => \XF::phrase('emoji.merperson_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone1:',
				'shortname_alternates' => [':merperson_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3fb-2640', '1f9dc-1f3fb-2642'],
				'keywords' => ['light skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fc' => [
				'name' => \XF::phrase('emoji.merperson_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone2:',
				'shortname_alternates' => [':merperson_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3fc-2640', '1f9dc-1f3fc-2642'],
				'keywords' => ['medium-light skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fd' => [
				'name' => \XF::phrase('emoji.merperson_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone3:',
				'shortname_alternates' => [':merperson_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3fd-2640', '1f9dc-1f3fd-2642'],
				'keywords' => ['medium skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fe' => [
				'name' => \XF::phrase('emoji.merperson_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone4:',
				'shortname_alternates' => [':merperson_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3fe-2640', '1f9dc-1f3fe-2642'],
				'keywords' => ['medium-dark skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3ff' => [
				'name' => \XF::phrase('emoji.merperson_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone5:',
				'shortname_alternates' => [':merperson_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3ff-2640', '1f9dc-1f3ff-2642'],
				'keywords' => ['dark skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-2640' => [
				'name' => \XF::phrase('emoji.mermaid'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dc-1f3fb-2640', '1f9dc-1f3fc-2640', '1f9dc-1f3fd-2640', '1f9dc-1f3fe-2640', '1f9dc-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['merwoman', 'uc10'],
			],
			'1f9dc-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone1:',
				'shortname_alternates' => [':mermaid_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone2:',
				'shortname_alternates' => [':mermaid_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone3:',
				'shortname_alternates' => [':mermaid_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone4:',
				'shortname_alternates' => [':mermaid_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone5:',
				'shortname_alternates' => [':mermaid_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-2642' => [
				'name' => \XF::phrase('emoji.merman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dc-1f3fb-2642', '1f9dc-1f3fc-2642', '1f9dc-1f3fd-2642', '1f9dc-1f3fe-2642', '1f9dc-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Triton', 'uc10'],
			],
			'1f9dc-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.merman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone1:',
				'shortname_alternates' => [':merman_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Triton', 'light skin tone', 'uc10'],
			],
			'1f9dc-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.merman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone2:',
				'shortname_alternates' => [':merman_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Triton', 'medium-light skin tone', 'uc10'],
			],
			'1f9dc-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.merman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone3:',
				'shortname_alternates' => [':merman_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Triton', 'medium skin tone', 'uc10'],
			],
			'1f9dc-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.merman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone4:',
				'shortname_alternates' => [':merman_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Triton', 'medium-dark skin tone', 'uc10'],
			],
			'1f9dc-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.merman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone5:',
				'shortname_alternates' => [':merman_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Triton', 'dark skin tone', 'uc10'],
			],
			'1f9da' => [
				'name' => \XF::phrase('emoji.fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9da-1f3fb', '1f9da-1f3fc', '1f9da-1f3fd', '1f9da-1f3fe', '1f9da-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9da-2640', '1f9da-2642'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'uc10'],
			],
			'1f9da-1f3fb' => [
				'name' => \XF::phrase('emoji.fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone1:',
				'shortname_alternates' => [':fairy_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3fb-2640', '1f9da-1f3fb-2642'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'light skin tone', 'uc10'],
			],
			'1f9da-1f3fc' => [
				'name' => \XF::phrase('emoji.fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone2:',
				'shortname_alternates' => [':fairy_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3fc-2640', '1f9da-1f3fc-2642'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium-light skin tone', 'uc10'],
			],
			'1f9da-1f3fd' => [
				'name' => \XF::phrase('emoji.fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone3:',
				'shortname_alternates' => [':fairy_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3fd-2640', '1f9da-1f3fd-2642'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium skin tone', 'uc10'],
			],
			'1f9da-1f3fe' => [
				'name' => \XF::phrase('emoji.fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone4:',
				'shortname_alternates' => [':fairy_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3fe-2640', '1f9da-1f3fe-2642'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium-dark skin tone', 'uc10'],
			],
			'1f9da-1f3ff' => [
				'name' => \XF::phrase('emoji.fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone5:',
				'shortname_alternates' => [':fairy_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3ff-2640', '1f9da-1f3ff-2642'],
				'keywords' => ['Oberon', 'Puck', 'Titania', 'dark skin tone', 'uc10'],
			],
			'1f9da-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9da-1f3fb-2640', '1f9da-1f3fc-2640', '1f9da-1f3fd-2640', '1f9da-1f3fe-2640', '1f9da-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['Titania', 'uc10'],
			],
			'1f9da-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone1:',
				'shortname_alternates' => [':woman_fairy_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['Titania', 'light skin tone', 'uc10'],
			],
			'1f9da-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone2:',
				'shortname_alternates' => [':woman_fairy_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['Titania', 'medium-light skin tone', 'uc10'],
			],
			'1f9da-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone3:',
				'shortname_alternates' => [':woman_fairy_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['Titania', 'medium skin tone', 'uc10'],
			],
			'1f9da-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone4:',
				'shortname_alternates' => [':woman_fairy_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['Titania', 'medium-dark skin tone', 'uc10'],
			],
			'1f9da-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone5:',
				'shortname_alternates' => [':woman_fairy_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['Titania', 'dark skin tone', 'uc10'],
			],
			'1f9da-2642' => [
				'name' => \XF::phrase('emoji.man_fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9da-1f3fb-2642', '1f9da-1f3fc-2642', '1f9da-1f3fd-2642', '1f9da-1f3fe-2642', '1f9da-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Oberon', 'Puck', 'uc10'],
			],
			'1f9da-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone1:',
				'shortname_alternates' => [':man_fairy_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Oberon', 'Puck', 'light skin tone', 'uc10'],
			],
			'1f9da-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone2:',
				'shortname_alternates' => [':man_fairy_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Oberon', 'Puck', 'medium-light skin tone', 'uc10'],
			],
			'1f9da-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone3:',
				'shortname_alternates' => [':man_fairy_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Oberon', 'Puck', 'medium skin tone', 'uc10'],
			],
			'1f9da-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone4:',
				'shortname_alternates' => [':man_fairy_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Oberon', 'Puck', 'medium-dark skin tone', 'uc10'],
			],
			'1f9da-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone5:',
				'shortname_alternates' => [':man_fairy_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Oberon', 'Puck', 'dark skin tone', 'uc10'],
			],
			'1f47c' => [
				'name' => \XF::phrase('emoji.angel'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f47c-1f3fb', '1f47c-1f3fc', '1f47c-1f3fd', '1f47c-1f3fe', '1f47c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'uc6'],
			],
			'1f47c-1f3fb' => [
				'name' => \XF::phrase('emoji.angel_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'light skin tone', 'uc8'],
			],
			'1f47c-1f3fc' => [
				'name' => \XF::phrase('emoji.angel_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium-light skin tone', 'uc8'],
			],
			'1f47c-1f3fd' => [
				'name' => \XF::phrase('emoji.angel_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium skin tone', 'uc8'],
			],
			'1f47c-1f3fe' => [
				'name' => \XF::phrase('emoji.angel_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium-dark skin tone', 'uc8'],
			],
			'1f47c-1f3ff' => [
				'name' => \XF::phrase('emoji.angel_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['angel', 'baby', 'dark skin tone', 'face', 'fairy tale', 'fantasy', 'uc8'],
			],
			'1f930' => [
				'name' => \XF::phrase('emoji.pregnant_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman:',
				'shortname_alternates' => [':expecting_woman:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f930-1f3fb', '1f930-1f3fc', '1f930-1f3fd', '1f930-1f3fe', '1f930-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3fb' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone1:',
				'shortname_alternates' => [':expecting_woman_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3fc' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone2:',
				'shortname_alternates' => [':expecting_woman_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3fd' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone3:',
				'shortname_alternates' => [':expecting_woman_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3fe' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone4:',
				'shortname_alternates' => [':expecting_woman_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3ff' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone5:',
				'shortname_alternates' => [':expecting_woman_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f931' => [
				'name' => \XF::phrase('emoji.breast_feeding'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f931-1f3fb', '1f931-1f3fc', '1f931-1f3fd', '1f931-1f3fe', '1f931-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'breast', 'nursing', 'uc10'],
			],
			'1f931-1f3fb' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone1:',
				'shortname_alternates' => [':breast_feeding_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'breast', 'light skin tone', 'nursing', 'uc10'],
			],
			'1f931-1f3fc' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone2:',
				'shortname_alternates' => [':breast_feeding_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'breast', 'medium-light skin tone', 'nursing', 'uc10'],
			],
			'1f931-1f3fd' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone3:',
				'shortname_alternates' => [':breast_feeding_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'breast', 'medium skin tone', 'nursing', 'uc10'],
			],
			'1f931-1f3fe' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone4:',
				'shortname_alternates' => [':breast_feeding_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'breast', 'medium-dark skin tone', 'nursing', 'uc10'],
			],
			'1f931-1f3ff' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone5:',
				'shortname_alternates' => [':breast_feeding_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'breast', 'dark skin tone', 'nursing', 'uc10'],
			],
			'1f9d1-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f37c', '1f9d1-1f3fc-1f37c', '1f9d1-1f3fd-1f37c', '1f9d1-1f3fe-1f37c', '1f9d1-1f3ff-1f37c'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fb-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone1:',
				'shortname_alternates' => [':person_feeding_baby_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fc-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone2:',
				'shortname_alternates' => [':person_feeding_baby_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fd-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone3:',
				'shortname_alternates' => [':person_feeding_baby_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fe-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone4:',
				'shortname_alternates' => [':person_feeding_baby_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3ff-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone5:',
				'shortname_alternates' => [':person_feeding_baby_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f469-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f37c', '1f469-1f3fc-1f37c', '1f469-1f3fd-1f37c', '1f469-1f3fe-1f37c', '1f469-1f3ff-1f37c'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone1:',
				'shortname_alternates' => [':woman_feeding_baby_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone2:',
				'shortname_alternates' => [':woman_feeding_baby_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone3:',
				'shortname_alternates' => [':woman_feeding_baby_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f469-1f3fe-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone4:',
				'shortname_alternates' => [':woman_feeding_baby_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f469-1f3ff-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone5:',
				'shortname_alternates' => [':woman_feeding_baby_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f468-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f37c', '1f468-1f3fc-1f37c', '1f468-1f3fd-1f37c', '1f468-1f3fe-1f37c', '1f468-1f3ff-1f37c'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f468-1f3fb-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone1:',
				'shortname_alternates' => [':man_feeding_baby_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f468-1f3fc-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone2:',
				'shortname_alternates' => [':man_feeding_baby_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f468-1f3fd-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone3:',
				'shortname_alternates' => [':man_feeding_baby_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f468-1f3fe-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone4:',
				'shortname_alternates' => [':man_feeding_baby_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f468-1f3ff-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone5:',
				'shortname_alternates' => [':man_feeding_baby_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f647' => [
				'name' => \XF::phrase('emoji.person_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing:',
				'shortname_alternates' => [':bow:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f647-1f3fb', '1f647-1f3fc', '1f647-1f3fd', '1f647-1f3fe', '1f647-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f647-2642', '1f647-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'sorry', 'uc6'],
			],
			'1f647-1f3fb' => [
				'name' => \XF::phrase('emoji.person_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone1:',
				'shortname_alternates' => [':bow_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3fb-2642', '1f647-1f3fb-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'light skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fc' => [
				'name' => \XF::phrase('emoji.person_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone2:',
				'shortname_alternates' => [':bow_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3fc-2642', '1f647-1f3fc-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'medium-light skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fd' => [
				'name' => \XF::phrase('emoji.person_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone3:',
				'shortname_alternates' => [':bow_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3fd-2642', '1f647-1f3fd-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'medium skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fe' => [
				'name' => \XF::phrase('emoji.person_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone4:',
				'shortname_alternates' => [':bow_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3fe-2642', '1f647-1f3fe-2640'],
				'keywords' => ['apology', 'bow', 'gesture', 'medium-dark skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3ff' => [
				'name' => \XF::phrase('emoji.person_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone5:',
				'shortname_alternates' => [':bow_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3ff-2642', '1f647-1f3ff-2640'],
				'keywords' => ['apology', 'bow', 'dark skin tone', 'gesture', 'sorry', 'uc8'],
			],
			'1f647-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f647-1f3ff-2640', '1f647-1f3fe-2640', '1f647-1f3fd-2640', '1f647-1f3fc-2640', '1f647-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'sorry', 'woman', 'uc6'],
			],
			'1f647-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone1:',
				'shortname_alternates' => [':woman_bowing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'light skin tone', 'sorry', 'woman', 'uc8'],
			],
			'1f647-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone2:',
				'shortname_alternates' => [':woman_bowing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium-light skin tone', 'sorry', 'woman', 'uc8'],
			],
			'1f647-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone3:',
				'shortname_alternates' => [':woman_bowing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium skin tone', 'sorry', 'woman', 'uc8'],
			],
			'1f647-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone4:',
				'shortname_alternates' => [':woman_bowing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium-dark skin tone', 'sorry', 'woman', 'uc8'],
			],
			'1f647-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone5:',
				'shortname_alternates' => [':woman_bowing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'dark skin tone', 'favor', 'gesture', 'sorry', 'woman', 'uc8'],
			],
			'1f647-2642' => [
				'name' => \XF::phrase('emoji.man_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f647-1f3ff-2642', '1f647-1f3fe-2642', '1f647-1f3fd-2642', '1f647-1f3fc-2642', '1f647-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'sorry', 'uc6'],
			],
			'1f647-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone1:',
				'shortname_alternates' => [':man_bowing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'light skin tone', 'man', 'sorry', 'uc8'],
			],
			'1f647-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone2:',
				'shortname_alternates' => [':man_bowing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium-light skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone3:',
				'shortname_alternates' => [':man_bowing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone4:',
				'shortname_alternates' => [':man_bowing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium-dark skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone5:',
				'shortname_alternates' => [':man_bowing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['apology', 'bowing', 'dark skin tone', 'favor', 'gesture', 'man', 'sorry', 'uc8'],
			],
			'1f481' => [
				'name' => \XF::phrase('emoji.person_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand:',
				'shortname_alternates' => [':information_desk_person:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f481-1f3fb', '1f481-1f3fc', '1f481-1f3fd', '1f481-1f3fe', '1f481-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f481-2642', '1f481-2640'],
				'keywords' => ['hand', 'help', 'information', 'sassy', 'tipping', 'uc6'],
			],
			'1f481-1f3fb' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone1:',
				'shortname_alternates' => [':information_desk_person_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3fb-2642', '1f481-1f3fb-2640'],
				'keywords' => ['hand', 'help', 'information', 'light skin tone', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-1f3fc' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone2:',
				'shortname_alternates' => [':information_desk_person_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3fc-2642', '1f481-1f3fc-2640'],
				'keywords' => ['hand', 'help', 'information', 'medium-light skin tone', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-1f3fd' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone3:',
				'shortname_alternates' => [':information_desk_person_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3fd-2642', '1f481-1f3fd-2640'],
				'keywords' => ['hand', 'help', 'information', 'medium skin tone', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-1f3fe' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone4:',
				'shortname_alternates' => [':information_desk_person_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3fe-2642', '1f481-1f3fe-2640'],
				'keywords' => ['hand', 'help', 'information', 'medium-dark skin tone', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-1f3ff' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone5:',
				'shortname_alternates' => [':information_desk_person_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3ff-2642', '1f481-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'hand', 'help', 'information', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f481-1f3ff-2640', '1f481-1f3fe-2640', '1f481-1f3fd-2640', '1f481-1f3fc-2640', '1f481-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['sassy', 'tipping hand', 'woman', 'uc6'],
			],
			'1f481-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone1:',
				'shortname_alternates' => [':woman_tipping_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone2:',
				'shortname_alternates' => [':woman_tipping_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone3:',
				'shortname_alternates' => [':woman_tipping_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone4:',
				'shortname_alternates' => [':woman_tipping_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone5:',
				'shortname_alternates' => [':woman_tipping_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f481-1f3ff-2642', '1f481-1f3fe-2642', '1f481-1f3fd-2642', '1f481-1f3fc-2642', '1f481-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'sassy', 'tipping hand', 'uc6'],
			],
			'1f481-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone1:',
				'shortname_alternates' => [':man_tipping_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'man', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f481-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone2:',
				'shortname_alternates' => [':man_tipping_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium-light skin tone', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f481-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone3:',
				'shortname_alternates' => [':man_tipping_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium skin tone', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f481-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone4:',
				'shortname_alternates' => [':man_tipping_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'medium-dark skin tone', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f481-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone5:',
				'shortname_alternates' => [':man_tipping_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'man', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f645' => [
				'name' => \XF::phrase('emoji.person_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no:',
				'shortname_alternates' => [':no_good:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f645-1f3fb', '1f645-1f3fc', '1f645-1f3fd', '1f645-1f3fe', '1f645-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f645-2642', '1f645-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'no', 'not', 'prohibited', 'uc6'],
			],
			'1f645-1f3fb' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone1:',
				'shortname_alternates' => [':no_good_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3fb-2642', '1f645-1f3fb-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-1f3fc' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone2:',
				'shortname_alternates' => [':no_good_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3fc-2642', '1f645-1f3fc-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-light skin tone', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-1f3fd' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone3:',
				'shortname_alternates' => [':no_good_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3fd-2642', '1f645-1f3fd-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium skin tone', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-1f3fe' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone4:',
				'shortname_alternates' => [':no_good_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3fe-2642', '1f645-1f3fe-2640'],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-dark skin tone', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-1f3ff' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone5:',
				'shortname_alternates' => [':no_good_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3ff-2642', '1f645-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f645-1f3ff-2640', '1f645-1f3fe-2640', '1f645-1f3fd-2640', '1f645-1f3fc-2640', '1f645-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'no', 'prohibited', 'woman', 'uc6'],
			],
			'1f645-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone1:',
				'shortname_alternates' => [':woman_gesturing_no_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone2:',
				'shortname_alternates' => [':woman_gesturing_no_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-light skin tone', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone3:',
				'shortname_alternates' => [':woman_gesturing_no_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium skin tone', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone4:',
				'shortname_alternates' => [':woman_gesturing_no_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-dark skin tone', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone5:',
				'shortname_alternates' => [':woman_gesturing_no_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f645-1f3ff-2642', '1f645-1f3fe-2642', '1f645-1f3fd-2642', '1f645-1f3fc-2642', '1f645-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'no', 'prohibited', 'uc6'],
			],
			'1f645-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone1:',
				'shortname_alternates' => [':man_gesturing_no_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'man', 'no', 'prohibited', 'uc8'],
			],
			'1f645-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone2:',
				'shortname_alternates' => [':man_gesturing_no_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium-light skin tone', 'no', 'prohibited', 'uc8'],
			],
			'1f645-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone3:',
				'shortname_alternates' => [':man_gesturing_no_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium skin tone', 'no', 'prohibited', 'uc8'],
			],
			'1f645-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone4:',
				'shortname_alternates' => [':man_gesturing_no_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium-dark skin tone', 'no', 'prohibited', 'uc8'],
			],
			'1f645-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone5:',
				'shortname_alternates' => [':man_gesturing_no_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'man', 'no', 'prohibited', 'uc8'],
			],
			'1f646' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok:',
				'shortname_alternates' => [':ok_woman:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f646-1f3fb', '1f646-1f3fc', '1f646-1f3fd', '1f646-1f3fe', '1f646-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f646-2642', '1f646-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'uc6'],
			],
			'1f646-1f3fb' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone1:',
				'shortname_alternates' => [':ok_woman_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3fb-2642', '1f646-1f3fb-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone', 'uc8'],
			],
			'1f646-1f3fc' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone2:',
				'shortname_alternates' => [':ok_woman_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3fc-2642', '1f646-1f3fc-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'medium-light skin tone', 'uc8'],
			],
			'1f646-1f3fd' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone3:',
				'shortname_alternates' => [':ok_woman_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3fd-2642', '1f646-1f3fd-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'medium skin tone', 'uc8'],
			],
			'1f646-1f3fe' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone4:',
				'shortname_alternates' => [':ok_woman_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3fe-2642', '1f646-1f3fe-2640'],
				'keywords' => ['OK', 'gesture', 'hand', 'medium-dark skin tone', 'uc8'],
			],
			'1f646-1f3ff' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone5:',
				'shortname_alternates' => [':ok_woman_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3ff-2642', '1f646-1f3ff-2640'],
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand', 'uc8'],
			],
			'1f646-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f646-1f3ff-2640', '1f646-1f3fe-2640', '1f646-1f3fd-2640', '1f646-1f3fc-2640', '1f646-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'woman', 'uc6'],
			],
			'1f646-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone1:',
				'shortname_alternates' => [':woman_gesturing_ok_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone', 'woman', 'uc8'],
			],
			'1f646-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone2:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f646-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone3:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f646-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone4:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f646-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone5:',
				'shortname_alternates' => [':woman_gesturing_ok_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand', 'woman', 'uc8'],
			],
			'1f646-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f646-1f3ff-2642', '1f646-1f3fe-2642', '1f646-1f3fd-2642', '1f646-1f3fc-2642', '1f646-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'uc6'],
			],
			'1f646-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone1:',
				'shortname_alternates' => [':man_gesturing_ok_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone', 'man', 'uc8'],
			],
			'1f646-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone2:',
				'shortname_alternates' => [':man_gesturing_ok_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f646-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone3:',
				'shortname_alternates' => [':man_gesturing_ok_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium skin tone', 'uc8'],
			],
			'1f646-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone4:',
				'shortname_alternates' => [':man_gesturing_ok_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f646-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone5:',
				'shortname_alternates' => [':man_gesturing_ok_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand', 'man', 'uc8'],
			],
			'1f64b' => [
				'name' => \XF::phrase('emoji.person_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand:',
				'shortname_alternates' => [':raising_hand:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64b-1f3fb', '1f64b-1f3fc', '1f64b-1f3fd', '1f64b-1f3fe', '1f64b-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f64b-2642', '1f64b-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'raised', 'uc6'],
			],
			'1f64b-1f3fb' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone1:',
				'shortname_alternates' => [':raising_hand_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3fb-2642', '1f64b-1f3fb-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'light skin tone', 'raised', 'uc8'],
			],
			'1f64b-1f3fc' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone2:',
				'shortname_alternates' => [':raising_hand_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3fc-2642', '1f64b-1f3fc-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'medium-light skin tone', 'raised', 'uc8'],
			],
			'1f64b-1f3fd' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone3:',
				'shortname_alternates' => [':raising_hand_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3fd-2642', '1f64b-1f3fd-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'medium skin tone', 'raised', 'uc8'],
			],
			'1f64b-1f3fe' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone4:',
				'shortname_alternates' => [':raising_hand_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3fe-2642', '1f64b-1f3fe-2640'],
				'keywords' => ['gesture', 'hand', 'happy', 'medium-dark skin tone', 'raised', 'uc8'],
			],
			'1f64b-1f3ff' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone5:',
				'shortname_alternates' => [':raising_hand_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3ff-2642', '1f64b-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'gesture', 'hand', 'happy', 'raised', 'uc8'],
			],
			'1f64b-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64b-1f3ff-2640', '1f64b-1f3fe-2640', '1f64b-1f3fd-2640', '1f64b-1f3fc-2640', '1f64b-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'raising hand', 'woman', 'uc6'],
			],
			'1f64b-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone1:',
				'shortname_alternates' => [':woman_raising_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'light skin tone', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone2:',
				'shortname_alternates' => [':woman_raising_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'medium-light skin tone', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone3:',
				'shortname_alternates' => [':woman_raising_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'medium skin tone', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone4:',
				'shortname_alternates' => [':woman_raising_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'medium-dark skin tone', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone5:',
				'shortname_alternates' => [':woman_raising_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'gesture', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64b-1f3ff-2642', '1f64b-1f3fe-2642', '1f64b-1f3fd-2642', '1f64b-1f3fc-2642', '1f64b-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'man', 'raising hand', 'uc6'],
			],
			'1f64b-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone1:',
				'shortname_alternates' => [':man_raising_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'light skin tone', 'man', 'raising hand', 'uc8'],
			],
			'1f64b-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone2:',
				'shortname_alternates' => [':man_raising_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'man', 'medium-light skin tone', 'raising hand', 'uc8'],
			],
			'1f64b-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone3:',
				'shortname_alternates' => [':man_raising_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'man', 'medium skin tone', 'raising hand', 'uc8'],
			],
			'1f64b-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone4:',
				'shortname_alternates' => [':man_raising_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'man', 'medium-dark skin tone', 'raising hand', 'uc8'],
			],
			'1f64b-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone5:',
				'shortname_alternates' => [':man_raising_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'gesture', 'man', 'raising hand', 'uc8'],
			],
			'1f9cf' => [
				'name' => \XF::phrase('emoji.deaf_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cf-1f3fb', '1f9cf-1f3fc', '1f9cf-1f3fd', '1f9cf-1f3fe', '1f9cf-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9cf-2640', '1f9cf-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fb' => [
				'name' => \XF::phrase('emoji.deaf_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone1:',
				'shortname_alternates' => [':deaf_person_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3fb-2640', '1f9cf-1f3fb-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fc' => [
				'name' => \XF::phrase('emoji.deaf_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone2:',
				'shortname_alternates' => [':deaf_person_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3fc-2640', '1f9cf-1f3fc-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fd' => [
				'name' => \XF::phrase('emoji.deaf_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone3:',
				'shortname_alternates' => [':deaf_person_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3fd-2640', '1f9cf-1f3fd-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fe' => [
				'name' => \XF::phrase('emoji.deaf_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone4:',
				'shortname_alternates' => [':deaf_person_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3fe-2640', '1f9cf-1f3fe-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3ff' => [
				'name' => \XF::phrase('emoji.deaf_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone5:',
				'shortname_alternates' => [':deaf_person_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3ff-2640', '1f9cf-1f3ff-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cf-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cf-1f3fb-2640', '1f9cf-1f3fc-2640', '1f9cf-1f3fd-2640', '1f9cf-1f3fe-2640', '1f9cf-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone1:',
				'shortname_alternates' => [':deaf_woman_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone2:',
				'shortname_alternates' => [':deaf_woman_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone3:',
				'shortname_alternates' => [':deaf_woman_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone4:',
				'shortname_alternates' => [':deaf_woman_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone5:',
				'shortname_alternates' => [':deaf_woman_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-2642' => [
				'name' => \XF::phrase('emoji.deaf_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cf-1f3fb-2642', '1f9cf-1f3fc-2642', '1f9cf-1f3fd-2642', '1f9cf-1f3fe-2642', '1f9cf-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone1:',
				'shortname_alternates' => [':deaf_man_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone2:',
				'shortname_alternates' => [':deaf_man_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone3:',
				'shortname_alternates' => [':deaf_man_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone4:',
				'shortname_alternates' => [':deaf_man_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone5:',
				'shortname_alternates' => [':deaf_man_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f926' => [
				'name' => \XF::phrase('emoji.person_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming:',
				'shortname_alternates' => [':face_palm:', ':facepalm:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f926-1f3fb', '1f926-1f3fc', '1f926-1f3fd', '1f926-1f3fe', '1f926-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f926-2642', '1f926-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'palm', 'uc9'],
			],
			'1f926-1f3fb' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone1:',
				'shortname_alternates' => [':face_palm_tone1:', ':facepalm_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3fb-2642', '1f926-1f3fb-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'light skin tone', 'palm', 'uc9'],
			],
			'1f926-1f3fc' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone2:',
				'shortname_alternates' => [':face_palm_tone2:', ':facepalm_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3fc-2642', '1f926-1f3fc-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium-light skin tone', 'palm', 'uc9'],
			],
			'1f926-1f3fd' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone3:',
				'shortname_alternates' => [':face_palm_tone3:', ':facepalm_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3fd-2642', '1f926-1f3fd-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium skin tone', 'palm', 'uc9'],
			],
			'1f926-1f3fe' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone4:',
				'shortname_alternates' => [':face_palm_tone4:', ':facepalm_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3fe-2642', '1f926-1f3fe-2640'],
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium-dark skin tone', 'palm', 'uc9'],
			],
			'1f926-1f3ff' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone5:',
				'shortname_alternates' => [':face_palm_tone5:', ':facepalm_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3ff-2642', '1f926-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'face', 'palm', 'uc9'],
			],
			'1f926-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f926-1f3ff-2640', '1f926-1f3fe-2640', '1f926-1f3fd-2640', '1f926-1f3fc-2640', '1f926-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'woman', 'uc9'],
			],
			'1f926-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone1:',
				'shortname_alternates' => [':woman_facepalming_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'light skin tone', 'woman', 'uc9'],
			],
			'1f926-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone2:',
				'shortname_alternates' => [':woman_facepalming_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium-light skin tone', 'woman', 'uc9'],
			],
			'1f926-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone3:',
				'shortname_alternates' => [':woman_facepalming_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium skin tone', 'woman', 'uc9'],
			],
			'1f926-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone4:',
				'shortname_alternates' => [':woman_facepalming_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium-dark skin tone', 'woman', 'uc9'],
			],
			'1f926-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone5:',
				'shortname_alternates' => [':woman_facepalming_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'facepalm', 'woman', 'uc9'],
			],
			'1f926-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f926-1f3ff-2642', '1f926-1f3fe-2642', '1f926-1f3fd-2642', '1f926-1f3fc-2642', '1f926-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'uc9'],
			],
			'1f926-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone1:',
				'shortname_alternates' => [':man_facepalming_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'light skin tone', 'man', 'uc9'],
			],
			'1f926-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone2:',
				'shortname_alternates' => [':man_facepalming_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium-light skin tone', 'uc9'],
			],
			'1f926-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone3:',
				'shortname_alternates' => [':man_facepalming_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium skin tone', 'uc9'],
			],
			'1f926-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone4:',
				'shortname_alternates' => [':man_facepalming_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium-dark skin tone', 'uc9'],
			],
			'1f926-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone5:',
				'shortname_alternates' => [':man_facepalming_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'facepalm', 'man', 'uc9'],
			],
			'1f937' => [
				'name' => \XF::phrase('emoji.person_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging:',
				'shortname_alternates' => [':shrug:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f937-1f3fb', '1f937-1f3fc', '1f937-1f3fd', '1f937-1f3fe', '1f937-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f937-2642', '1f937-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'shrug', 'uc9'],
			],
			'1f937-1f3fb' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone1:',
				'shortname_alternates' => [':shrug_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3fb-2642', '1f937-1f3fb-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fc' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone2:',
				'shortname_alternates' => [':shrug_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3fc-2642', '1f937-1f3fc-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-light skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fd' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone3:',
				'shortname_alternates' => [':shrug_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3fd-2642', '1f937-1f3fd-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fe' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone4:',
				'shortname_alternates' => [':shrug_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3fe-2642', '1f937-1f3fe-2640'],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-dark skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3ff' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone5:',
				'shortname_alternates' => [':shrug_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3ff-2642', '1f937-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'shrug', 'uc9'],
			],
			'1f937-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f937-1f3ff-2640', '1f937-1f3fe-2640', '1f937-1f3fd-2640', '1f937-1f3fc-2640', '1f937-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone1:',
				'shortname_alternates' => [':woman_shrugging_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone2:',
				'shortname_alternates' => [':woman_shrugging_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-light skin tone', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone3:',
				'shortname_alternates' => [':woman_shrugging_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium skin tone', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone4:',
				'shortname_alternates' => [':woman_shrugging_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-dark skin tone', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone5:',
				'shortname_alternates' => [':woman_shrugging_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'shrug', 'woman', 'uc9'],
			],
			'1f937-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f937-1f3ff-2642', '1f937-1f3fe-2642', '1f937-1f3fd-2642', '1f937-1f3fc-2642', '1f937-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'shrug', 'uc9'],
			],
			'1f937-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone1:',
				'shortname_alternates' => [':man_shrugging_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'man', 'shrug', 'uc9'],
			],
			'1f937-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone2:',
				'shortname_alternates' => [':man_shrugging_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium-light skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone3:',
				'shortname_alternates' => [':man_shrugging_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone4:',
				'shortname_alternates' => [':man_shrugging_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium-dark skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone5:',
				'shortname_alternates' => [':man_shrugging_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'man', 'shrug', 'uc9'],
			],
			'1f64e' => [
				'name' => \XF::phrase('emoji.person_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting:',
				'shortname_alternates' => [':person_with_pouting_face:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64e-1f3fb', '1f64e-1f3fc', '1f64e-1f3fd', '1f64e-1f3fe', '1f64e-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f64e-2642', '1f64e-2640'],
				'keywords' => ['gesture', 'pouting', 'uc6'],
			],
			'1f64e-1f3fb' => [
				'name' => \XF::phrase('emoji.person_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone1:',
				'shortname_alternates' => [':person_with_pouting_face_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3fb-2642', '1f64e-1f3fb-2640'],
				'keywords' => ['gesture', 'light skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fc' => [
				'name' => \XF::phrase('emoji.person_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone2:',
				'shortname_alternates' => [':person_with_pouting_face_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3fc-2642', '1f64e-1f3fc-2640'],
				'keywords' => ['gesture', 'medium-light skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fd' => [
				'name' => \XF::phrase('emoji.person_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone3:',
				'shortname_alternates' => [':person_with_pouting_face_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3fd-2642', '1f64e-1f3fd-2640'],
				'keywords' => ['gesture', 'medium skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fe' => [
				'name' => \XF::phrase('emoji.person_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone4:',
				'shortname_alternates' => [':person_with_pouting_face_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3fe-2642', '1f64e-1f3fe-2640'],
				'keywords' => ['gesture', 'medium-dark skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3ff' => [
				'name' => \XF::phrase('emoji.person_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone5:',
				'shortname_alternates' => [':person_with_pouting_face_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3ff-2642', '1f64e-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'gesture', 'pouting', 'uc8'],
			],
			'1f64e-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64e-1f3ff-2640', '1f64e-1f3fe-2640', '1f64e-1f3fd-2640', '1f64e-1f3fc-2640', '1f64e-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'pouting', 'woman', 'uc6'],
			],
			'1f64e-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone1:',
				'shortname_alternates' => [':woman_pouting_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'light skin tone', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone2:',
				'shortname_alternates' => [':woman_pouting_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'medium-light skin tone', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone3:',
				'shortname_alternates' => [':woman_pouting_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'medium skin tone', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone4:',
				'shortname_alternates' => [':woman_pouting_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['gesture', 'medium-dark skin tone', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone5:',
				'shortname_alternates' => [':woman_pouting_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'gesture', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-2642' => [
				'name' => \XF::phrase('emoji.man_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64e-1f3ff-2642', '1f64e-1f3fe-2642', '1f64e-1f3fd-2642', '1f64e-1f3fc-2642', '1f64e-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'man', 'pouting', 'uc6'],
			],
			'1f64e-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone1:',
				'shortname_alternates' => [':man_pouting_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'light skin tone', 'man', 'pouting', 'uc8'],
			],
			'1f64e-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone2:',
				'shortname_alternates' => [':man_pouting_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'man', 'medium-light skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone3:',
				'shortname_alternates' => [':man_pouting_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'man', 'medium skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone4:',
				'shortname_alternates' => [':man_pouting_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['gesture', 'man', 'medium-dark skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone5:',
				'shortname_alternates' => [':man_pouting_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'gesture', 'man', 'pouting', 'uc8'],
			],
			'1f64d' => [
				'name' => \XF::phrase('emoji.person_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64d-1f3fb', '1f64d-1f3fc', '1f64d-1f3fd', '1f64d-1f3fe', '1f64d-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f64d-2642', '1f64d-2640'],
				'keywords' => ['frown', 'gesture', 'uc6'],
			],
			'1f64d-1f3fb' => [
				'name' => \XF::phrase('emoji.person_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3fb-2642', '1f64d-1f3fb-2640'],
				'keywords' => ['frown', 'gesture', 'light skin tone', 'uc8'],
			],
			'1f64d-1f3fc' => [
				'name' => \XF::phrase('emoji.person_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3fc-2642', '1f64d-1f3fc-2640'],
				'keywords' => ['frown', 'gesture', 'medium-light skin tone', 'uc8'],
			],
			'1f64d-1f3fd' => [
				'name' => \XF::phrase('emoji.person_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3fd-2642', '1f64d-1f3fd-2640'],
				'keywords' => ['frown', 'gesture', 'medium skin tone', 'uc8'],
			],
			'1f64d-1f3fe' => [
				'name' => \XF::phrase('emoji.person_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3fe-2642', '1f64d-1f3fe-2640'],
				'keywords' => ['frown', 'gesture', 'medium-dark skin tone', 'uc8'],
			],
			'1f64d-1f3ff' => [
				'name' => \XF::phrase('emoji.person_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3ff-2642', '1f64d-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'frown', 'gesture', 'uc8'],
			],
			'1f64d-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64d-1f3ff-2640', '1f64d-1f3fe-2640', '1f64d-1f3fd-2640', '1f64d-1f3fc-2640', '1f64d-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'woman', 'uc6'],
			],
			'1f64d-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone1:',
				'shortname_alternates' => [':woman_frowning_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'light skin tone', 'woman', 'uc8'],
			],
			'1f64d-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone2:',
				'shortname_alternates' => [':woman_frowning_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f64d-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone3:',
				'shortname_alternates' => [':woman_frowning_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f64d-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone4:',
				'shortname_alternates' => [':woman_frowning_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f64d-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone5:',
				'shortname_alternates' => [':woman_frowning_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'frowning', 'gesture', 'woman', 'uc8'],
			],
			'1f64d-2642' => [
				'name' => \XF::phrase('emoji.man_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64d-1f3ff-2642', '1f64d-1f3fe-2642', '1f64d-1f3fd-2642', '1f64d-1f3fc-2642', '1f64d-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'man', 'uc6'],
			],
			'1f64d-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone1:',
				'shortname_alternates' => [':man_frowning_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'light skin tone', 'man', 'uc8'],
			],
			'1f64d-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone2:',
				'shortname_alternates' => [':man_frowning_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f64d-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone3:',
				'shortname_alternates' => [':man_frowning_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'man', 'medium skin tone', 'uc8'],
			],
			'1f64d-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone4:',
				'shortname_alternates' => [':man_frowning_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['frowning', 'gesture', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f64d-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone5:',
				'shortname_alternates' => [':man_frowning_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'frowning', 'gesture', 'man', 'uc8'],
			],
			'1f487' => [
				'name' => \XF::phrase('emoji.person_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut:',
				'shortname_alternates' => [':haircut:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f487-1f3fb', '1f487-1f3fc', '1f487-1f3fd', '1f487-1f3fe', '1f487-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f487-2642', '1f487-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'parlor', 'uc6'],
			],
			'1f487-1f3fb' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone1:',
				'shortname_alternates' => [':haircut_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3fb-2642', '1f487-1f3fb-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'light skin tone', 'parlor', 'uc8'],
			],
			'1f487-1f3fc' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone2:',
				'shortname_alternates' => [':haircut_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3fc-2642', '1f487-1f3fc-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'medium-light skin tone', 'parlor', 'uc8'],
			],
			'1f487-1f3fd' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone3:',
				'shortname_alternates' => [':haircut_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3fd-2642', '1f487-1f3fd-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'medium skin tone', 'parlor', 'uc8'],
			],
			'1f487-1f3fe' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone4:',
				'shortname_alternates' => [':haircut_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3fe-2642', '1f487-1f3fe-2640'],
				'keywords' => ['barber', 'beauty', 'haircut', 'medium-dark skin tone', 'parlor', 'uc8'],
			],
			'1f487-1f3ff' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone5:',
				'shortname_alternates' => [':haircut_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3ff-2642', '1f487-1f3ff-2640'],
				'keywords' => ['barber', 'beauty', 'dark skin tone', 'haircut', 'parlor', 'uc8'],
			],
			'1f487-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f487-1f3ff-2640', '1f487-1f3fe-2640', '1f487-1f3fd-2640', '1f487-1f3fc-2640', '1f487-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['haircut', 'woman', 'uc6'],
			],
			'1f487-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone1:',
				'shortname_alternates' => [':woman_getting_haircut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['haircut', 'light skin tone', 'woman', 'uc8'],
			],
			'1f487-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone2:',
				'shortname_alternates' => [':woman_getting_haircut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['haircut', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f487-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone3:',
				'shortname_alternates' => [':woman_getting_haircut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['haircut', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f487-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone4:',
				'shortname_alternates' => [':woman_getting_haircut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['haircut', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f487-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone5:',
				'shortname_alternates' => [':woman_getting_haircut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'haircut', 'woman', 'uc8'],
			],
			'1f487-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f487-1f3ff-2642', '1f487-1f3fe-2642', '1f487-1f3fd-2642', '1f487-1f3fc-2642', '1f487-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['haircut', 'man', 'uc6'],
			],
			'1f487-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone1:',
				'shortname_alternates' => [':man_getting_haircut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['haircut', 'light skin tone', 'man', 'uc8'],
			],
			'1f487-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone2:',
				'shortname_alternates' => [':man_getting_haircut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['haircut', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f487-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone3:',
				'shortname_alternates' => [':man_getting_haircut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['haircut', 'man', 'medium skin tone', 'uc8'],
			],
			'1f487-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone4:',
				'shortname_alternates' => [':man_getting_haircut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['haircut', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f487-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone5:',
				'shortname_alternates' => [':man_getting_haircut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'haircut', 'man', 'uc8'],
			],
			'1f486' => [
				'name' => \XF::phrase('emoji.person_getting_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage:',
				'shortname_alternates' => [':massage:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f486-1f3fb', '1f486-1f3fc', '1f486-1f3fd', '1f486-1f3fe', '1f486-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f486-2642', '1f486-2640'],
				'keywords' => ['face', 'massage', 'salon', 'uc6'],
			],
			'1f486-1f3fb' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone1:',
				'shortname_alternates' => [':massage_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3fb-2642', '1f486-1f3fb-2640'],
				'keywords' => ['face', 'light skin tone', 'massage', 'salon', 'uc8'],
			],
			'1f486-1f3fc' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone2:',
				'shortname_alternates' => [':massage_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3fc-2642', '1f486-1f3fc-2640'],
				'keywords' => ['face', 'massage', 'medium-light skin tone', 'salon', 'uc8'],
			],
			'1f486-1f3fd' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone3:',
				'shortname_alternates' => [':massage_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3fd-2642', '1f486-1f3fd-2640'],
				'keywords' => ['face', 'massage', 'medium skin tone', 'salon', 'uc8'],
			],
			'1f486-1f3fe' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone4:',
				'shortname_alternates' => [':massage_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3fe-2642', '1f486-1f3fe-2640'],
				'keywords' => ['face', 'massage', 'medium-dark skin tone', 'salon', 'uc8'],
			],
			'1f486-1f3ff' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone5:',
				'shortname_alternates' => [':massage_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3ff-2642', '1f486-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'face', 'massage', 'salon', 'uc8'],
			],
			'1f486-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f486-1f3ff-2640', '1f486-1f3fe-2640', '1f486-1f3fd-2640', '1f486-1f3fc-2640', '1f486-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['face', 'massage', 'woman', 'uc6'],
			],
			'1f486-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone1:',
				'shortname_alternates' => [':woman_getting_face_massage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['face', 'light skin tone', 'massage', 'woman', 'uc8'],
			],
			'1f486-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone2:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['face', 'massage', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f486-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone3:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['face', 'massage', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f486-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone4:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['face', 'massage', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f486-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone5:',
				'shortname_alternates' => [':woman_getting_face_massage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'face', 'massage', 'woman', 'uc8'],
			],
			'1f486-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f486-1f3ff-2642', '1f486-1f3fe-2642', '1f486-1f3fd-2642', '1f486-1f3fc-2642', '1f486-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['face', 'man', 'massage', 'uc6'],
			],
			'1f486-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone1:',
				'shortname_alternates' => [':man_getting_face_massage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['face', 'light skin tone', 'man', 'massage', 'uc8'],
			],
			'1f486-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone2:',
				'shortname_alternates' => [':man_getting_face_massage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['face', 'man', 'massage', 'medium-light skin tone', 'uc8'],
			],
			'1f486-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone3:',
				'shortname_alternates' => [':man_getting_face_massage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['face', 'man', 'massage', 'medium skin tone', 'uc8'],
			],
			'1f486-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone4:',
				'shortname_alternates' => [':man_getting_face_massage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['face', 'man', 'massage', 'medium-dark skin tone', 'uc8'],
			],
			'1f486-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone5:',
				'shortname_alternates' => [':man_getting_face_massage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'face', 'man', 'massage', 'uc8'],
			],
			'1f9d6' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d6-1f3fb', '1f9d6-1f3fc', '1f9d6-1f3fd', '1f9d6-1f3fe', '1f9d6-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9d6-2640', '1f9d6-2642'],
				'keywords' => ['uc10'],
			],
			'1f9d6-1f3fb' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone1:',
				'shortname_alternates' => [':person_in_steamy_room_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3fb-2640', '1f9d6-1f3fb-2642'],
				'keywords' => ['light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fc' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone2:',
				'shortname_alternates' => [':person_in_steamy_room_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3fc-2640', '1f9d6-1f3fc-2642'],
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fd' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone3:',
				'shortname_alternates' => [':person_in_steamy_room_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3fd-2640', '1f9d6-1f3fd-2642'],
				'keywords' => ['medium skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fe' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone4:',
				'shortname_alternates' => [':person_in_steamy_room_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3fe-2640', '1f9d6-1f3fe-2642'],
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3ff' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone5:',
				'shortname_alternates' => [':person_in_steamy_room_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3ff-2640', '1f9d6-1f3ff-2642'],
				'keywords' => ['dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d6-1f3fb-2640', '1f9d6-1f3fc-2640', '1f9d6-1f3fd-2640', '1f9d6-1f3fe-2640', '1f9d6-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone1:',
				'shortname_alternates' => [':woman_in_steamy_room_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone2:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone3:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone4:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone5:',
				'shortname_alternates' => [':woman_in_steamy_room_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d6-1f3fb-2642', '1f9d6-1f3fc-2642', '1f9d6-1f3fd-2642', '1f9d6-1f3fe-2642', '1f9d6-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone1:',
				'shortname_alternates' => [':man_in_steamy_room_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone2:',
				'shortname_alternates' => [':man_in_steamy_room_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone3:',
				'shortname_alternates' => [':man_in_steamy_room_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['medium skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone4:',
				'shortname_alternates' => [':man_in_steamy_room_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone5:',
				'shortname_alternates' => [':man_in_steamy_room_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f485' => [
				'name' => \XF::phrase('emoji.nail_care'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f485-1f3fb', '1f485-1f3fc', '1f485-1f3fd', '1f485-1f3fe', '1f485-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['care', 'cosmetics', 'manicure', 'nail', 'polish', 'uc6'],
			],
			'1f485-1f3fb' => [
				'name' => \XF::phrase('emoji.nail_care_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['care', 'cosmetics', 'light skin tone', 'manicure', 'nail', 'polish', 'uc8'],
			],
			'1f485-1f3fc' => [
				'name' => \XF::phrase('emoji.nail_care_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium-light skin tone', 'nail', 'polish', 'uc8'],
			],
			'1f485-1f3fd' => [
				'name' => \XF::phrase('emoji.nail_care_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium skin tone', 'nail', 'polish', 'uc8'],
			],
			'1f485-1f3fe' => [
				'name' => \XF::phrase('emoji.nail_care_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium-dark skin tone', 'nail', 'polish', 'uc8'],
			],
			'1f485-1f3ff' => [
				'name' => \XF::phrase('emoji.nail_care_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['care', 'cosmetics', 'dark skin tone', 'manicure', 'nail', 'polish', 'uc8'],
			],
			'1f933' => [
				'name' => \XF::phrase('emoji.selfie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f933-1f3fb', '1f933-1f3fc', '1f933-1f3fd', '1f933-1f3fe', '1f933-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['camera', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3fb' => [
				'name' => \XF::phrase('emoji.selfie_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['camera', 'light skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3fc' => [
				'name' => \XF::phrase('emoji.selfie_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['camera', 'medium-light skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3fd' => [
				'name' => \XF::phrase('emoji.selfie_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['camera', 'medium skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3fe' => [
				'name' => \XF::phrase('emoji.selfie_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['camera', 'medium-dark skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3ff' => [
				'name' => \XF::phrase('emoji.selfie_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['camera', 'dark skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f483' => [
				'name' => \XF::phrase('emoji.dancer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f483-1f3fb', '1f483-1f3fc', '1f483-1f3fd', '1f483-1f3fe', '1f483-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dancing', 'woman', 'uc6'],
			],
			'1f483-1f3fb' => [
				'name' => \XF::phrase('emoji.dancer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dancing', 'light skin tone', 'woman', 'uc8'],
			],
			'1f483-1f3fc' => [
				'name' => \XF::phrase('emoji.dancer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dancing', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f483-1f3fd' => [
				'name' => \XF::phrase('emoji.dancer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dancing', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f483-1f3fe' => [
				'name' => \XF::phrase('emoji.dancer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dancing', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f483-1f3ff' => [
				'name' => \XF::phrase('emoji.dancer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dancing', 'dark skin tone', 'woman', 'uc8'],
			],
			'1f57a' => [
				'name' => \XF::phrase('emoji.man_dancing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing:',
				'shortname_alternates' => [':male_dancer:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f57a-1f3fb', '1f57a-1f3fc', '1f57a-1f3fd', '1f57a-1f3fe', '1f57a-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dance', 'man', 'uc9'],
			],
			'1f57a-1f3fb' => [
				'name' => \XF::phrase('emoji.man_dancing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone1:',
				'shortname_alternates' => [':male_dancer_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dance', 'light skin tone', 'man', 'uc9'],
			],
			'1f57a-1f3fc' => [
				'name' => \XF::phrase('emoji.man_dancing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone2:',
				'shortname_alternates' => [':male_dancer_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dance', 'man', 'medium-light skin tone', 'uc9'],
			],
			'1f57a-1f3fd' => [
				'name' => \XF::phrase('emoji.man_dancing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone3:',
				'shortname_alternates' => [':male_dancer_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dance', 'man', 'medium skin tone', 'uc9'],
			],
			'1f57a-1f3ff' => [
				'name' => \XF::phrase('emoji.man_dancing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone5:',
				'shortname_alternates' => [':male_dancer_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dance', 'dark skin tone', 'man', 'uc9'],
			],
			'1f57a-1f3fe' => [
				'name' => \XF::phrase('emoji.man_dancing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone4:',
				'shortname_alternates' => [':male_dancer_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dance', 'man', 'medium-dark skin tone', 'uc9'],
			],
			'1f46f' => [
				'name' => \XF::phrase('emoji.people_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_with_bunny_ears_partying:',
				'shortname_alternates' => [':dancers:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46f-2642', '1f46f-2640'],
				'keywords' => ['bunny ear', 'dancer', 'partying', 'uc6'],
			],
			'1f46f-2640' => [
				'name' => \XF::phrase('emoji.women_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_with_bunny_ears_partying:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['bunny ear', 'dancer', 'partying', 'women', 'uc6'],
			],
			'1f46f-2642' => [
				'name' => \XF::phrase('emoji.men_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_with_bunny_ears_partying:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['bunny ear', 'dancer', 'men', 'partying', 'uc6'],
			],
			'1f574' => [
				'name' => \XF::phrase('emoji.levitate'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate:',
				'shortname_alternates' => [':man_in_business_suit_levitating:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f574-1f3fb', '1f574-1f3fc', '1f574-1f3fd', '1f574-1f3fe', '1f574-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['business', 'man', 'suit', 'uc7'],
			],
			'1f574-1f3fb' => [
				'name' => \XF::phrase('emoji.levitate_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone1:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone1:', ':man_in_business_suit_levitating_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['business', 'light skin tone', 'man', 'suit', 'uc8'],
			],
			'1f574-1f3fc' => [
				'name' => \XF::phrase('emoji.levitate_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone2:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone2:', ':man_in_business_suit_levitating_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['business', 'man', 'medium-light skin tone', 'suit', 'uc8'],
			],
			'1f574-1f3fd' => [
				'name' => \XF::phrase('emoji.levitate_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone3:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone3:', ':man_in_business_suit_levitating_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['business', 'man', 'medium skin tone', 'suit', 'uc8'],
			],
			'1f574-1f3fe' => [
				'name' => \XF::phrase('emoji.levitate_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone4:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone4:', ':man_in_business_suit_levitating_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['business', 'man', 'medium-dark skin tone', 'suit', 'uc8'],
			],
			'1f574-1f3ff' => [
				'name' => \XF::phrase('emoji.levitate_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone5:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone5:', ':man_in_business_suit_levitating_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['business', 'dark skin tone', 'man', 'suit', 'uc8'],
			],
			'1f9d1-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9bd', '1f9d1-1f3fc-1f9bd', '1f9d1-1f3fd-1f9bd', '1f9d1-1f3fe-1f9bd', '1f9d1-1f3ff-1f9bd'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone1:',
				'shortname_alternates' => [':person_in_manual_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone2:',
				'shortname_alternates' => [':person_in_manual_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone3:',
				'shortname_alternates' => [':person_in_manual_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone4:',
				'shortname_alternates' => [':person_in_manual_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone5:',
				'shortname_alternates' => [':person_in_manual_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9bd', '1f469-1f3fc-1f9bd', '1f469-1f3fd-1f9bd', '1f469-1f3fe-1f9bd', '1f469-1f3ff-1f9bd'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone1:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone2:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone3:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone4:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone5:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9bd', '1f468-1f3fc-1f9bd', '1f468-1f3fd-1f9bd', '1f468-1f3fe-1f9bd', '1f468-1f3ff-1f9bd'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone1:',
				'shortname_alternates' => [':man_in_manual_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone2:',
				'shortname_alternates' => [':man_in_manual_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone3:',
				'shortname_alternates' => [':man_in_manual_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone4:',
				'shortname_alternates' => [':man_in_manual_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone5:',
				'shortname_alternates' => [':man_in_manual_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9bc', '1f9d1-1f3fc-1f9bc', '1f9d1-1f3fd-1f9bc', '1f9d1-1f3fe-1f9bc', '1f9d1-1f3ff-1f9bc'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone1:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone2:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone3:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone4:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone5:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9bc', '1f469-1f3fc-1f9bc', '1f469-1f3fd-1f9bc', '1f469-1f3fe-1f9bc', '1f469-1f3ff-1f9bc'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone1:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone2:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone3:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone4:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone5:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9bc', '1f468-1f3fc-1f9bc', '1f468-1f3fd-1f9bc', '1f468-1f3fe-1f9bc', '1f468-1f3ff-1f9bc'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone1:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone2:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone3:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone4:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone5:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f6b6' => [
				'name' => \XF::phrase('emoji.person_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking:',
				'shortname_alternates' => [':walking:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f6b6-1f3fb', '1f6b6-1f3fc', '1f6b6-1f3fd', '1f6b6-1f3fe', '1f6b6-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f6b6-2642', '1f6b6-2640'],
				'keywords' => ['hike', 'walk', 'walking', 'uc6'],
			],
			'1f6b6-1f3fb' => [
				'name' => \XF::phrase('emoji.person_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone1:',
				'shortname_alternates' => [':walking_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3fb-2642', '1f6b6-1f3fb-2640'],
				'keywords' => ['hike', 'light skin tone', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-1f3fc' => [
				'name' => \XF::phrase('emoji.person_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone2:',
				'shortname_alternates' => [':walking_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3fc-2642', '1f6b6-1f3fc-2640'],
				'keywords' => ['hike', 'medium-light skin tone', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-1f3fd' => [
				'name' => \XF::phrase('emoji.person_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone3:',
				'shortname_alternates' => [':walking_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3fd-2642', '1f6b6-1f3fd-2640'],
				'keywords' => ['hike', 'medium skin tone', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-1f3fe' => [
				'name' => \XF::phrase('emoji.person_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone4:',
				'shortname_alternates' => [':walking_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3fe-2642', '1f6b6-1f3fe-2640'],
				'keywords' => ['hike', 'medium-dark skin tone', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-1f3ff' => [
				'name' => \XF::phrase('emoji.person_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone5:',
				'shortname_alternates' => [':walking_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3ff-2642', '1f6b6-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'hike', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-2640' => [
				'name' => \XF::phrase('emoji.woman_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f6b6-1f3ff-2640', '1f6b6-1f3fe-2640', '1f6b6-1f3fd-2640', '1f6b6-1f3fc-2640', '1f6b6-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['hike', 'walk', 'woman', 'uc6'],
			],
			'1f6b6-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone1:',
				'shortname_alternates' => [':woman_walking_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['hike', 'light skin tone', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone2:',
				'shortname_alternates' => [':woman_walking_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['hike', 'medium-light skin tone', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone3:',
				'shortname_alternates' => [':woman_walking_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['hike', 'medium skin tone', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone4:',
				'shortname_alternates' => [':woman_walking_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['hike', 'medium-dark skin tone', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone5:',
				'shortname_alternates' => [':woman_walking_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'hike', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-2642' => [
				'name' => \XF::phrase('emoji.man_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f6b6-1f3ff-2642', '1f6b6-1f3fe-2642', '1f6b6-1f3fd-2642', '1f6b6-1f3fc-2642', '1f6b6-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['hike', 'man', 'walk', 'uc6'],
			],
			'1f6b6-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone1:',
				'shortname_alternates' => [':man_walking_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['hike', 'light skin tone', 'man', 'walk', 'uc8'],
			],
			'1f6b6-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone2:',
				'shortname_alternates' => [':man_walking_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['hike', 'man', 'medium-light skin tone', 'walk', 'uc8'],
			],
			'1f6b6-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone3:',
				'shortname_alternates' => [':man_walking_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['hike', 'man', 'medium skin tone', 'walk', 'uc8'],
			],
			'1f6b6-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone4:',
				'shortname_alternates' => [':man_walking_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['hike', 'man', 'medium-dark skin tone', 'walk', 'uc8'],
			],
			'1f6b6-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone5:',
				'shortname_alternates' => [':man_walking_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'hike', 'man', 'walk', 'uc8'],
			],
			'1f9d1-1f3fb-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone1:',
				'shortname_alternates' => [':person_with_probing_cane_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9af', '1f9d1-1f3fc-1f9af', '1f9d1-1f3fd-1f9af', '1f9d1-1f3fe-1f9af', '1f9d1-1f3ff-1f9af'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone2:',
				'shortname_alternates' => [':person_with_probing_cane_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone3:',
				'shortname_alternates' => [':person_with_probing_cane_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone4:',
				'shortname_alternates' => [':person_with_probing_cane_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone5:',
				'shortname_alternates' => [':person_with_probing_cane_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9af', '1f469-1f3fc-1f9af', '1f469-1f3fd-1f9af', '1f469-1f3fe-1f9af', '1f469-1f3ff-1f9af'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone1:',
				'shortname_alternates' => [':woman_with_probing_cane_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone2:',
				'shortname_alternates' => [':woman_with_probing_cane_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone3:',
				'shortname_alternates' => [':woman_with_probing_cane_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone4:',
				'shortname_alternates' => [':woman_with_probing_cane_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone5:',
				'shortname_alternates' => [':woman_with_probing_cane_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9af', '1f468-1f3fc-1f9af', '1f468-1f3fd-1f9af', '1f468-1f3fe-1f9af', '1f468-1f3ff-1f9af'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone1:',
				'shortname_alternates' => [':man_with_probing_cane_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone3:',
				'shortname_alternates' => [':man_with_probing_cane_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone2:',
				'shortname_alternates' => [':man_with_probing_cane_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone4:',
				'shortname_alternates' => [':man_with_probing_cane_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone5:',
				'shortname_alternates' => [':man_with_probing_cane_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce' => [
				'name' => \XF::phrase('emoji.person_kneeling'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9ce-1f3fb', '1f9ce-1f3fc', '1f9ce-1f3fd', '1f9ce-1f3fe', '1f9ce-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9ce-2640', '1f9ce-2642'],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fb' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone1:',
				'shortname_alternates' => [':person_kneeling_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3fb-2640', '1f9ce-1f3fb-2642'],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fc' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone2:',
				'shortname_alternates' => [':person_kneeling_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3fc-2640', '1f9ce-1f3fc-2642'],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fd' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone3:',
				'shortname_alternates' => [':person_kneeling_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3fd-2640', '1f9ce-1f3fd-2642'],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fe' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone4:',
				'shortname_alternates' => [':person_kneeling_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3fe-2640', '1f9ce-1f3fe-2642'],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3ff' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone5:',
				'shortname_alternates' => [':person_kneeling_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3ff-2640', '1f9ce-1f3ff-2642'],
				'keywords' => ['uc12'],
			],
			'1f9ce-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9ce-1f3fb-2640', '1f9ce-1f3fc-2640', '1f9ce-1f3fd-2640', '1f9ce-1f3fe-2640', '1f9ce-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone1:',
				'shortname_alternates' => [':woman_kneeling_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone2:',
				'shortname_alternates' => [':woman_kneeling_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone3:',
				'shortname_alternates' => [':woman_kneeling_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone4:',
				'shortname_alternates' => [':woman_kneeling_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone5:',
				'shortname_alternates' => [':woman_kneeling_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9ce-1f3fb-2642', '1f9ce-1f3fc-2642', '1f9ce-1f3fd-2642', '1f9ce-1f3fe-2642', '1f9ce-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone1:',
				'shortname_alternates' => [':man_kneeling_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone2:',
				'shortname_alternates' => [':man_kneeling_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone3:',
				'shortname_alternates' => [':man_kneeling_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone4:',
				'shortname_alternates' => [':man_kneeling_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone5:',
				'shortname_alternates' => [':man_kneeling_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f3c3' => [
				'name' => \XF::phrase('emoji.person_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running:',
				'shortname_alternates' => [':runner:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f3c3-1f3fb', '1f3c3-1f3fc', '1f3c3-1f3fd', '1f3c3-1f3fe', '1f3c3-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f3c3-2642', '1f3c3-2640'],
				'keywords' => ['marathon', 'running', 'uc6'],
			],
			'1f3c3-1f3fb' => [
				'name' => \XF::phrase('emoji.person_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone1:',
				'shortname_alternates' => [':runner_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3fb-2642', '1f3c3-1f3fb-2640'],
				'keywords' => ['light skin tone', 'marathon', 'running', 'uc8'],
			],
			'1f3c3-1f3fc' => [
				'name' => \XF::phrase('emoji.person_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone2:',
				'shortname_alternates' => [':runner_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3fc-2642', '1f3c3-1f3fc-2640'],
				'keywords' => ['marathon', 'medium-light skin tone', 'running', 'uc8'],
			],
			'1f3c3-1f3fd' => [
				'name' => \XF::phrase('emoji.person_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone3:',
				'shortname_alternates' => [':runner_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3fd-2642', '1f3c3-1f3fd-2640'],
				'keywords' => ['marathon', 'medium skin tone', 'running', 'uc8'],
			],
			'1f3c3-1f3fe' => [
				'name' => \XF::phrase('emoji.person_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone4:',
				'shortname_alternates' => [':runner_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3fe-2642', '1f3c3-1f3fe-2640'],
				'keywords' => ['marathon', 'medium-dark skin tone', 'running', 'uc8'],
			],
			'1f3c3-1f3ff' => [
				'name' => \XF::phrase('emoji.person_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone5:',
				'shortname_alternates' => [':runner_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3ff-2642', '1f3c3-1f3ff-2640'],
				'keywords' => ['dark skin tone', 'marathon', 'running', 'uc8'],
			],
			'1f3c3-2640' => [
				'name' => \XF::phrase('emoji.woman_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f3c3-1f3ff-2640', '1f3c3-1f3fe-2640', '1f3c3-1f3fd-2640', '1f3c3-1f3fc-2640', '1f3c3-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['marathon', 'racing', 'running', 'woman', 'uc6'],
			],
			'1f3c3-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone1:',
				'shortname_alternates' => [':woman_running_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'marathon', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone2:',
				'shortname_alternates' => [':woman_running_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['marathon', 'medium-light skin tone', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone3:',
				'shortname_alternates' => [':woman_running_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['marathon', 'medium skin tone', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone4:',
				'shortname_alternates' => [':woman_running_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['marathon', 'medium-dark skin tone', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone5:',
				'shortname_alternates' => [':woman_running_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'marathon', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-2642' => [
				'name' => \XF::phrase('emoji.man_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f3c3-1f3ff-2642', '1f3c3-1f3fe-2642', '1f3c3-1f3fd-2642', '1f3c3-1f3fc-2642', '1f3c3-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'marathon', 'racing', 'running', 'uc6'],
			],
			'1f3c3-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone1:',
				'shortname_alternates' => [':man_running_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['light skin tone', 'man', 'marathon', 'racing', 'running', 'uc8'],
			],
			'1f3c3-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone2:',
				'shortname_alternates' => [':man_running_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'marathon', 'medium-light skin tone', 'racing', 'running', 'uc8'],
			],
			'1f3c3-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone3:',
				'shortname_alternates' => [':man_running_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'marathon', 'medium skin tone', 'racing', 'running', 'uc8'],
			],
			'1f3c3-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone4:',
				'shortname_alternates' => [':man_running_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['man', 'marathon', 'medium-dark skin tone', 'racing', 'running', 'uc8'],
			],
			'1f3c3-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone5:',
				'shortname_alternates' => [':man_running_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['dark skin tone', 'man', 'marathon', 'racing', 'running', 'uc8'],
			],
			'1f9cd' => [
				'name' => \XF::phrase('emoji.person_standing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cd-1f3fb', '1f9cd-1f3fc', '1f9cd-1f3fd', '1f9cd-1f3fe', '1f9cd-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9cd-2640', '1f9cd-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fb' => [
				'name' => \XF::phrase('emoji.person_standing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone1:',
				'shortname_alternates' => [':person_standing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3fb-2640', '1f9cd-1f3fb-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fc' => [
				'name' => \XF::phrase('emoji.person_standing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone2:',
				'shortname_alternates' => [':person_standing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3fc-2640', '1f9cd-1f3fc-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fd' => [
				'name' => \XF::phrase('emoji.person_standing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone3:',
				'shortname_alternates' => [':person_standing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3fd-2640', '1f9cd-1f3fd-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fe' => [
				'name' => \XF::phrase('emoji.person_standing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone4:',
				'shortname_alternates' => [':person_standing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3fe-2640', '1f9cd-1f3fe-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3ff' => [
				'name' => \XF::phrase('emoji.person_standing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone5:',
				'shortname_alternates' => [':person_standing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3ff-2640', '1f9cd-1f3ff-2642'],
				'keywords' => ['uc12'],
			],
			'1f9cd-2640' => [
				'name' => \XF::phrase('emoji.woman_standing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cd-1f3fb-2640', '1f9cd-1f3fc-2640', '1f9cd-1f3fd-2640', '1f9cd-1f3fe-2640', '1f9cd-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone1:',
				'shortname_alternates' => [':woman_standing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone2:',
				'shortname_alternates' => [':woman_standing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone3:',
				'shortname_alternates' => [':woman_standing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone4:',
				'shortname_alternates' => [':woman_standing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone5:',
				'shortname_alternates' => [':woman_standing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-2642' => [
				'name' => \XF::phrase('emoji.man_standing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cd-1f3fb-2642', '1f9cd-1f3fc-2642', '1f9cd-1f3fd-2642', '1f9cd-1f3fe-2642', '1f9cd-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone1:',
				'shortname_alternates' => [':man_standing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone2:',
				'shortname_alternates' => [':man_standing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone3:',
				'shortname_alternates' => [':man_standing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone4:',
				'shortname_alternates' => [':man_standing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone5:',
				'shortname_alternates' => [':man_standing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f91d-1f9d1' => [
				'name' => \XF::phrase('emoji.people_holding_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f91d-1f9d1-1f3fb', '1f9d1-1f3fc-1f91d-1f9d1-1f3fb', '1f9d1-1f3fc-1f91d-1f9d1-1f3fc', '1f9d1-1f3fd-1f91d-1f9d1-1f3fb', '1f9d1-1f3fd-1f91d-1f9d1-1f3fc', '1f9d1-1f3fd-1f91d-1f9d1-1f3fd', '1f9d1-1f3fe-1f91d-1f9d1-1f3fb', '1f9d1-1f3fe-1f91d-1f9d1-1f3fd', '1f9d1-1f3fe-1f91d-1f9d1-1f3fe', '1f9d1-1f3ff-1f91d-1f9d1-1f3fb', '1f9d1-1f3ff-1f91d-1f9d1-1f3fc', '1f9d1-1f3ff-1f91d-1f9d1-1f3fd', '1f9d1-1f3ff-1f91d-1f9d1-1f3fe', '1f9d1-1f3ff-1f91d-1f9d1-1f3ff', '1f9d1-1f3fe-1f91d-1f9d1-1f3fc', '1f9d1-1f3fb-1f91d-1f9d1-1f3fc', '1f9d1-1f3fb-1f91d-1f9d1-1f3fd', '1f9d1-1f3fb-1f91d-1f9d1-1f3fe', '1f9d1-1f3fb-1f91d-1f9d1-1f3ff', '1f9d1-1f3fc-1f91d-1f9d1-1f3fd', '1f9d1-1f3fc-1f91d-1f9d1-1f3fe', '1f9d1-1f3fc-1f91d-1f9d1-1f3ff', '1f9d1-1f3fd-1f91d-1f9d1-1f3fe', '1f9d1-1f3fd-1f91d-1f9d1-1f3ff', '1f9d1-1f3fe-1f91d-1f9d1-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1_tone2:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1_tone3:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1_tone4:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1_tone5:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2_tone1:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2_tone3:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2_tone4:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2_tone5:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3_tone1:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3_tone2:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3_tone4:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3_tone5:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4_tone1:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4_tone2:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4_tone3:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4_tone5:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5_tone1:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5_tone2:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5_tone3:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5_tone4:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46b' => [
				'name' => \XF::phrase('emoji.couple'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46b-1f3fb', '1f46b-1f3fc', '1f46b-1f3fd', '1f46b-1f3fe', '1f46b-1f3ff', '1f469-1f3fb-1f91d-1f468-1f3fd', '1f469-1f3fb-1f91d-1f468-1f3ff', '1f469-1f3fd-1f91d-1f468-1f3ff', '1f469-1f3ff-1f91d-1f468-1f3fe', '1f469-1f3ff-1f91d-1f468-1f3fd', '1f469-1f3ff-1f91d-1f468-1f3fc', '1f469-1f3ff-1f91d-1f468-1f3fb', '1f469-1f3fe-1f91d-1f468-1f3ff', '1f469-1f3fe-1f91d-1f468-1f3fd', '1f469-1f3fe-1f91d-1f468-1f3fc', '1f469-1f3fe-1f91d-1f468-1f3fb', '1f469-1f3fd-1f91d-1f468-1f3fe', '1f469-1f3fd-1f91d-1f468-1f3fc', '1f469-1f3fd-1f91d-1f468-1f3fb', '1f469-1f3fc-1f91d-1f468-1f3ff', '1f469-1f3fc-1f91d-1f468-1f3fe', '1f469-1f3fc-1f91d-1f468-1f3fd', '1f469-1f3fc-1f91d-1f468-1f3fb', '1f469-1f3fb-1f91d-1f468-1f3fe', '1f469-1f3fb-1f91d-1f468-1f3fc'],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['couple', 'hand', 'hold', 'man', 'woman', 'uc6'],
			],
			'1f46b-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46b-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46b-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46b-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46b-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46d' => [
				'name' => \XF::phrase('emoji.two_women_holding_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':two_women_holding_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46d-1f3fb', '1f46d-1f3fc', '1f46d-1f3fd', '1f46d-1f3fe', '1f46d-1f3ff', '1f469-1f3fc-1f91d-1f469-1f3fb', '1f469-1f3fd-1f91d-1f469-1f3fb', '1f469-1f3fd-1f91d-1f469-1f3fc', '1f469-1f3fe-1f91d-1f469-1f3fb', '1f469-1f3fe-1f91d-1f469-1f3fd', '1f469-1f3ff-1f91d-1f469-1f3fb', '1f469-1f3ff-1f91d-1f469-1f3fc', '1f469-1f3ff-1f91d-1f469-1f3fd', '1f469-1f3ff-1f91d-1f469-1f3fe', '1f469-1f3fe-1f91d-1f469-1f3fc', '1f469-1f3fb-1f91d-1f469-1f3fc', '1f469-1f3fb-1f91d-1f469-1f3fd', '1f469-1f3fb-1f91d-1f469-1f3fe', '1f469-1f3fb-1f91d-1f469-1f3ff', '1f469-1f3fc-1f91d-1f469-1f3fd', '1f469-1f3fc-1f91d-1f469-1f3fe', '1f469-1f3fc-1f91d-1f469-1f3ff', '1f469-1f3fd-1f91d-1f469-1f3fe', '1f469-1f3fd-1f91d-1f469-1f3ff', '1f469-1f3fe-1f91d-1f469-1f3ff'],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['couple', 'hand', 'hold', 'woman', 'uc6'],
			],
			'1f46d-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1_tone2:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1_tone3:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1_tone4:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1_tone5:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2_tone1:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46d-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2_tone3:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2_tone4:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2_tone5:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3_tone1:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3_tone2:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46d-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3_tone4:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3_tone5:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4_tone1:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4_tone2:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4_tone3:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46d-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4_tone5:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5_tone1:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5_tone2:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5_tone3:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5_tone4:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46d-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46c' => [
				'name' => \XF::phrase('emoji.two_men_holding_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':two_men_holding_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46c-1f3fb', '1f46c-1f3fc', '1f46c-1f3fd', '1f46c-1f3fe', '1f46c-1f3ff', '1f468-1f3fc-1f91d-1f468-1f3fb', '1f468-1f3fd-1f91d-1f468-1f3fb', '1f468-1f3fd-1f91d-1f468-1f3fc', '1f468-1f3fe-1f91d-1f468-1f3fb', '1f468-1f3fe-1f91d-1f468-1f3fd', '1f468-1f3ff-1f91d-1f468-1f3fb', '1f468-1f3ff-1f91d-1f468-1f3fc', '1f468-1f3ff-1f91d-1f468-1f3fd', '1f468-1f3ff-1f91d-1f468-1f3fe', '1f468-1f3fe-1f91d-1f468-1f3fc', '1f468-1f3fb-1f91d-1f468-1f3fc', '1f468-1f3fb-1f91d-1f468-1f3fd', '1f468-1f3fb-1f91d-1f468-1f3fe', '1f468-1f3fb-1f91d-1f468-1f3ff', '1f468-1f3fc-1f91d-1f468-1f3fd', '1f468-1f3fc-1f91d-1f468-1f3fe', '1f468-1f3fc-1f91d-1f468-1f3ff', '1f468-1f3fd-1f91d-1f468-1f3fe', '1f468-1f3fd-1f91d-1f468-1f3ff', '1f468-1f3fe-1f91d-1f468-1f3ff'],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['Gemini', 'couple', 'hand', 'hold', 'man', 'twins', 'zodiac', 'uc6'],
			],
			'1f46c-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1_tone2:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1_tone3:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1_tone4:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1_tone5:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2_tone1:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46c-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2_tone3:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2_tone4:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2_tone5:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3_tone1:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3_tone2:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46c-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3_tone4:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3_tone5:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4_tone1:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4_tone2:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4_tone3:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46c-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4_tone5:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5_tone1:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5_tone2:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5_tone3:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5_tone4:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f46c-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f491' => [
				'name' => \XF::phrase('emoji.couple_with_heart'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['couple', 'love', 'uc6'],
			],
			'1f469-2764-1f468' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['couple', 'love', 'man', 'woman', 'uc6'],
			],
			'1f469-2764-1f469' => [
				'name' => \XF::phrase('emoji.couple_ww'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_ww:',
				'shortname_alternates' => [':couple_with_heart_ww:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['couple', 'love', 'woman', 'uc6'],
			],
			'1f468-2764-1f468' => [
				'name' => \XF::phrase('emoji.couple_mm'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_mm:',
				'shortname_alternates' => [':couple_with_heart_mm:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['couple', 'love', 'man', 'uc6'],
			],
			'1f48f' => [
				'name' => \XF::phrase('emoji.couplekiss'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couplekiss:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['couple', 'uc6'],
			],
			'1f469-2764-1f48b-1f468' => [
				'name' => \XF::phrase('emoji.kiss_woman_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss_woman_man:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['couple', 'man', 'woman', 'uc6'],
			],
			'1f469-2764-1f48b-1f469' => [
				'name' => \XF::phrase('emoji.kiss_ww'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss_ww:',
				'shortname_alternates' => [':couplekiss_ww:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['couple', 'woman', 'uc6'],
			],
			'1f468-2764-1f48b-1f468' => [
				'name' => \XF::phrase('emoji.kiss_mm'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss_mm:',
				'shortname_alternates' => [':couplekiss_mm:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['couple', 'man', 'uc6'],
			],
			'1f46a' => [
				'name' => \XF::phrase('emoji.family'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['family', 'uc6'],
			],
			'1f468-1f469-1f466' => [
				'name' => \XF::phrase('emoji.family_man_woman_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_woman_boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'man', 'woman', 'uc6'],
			],
			'1f468-1f469-1f467' => [
				'name' => \XF::phrase('emoji.family_mwg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mwg:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'man', 'woman', 'uc6'],
			],
			'1f468-1f469-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_mwgb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mwgb:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'girl', 'man', 'woman', 'uc6'],
			],
			'1f468-1f469-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_mwbb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mwbb:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'man', 'woman', 'uc6'],
			],
			'1f468-1f469-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_mwgg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mwgg:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'man', 'woman', 'uc6'],
			],
			'1f469-1f469-1f466' => [
				'name' => \XF::phrase('emoji.family_wwb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwb:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'woman', 'uc6'],
			],
			'1f469-1f469-1f467' => [
				'name' => \XF::phrase('emoji.family_wwg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwg:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'woman', 'uc6'],
			],
			'1f469-1f469-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_wwgb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwgb:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'girl', 'woman', 'uc6'],
			],
			'1f469-1f469-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_wwbb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwbb:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'woman', 'uc6'],
			],
			'1f469-1f469-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_wwgg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_wwgg:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'woman', 'uc6'],
			],
			'1f468-1f468-1f466' => [
				'name' => \XF::phrase('emoji.family_mmb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmb:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'man', 'uc6'],
			],
			'1f468-1f468-1f467' => [
				'name' => \XF::phrase('emoji.family_mmg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmg:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'man', 'uc6'],
			],
			'1f468-1f468-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_mmgb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmgb:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'girl', 'man', 'uc6'],
			],
			'1f468-1f468-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_mmbb'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmbb:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'man', 'uc6'],
			],
			'1f468-1f468-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_mmgg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_mmgg:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'man', 'uc6'],
			],
			'1f469-1f466' => [
				'name' => \XF::phrase('emoji.family_woman_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'woman', 'uc6'],
			],
			'1f469-1f467' => [
				'name' => \XF::phrase('emoji.family_woman_girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_girl:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'woman', 'uc6'],
			],
			'1f469-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_woman_girl_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_girl_boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'girl', 'woman', 'uc6'],
			],
			'1f469-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_woman_boy_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_boy_boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'woman', 'uc6'],
			],
			'1f469-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_woman_girl_girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_woman_girl_girl:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'woman', 'uc6'],
			],
			'1f468-1f466' => [
				'name' => \XF::phrase('emoji.family_man_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'man', 'uc6'],
			],
			'1f468-1f467' => [
				'name' => \XF::phrase('emoji.family_man_girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_girl:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'man', 'uc6'],
			],
			'1f468-1f467-1f466' => [
				'name' => \XF::phrase('emoji.family_man_girl_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_girl_boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'girl', 'man', 'uc6'],
			],
			'1f468-1f466-1f466' => [
				'name' => \XF::phrase('emoji.family_man_boy_boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_boy_boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['boy', 'family', 'man', 'uc6'],
			],
			'1f468-1f467-1f467' => [
				'name' => \XF::phrase('emoji.family_man_girl_girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':family_man_girl_girl:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'keywords' => ['family', 'girl', 'man', 'uc6'],
			],
			'1f9f6' => [
				'name' => \XF::phrase('emoji.yarn'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':yarn:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9f5' => [
				'name' => \XF::phrase('emoji.thread'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thread:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9e5' => [
				'name' => \XF::phrase('emoji.coat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':coat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['jacket', 'uc10'],
			],
			'1f97c' => [
				'name' => \XF::phrase('emoji.lab_coat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lab_coat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9ba' => [
				'name' => \XF::phrase('emoji.safety_vest'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':safety_vest:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f45a' => [
				'name' => \XF::phrase('emoji.womans_clothes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':womans_clothes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'woman', 'uc6'],
			],
			'1f455' => [
				'name' => \XF::phrase('emoji.shirt'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':shirt:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'shirt', 'tshirt', 'uc6'],
			],
			'1f456' => [
				'name' => \XF::phrase('emoji.jeans'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':jeans:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'pants', 'trousers', 'uc6'],
			],
			'1fa72' => [
				'name' => \XF::phrase('emoji.briefs'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':briefs:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1fa73' => [
				'name' => \XF::phrase('emoji.shorts'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':shorts:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f454' => [
				'name' => \XF::phrase('emoji.necktie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':necktie:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'uc6'],
			],
			'1f457' => [
				'name' => \XF::phrase('emoji.dress'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dress:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'uc6'],
			],
			'1f459' => [
				'name' => \XF::phrase('emoji.bikini'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bikini:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'swim', 'uc6'],
			],
			'1fa71' => [
				'name' => \XF::phrase('emoji.one_piece_swimsuit'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':one_piece_swimsuit:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f458' => [
				'name' => \XF::phrase('emoji.kimono'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kimono:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'uc6'],
			],
			'1f97b' => [
				'name' => \XF::phrase('emoji.sari'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sari:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f97f' => [
				'name' => \XF::phrase('emoji.womans_flat_shoe'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':womans_flat_shoe:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f460' => [
				'name' => \XF::phrase('emoji.high_heel'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':high_heel:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'heel', 'shoe', 'woman', 'uc6'],
			],
			'1f461' => [
				'name' => \XF::phrase('emoji.sandal'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sandal:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'sandal', 'shoe', 'woman', 'uc6'],
			],
			'1f462' => [
				'name' => \XF::phrase('emoji.boot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boot:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['boot', 'clothing', 'shoe', 'woman', 'uc6'],
			],
			'1f45e' => [
				'name' => \XF::phrase('emoji.mans_shoe'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mans_shoe:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'man', 'shoe', 'uc6'],
			],
			'1f45f' => [
				'name' => \XF::phrase('emoji.athletic_shoe'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':athletic_shoe:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['athletic', 'clothing', 'shoe', 'sneaker', 'uc6'],
			],
			'1f97e' => [
				'name' => \XF::phrase('emoji.hiking_boot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hiking_boot:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1fa74' => [
				'name' => \XF::phrase('emoji.thong_sandal'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thong_sandal:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9e6' => [
				'name' => \XF::phrase('emoji.socks'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':socks:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['stocking', 'uc10'],
			],
			'1f9e4' => [
				'name' => \XF::phrase('emoji.gloves'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':gloves:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hand', 'uc10'],
			],
			'1f9e3' => [
				'name' => \XF::phrase('emoji.scarf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scarf:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['neck', 'uc10'],
			],
			'1f3a9' => [
				'name' => \XF::phrase('emoji.tophat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tophat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'hat', 'top', 'tophat', 'uc6'],
			],
			'1f9e2' => [
				'name' => \XF::phrase('emoji.billed_cap'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':billed_cap:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baseball cap', 'uc10'],
			],
			'1f452' => [
				'name' => \XF::phrase('emoji.womans_hat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':womans_hat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'hat', 'woman', 'uc6'],
			],
			'1f393' => [
				'name' => \XF::phrase('emoji.mortar_board'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mortar_board:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cap', 'celebration', 'clothing', 'graduation', 'hat', 'uc6'],
			],
			'26d1' => [
				'name' => \XF::phrase('emoji.helmet_with_cross'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':helmet_with_cross:',
				'shortname_alternates' => [':helmet_with_white_cross:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['aid', 'cross', 'face', 'hat', 'helmet', 'uc5'],
			],
			'1fa96' => [
				'name' => \XF::phrase('emoji.military_helmet'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':military_helmet:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f451' => [
				'name' => \XF::phrase('emoji.crown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':crown:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'king', 'queen', 'uc6'],
			],
			'1f48d' => [
				'name' => \XF::phrase('emoji.ring'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ring:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['diamond', 'uc6'],
			],
			'1f45d' => [
				'name' => \XF::phrase('emoji.pouch'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pouch:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bag', 'clothing', 'pouch', 'uc6'],
			],
			'1f45b' => [
				'name' => \XF::phrase('emoji.purse'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':purse:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'coin', 'uc6'],
			],
			'1f45c' => [
				'name' => \XF::phrase('emoji.handbag'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handbag:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bag', 'clothing', 'purse', 'uc6'],
			],
			'1f4bc' => [
				'name' => \XF::phrase('emoji.briefcase'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':briefcase:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['briefcase', 'uc6'],
			],
			'1f392' => [
				'name' => \XF::phrase('emoji.school_satchel'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':school_satchel:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bag', 'satchel', 'school', 'uc6'],
			],
			'1f9f3' => [
				'name' => \XF::phrase('emoji.luggage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':luggage:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f453' => [
				'name' => \XF::phrase('emoji.eyeglasses'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':eyeglasses:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'eye', 'eyeglasses', 'eyewear', 'uc6'],
			],
			'1f576' => [
				'name' => \XF::phrase('emoji.dark_sunglasses'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dark_sunglasses:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark', 'eye', 'eyewear', 'glasses', 'uc7'],
			],
			'1f97d' => [
				'name' => \XF::phrase('emoji.goggles'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':goggles:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f302' => [
				'name' => \XF::phrase('emoji.closed_umbrella'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':closed_umbrella:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'rain', 'umbrella', 'uc6'],
			],
			'1f9b1' => [
				'name' => \XF::phrase('emoji.curly_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':curly_haired:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b0' => [
				'name' => \XF::phrase('emoji.red_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':red_haired:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b3' => [
				'name' => \XF::phrase('emoji.white_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':white_haired:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9b2' => [
				'name' => \XF::phrase('emoji.bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bald:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f436' => [
				'name' => \XF::phrase('emoji.dog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dog:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dog', 'face', 'pet', 'uc6'],
			],
			'1f431' => [
				'name' => \XF::phrase('emoji.cat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cat', 'face', 'pet', 'uc6'],
			],
			'1f42d' => [
				'name' => \XF::phrase('emoji.mouse'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mouse:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'mouse', 'uc6'],
			],
			'1f439' => [
				'name' => \XF::phrase('emoji.hamster'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hamster:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'hamster', 'pet', 'uc6'],
			],
			'1f430' => [
				'name' => \XF::phrase('emoji.rabbit'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rabbit:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bunny', 'face', 'pet', 'rabbit', 'uc6'],
			],
			'1f98a' => [
				'name' => \XF::phrase('emoji.fox'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fox:',
				'shortname_alternates' => [':fox_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'fox', 'uc9'],
			],
			'1f43b' => [
				'name' => \XF::phrase('emoji.bear'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bear:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bear', 'face', 'uc6'],
			],
			'1f43c' => [
				'name' => \XF::phrase('emoji.panda_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':panda_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'panda', 'uc6'],
			],
			'1f43b-2744' => [
				'name' => \XF::phrase('emoji.polar_bear'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':polar_bear:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f428' => [
				'name' => \XF::phrase('emoji.koala'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':koala:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bear', 'uc6'],
			],
			'1f42f' => [
				'name' => \XF::phrase('emoji.tiger'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tiger:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'tiger', 'uc6'],
			],
			'1f981' => [
				'name' => \XF::phrase('emoji.lion_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':lion_face:',
				'shortname_alternates' => [':lion:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Leo', 'face', 'lion', 'zodiac', 'uc8'],
			],
			'1f42e' => [
				'name' => \XF::phrase('emoji.cow'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cow:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cow', 'face', 'uc6'],
			],
			'1f437' => [
				'name' => \XF::phrase('emoji.pig'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':pig:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'pig', 'uc6'],
			],
			'1f43d' => [
				'name' => \XF::phrase('emoji.pig_nose'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':pig_nose:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'nose', 'pig', 'uc6'],
			],
			'1f438' => [
				'name' => \XF::phrase('emoji.frog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':frog:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'frog', 'uc6'],
			],
			'1f435' => [
				'name' => \XF::phrase('emoji.monkey_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':monkey_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'monkey', 'uc6'],
			],
			'1f648' => [
				'name' => \XF::phrase('emoji.see_no_evil'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':see_no_evil:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['evil', 'face', 'forbidden', 'gesture', 'monkey', 'no', 'not', 'prohibited', 'see', 'uc6'],
			],
			'1f649' => [
				'name' => \XF::phrase('emoji.hear_no_evil'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hear_no_evil:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['evil', 'face', 'forbidden', 'gesture', 'hear', 'monkey', 'no', 'not', 'prohibited', 'uc6'],
			],
			'1f64a' => [
				'name' => \XF::phrase('emoji.speak_no_evil'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':speak_no_evil:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['evil', 'face', 'forbidden', 'gesture', 'monkey', 'no', 'not', 'prohibited', 'speak', 'uc6'],
			],
			'1f412' => [
				'name' => \XF::phrase('emoji.monkey'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':monkey:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['monkey', 'uc6'],
			],
			'1f414' => [
				'name' => \XF::phrase('emoji.chicken'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':chicken:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'chicken', 'uc6'],
			],
			'1f427' => [
				'name' => \XF::phrase('emoji.penguin'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':penguin:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'penguin', 'uc6'],
			],
			'1f426' => [
				'name' => \XF::phrase('emoji.bird'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bird:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'uc6'],
			],
			'1f424' => [
				'name' => \XF::phrase('emoji.baby_chick'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':baby_chick:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'bird', 'chick', 'uc6'],
			],
			'1f423' => [
				'name' => \XF::phrase('emoji.hatching_chick'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hatching_chick:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'bird', 'chick', 'hatching', 'uc6'],
			],
			'1f425' => [
				'name' => \XF::phrase('emoji.hatched_chick'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hatched_chick:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baby', 'bird', 'chick', 'uc6'],
			],
			'1f986' => [
				'name' => \XF::phrase('emoji.duck'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':duck:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'duck', 'uc9'],
			],
			'1f9a4' => [
				'name' => \XF::phrase('emoji.dodo'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dodo:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f985' => [
				'name' => \XF::phrase('emoji.eagle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':eagle:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'eagle', 'uc9'],
			],
			'1f989' => [
				'name' => \XF::phrase('emoji.owl'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':owl:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'owl', 'wise', 'uc9'],
			],
			'1f987' => [
				'name' => \XF::phrase('emoji.bat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bat', 'vampire', 'uc9'],
			],
			'1f43a' => [
				'name' => \XF::phrase('emoji.wolf'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':wolf:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'wolf', 'uc6'],
			],
			'1f417' => [
				'name' => \XF::phrase('emoji.boar'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':boar:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['pig', 'uc6'],
			],
			'1f434' => [
				'name' => \XF::phrase('emoji.horse'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':horse:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'horse', 'uc6'],
			],
			'1f984' => [
				'name' => \XF::phrase('emoji.unicorn'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':unicorn:',
				'shortname_alternates' => [':unicorn_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'unicorn', 'uc8'],
			],
			'1f41d' => [
				'name' => \XF::phrase('emoji.bee'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bee:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bee', 'insect', 'uc6'],
			],
			'1f41b' => [
				'name' => \XF::phrase('emoji.bug'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bug:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['insect', 'uc6'],
			],
			'1f98b' => [
				'name' => \XF::phrase('emoji.butterfly'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':butterfly:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['butterfly', 'insect', 'pretty', 'uc9'],
			],
			'1f40c' => [
				'name' => \XF::phrase('emoji.snail'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snail:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['snail', 'uc6'],
			],
			'1fab1' => [
				'name' => \XF::phrase('emoji.worm'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':worm:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f41e' => [
				'name' => \XF::phrase('emoji.lady_beetle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':lady_beetle:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['beetle', 'insect', 'ladybird', 'ladybug', 'uc6'],
			],
			'1f41c' => [
				'name' => \XF::phrase('emoji.ant'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ant:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['insect', 'uc6'],
			],
			'1fab0' => [
				'name' => \XF::phrase('emoji.fly'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fly:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f99f' => [
				'name' => \XF::phrase('emoji.mosquito'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mosquito:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1fab3' => [
				'name' => \XF::phrase('emoji.cockroach'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cockroach:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1fab2' => [
				'name' => \XF::phrase('emoji.beetle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':beetle:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f997' => [
				'name' => \XF::phrase('emoji.cricket'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cricket:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f577' => [
				'name' => \XF::phrase('emoji.spider'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':spider:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['insect', 'uc7'],
			],
			'1f578' => [
				'name' => \XF::phrase('emoji.spider_web'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':spider_web:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['spider', 'web', 'uc7'],
			],
			'1f982' => [
				'name' => \XF::phrase('emoji.scorpion'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':scorpion:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Scorpius', 'scorpio', 'zodiac', 'uc8'],
			],
			'1f422' => [
				'name' => \XF::phrase('emoji.turtle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':turtle:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['terrapin', 'tortoise', 'turtle', 'uc6'],
			],
			'1f40d' => [
				'name' => \XF::phrase('emoji.snake'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snake:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Ophiuchus', 'bearer', 'serpent', 'zodiac', 'uc6'],
			],
			'1f98e' => [
				'name' => \XF::phrase('emoji.lizard'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':lizard:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['lizard', 'reptile', 'uc9'],
			],
			'1f996' => [
				'name' => \XF::phrase('emoji.t_rex'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':t_rex:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Tyrannosaurus Rex', 'uc10'],
			],
			'1f995' => [
				'name' => \XF::phrase('emoji.sauropod'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sauropod:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['brachiosaurus', 'brontosaurus', 'diplodocus', 'uc10'],
			],
			'1f419' => [
				'name' => \XF::phrase('emoji.octopus'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':octopus:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['octopus', 'uc6'],
			],
			'1f991' => [
				'name' => \XF::phrase('emoji.squid'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':squid:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['food', 'molusc', 'squid', 'uc9'],
			],
			'1f990' => [
				'name' => \XF::phrase('emoji.shrimp'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':shrimp:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['food', 'shellfish', 'shrimp', 'small', 'uc9'],
			],
			'1f99e' => [
				'name' => \XF::phrase('emoji.lobster'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':lobster:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f980' => [
				'name' => \XF::phrase('emoji.crab'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':crab:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Cancer', 'zodiac', 'uc8'],
			],
			'1f421' => [
				'name' => \XF::phrase('emoji.blowfish'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':blowfish:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fish', 'uc6'],
			],
			'1f420' => [
				'name' => \XF::phrase('emoji.tropical_fish'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tropical_fish:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fish', 'tropical', 'uc6'],
			],
			'1f41f' => [
				'name' => \XF::phrase('emoji.fish'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fish:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Pisces', 'zodiac', 'uc6'],
			],
			'1f9ad' => [
				'name' => \XF::phrase('emoji.seal'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':seal:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f42c' => [
				'name' => \XF::phrase('emoji.dolphin'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dolphin:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flipper', 'uc6'],
			],
			'1f433' => [
				'name' => \XF::phrase('emoji.whale'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':whale:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'spouting', 'whale', 'uc6'],
			],
			'1f40b' => [
				'name' => \XF::phrase('emoji.whale2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':whale2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['whale', 'uc6'],
			],
			'1f988' => [
				'name' => \XF::phrase('emoji.shark'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':shark:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fish', 'shark', 'uc9'],
			],
			'1f40a' => [
				'name' => \XF::phrase('emoji.crocodile'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':crocodile:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['crocodile', 'uc6'],
			],
			'1f405' => [
				'name' => \XF::phrase('emoji.tiger2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tiger2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['tiger', 'uc6'],
			],
			'1f406' => [
				'name' => \XF::phrase('emoji.leopard'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':leopard:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['leopard', 'uc6'],
			],
			'1f993' => [
				'name' => \XF::phrase('emoji.zebra'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':zebra:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['stripe', 'uc10'],
			],
			'1f98d' => [
				'name' => \XF::phrase('emoji.gorilla'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':gorilla:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gorilla', 'uc9'],
			],
			'1f9a7' => [
				'name' => \XF::phrase('emoji.orangutan'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':orangutan:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f418' => [
				'name' => \XF::phrase('emoji.elephant'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':elephant:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['elephant', 'uc6'],
			],
			'1f9a3' => [
				'name' => \XF::phrase('emoji.mammoth'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mammoth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9ac' => [
				'name' => \XF::phrase('emoji.bison'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bison:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f99b' => [
				'name' => \XF::phrase('emoji.hippopotamus'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hippopotamus:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f98f' => [
				'name' => \XF::phrase('emoji.rhino'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rhino:',
				'shortname_alternates' => [':rhinoceros:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['rhinoceros', 'uc9'],
			],
			'1f42a' => [
				'name' => \XF::phrase('emoji.dromedary_camel'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dromedary_camel:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dromedary', 'hump', 'uc6'],
			],
			'1f42b' => [
				'name' => \XF::phrase('emoji.camel'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':camel:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bactrian', 'camel', 'hump', 'uc6'],
			],
			'1f992' => [
				'name' => \XF::phrase('emoji.giraffe'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':giraffe:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['spots', 'uc10'],
			],
			'1f998' => [
				'name' => \XF::phrase('emoji.kangaroo'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':kangaroo:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f403' => [
				'name' => \XF::phrase('emoji.water_buffalo'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':water_buffalo:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['buffalo', 'water', 'uc6'],
			],
			'1f402' => [
				'name' => \XF::phrase('emoji.ox'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ox:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Taurus', 'bull', 'zodiac', 'uc6'],
			],
			'1f404' => [
				'name' => \XF::phrase('emoji.cow2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cow2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cow', 'uc6'],
			],
			'1f40e' => [
				'name' => \XF::phrase('emoji.racehorse'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':racehorse:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['equestrian', 'racehorse', 'racing', 'uc6'],
			],
			'1f416' => [
				'name' => \XF::phrase('emoji.pig2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':pig2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['sow', 'uc6'],
			],
			'1f40f' => [
				'name' => \XF::phrase('emoji.ram'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ram:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Aries', 'male', 'sheep', 'zodiac', 'uc6'],
			],
			'1f411' => [
				'name' => \XF::phrase('emoji.sheep'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sheep:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['female', 'sheep', 'uc6'],
			],
			'1f999' => [
				'name' => \XF::phrase('emoji.llama'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':llama:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f410' => [
				'name' => \XF::phrase('emoji.goat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':goat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Capricorn', 'zodiac', 'uc6'],
			],
			'1f98c' => [
				'name' => \XF::phrase('emoji.deer'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':deer:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['deer', 'uc9'],
			],
			'1f415' => [
				'name' => \XF::phrase('emoji.dog2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dog2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['pet', 'uc6'],
			],
			'1f429' => [
				'name' => \XF::phrase('emoji.poodle'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':poodle:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dog', 'uc6'],
			],
			'1f9ae' => [
				'name' => \XF::phrase('emoji.guide_dog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':guide_dog:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f415-1f9ba' => [
				'name' => \XF::phrase('emoji.service_dog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':service_dog:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f408' => [
				'name' => \XF::phrase('emoji.cat2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cat2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['pet', 'uc6'],
			],
			'1f408-2b1b' => [
				'name' => \XF::phrase('emoji.black_cat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':black_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f413' => [
				'name' => \XF::phrase('emoji.rooster'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rooster:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'rooster', 'uc6'],
			],
			'1f983' => [
				'name' => \XF::phrase('emoji.turkey'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':turkey:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'turkey', 'uc8'],
			],
			'1f99a' => [
				'name' => \XF::phrase('emoji.peacock'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':peacock:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f99c' => [
				'name' => \XF::phrase('emoji.parrot'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':parrot:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9a2' => [
				'name' => \XF::phrase('emoji.swan'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':swan:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9a9' => [
				'name' => \XF::phrase('emoji.flamingo'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':flamingo:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f54a' => [
				'name' => \XF::phrase('emoji.dove'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dove:',
				'shortname_alternates' => [':dove_of_peace:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bird', 'fly', 'peace', 'uc7'],
			],
			'1f407' => [
				'name' => \XF::phrase('emoji.rabbit2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rabbit2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bunny', 'pet', 'uc6'],
			],
			'1f99d' => [
				'name' => \XF::phrase('emoji.raccoon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':raccoon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9a8' => [
				'name' => \XF::phrase('emoji.skunk'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':skunk:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9a1' => [
				'name' => \XF::phrase('emoji.badger'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':badger:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f9ab' => [
				'name' => \XF::phrase('emoji.beaver'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':beaver:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f9a6' => [
				'name' => \XF::phrase('emoji.otter'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':otter:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9a5' => [
				'name' => \XF::phrase('emoji.sloth'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sloth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f401' => [
				'name' => \XF::phrase('emoji.mouse2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mouse2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['mouse', 'uc6'],
			],
			'1f400' => [
				'name' => \XF::phrase('emoji.rat'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['rat', 'uc6'],
			],
			'1f43f' => [
				'name' => \XF::phrase('emoji.chipmunk'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':chipmunk:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['chipmunk', 'uc7'],
			],
			'1f994' => [
				'name' => \XF::phrase('emoji.hedgehog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hedgehog:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['spiny', 'uc10'],
			],
			'1f43e' => [
				'name' => \XF::phrase('emoji.feet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':feet:',
				'shortname_alternates' => [':paw_prints:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['feet', 'paw', 'print', 'uc6'],
			],
			'1f409' => [
				'name' => \XF::phrase('emoji.dragon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dragon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fairy tale', 'uc6'],
			],
			'1f432' => [
				'name' => \XF::phrase('emoji.dragon_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dragon_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dragon', 'face', 'fairy tale', 'uc6'],
			],
			'1f335' => [
				'name' => \XF::phrase('emoji.cactus'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cactus:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['plant', 'uc6'],
			],
			'1f384' => [
				'name' => \XF::phrase('emoji.christmas_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':christmas_tree:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Christmas', 'celebration', 'tree', 'uc6'],
			],
			'1f332' => [
				'name' => \XF::phrase('emoji.evergreen_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':evergreen_tree:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['tree', 'uc6'],
			],
			'1f333' => [
				'name' => \XF::phrase('emoji.deciduous_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':deciduous_tree:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['deciduous', 'shedding', 'tree', 'uc6'],
			],
			'1f334' => [
				'name' => \XF::phrase('emoji.palm_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':palm_tree:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['palm', 'tree', 'uc6'],
			],
			'1f331' => [
				'name' => \XF::phrase('emoji.seedling'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':seedling:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['young', 'uc6'],
			],
			'1f33f' => [
				'name' => \XF::phrase('emoji.herb'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':herb:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['leaf', 'uc6'],
			],
			'2618' => [
				'name' => \XF::phrase('emoji.shamrock'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':shamrock:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['plant', 'uc4'],
			],
			'1f340' => [
				'name' => \XF::phrase('emoji.four_leaf_clover'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':four_leaf_clover:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['4', 'clover', 'four', 'leaf', 'uc6'],
			],
			'1f38d' => [
				'name' => \XF::phrase('emoji.bamboo'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bamboo:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Japanese', 'bamboo', 'celebration', 'pine', 'uc6'],
			],
			'1f38b' => [
				'name' => \XF::phrase('emoji.tanabata_tree'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tanabata_tree:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Japanese', 'banner', 'celebration', 'tree', 'uc6'],
			],
			'1f343' => [
				'name' => \XF::phrase('emoji.leaves'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':leaves:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['blow', 'flutter', 'leaf', 'wind', 'uc6'],
			],
			'1f342' => [
				'name' => \XF::phrase('emoji.fallen_leaf'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fallen_leaf:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['falling', 'leaf', 'uc6'],
			],
			'1f341' => [
				'name' => \XF::phrase('emoji.maple_leaf'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':maple_leaf:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['falling', 'leaf', 'maple', 'uc6'],
			],
			'1fab6' => [
				'name' => \XF::phrase('emoji.feather'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':feather:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f344' => [
				'name' => \XF::phrase('emoji.mushroom'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':mushroom:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['toadstool', 'uc6'],
			],
			'1f41a' => [
				'name' => \XF::phrase('emoji.shell'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':shell:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['shell', 'spiral', 'uc6'],
			],
			'1faa8' => [
				'name' => \XF::phrase('emoji.rock'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rock:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1fab5' => [
				'name' => \XF::phrase('emoji.wood'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':wood:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f33e' => [
				'name' => \XF::phrase('emoji.ear_of_rice'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ear_of_rice:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ear', 'grain', 'rice', 'uc6'],
			],
			'1fab4' => [
				'name' => \XF::phrase('emoji.potted_plant'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':potted_plant:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f490' => [
				'name' => \XF::phrase('emoji.bouquet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':bouquet:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flower', 'uc6'],
			],
			'1f337' => [
				'name' => \XF::phrase('emoji.tulip'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':tulip:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flower', 'uc6'],
			],
			'1f339' => [
				'name' => \XF::phrase('emoji.rose'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rose:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flower', 'uc6'],
			],
			'1f940' => [
				'name' => \XF::phrase('emoji.wilted_rose'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':wilted_rose:',
				'shortname_alternates' => [':wilted_flower:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flower', 'wilted', 'uc9'],
			],
			'1f33a' => [
				'name' => \XF::phrase('emoji.hibiscus'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':hibiscus:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flower', 'uc6'],
			],
			'1f338' => [
				'name' => \XF::phrase('emoji.cherry_blossom'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cherry_blossom:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['blossom', 'cherry', 'flower', 'uc6'],
			],
			'1f33c' => [
				'name' => \XF::phrase('emoji.blossom'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':blossom:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flower', 'uc6'],
			],
			'1f33b' => [
				'name' => \XF::phrase('emoji.sunflower'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sunflower:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flower', 'sun', 'uc6'],
			],
			'1f31e' => [
				'name' => \XF::phrase('emoji.sun_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sun_with_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bright', 'face', 'sun', 'uc6'],
			],
			'1f31d' => [
				'name' => \XF::phrase('emoji.full_moon_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':full_moon_with_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bright', 'face', 'full', 'moon', 'uc6'],
			],
			'1f31b' => [
				'name' => \XF::phrase('emoji.first_quarter_moon_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':first_quarter_moon_with_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'moon', 'quarter', 'uc6'],
			],
			'1f31c' => [
				'name' => \XF::phrase('emoji.last_quarter_moon_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':last_quarter_moon_with_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'moon', 'quarter', 'uc6'],
			],
			'1f31a' => [
				'name' => \XF::phrase('emoji.new_moon_with_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':new_moon_with_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['face', 'moon', 'uc6'],
			],
			'1f315' => [
				'name' => \XF::phrase('emoji.full_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':full_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['full', 'moon', 'uc6'],
			],
			'1f316' => [
				'name' => \XF::phrase('emoji.waning_gibbous_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':waning_gibbous_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gibbous', 'moon', 'waning', 'uc6'],
			],
			'1f317' => [
				'name' => \XF::phrase('emoji.last_quarter_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':last_quarter_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['moon', 'quarter', 'uc6'],
			],
			'1f318' => [
				'name' => \XF::phrase('emoji.waning_crescent_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':waning_crescent_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['crescent', 'moon', 'waning', 'uc6'],
			],
			'1f311' => [
				'name' => \XF::phrase('emoji.new_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':new_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['dark', 'moon', 'uc6'],
			],
			'1f312' => [
				'name' => \XF::phrase('emoji.waxing_crescent_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':waxing_crescent_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['crescent', 'moon', 'waxing', 'uc6'],
			],
			'1f313' => [
				'name' => \XF::phrase('emoji.first_quarter_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':first_quarter_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['moon', 'quarter', 'uc6'],
			],
			'1f314' => [
				'name' => \XF::phrase('emoji.waxing_gibbous_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':waxing_gibbous_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['gibbous', 'moon', 'waxing', 'uc6'],
			],
			'1f319' => [
				'name' => \XF::phrase('emoji.crescent_moon'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':crescent_moon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['crescent', 'moon', 'uc6'],
			],
			'1f30e' => [
				'name' => \XF::phrase('emoji.earth_americas'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':earth_americas:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Americas', 'earth', 'globe', 'world', 'uc6'],
			],
			'1f30d' => [
				'name' => \XF::phrase('emoji.earth_africa'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':earth_africa:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Africa', 'Europe', 'earth', 'globe', 'world', 'uc6'],
			],
			'1f30f' => [
				'name' => \XF::phrase('emoji.earth_asia'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':earth_asia:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['Asia', 'Australia', 'earth', 'globe', 'world', 'uc6'],
			],
			'1fa90' => [
				'name' => \XF::phrase('emoji.ringed_planet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ringed_planet:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f4ab' => [
				'name' => \XF::phrase('emoji.dizzy'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dizzy:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['comic', 'star', 'uc6'],
			],
			'2b50' => [
				'name' => \XF::phrase('emoji.star'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':star:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['star', 'uc5'],
			],
			'1f31f' => [
				'name' => \XF::phrase('emoji.star2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':star2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['glittery', 'glow', 'shining', 'sparkle', 'star', 'uc6'],
			],
			'2728' => [
				'name' => \XF::phrase('emoji.sparkles'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sparkles:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['sparkle', 'star', 'uc6'],
			],
			'26a1' => [
				'name' => \XF::phrase('emoji.zap'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':zap:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['danger', 'electric', 'electricity', 'lightning', 'voltage', 'zap', 'uc4'],
			],
			'2604' => [
				'name' => \XF::phrase('emoji.comet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':comet:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['space', 'uc1'],
			],
			'1f4a5' => [
				'name' => \XF::phrase('emoji.boom'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':boom:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['boom', 'comic', 'uc6'],
			],
			'1f525' => [
				'name' => \XF::phrase('emoji.fire'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fire:',
				'shortname_alternates' => [':flame:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['flame', 'tool', 'uc6'],
			],
			'1f32a' => [
				'name' => \XF::phrase('emoji.cloud_tornado'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud_tornado:',
				'shortname_alternates' => [':cloud_with_tornado:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'whirlwind', 'uc7'],
			],
			'1f308' => [
				'name' => \XF::phrase('emoji.rainbow'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':rainbow:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['rain', 'uc6'],
			],
			'2600' => [
				'name' => \XF::phrase('emoji.sunny'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sunny:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bright', 'rays', 'sunny', 'uc1'],
			],
			'1f324' => [
				'name' => \XF::phrase('emoji.white_sun_small_cloud'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':white_sun_small_cloud:',
				'shortname_alternates' => [':white_sun_with_small_cloud:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'sun', 'uc7'],
			],
			'26c5' => [
				'name' => \XF::phrase('emoji.partly_sunny'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':partly_sunny:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'sun', 'uc5'],
			],
			'1f325' => [
				'name' => \XF::phrase('emoji.white_sun_cloud'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':white_sun_cloud:',
				'shortname_alternates' => [':white_sun_behind_cloud:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'sun', 'uc7'],
			],
			'2601' => [
				'name' => \XF::phrase('emoji.cloud'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['weather', 'uc1'],
			],
			'1f326' => [
				'name' => \XF::phrase('emoji.white_sun_rain_cloud'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':white_sun_rain_cloud:',
				'shortname_alternates' => [':white_sun_behind_cloud_with_rain:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'rain', 'sun', 'uc7'],
			],
			'1f327' => [
				'name' => \XF::phrase('emoji.cloud_rain'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud_rain:',
				'shortname_alternates' => [':cloud_with_rain:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'rain', 'uc7'],
			],
			'26c8' => [
				'name' => \XF::phrase('emoji.thunder_cloud_rain'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':thunder_cloud_rain:',
				'shortname_alternates' => [':thunder_cloud_and_rain:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'rain', 'thunder', 'uc5'],
			],
			'1f329' => [
				'name' => \XF::phrase('emoji.cloud_lightning'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud_lightning:',
				'shortname_alternates' => [':cloud_with_lightning:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'lightning', 'uc7'],
			],
			'1f328' => [
				'name' => \XF::phrase('emoji.cloud_snow'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':cloud_snow:',
				'shortname_alternates' => [':cloud_with_snow:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'cold', 'snow', 'uc7'],
			],
			'2744' => [
				'name' => \XF::phrase('emoji.snowflake'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snowflake:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cold', 'snow', 'uc1'],
			],
			'2603' => [
				'name' => \XF::phrase('emoji.snowman2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snowman2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cold', 'snow', 'uc1'],
			],
			'26c4' => [
				'name' => \XF::phrase('emoji.snowman'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':snowman:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cold', 'snow', 'snowman', 'uc5'],
			],
			'1f32c' => [
				'name' => \XF::phrase('emoji.wind_blowing_face'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':wind_blowing_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['blow', 'cloud', 'face', 'wind', 'uc7'],
			],
			'1f4a8' => [
				'name' => \XF::phrase('emoji.dash'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':dash:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['comic', 'dash', 'running', 'uc6'],
			],
			'1f4a7' => [
				'name' => \XF::phrase('emoji.droplet'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':droplet:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cold', 'comic', 'drop', 'sweat', 'uc6'],
			],
			'1f4a6' => [
				'name' => \XF::phrase('emoji.sweat_drops'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':sweat_drops:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['comic', 'splashing', 'sweat', 'uc6'],
			],
			'2614' => [
				'name' => \XF::phrase('emoji.umbrella'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':umbrella:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'drop', 'rain', 'umbrella', 'uc4'],
			],
			'2602' => [
				'name' => \XF::phrase('emoji.umbrella2'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':umbrella2:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['clothing', 'rain', 'uc1'],
			],
			'1f30a' => [
				'name' => \XF::phrase('emoji.ocean'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':ocean:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['ocean', 'water', 'wave', 'uc6'],
			],
			'1f32b' => [
				'name' => \XF::phrase('emoji.fog'),
				'category_name' => \XF::phrase('emoji_category.nature'),
				'category' => 'nature',
				'shortname' => ':fog:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cloud', 'uc7'],
			],
			'1f34f' => [
				'name' => \XF::phrase('emoji.green_apple'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':green_apple:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['apple', 'fruit', 'green', 'uc6'],
			],
			'1f34e' => [
				'name' => \XF::phrase('emoji.apple'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':apple:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['apple', 'fruit', 'red', 'uc6'],
			],
			'1f350' => [
				'name' => \XF::phrase('emoji.pear'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pear:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'uc6'],
			],
			'1f34a' => [
				'name' => \XF::phrase('emoji.tangerine'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':tangerine:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'orange', 'uc6'],
			],
			'1f34b' => [
				'name' => \XF::phrase('emoji.lemon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':lemon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['citrus', 'fruit', 'uc6'],
			],
			'1f34c' => [
				'name' => \XF::phrase('emoji.banana'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':banana:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'uc6'],
			],
			'1f349' => [
				'name' => \XF::phrase('emoji.watermelon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':watermelon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'uc6'],
			],
			'1f347' => [
				'name' => \XF::phrase('emoji.grapes'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':grapes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'grape', 'uc6'],
			],
			'1fad0' => [
				'name' => \XF::phrase('emoji.blueberries'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':blueberries:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f353' => [
				'name' => \XF::phrase('emoji.strawberry'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':strawberry:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['berry', 'fruit', 'uc6'],
			],
			'1f348' => [
				'name' => \XF::phrase('emoji.melon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':melon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'uc6'],
			],
			'1f352' => [
				'name' => \XF::phrase('emoji.cherries'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cherries:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cherry', 'fruit', 'uc6'],
			],
			'1f351' => [
				'name' => \XF::phrase('emoji.peach'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':peach:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'uc6'],
			],
			'1f96d' => [
				'name' => \XF::phrase('emoji.mango'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':mango:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f34d' => [
				'name' => \XF::phrase('emoji.pineapple'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pineapple:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'uc6'],
			],
			'1f965' => [
				'name' => \XF::phrase('emoji.coconut'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':coconut:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['palm', 'piña colada', 'uc10'],
			],
			'1f95d' => [
				'name' => \XF::phrase('emoji.kiwi'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':kiwi:',
				'shortname_alternates' => [':kiwifruit:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['food', 'fruit', 'kiwi', 'uc9'],
			],
			'1f345' => [
				'name' => \XF::phrase('emoji.tomato'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':tomato:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['fruit', 'vegetable', 'uc6'],
			],
			'1f346' => [
				'name' => \XF::phrase('emoji.eggplant'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':eggplant:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['aubergine', 'vegetable', 'uc6'],
			],
			'1f951' => [
				'name' => \XF::phrase('emoji.avocado'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':avocado:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['avocado', 'food', 'fruit', 'uc9'],
			],
			'1fad2' => [
				'name' => \XF::phrase('emoji.olive'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':olive:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f966' => [
				'name' => \XF::phrase('emoji.broccoli'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':broccoli:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['wild cabbage', 'uc10'],
			],
			'1f96c' => [
				'name' => \XF::phrase('emoji.leafy_green'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':leafy_green:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1fad1' => [
				'name' => \XF::phrase('emoji.bell_pepper'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bell_pepper:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f952' => [
				'name' => \XF::phrase('emoji.cucumber'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cucumber:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cucumber', 'food', 'pickle', 'vegetable', 'uc9'],
			],
			'1f336' => [
				'name' => \XF::phrase('emoji.hot_pepper'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':hot_pepper:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['hot', 'pepper', 'uc7'],
			],
			'1f33d' => [
				'name' => \XF::phrase('emoji.corn'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':corn:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['corn', 'ear', 'maize', 'maze', 'uc6'],
			],
			'1f955' => [
				'name' => \XF::phrase('emoji.carrot'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':carrot:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['carrot', 'food', 'vegetable', 'uc9'],
			],
			'1f9c4' => [
				'name' => \XF::phrase('emoji.garlic'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':garlic:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f9c5' => [
				'name' => \XF::phrase('emoji.onion'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':onion:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f954' => [
				'name' => \XF::phrase('emoji.potato'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':potato:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['food', 'potato', 'vegetable', 'uc9'],
			],
			'1f360' => [
				'name' => \XF::phrase('emoji.sweet_potato'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':sweet_potato:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['potato', 'roasted', 'sweet', 'uc6'],
			],
			'1f950' => [
				'name' => \XF::phrase('emoji.croissant'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':croissant:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bread', 'crescent roll', 'croissant', 'food', 'french', 'uc9'],
			],
			'1f96f' => [
				'name' => \XF::phrase('emoji.bagel'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bagel:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc11'],
			],
			'1f35e' => [
				'name' => \XF::phrase('emoji.bread'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bread:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['loaf', 'uc6'],
			],
			'1f956' => [
				'name' => \XF::phrase('emoji.french_bread'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':french_bread:',
				'shortname_alternates' => [':baguette_bread:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['baguette', 'bread', 'food', 'french', 'uc9'],
			],
			'1fad3' => [
				'name' => \XF::phrase('emoji.flatbread'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':flatbread:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc13'],
			],
			'1f968' => [
				'name' => \XF::phrase('emoji.pretzel'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pretzel:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc10'],
			],
			'1f9c0' => [
				'name' => \XF::phrase('emoji.cheese'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cheese:',
				'shortname_alternates' => [':cheese_wedge:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cheese', 'uc8'],
			],
			'1f95a' => [
				'name' => \XF::phrase('emoji.egg'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':egg:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['egg', 'food', 'uc9'],
			],
			'1f373' => [
				'name' => \XF::phrase('emoji.cooking'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cooking:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['egg', 'frying', 'pan', 'uc6'],
			],
			'1f9c8' => [
				'name' => \XF::phrase('emoji.butter'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':butter:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f95e' => [
				'name' => \XF::phrase('emoji.pancakes'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pancakes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['crêpe', 'food', 'hotcake', 'pancake', 'uc9'],
			],
			'1f9c7' => [
				'name' => \XF::phrase('emoji.waffle'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':waffle:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f953' => [
				'name' => \XF::phrase('emoji.bacon'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':bacon:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bacon', 'food', 'meat', 'uc9'],
			],
			'1f969' => [
				'name' => \XF::phrase('emoji.cut_of_meat'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':cut_of_meat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['chop', 'lambchop', 'porkchop', 'steak', 'uc10'],
			],
			'1f357' => [
				'name' => \XF::phrase('emoji.poultry_leg'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':poultry_leg:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bone', 'chicken', 'leg', 'poultry', 'uc6'],
			],
			'1f356' => [
				'name' => \XF::phrase('emoji.meat_on_bone'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':meat_on_bone:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bone', 'meat', 'uc6'],
			],
			'1f32d' => [
				'name' => \XF::phrase('emoji.hotdog'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':hotdog:',
				'shortname_alternates' => [':hot_dog:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['frankfurter', 'hotdog', 'sausage', 'uc8'],
			],
			'1f354' => [
				'name' => \XF::phrase('emoji.hamburger'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':hamburger:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['burger', 'uc6'],
			],
			'1f35f' => [
				'name' => \XF::phrase('emoji.fries'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':fries:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['french', 'fries', 'uc6'],
			],
			'1f355' => [
				'name' => \XF::phrase('emoji.pizza'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':pizza:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['cheese', 'slice', 'uc6'],
			],
			'1f96a' => [
				'name' => \XF::phrase('emoji.sandwich'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':sandwich:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['bread', 'uc10'],
			],
			'1f959' => [
				'name' => \XF::phrase('emoji.stuffed_flatbread'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':stuffed_flatbread:',
				'shortname_alternates' => [':stuffed_pita:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['falafel', 'flatbread', 'food', 'gyro', 'kebab', 'stuffed', 'uc9'],
			],
			'1f9c6' => [
				'name' => \XF::phrase('emoji.falafel'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' => 'food',
				'shortname' => ':falafel:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'keywords' => ['uc12'],
			],
			'1f32e' => [
				'name' => \XF::phrase('emoji.taco'),
				'category_name' => \XF::phrase('emoji_category.food'),
				'category' =