<?php

namespace XF\Admin\Controller;

use OAuth\OAuth2\Service\Google;
use XF\Mvc\ParameterBag;

class Misc extends AbstractController
{
	public function actionEmailOAuthSetup(ParameterBag $params)
	{
		/** @var \XF\Admin\ControllerPlugin\EmailOAuth $oAuthPlugin */
		$oAuthPlugin = $this->plugin('XF:Admin:EmailOAuth');

		$oAuthEmailSetup = $oAuthPlugin->assertOAuthEmailSetupData(false);

		$provider = $this->app->oAuth()->provider($oAuthEmailSetup['provider'], $oAuthEmailSetup['config']);
		if (method_exists($provider, 'setAccessType'))
		{
			$provider->setAccessType('offline');
		}

		$code = $this->filter('code', 'str');

		try
		{
			$token = $provider->requestAccessToken($code);
		}
		catch (\Exception $e)
		{
			\XF::logException($e);
			return $this->error(\XF::phrase('something_went_wrong_please_try_again'));
		}

		$oAuthEmailSetup['tokenData'] = [
			'token' => $token->getAccessToken(),
			'token_expiry' => $token->getEndOfLife(),
			'refresh_token' => $token->getRefreshToken()
		];
		$oAuthEmailSetup['loginUserName'] = $oAuthPlugin->getLoginUserNameFromProvider(
			$oAuthEmailSetup['provider'],
			$provider
		);

		$this->session()->oAuthEmailSetup = $oAuthEmailSetup;

		return $this->redirect($oAuthEmailSetup['returnUrl']);
	}
}