<?php
namespace Tapatalk;



use Tapatalk\Service\CompatibleOtherPlugin;
use Tapatalk\Service\MbqRegistration;
use Tapatalk\XF\Repository\TapatalkUsersRepo;
use XF\App;
use XF\Container;
use XF\DataRegistry;
use XF\Entity\AddOn;
use XF\Entity\ConversationMaster;
use XF\Entity\Forum;
use XF\Entity\Post;
use XF\Entity\Thread;
use XF\Entity\User;
use XF\Http\Request;
use XF\Language;
use XF\Mvc\Controller as XFController;
use XF\Pub\Controller\AbstractController as XFAbstractController;
use XF\Mvc\ParameterBag;
use XF\Repository\Banning;
use XF\Repository\Counters;
use XF\Repository\Ip;
use XF\Repository\LikedContent;
use XF\Repository\LoginAttempt;
use XF\Repository\Permission;
use XF\Repository\PermissionEntry;
use XF\Repository\SessionActivity;
use XF\Repository\Tfa;
use XF\Repository\UserField;
use XF\Repository\UserFollow;
use XF\Repository\UserGroup;


class Bridge extends XFAbstractController
{
    /**
     * Instance holder
     *
     * @var Bridge
     */
    private static $_instance;

    public $_input;

    public $_request;
    public $_response;

    /**
     * Any errors go here for later output via xml-rpc
     *
     * @var string
     */
    public $error;
    public $mobiquo_configuration;

    /** @var Container */
    protected $container;

    protected $_dependencies;

    private $_action;
    private $_session_timeout;
    private $memstart, $timestart;
    public  $xenResourcePrefix = 'r';

    protected $_modelCache = array();

    public function __construct(App $app, Request $request)
    {
        parent::__construct($app, $request);
        $this->container = $app->container();
        $this->_request = $app->request();

        $this->_response = $app->response();
        $this->_input = $app->inputFilterer();
    }

    /**
     * @param App $app
     * @param Request $request
     * @return Bridge
     */
    public static function setInstance(App $app, Request $request)
    {
        self::$_instance = new self($app, $request);
        return self::$_instance;
    }

    /**
     * @return Bridge
     */
    public static final function getInstance($app = null,$request = null)
    {
        if (!self::$_instance)
        {
            if(!$app)
            {
                $app = \XF::App();
            }
            if(!$request)
            {
                $request = $app->request();
            }
            self::$_instance = new self($app, $request);
        }

        return self::$_instance;
    }

    public function initBasePlugin()
    {
        $this->_preTapatalkSettingBasePlugin();

        $paramBag = new ParameterBag();
        $this->preDispatchType($this->_action, $paramBag);
        $this->preDispatch($this->_action,$paramBag);
    }
    public function assertValidCsrfToken($token = null, $validityPeriod = null)
    {

    }

    public function init()
    {
        parent::init(); // TODO: Change the autogenerated stub
    }

    public function initBridgeWithPush()
    {
        $this->_prepareGetConfig();

        $this->_preTapatalkSetting();

        $parameterBag = new ParameterBag();
        $this->preDispatchType($this->_action, $parameterBag);
        $this->preDispatch($this->_action, $parameterBag);
    }

    protected function _preTapatalkSettingBasePlugin()
    {
        $request_method_name = \MbqMain::getCurrentCmd();

        if ($request_method_name == 'get_config' || $request_method_name == 'login' || $request_method_name == 'sign_in' || $request_method_name == 'register' || $request_method_name == 'prefetch_account' || $request_method_name == 'forget_password' || $request_method_name == 'get_contact' || $request_method_name == 'set_api_key' || $request_method_name == 'reset_push_slug' || $request_method_name == 'sync_user' || $request_method_name == 'push_content_check' || $request_method_name == 'user_subscription' || $request_method_name == 'set_forum_info')
        {
            $visitor = \XF::visitor();
            $visitorPermissionSet = $visitor->getPermissionSet();
            $globalPermsData = $visitorPermissionSet->getGlobalPerms();
            $permissionComId = $visitorPermissionSet->getPermissionCombinationId();
            $permissionCache = $visitorPermissionSet->getPermissionCache();
            $setViewPermission = [];
            if ($globalPermsData && !is_array($globalPermsData)) {
                $globalPermsData = @unserialize($globalPermsData);
                if ($globalPermsData && is_array($globalPermsData)) {
                    $setViewPermission = $globalPermsData;
                }
            }
            $setViewPermission['general']['view'] = true;
            if (!$visitor->hasPermission('general', 'view'))
            {
                $permissionCache->setGlobalPerms($permissionComId, $setViewPermission);
            }
        }
    }

    protected function _preTapatalkSetting()
    {
        global $request_method_name, $mobiquo_config;

        $request_method_name = $this->_action;

        /** @var AddOn $tapatalk_addon */
        $tapatalk_addon = $this->finder('XF:AddOn')->where([
            'addon_id' => 'Tapatalk'
        ])->fetchOne();

        if ($request_method_name != 'get_config' && !$tapatalk_addon['active']) {
            $result = array('result' => new \xmlrpcval(false, 'boolean'));
            $result_text = "Tapatalk is disabled in this forum, please contact the forum administrator for more.";
            $result['result_text'] = new \xmlrpcval($result_text, 'base64');
            $response = new \xmlrpcresp(new \xmlrpcval($result, 'struct'));
            echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" . $response->serialize("UTF-8");
            exit();
        }

        if ($request_method_name == 'get_config' || $request_method_name == 'login' || $request_method_name == 'sign_in' || $request_method_name == 'register' || $request_method_name == 'prefetch_account' || $request_method_name == 'forget_password' || $request_method_name == 'get_contact' || $request_method_name == 'set_api_key' || $request_method_name == 'reset_push_slug' || $request_method_name == 'sync_user' || $request_method_name == 'push_content_check' || $request_method_name == 'user_subscription' || $request_method_name == 'set_forum_info') {

            $visitor = $this::visitor();
            if (!$visitor->hasPermission('general', 'view')) {
                $user_permissions['general']['view'] = 1;
                $mobiquo_config['guest_okay'] = 0;
            }
            $visitor->setReadOnly(true);
        }
    }

    protected function _prepareGetConfig()
    {
        global $mobiquo_config;

        $options = $this->options();
        if ($this->_action == 'get_config' && !$options->boardActive) {
            $options->boardActive = 1;
            $options->offsetSet('boardActive', 1);
            $options->offsetSet('originBoardActive', 0);
        } else
            $options->offsetSet('originBoardActive', 1);

        $register_setup = $options->registrationSetup;
        if (!isset($register_setup['enabled']) || empty($register_setup['enabled'])) {
            $mobiquo_config['sign_in'] = 0;
            $mobiquo_config['inappreg'] = 0;

            $mobiquo_config['sso_signin'] = 0;
            $mobiquo_config['sso_register'] = 0;
            $mobiquo_config['native_register'] = 0;
        }

        if (!function_exists('curl_init') && !@ini_get('allow_url_fopen')) {
            $mobiquo_config['sign_in'] = 0;
            $mobiquo_config['inappreg'] = 0;

            $mobiquo_config['sso_login'] = 0;
            $mobiquo_config['sso_signin'] = 0;
            $mobiquo_config['sso_register'] = 0;
        }
        if (isset($options->tapatalk_reg_type)) {
            if ($options->tapatalk_reg_type != 0) {
                $mobiquo_config['sign_in'] = 0;
                $mobiquo_config['inappreg'] = 0;
                $mobiquo_config['sso_signin'] = 0;
                $mobiquo_config['sso_register'] = 0;
                $mobiquo_config['native_register'] = 0;
            }
        }
        $this->mobiquo_configuration = $mobiquo_config;
    }

    /**
     * @param null $key
     * @return mixed|Container
     */
    public function container($key = null)
    {
        return $key === null ? $this->container : $this->container[$key];
    }

    /**
     * @return \XF\Mvc\Entity\Manager
     */
    public function getEm()
    {
        return $this->em();
    }

    /**
     * @return int
     */
    public static function getXFVersionId()
    {
        return \XF::$versionId;
    }

    /**
     * @return string
     */
    public static function xfVersion()
    {
        return \XF::$version;
    }

    /**
     * @return \XF\Entity\User
     */
    public function getVisitor()
    {
        return \XF::visitor();
    }

    /**
     * @return \XF\Entity\User
     */
    public static function visitor()
    {
        return \XF::visitor();
    }

    /**
     * @return \XF\PermissionSet
     */
    public function getPermission()
    {
        return \XF::permissionCache()->getPermissionSet(false);
    }

    /**
     * @return DataRegistry
     */
    public function getDataRegistry()
    {
        return $this->registry();
    }

    /**
     * @return Counters
     */
    public function getCountersRepo()
    {
        return $this->em()->getRepository('XF:Counters');
    }

    /**
     * @return \Tapatalk\XF\Repository\ForumWatch
     */
    public function getForumWatchRepo()
    {
        return $this->app()->repository('XF:ForumWatch');
    }

    /**
     * @return \Tapatalk\XF\Repository\Node
     */
    public function getNodeRepo()
    {
        return $this->app()->repository('XF:Node');
    }

    /**
     * @return PermissionEntry
     */
    public function getPermissionEntryRepo()
    {
        return $this->app()->repository('XF:PermissionEntry');
    }

    /**
     * @return Permission
     */
    public function getPermissionRepo()
    {
        return $this->app()->repository('XF:Permission');
    }

    /**
     * @return \Tapatalk\XF\Repository\Forum
     */
    public function getForumRepo()
    {
        return $this->app()->repository('XF:Forum');
    }

    /**
     * @return \Tapatalk\XF\Repository\AddOn
     */
    public function getAddOnRepo()
    {
        return $this->app()->repository('XF:AddOn');
    }

    /**
     * @return \Tapatalk\XF\Repository\Thread
     */
    public function getThreadRepo()
    {
        return $this->app()->repository('XF:Thread');
    }

    /**
     * @return \Tapatalk\XF\Repository\Post
     */
    public function getPostRepo()
    {
        return $this->app()->repository('XF:Post');
    }

    /**
     * @return \Tapatalk\XF\Repository\User
     */
    public function getUserRepo()
    {
        return $this->app()->repository('XF:User');
    }

    /**
     * @return \Tapatalk\XF\Repository\ThreadRedirect
     */
    public function getThreadRedirectRepo()
    {
        return $this->app()->repository('XF:ThreadRedirect');
    }

    /**
     * @return LoginAttempt
     */
    public function getLoginAttemptRepo()
    {
        return $this->app()->repository('XF:LoginAttempt');
    }

    /**
     * @return Tfa
     */
    public function getTfaRepo()
    {
        return $this->app()->repository('XF:Tfa');
    }

    /**
     * @return Ip
     */
    public function getIpRepo()
    {
        return $this->app()->repository('XF:Ip');
    }

    /**
     * @return SessionActivity
     */
    public function getSessionActivityRepo()
    {
        return $this->app()->repository('XF:SessionActivity');
    }

    /**
     * @return UserFollow
     */
    public function getUserFollowRepo()
    {
        return $this->app()->repository('XF:UserFollow');
    }

    /**
     * @return UserField
     */
    public function getUserFieldRepo()
    {
        return $this->app()->repository('XF:UserField');
    }

    /**
     * @return \Tapatalk\XF\Repository\Conversation
     */
    public function getConversationRepo()
    {
        return $this->app()->repository('XF:Conversation');
    }

    /**
     * @return \Tapatalk\XF\Repository\Notice
     */
    public function getNoticeRepo()
    {
        return $this->app()->repository('XF:Notice');
    }

    /**
     * @return \Tapatalk\XF\Repository\ThreadWatch
     */
    public function getThreadWatchRepo()
    {
        return $this->app()->repository('XF:ThreadWatch');
    }

    /**
     * @return \Tapatalk\XF\Repository\ThreadPrefix
     */
    public function getThreadPrefixRepo()
    {
        return $this->app()->repository('XF:ThreadPrefix');
    }

    /**
     * @return \Tapatalk\XF\Repository\ApprovalQueue
     */
    public function getApprovalQueueReop()
    {
        return $this->app()->repository('XF:ApprovalQueue');
    }

    /**
     * @return \Tapatalk\XF\Repository\Attachment
     */
    public function getAttachmentRepo()
    {
        return $this->app()->repository('XF:Attachment');
    }

    /**
     * @return UserGroup
     */
    public function getUserGroupRepo()
    {
        return $this->app()->repository('XF:UserGroup');
    }

    /**
     * @return \Tapatalk\XF\Repository\Search
     */
    public function getSearchRepo()
    {
        return $this->app()->repository('XF:Search');
    }

    /**
     * @return \Tapatalk\XF\Repository\ConversationMessage
     */
    public function getConversationMessageRepo()
    {
        return $this->app()->repository('XF:ConversationMessage');
    }

    /**
     * @return \Tapatalk\XF\Repository\Report
     */
    public function getReportRepo()
    {
        return $this->app()->repository('XF:Report');
    }

    /**
     * @return \Tapatalk\XF\Repository\UserAlert
     */
    public function getUserAlertRepo()
    {
        return $this->app()->repository('XF:UserAlert');
    }

    /**
     * @return LikedContent
     */
    public function getLikedContentRepo()
    {
        return $this->app()->repository('XF:LikedContent');
    }

    /**
     * @return \XF\Repository\Reaction
     */
    public function getReactionRepo()
    {
        return $this->app()->repository('XF:Reaction');
    }

    /**
     * @return \Tapatalk\XF\Repository\Option
     */
    public function getOptionRepo()
    {
        return $this->app()->repository('XF:Option');
    }


    /**
     * @param $uri
     * @param null $fullBasePath
     * @return string
     */
    public function XFConvertToAbsoluteUri($uri, $fullBasePath = null)
    {
        return $this->_request->convertToAbsoluteUri($uri, $fullBasePath = null);
    }

    /**
     * @return \Tapatalk\XF\Repository\UserTfaTrusted
     */
    public function getUserTfaTrustedRepo()
    {
        return $this->app()->repository('XF:UserTfaTrusted');
    }

    /**
     * @return \Tapatalk\XF\Repository\ApprovalQueue
     */
    public function getApprovalQueueRepo()
    {
        return $this->app()->repository('XF:ApprovalQueue');
    }

    /**
     * @return \Tapatalk\XF\Repository\TapatalkUsersRepo
     */
    public function getTapatalkUsersRepo()
    {
        return $this->app()->repository('Tapatalk\XF\Repository\TapatalkUsersRepo');
    }

    /**
     * @return Banning
     */
    public function getBanningRepo()
    {
        return $this->app()->repository('XF:Banning');
    }

    /**
     * @return \XF\Session\Session
     */
    public function getSession()
    {
        return $this->app()->session();
    }

    /**
     * @param $userName
     * @param $ip
     * @return \XF\Service\User\Login
     */
    public function getUserLoginService($userName = null, $ip = null)
    {
        if (!$userName)
            $userName = self::visitor()->username;
        if (!$ip)
            $ip = $this->_request->getIp();

        /** @var \XF\Service\User\Login $loginService */
        $loginService = $this->app()->service('XF:User\Login', $userName, $ip);
        return $loginService;
    }

    /**
     * @return \XF\Service\User\Registration
     */
    public function getUserRegistrationService()
    {
        /** @var \XF\Service\User\Registration $registration */
        $registration = $this->service('XF:User\Registration');
        return $registration;
    }

    /**
     * @return MbqRegistration
     */
    public function getMbqRegistrationService()
    {
        /** @var MbqRegistration $registration */
        $registration = new MbqRegistration($this->app());
        return $registration;
    }

    /**
     * @return CompatibleOtherPlugin
     */
    public static function getCompatibleOtherPlugin()
    {
        static $CompatibleOtherPlugin;
        if (isset($CompatibleOtherPlugin) && $CompatibleOtherPlugin) {
            return $CompatibleOtherPlugin;
        }
        $CompatibleOtherPlugin = new CompatibleOtherPlugin();
        return $CompatibleOtherPlugin;
    }

    /**
     * @param ConversationMaster $conversation
     * @param User $user
     * @return \XF\Service\AbstractService
     */
    public function getConversationInviterService(ConversationMaster $conversation, User $user)
    {
        /** @var \XF\Service\Conversation\Inviter $inviter */
        return $inviter = $this->service('XF:Conversation\Inviter', $conversation, $user);
    }

    /**
     * @param User $visitor
     * @param string $password
     * @return \XF\Service\User\PasswordChange
     */
    public function getUserPasswordChangeService(User $visitor, $password)
    {
        /** @var \XF\Service\User\PasswordChange $userPasswordChange */
        $userPasswordChange = $this->service('XF:User\PasswordChange', $visitor, $password);
        return $userPasswordChange;
    }

    /**
     * @param User $visitor
     * @return \XF\Service\User\PasswordReset
     */
    public function getUserPasswordResetService(User $visitor)
    {
        /** @var \XF\Service\User\PasswordReset $passwordConfirmation */
        $passwordConfirmation = $this->service('XF:User\PasswordReset', $visitor);
        return $passwordConfirmation;
    }

    /**
     * @param User $visitor
     * @return \XF\Service\Conversation\Creator
     */
    public function getConversationCreatorService(User $visitor)
    {
        /** @var \XF\Service\Conversation\Creator $creator */
        $creator = $this->service('XF:Conversation\Creator', $visitor);
        return $creator;
    }

    /**
     * @param Thread $thread
     * @return \XF\Service\Thread\Replier
     */
    public function getThreadReplierService(Thread $thread)
    {
        /** @var \XF\Service\Thread\Replier $replier */
        $replier = $this->service('XF:Thread\Replier', $thread);
        return $replier;
    }

    /**
     * @param $contentType
     * @param \XF\Mvc\Entity\Entity $content
     * @return \XF\Service\Report\Creator
     */
    public function getReportCreatorService($contentType, $content)
    {
        /** @var \XF\Service\Report\Creator $creator */
        $creator = $this->service('XF:Report\Creator', $contentType, $content);
        return $creator;
    }

    /**
     * @param User $visitor
     * @param string $email
     * @return \XF\Service\User\EmailChange
     */
    public function getUserEmailChangeService(User $visitor, $email)
    {
        /** @var \XF\Service\User\EmailChange $emailChange */
        $emailChange = $this->service('XF:User\EmailChange', $visitor, $email);
        return $emailChange;
    }

    /**
     * @param Post $post
     * @return \XF\Service\Post\Editor
     */
    public function getPostEditorService(Post $post)
    {
        /** @var \XF\Service\Post\Editor $editor */
        $editor = $this->service('XF:Post\Editor', $post);
        return $editor;
    }

    /**
     * @param Thread $thread
     * @return \XF\Service\Thread\Editor
     */
    public function getThreadEditorService(Thread $thread)
    {
        /** @var \XF\Service\Thread\Editor $threadEditor */
        $threadEditor = $this->service('XF:Thread\Editor', $thread);
        return $threadEditor;
    }

    /**
     * @param User $ignoreUser
     * @return \XF\Service\User\Ignore
     */
    public function getUserIgnoreService(User $ignoreUser)
    {
        /** @var \XF\Service\User\Ignore $userIgnore */
        $userIgnore = $this->service('XF:User\Ignore', $ignoreUser);
        return $userIgnore;
    }

    /**
     * @param ConversationMaster $conversation
     * @param User $visitor
     * @return \XF\Service\Conversation\Replier
     */
    public function getConversationReplierService(ConversationMaster $conversation, User $visitor)
    {
        /** @var \XF\Service\Conversation\Replier $replier */
        $replier = $this->service('XF:Conversation\Replier', $conversation, $visitor);
        return $replier;
    }

    /**
     * @param Forum $forum
     * @return \XF\Service\Thread\Creator
     */
    public function getThreadCreatorService(Forum $forum)
    {
        /** @var \XF\Service\Thread\Creator $creator */
        $creator = $this->service('XF:Thread\Creator', $forum);
        return $creator;
    }

    /**
     * @param User $user
     * @return \XF\Entity\UserProfile|null
     */
    public function getUserProfile($user)
    {
        if (!$user || !($user instanceof User)) {
            return null;
        }
        /** @var \XF\Entity\UserProfile $userProfile */
        $userProfile = $user->getRelationOrDefault('Profile');
        return $userProfile;
    }

    /**
     * @return \XF\Entity\UserProfile
     */
    public function getCurrentUserProfile()
    {
        /** @var \XF\Entity\UserProfile $userProfile */
        $userProfile = \XF::visitor()->getRelationOrDefault('Profile');
        return $userProfile;
    }

    /**
     * @return \XF\ControllerPlugin\Login
     */
    public function getControllerPluginLogin()
    {
        /** @var \XF\ControllerPlugin\Login $loginPlugin */
        $loginPlugin = $this->plugin('XF:Login');
        return $loginPlugin;
    }

    /**
     * @param User|null $user
     * @return Language
     */
    public function getLanguage(\XF\Entity\User $user = null)
    {
        if ($user && ($user instanceof \XF\Entity\User)) {
            /** @var Language $language */
            $language = $this->app()->language($user->language_id);
            return $language;
        }
        return \XF::language();
    }

    /**
     * @param $action
     */
    public function setAction($action)
    {
        $this->_action = $action;
    }

    /**
     * @param $key
     * @param $value
     */
    public function setUserParams($key, $value)
    {
        if($key == 'useragent')
        {
            if(strpos($value, 'Tapatalk') !== false)
                $value = 'tapatalk';
            else if(strpos($value, 'BYO') !== false)
                $value = 'byo';
            else
                $value = 'others';
        }
        $this->_request->set($key, $value);
    }

    public function shutdown()
    {
        $params = new ParameterBag();
        $params->offsetSet('useragent', $this->_request->get('useragent'));
        $reply = $this->view('Tapatalk:SelfDeactivate', 'tapatalk_mbq_view');
        $controllerClass = '\Tapatalk\Pub\Controller\Tapatalk';
        /** @var \Tapatalk\Pub\Controller\Tapatalk $tapatalkController */
        $tapatalkController = $this->app->controller($controllerClass, $this->_request);
        $tapatalkController->postDispatch($this->_action, $params, $reply);  //$this->
        $this->_response->sendHeaders();
    }

    public function isXenRenresourceForumId($forumId)
    {
        if(strpos($forumId, $this->xenResourcePrefix)===0)
        {
            return substr($forumId, strlen($this->xenResourcePrefix));
        }
        return false;
    }

    public function getXenResourceCategoryModel()
    {
        // dev
        return null;
    }

    /**
     * @param $name
     * @param array $params
     * @param bool $allowHtml
     * @return \XF\Phrase
     */
    public static function XFPhrase($name, array $params = [], $allowHtml = true)
    {
        return \XF::phrase($name, $params, $allowHtml);
    }

    /**
     * @param $name
     * @param array $params
     * @param bool $allowHtml
     * @return mixed|string
     */
    public static function XFPhraseOutName($name, array $params = [], $allowHtml = true)
    {
        return \XF::phrase($name, $params, $allowHtml)->getName();
    }

    /**
     * @param $name
     * @param array $params
     * @param bool $allowHtml
     * @return mixed|string
     */
    public static function XFPhraseOutRender($name, array $params = [], $allowHtml = true)
    {
        return \XF::phrase($name, $params, $allowHtml)->render();
    }

    /**
     * Date formatting. Format represents a string name of a format.
     *
     * @param integer Unix timestamp to format
     * @param string  Named format (name options TBD)
     *
     * @return string
     */
    public static function date($timestamp, $format = null)
    {

    }

    /**
     * format process
     *
     * @param $message
     * @param $authorId
     * @param int $length
     * @return mixed|string
     */
    public function renderPostPreview($message, $authorId, $length=0)
    {

        if(\MbqCM::checkIfUserIsIgnored($authorId))
        {
            return '[ignored]';
        }

        $app = $this->app();
        $formatter = $app->stringFormatter();
        $message = $formatter->censorText($message);
        $message = $formatter->stripBbCode($message);
        $rendered = $message;

        $rendered = str_replace(array("\r", "\n"), " ", $rendered);
        return $length > 0 ? TT_cutstr($rendered, $length) : $rendered;
    }

    /**
     * clear post message bbCode
     * @param $post
     * @param array $extraStates
     * @return mixed
     */
    public function cleanPost($post, $extraStates=array())
    {
        if (!isset($extraStates['states']['returnHtml']))
            $extraStates['states']['returnHtml'] = false;

        $options = $this->options();

        if ($extraStates['states']['returnHtml'])
        {
            $post = str_replace("&", '&amp;', $post);
            $post = str_replace("<", '&lt;', $post);
            $post = str_replace(">", '&gt;', $post);
            $post = str_replace("\r", '', $post);
            $post = str_replace("\n", '<br />', $post);

            if (!isset($extraStates['stopSmilies'])) {
                $extraStates['stopSmilies'] = true;
            }
        }
        //process unfurl
        $post = preg_replace("/\[URL unfurl=\"true\"\](.+?)\[\/URL\]/is", "[URL]$1[/URL]", $post);

        if(!$extraStates) $extraStates = array('states' => array());

        //handle multiple same media url issue
        try {
            $new_post = $post;
            if ($options->autoEmbedMedia['embedType'] == 2){
                $linkBbCode = $options->autoEmbedMedia['linkBbCode'];
                $linkBbCodeRegular = preg_quote($linkBbCode, '/');
                $linkBbCodeRegular = '/(\[MEDIA=.*?\].*?\[\/MEDIA\])\s*?' . str_replace('\{\$url\}', '(\S*?)', $linkBbCodeRegular) . '/';
                $new_post = preg_replace($linkBbCodeRegular, '$1', $post);
            }
            $post = $new_post;
        } catch (Exception $e) {}

        $post = $this->_processListTag($post);

        $app = $this->app();

        if ($this::getXFVersionId() >= '2000052') {
            $post = $app->bbCode()->render($post, 'html', 'post', $post, $extraStates);
        }else {
            $post = $app->bbCode()->render($post, 'html', 'post', $extraStates);
        }


        $formatter = $app->stringFormatter();
        $post = $formatter->censorText($post);
        // $post = $formatter->stripBbCode($post);

        $post = trim($post);
        $custom_replacement = $options->tapatalk_custom_replacement;
        if(!empty($custom_replacement))
        {
            $replace_arr = explode("\n", $custom_replacement);
            foreach ($replace_arr as $replace)
            {
                preg_match('/^\s*(\'|")((\#|\/|\!).+\3[ismexuADUX]*?)\1\s*,\s*(\'|")(.*?)\4\s*$/', $replace,$matches);
                if(count($matches) == 6)
                {
                    $temp_post = $post;
                    $post = @preg_replace($matches[2], $matches[5], $post);
                    if(empty($post))
                    {
                        $post = $temp_post;
                    }
                }
            }
        }
        return $post;
    }

    protected function _processListTag($message)
    {
        $contents = preg_split('#(\[LIST=[^\]]*?\]|\[/?LIST\])#siU', $message, -1, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE);

        $result = '';
        $status = 'out';
        foreach($contents as $content)
        {
            if ($status == 'out')
            {
                if ($content == '[LIST]')
                {
                    $status = 'inlist';
                } elseif (strpos($content, '[LIST=') !== false)
                {
                    $status = 'inorder';
                } else {
                    $result .= $content;
                }
            } elseif ($status == 'inlist')
            {
                if ($content == '[/LIST]')
                {
                    $status = 'out';
                } else
                {
                    $result .= str_replace('[*]', '  * ', ltrim($content));
                }
            } elseif ($status == 'inorder')
            {
                if ($content == '[/LIST]')
                {
                    $status = 'out';
                } else
                {
                    $index = 1;
                    $result .= preg_replace_callback('/\[\*\]/s',
                        array($this,'matchCount'),
                        ltrim($content));
                }
            }
        }
        return $result;
    }
    private function matchCount($matches){
        static $index = 1;
        return '  '.$index++.'. ';
    }
    /**
     * @param $error
     * @return string
     */
    public function errorToString($error)
    {
        if (is_array($error)) {
            $error = end($error);
        }
        if ($error instanceof \XF\Phrase) {
            $error = $error->render();
        }

        return $error;
    }

    public function responseError($message)
    {
        if (is_array($message)) {
            $message = end($message);
        }
        if ($message instanceof \XF\Phrase) {
            $message = $message->render();
        }
        \MbqError::alert('',$message);
    }

    public function errorAssertRegistrationRequired()
    {
        \MbqError::alert('', 'need login');
    }

    /**
     * @return array
     */
    public function getSearchSupportFilters()
    {
        return $filters = [
            'username' => 'str',
            'userId' => 'uint',
            'searchId' => 'uint',
            'keywords' => 'str',
            'searchUser' => 'str',
            'forumId' => 'str',
            'topicId' => 'str',
            'titleOnly' => 'uint',
            'showPosts' => 'uint',
            'searchTime' => 'str',
            'onlyIn' => 'array',
            'notIn' => 'array',
            'startedBy' => 'uint'
        ];
    }

    /**
     * @param $action
     * @param null $floodingLimit
     * @return \XF\Phrase|null
     */
    public function XFAssertNotFlooding($action, $floodingLimit = null)
    {
        $bridge = Bridge::getInstance();
        $visitor = $bridge::visitor();
        if ($visitor->hasPermission('general', 'bypassFloodCheck'))
        {
            return;
        }

        /** @var \XF\Service\FloodCheck $floodChecker */
        $floodChecker = $this->service('XF:FloodCheck');
        $timeRemaining = $floodChecker->checkFlooding($action, $visitor->user_id, $floodingLimit);
        if ($timeRemaining)
        {
            return $bridge::XFPhrase('must_wait_x_seconds_before_performing_this_action', ['count' => $timeRemaining]);
        }

        return;
    }

    /**
     * @param \XF\Attachment\AbstractHandler $handler
     * @param \XF\Repository\Attachment $repo
     * @param array $context
     * @param $hash
     * @return \XF\Attachment\Manipulator
     */
    public function XFManipulator(\XF\Attachment\AbstractHandler $handler, \XF\Repository\Attachment $repo, array $context, $hash)
    {
        return new \XF\Attachment\Manipulator($handler, $repo, $context, $hash);
    }

    /**
     * @param null $message
     * @return mixed|string
     */
    public function noPermission($message = null)
    {
        return parent::noPermission($message); // TODO: Change the autogenerated stub
        //        if (!$message) {
        //            return TT_GetPhraseString('do_not_have_permission');
        //        }
    }

    /**
     * @param null $error
     * @return string
     */
    public function noPermissionToString($error = null)
    {
        if (empty($error)){
            return TT_GetPhraseString('do_not_have_permission');
        }

        return $this->errorToString($error);
    }

    /**
     * @return \XF\Str\Formatter
     */
    public function stringFormatter()
    {
        return $this->app()->stringFormatter();
    }

    /**
     * @return string
     */
    public static function getBoardUrl()
    {
        $app = \XF::app();
        $homePageUrl = $app->container('homePageUrl');
        // $pather = $bridge->container('request.pather');

        if ($homePageUrl) {
            return $homePageUrl;
        }
        return $app->options()->boardUrl;
    }

    public static function XFCleanString($string, $trim = true)
    {
        return \XF::cleanString($string, $trim);
    }

    public function newPostContent($html)
    {
        $html = preg_replace('/\\n/is', '<br/>', $html);
        return $this->plugin('XF:Editor')->convertToBbCode($html);
    }

    public function setUserCookie($key, $value)
    {
        $this->app->response()->setCookie($key, $value);
        $key = $this->app->response()->getCookiePrefix();
        $_COOKIE[$key] = $value;
    }
    public function getAction()
    {
        return $this->_action;
    }
}
