<?php

class ModEss_XenForo_DataWriter_ConversationMaster extends XFCP_ModEss_XenForo_DataWriter_ConversationMaster
{
	protected function _preSave()
	{
		$options = XenForo_Application::getOptions();

		if ($options->modEss_warning_conversation_starter['enabled'] && XenForo_Application::isRegistered('modEss_inside_warn_action') && XenForo_Application::get('modEss_inside_warn_action') === true)
		{
			$senderName = $options->modEss_warning_conversation_starter['username'];
			$sender = $this->_getUserModel()->getUserByName($senderName,
				array('join' => XenForo_Model_User::FETCH_USER_FULL | XenForo_Model_User::FETCH_USER_PERMISSIONS));

			if ($sender)
			{
				$this->setExtraData(self::DATA_ACTION_USER, $sender);
				$this->set('username', $sender['username']);
				$this->set('user_id', $sender['user_id']);
			}
			else
			{
				XenForo_Error::logException(new XenForo_Exception('The custom warning conversation starter is enabled, but an invalid username has been set!'),
					false);
			}
		}

		parent::_preSave();
	}

	protected function _postSaveAfterTransaction()
	{
		parent::_postSaveAfterTransaction();

        if (XenForo_Application::isRegistered('modEss_inside_warn_action') && XenForo_Application::get('modEss_inside_warn_action') === true)
        {
            $this->_getConversationModel()->markConversationAsRead(
                $this->get('conversation_id'), $this->get('user_id'), XenForo_Application::$time
            );
        }
	}
}

if (false)
{
	class XFCP_ModEss_XenForo_DataWriter_ConversationMaster extends XenForo_DataWriter_ConversationMaster
	{
	}
}