<?php

class ModEss_ViewPublic_ModerationQueue_List extends XFCP_ModEss_ViewPublic_ModerationQueue_List
{
    public function renderHtml()
	{
		if (!empty($this->_params) && isset($this->_params['queue']))
		{
			$queue = $this->_params['queue'];
			if (is_array($queue))
			{
				$postModel = XenForo_Model::create('XenForo_Model_Post');
				$threadModel = XenForo_Model::create('XenForo_Model_Thread');
				
				// this is done here as function getModerationQueueEntries() does not have any fetch options
				// also chose not to do it in function getVisibleModerationQueueEntriesForUser() as that is sometimes used for counting entries
				// and so the following links are not needed there
				foreach ($queue AS &$entry)
				{
					$contentId = $entry['content_id'];
					
					if ($entry['content_type'] == 'post')
					{
						$post = $postModel->getPostById($contentId, array('join' => XenForo_Model_Post::FETCH_THREAD | XenForo_Model_Post::FETCH_FORUM));
						$entry['content']['forum_title'] = $post['node_title'];
						$entry['content']['forum_link'] = XenForo_Link::buildPublicLink('forums', '', array('node_id' => $post['node_id']));
					}
					else if ($entry['content_type'] == 'thread')
					{
						$thread = $threadModel->getThreadById($contentId, array('join' => XenForo_Model_Thread::FETCH_FIRSTPOST | XenForo_Model_Thread::FETCH_FORUM));
						$entry['content']['forum_title'] = $thread['node_title'];
						$entry['content']['forum_link'] = XenForo_Link::buildPublicLink('forums', '', array('node_id' => $thread['node_id']));
					}
				}
				
				$this->_params['queue'] = $queue;
			}
		}
	}
}