<?php

/**
 * View handling for viewing the details of a specific forum.
 *
 * @package ModEss
 */
class ModEss_ViewPublic_Forum_View extends XFCP_ModEss_ViewPublic_Forum_View
{
	public function renderRss()
	{
		if (!empty($this->_params) && isset($this->_params['threads']))
		{
			foreach ($this->_params['threads'] AS $thread)
			{
				if ($thread['discussion_state'] == 'deleted')
				{
					// in the event the user has the permission to view deleted threads place holders,
					// then it is fetched but must be removed from view
					unset($this->_params['threads'][$thread['thread_id']]);
				}
			}
		}
		
		return parent::renderRss();
	}
}