<?php
class ModEss_DataWriter_UserNote extends XenForo_DataWriter
{
    /**
     * Gets the fields that are defined for the table. See parent for explanation.
     *
     * @return array
     */
    protected function _getFields()
    {
        return array(
            'modess_usernote'	=> array(
                'note_id' => array(
                    'type' => self::TYPE_UINT,
                    'required' => true
                ),
                'user_id' => array(
                    'type' => self::TYPE_UINT,
                    'required' => true
                ),
                'mod_id' => array(
                    'type' => self::TYPE_UINT,
                    'required' => true
                ),
                'note_date' => array(
                    'type' => self::TYPE_UINT,
                    'required' => false,
                    'default' => XenForo_Application::$time
                ),
                'title' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true
                ),
                'note' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true
                )
            )
        );
    }

    /**
     * Gets the actual existing data out of data that was passed in. See parent for explanation.
     *
     * @param mixed
     *
     * @return array|false
     */
    protected function _getExistingData($data)
    {
        if (!$noteId = $this->_getExistingPrimaryKey($data, 'note_id'))
        {
            return false;
        }

        return array('modess_usernote' => $this->_getUserNoteModel()->getUserNoteById($noteId));
    }

    /**
     * Gets SQL condition to update the existing record.
     *
     * @return string
     */
    protected function _getUpdateCondition($tableName)
    {
        return 'note_id = ' . $this->_db->quote($this->getExisting('note_id'));
    }

    /**
     * @return ModEss_Model_STO
     */
    protected function _getUserNoteModel()
    {
        return $this->getModelFromCache('ModEss_Model_UserNote');
    }
}