<?php

class ModEss_ModeratorLogHandler_Thread extends XFCP_ModEss_ModeratorLogHandler_Thread
{
	protected function _prepareEntry(array $entry)
	{
		$entry = parent::_prepareEntry($entry);
		$action = $entry['action'];
		
		if ($action == 'threadban' || $action == 'threadbanlift' || $action == 'threadban_edit' || $action == 'threadbanlift_cron')
		{
			$addOns = XenForo_Application::get('addOns');
			
			// since the type is 'thread' and will be displayed, we must process the entry instead of the Thread Ban add-on
			if (!isset($addOns['ThreadBan']))
			{
				$elements = json_decode($entry['action_params'], true);
				
				if (!isset($elements['url']) && isset($elements['user_id']))
				{
					$elements['url'] = XenForo_Link::buildAdminLink('users/edit', '', array('user_id' => $elements['user_id']));
				}
				
				if (!isset($entry['actionText']))
				{
					$entry['actionText'] = new XenForo_Phrase(
						'moderator_log_' . $entry['content_type'] . '_' . $entry['action'],
						$elements
					);
				}
				
				// change the user name link from ACP to Members to be used in Thread Log and ModEss log
				if (isset($elements['user_id']) || isset($elements['username']))
				{
					if (isset($elements['user_id']))
						$elements['url'] = XenForo_Link::buildPublicLink('members', array('user_id' => $elements['user_id'])) . "#threadbans";
					else
						$elements['url'] = XenForo_Link::buildPublicLink('members', '', array('username' => $elements['username'])) . "#threadbans";
				
					$entry['actionTextThreadLog'] = new XenForo_Phrase(
						'moderator_log_' . $entry['content_type'] . '_' . $entry['action'],
						$elements
					);
				}
			}
		}
		
		return $entry;
	}
}