<?php
class ModEss_Model_UserNote extends XenForo_Model
{
    const FETCH_USER = 0x01;
    const FETCH_MODERATOR = 0x02;
    public function getUserNotes(array $conditions = array(), array $fetchOptions = array())
    {
        $whereConditions = $this->prepareUserNoteConditions($conditions, $fetchOptions);
        $sqlClauses = $this->prepareUserNoteFetchOptions($fetchOptions);

        $limitOptions = $this->prepareLimitFetchOptions($fetchOptions);

        $forceIndex = (!empty($fetchOptions['forceNoteIndex']) ? 'FORCE INDEX (' . $fetchOptions['forceNoteIndex'] . ')' : '');

        return $this->fetchAllKeyed($this->limitQueryResults(
            '
                SELECT note.*
                    ' . $sqlClauses['selectFields'] . '
				FROM modess_usernote AS note ' . $forceIndex . '
				' . $sqlClauses['joinTables'] . '
				WHERE ' . $whereConditions . '
				' . $sqlClauses['orderClause'] . '
			', $limitOptions['limit'], $limitOptions['offset']
        ), 'note_id');
    }

    public function prepareUserNoteFetchOptions(array $fetchOptions)
    {
        $selectFields = '';
        $joinTables = '';
        $orderBy = '';

        if (!empty($fetchOptions['order']))
        {
            $orderBySecondary = '';

            switch ($fetchOptions['order'])
            {
                case 'title':
                case 'note_date':
                    $orderBy = 'note.' . $fetchOptions['order'];
                    break;
                default:
                    $orderBy = 'note.note_date';
            }
            if (!isset($fetchOptions['orderDirection']) || $fetchOptions['orderDirection'] == 'desc')
            {
                $orderBy .= ' DESC';
            }
            else
            {
                $orderBy .= ' ASC';
            }

            $orderBy .= $orderBySecondary;
        }

        if (!empty($fetchOptions['join']))
        {
            if ($fetchOptions['join'] & self::FETCH_USER)
            {
                $selectFields .= ',
					user.*, IF(user.username IS NULL, thread.username, user.username) AS username';
                $joinTables .= '
					LEFT JOIN xf_user AS user ON
						(user.user_id = note.user_id)';
            }

            if ($fetchOptions['join'] & self::FETCH_MODERATOR)
            {
                $selectFields .= ',
					user.*, user.username AS username';
                $joinTables .= '
					LEFT JOIN xf_user AS user ON
						(user.user_id = note.mod_id)';
            }
        }

        return array(
            'selectFields' => $selectFields,
            'joinTables'   => $joinTables,
            'orderClause'  => ($orderBy ? "ORDER BY $orderBy" : '')
        );
    }

    public function prepareUserNoteConditions(array $conditions, array &$fetchOptions)
    {
        $sqlConditions = array();
        $db = $this->_getDb();

        if (!empty($conditions['note_id_gt']))
        {
            $sqlConditions[] = 'note.note_id > ' . $db->quote($conditions['note_id_gt']);
        }

        if (!empty($conditions['title']))
        {
            if (is_array($conditions['title']))
            {
                $sqlConditions[] = 'note.title LIKE ' . XenForo_Db::quoteLike($conditions['title'][0], $conditions['title'][1], $db);
            }
            else
            {
                $sqlConditions[] = 'note.title LIKE ' . XenForo_Db::quoteLike($conditions['title'], 'lr', $db);
            }
        }

        if (isset($conditions['user_id']))
        {
            if (is_array($conditions['user_id']))
            {
                $sqlConditions[] = 'note.user_id IN (' . $db->quote($conditions['user_id']) . ')';
            }
            else
            {
                $sqlConditions[] = 'note.user_id = ' . $db->quote($conditions['user_id']);
            }
        }

        if (isset($conditions['mod_id']))
        {
            if (is_array($conditions['mod_id']))
            {
                $sqlConditions[] = 'note.mod_id IN (' . $db->quote($conditions['mod_id']) . ')';
            }
            else
            {
                $sqlConditions[] = 'note.mod_id = ' . $db->quote($conditions['mod_id']);
            }
        }

        return $this->getConditionsForClause($sqlConditions);
    }

    public function prepareNotes(array $notes = array())
    {
        if (!empty($notes))
        {
            foreach ($notes as &$note)
            {
                $note = $this->prepareNote($note);
            }
        }
        return $notes;
    }
    public function prepareNote(array $note)
    {
        $note['canComment'] = true;
        return $note;
    }
}