<?php
class ModEss_Model_EditHistory extends XFCP_ModEss_Model_EditHistory
{
    public function getEditHistoryBetweenDates($userId, $startDate, $endDate = 0, $fetchOptions = array())
    {
        if ($endDate === 0)
        {
            return parent::getEditHistoryByUserSinceDate($userId, $startDate, $fetchOptions);
        }

        $joinOptions = $this->prepareEditHistoryFetchOptions($fetchOptions);

        return $this->fetchAllKeyed('
			SELECT history.edit_history_id, history.edit_user_id, history.edit_date
				' . $joinOptions['selectFields'] . '
			FROM xf_edit_history AS history
			' . $joinOptions['joinTables'] . '
			WHERE history.edit_user_id = ?
				AND history.edit_date >= ?
				AND history.edit_date <= ?
			ORDER BY history.edit_date DESC
		', 'edit_history_id', array($userId, $startDate, $endDate));
    }
}