<?php

/**
* Data writer for users.
*
* @package ModEss
*/
class ModEss_DataWriter_User extends XFCP_ModEss_DataWriter_User
{
    /*
     * Automatically ban new accounts under the age of 18 if feature is enabled.
     */
    protected function _postSave()
    {
        parent::_postSave();
        if (XenForo_Application::getOptions()->modess_ban_underage && XenForo_Application::getOptions()->modess_ban_underage_min_age > 0)
        {
            if ($this->isInsert())
            {
                $dobYear = $this->get('dob_year', 'xf_user_profile');
                $dobMonth = $this->get('dob_month', 'xf_user_profile');
                $dobDay = $this->get('dob_day', 'xf_user_profile');

                $banDate = strtotime((intval($dobYear) + XenForo_Application::getOptions()->modess_ban_underage_min_age) . "-" . intval($dobMonth) . "-" . intval($dobDay));
                $gracePeriod = (60*60*24) * intval(XenForo_Application::getOptions()->modess_ban_underage_grace_days);

                if (($banDate - $gracePeriod) > time())
                {
                    $this->getModelFromCache('XenForo_Model_User')->ban($this->get('user_id'), $banDate, XenForo_Application::getOptions()->modess_ban_underage_ban_reason);
                }
            }
        }
    }
	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
		parent::_postDelete();
		
		if ($this->get('is_moderator'))
		{
			$userId = $this->get('user_id');
			$this->getModelFromCache('ModEss_Model_ModEss')->deleteAllModEssByUserId($userId);
		}
	}
}