<?php

/**
 * Controller for handling actions on forums.
 *
 * @package ModEss
 */
class ModEss_ControllerPublic_Forum extends XFCP_ModEss_ControllerPublic_Forum
{
	/**
	 * Displays the contents of a forum.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionForum()
	{
		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);
		if (!$forumId && !$forumName)
			return parent::actionForum();
		
		$response = parent::actionForum();
		
		if (isset($response->params) && isset($response->params['forum']))
		{
			$options = XenForo_Application::get('options');
			
			$viewDeleted = $this->_getModEssModel()->viewDeleted($response->params['forum']['node_id']);
			$response->params['canViewDeleted'] = $viewDeleted;
			$response->params['canViewReason'] = ($viewDeleted ? true : $options->modess_delete_placeholder_view_reason);
			
			if ($options->modess_show_forum_moderators && XenForo_Visitor::getUserId())
			{
				$response->params['canViewForumModerators'] = true;
			}
		}
		
		return $response;
	}
	
	/**
	 * Displays a list of forum moderators
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionModerators()
	{
		$options = XenForo_Application::get('options');
		
		if (!$options->modess_show_forum_moderators || !XenForo_Visitor::getUserId())
		{
			return $this->responseNoPermission();
		}
		
		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		$forum = $this->getHelper('ForumThreadPost')->assertForumValidAndViewable(
			$forumId ? $forumId : $forumName,
			$this->_getForumFetchOptions()
		);
		
		$moderatorModel = $this->getModelFromCache('XenForo_Model_Moderator');
		$nodeModel = $this->getModelFromCache('XenForo_Model_Node');
		$node = $nodeModel->getNodeById($forum['node_id']);
		$nodes = $nodeModel->getNodeAncestors($node);
		$nodeIds = array_keys($nodes);
		$nodeIds[] = $forum['node_id'];
		
		if ($options->modess_include_super_forum_moderators)
		{
			$moderators = $moderatorModel->getSuperAndForumModerators($nodeIds);
		}
		else
		{
			$moderators = $moderatorModel->getForumModerators($nodeIds);
		}
		
		$viewParams = array(
			'forum' => $forum,
			'moderators' => $moderators,
			'nodeBreadCrumbs' => $ftpHelper->getNodeBreadCrumbs($forum)
		);

		return $this->responseView('XenForo_ViewPublic_Base', 'modess_forum_moderator_list', $viewParams);
	}
	
	/**
	 * Inserts a new thread into this forum.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionAddThread()
	{
		if (!XenForo_Application::get('options')->modess_sticky_thread_order)
		{
			return parent::actionAddThread();
		}
		
		$sets = $this->_input->filterSingle('_set', array(XenForo_Input::UINT, 'array' => true));
		$sticky = $this->_input->filterSingle('sticky', XenForo_Input::UINT);
		$stickyOrder = $this->_input->filterSingle('sticky_order', XenForo_Input::UINT);
		
		// discussion sticky state - moderator permission required
		if (!empty($sets['sticky']) && $sticky && $stickyOrder)
		{
			$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
			$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);
	
			$ftpHelper = $this->getHelper('ForumThreadPost');
			$forum = $ftpHelper->assertForumValidAndViewable($forumId ? $forumId : $forumName);
			
			if ($this->_getForumModel()->canStickUnstickThreadInForum($forum))
			{
				$response = parent::actionAddThread();
				
				if ($response instanceof XenForo_ControllerResponse_Redirect)
				{
					$target = $response->redirectTarget;
						
					// find the thread_id
					$includeTitleInUrls = XenForo_Application::get('options')->includeTitleInUrls;
					if ($includeTitleInUrls) // threads/eee.12/
					{
						$delimiter = XenForo_Application::URL_ID_DELIMITER;
						$startPos = strrpos($target, $delimiter);
					}
					else // threads/12/
					{
						$startPos = strrpos($target, '/', -2); // before last '/'
					}
					
					if ($startPos !== false)
					{
						$threadId = intval(substr($target, $startPos +1, -1)); // -1 is for the last '/'
						if ($threadId)
							$this->_getSTOModel()->addOrEditStickyOrder($stickyOrder, $threadId);
					}
				}
				
				return $response;
			}
		}
		
		return parent::actionAddThread();
	}
		
	/**
	 * @return ModEss_Model_STO
	 */
	protected function _getSTOModel()
	{
		return $this->getModelFromCache('ModEss_Model_STO');
	}
	
	/**
	 * @return ModEss_Model_ModEss
	 */
	protected function _getModEssModel()
	{
		return $this->getModelFromCache('ModEss_Model_ModEss');
	}
}